package telBook;

/**
 * Title: Element
 * Description: Ncleo de um registro (No).
 * Copyright:    Copyright (c) 2001
 * @author Alex Jeukens
 * @version 1.0
 */

/*Disponibiliza recursos importantissimos que auditam os objetos de aplicacao
  (ex: Record).
    O sistema Java e' dividido em dois niveis. O segundo denominado de metanivel
  pode interagir com o nivel dos objetos de aplicacao. Um objeto retirado da
  lista tem "perde" seu tipo (neste exemplo i.next devolve um "Object" e nao um
  "Record"). E' necessario invocar o metodo print() de "Record" atraves do
  metanivel, pois ao tentar compilar:
    Object o = i.next();
    o.print();
  obtem-se:
  "Element.java": Error #: 300 : method print() not found in class
  java.lang.Object at line 61, column 9

  Com o auxilio da reflexao e' possivel construir metodos genericos.
  */

import java.lang.reflect.*;

/*Contem a implementacao da classe List*/
import java.util.*;

/*Este package auxilia a manipulacao do console*/
import corejava.*;

public class Element {

/*Definicao de variaveis globais*/
  static int nextNum = 0; //Numero do proximo registro.
  static Console c = new Console();
  int regNum; //Numero do registro atual.
  static List l = new ArrayList();

  public Element() {
    regNum = nextNum;
    System.out.println();
    System.out.println("Novo registro (No:" + regNum + ")");
    System.out.println("Favor entrar informacoes:");
    nextNum++;
    }

  public static Object insert(Object aObj) {
    l.add(aObj);
    return l.get(0);
  }

/*Cria um iterator que chama o metodo print() de cada objeto Record
  enquanto percorre a lista de registros.*/

  public void printList(Object obj) {
    Object o;
    Method m; //Ecriado um objeto para manipular um metodo.
    System.out.println();
    System.out.println("Listagem de registros");
    for (Iterator i=l.iterator(); i.hasNext(); ) {

/*Retorna o elemento atual da lista, e faz o interator apontar para o proximo
  se houver.*/
      o = i.next();

/*try faz parte do mecanismo de exececao. Caso seja detectado um erro no trecho
  abaixo, sera executado o codigo excepcional que trata a excecao.*/
      try {

/*Define-se m como um metodo print(). No lugar de null poder-se-ia indicar a
  qual classe pertence.*/
        m = o.getClass().getMethod("print", null);

/*invoca o metodo print() do objeto "o" sem argumentos (null).*/
        m.invoke(o, null);
      }

/*catch marca o inicio do codigo excepcional - neste caso inutil, joga mensagem
  de erro na tela!*/
      catch (Exception e) {
        System.out.println(e);
      }
    }
  }

/*Utiliza o metodo sort, que requer um Comparator para decidir sobre a ordem
  dos elementos.*/
  public void sortByName () {
    System.out.println();
    System.out.println("Ordenando...");

//Vamos utilizar o algoritmo sort - mergesort otimizado da classe Collections.
    Collections.sort(l, new Comparator() {
        String s1;
        String s2;

//E necessario rederinir a funcao compare ...
        public int compare(Object o1, Object o2) {
          s1 = ((Record)o1).getName();
          s2 = ((Record)o2).getName();

/*Aproveitei da funcao String.compareTo, que retorna:
  inteiro negativo se s1 precede s2;
          positivo caso contrario;
          zero se sao identicas.*/
          return s1.compareTo(s2);
        }
      });
  }

  public void print() {
    System.out.println("Registro No: " + regNum);
  }
}