package parameters;

public class io_arguments {
	
	public String information;

	private String option; /**/

	/* Text detection options */

	private String in_image;
	
	private String image_list;

	private String out_image;

	private String xml_name;

	private String xml_header;

	/* Text tracking options */

	private int bframe; /* first frame to perform the text detection and tracking */

	private int eframe; /* last frame to perform the text detection and tracking */

	private int tracking_step;

	private String frames_path;

	private String out_path;
	
	private String detection_parameters_file;
	
	private String tracking_parameters_file;

	public void parsing(String arguments[]) {

		if (arguments[0].compareTo("-d") == 0) {
			
			/*if (arguments.length != 4) {
				detection_error_message ();
			}*/

			option = "d";

			if (arguments[1] != null) {
				in_image = arguments[1];
			} else {
				System.err.printf("error: missing the input image name\n");
				System.exit(1);
			}

			if (arguments[2] != null) {
				out_image = arguments[2];
			} else {
				System.err.printf("error: missing the output image name\n");
				System.exit(1);
			}

			if (arguments[3] != null) {
				xml_name = arguments[3];
			} else {
				System.err.printf("error: missing the xml image name\n");
				System.exit(1);
			}

			if (arguments[4] != null) {
				xml_header = arguments[4];
			} else {
				System.err.printf("error: missing the xml image name header\n");
				System.exit(1);
			}
			
			if (arguments[5] != null) {
				detection_parameters_file = arguments[5];
			} else {
				System.err.printf("error: missing text detection parameters file\n");
				System.exit(1);
			}
		}
		else if (arguments[0].compareTo("-l") == 0) {

			option = "l";

			if (arguments[1] != null) {
				image_list = arguments[1];
			} else {
				System.err.printf("error: missing the input image list\n");
				System.exit(1);
			}

			if (arguments[2] != null) {
				out_path = arguments[2];
				System.err.printf("Out path %s\n", out_path);
			} else {
				System.err.printf("error: missing the output image path\n");
				System.exit(1);
			}

			/*if (arguments[3] != null) {
				xml_name = arguments[3];
			} else {
				System.err.printf("error: missing the xml image name\n");
				System.exit(1);
			}

			if (arguments[4] != null) {
				xml_header = arguments[4];
			} else {
				System.err.printf("error: missing the xml image name header\n");
				System.exit(1);
			}*/
			
			if (arguments[3] != null) {
				detection_parameters_file = arguments[3];
			} else {
				System.err.printf("error: missing text detection parameters file\n");
				System.exit(1);
			}
		}
		
		else if (arguments[0].compareTo("-t") == 0) {

			option = "t";

			if (arguments[1] != null) {
				frames_path = arguments[1];
			} else {
				System.err.printf("error: missing the video frames path\n");
				System.exit(1);
			}
			xml_name = "sem_nocao";
			if (arguments[2] != null) {
				bframe = Integer.parseInt(arguments[2]);
			} else {
				System.err.printf("error: missing the number of the first frame to process\n");
				System.exit(1);
			}
			
			if (arguments[3] != null) {
				eframe = Integer.parseInt(arguments[3]);
			} else {
				System.err.printf("error: missing the number of the last frame to process\n");
				System.exit(1);
			}
			
			if (arguments[4] != null) {
				tracking_step = Integer.parseInt(arguments[4]);
			} else {
				System.err.printf("error: missing the tracking_step argument\n");
				System.exit(1);
			}
			
			if (arguments[5] != null) {
				detection_parameters_file = arguments[5];
			} else {
				System.err.printf("error: missing text detection parameters file\n");
				System.exit(1);
			}
			
			if (arguments[6] != null) {
				tracking_parameters_file = arguments[6];
			} else {
				System.err.printf("error: missing text tracking parameters file\n");
				System.exit(1);
			}
			
			if (arguments[7] != null) {
				out_path = arguments[7];
			} else {
				System.err.printf("error: missing the output frames path\n");
				System.exit(1);
			}

		} 
		else if (arguments[0].compareTo("-st1") == 0) {

			option = "st1";

			if (arguments[1] != null) {
				frames_path = arguments[1];
			} else {
				System.err.printf("error: missing the video frames path\n");
				System.exit(1);
			}
			xml_name = "sem_nocao";
			if (arguments[2] != null) {
				bframe = Integer.parseInt(arguments[2]);
			} else {
				System.err.printf("error: missing the number of the first frame to process\n");
				System.exit(1);
			}
			
			if (arguments[3] != null) {
				eframe = Integer.parseInt(arguments[3]);
			} else {
				System.err.printf("error: missing the number of the last frame to process\n");
				System.exit(1);
			}
			
			if (arguments[4] != null) {
				detection_parameters_file = arguments[4];
			} else {
				System.err.printf("error: missing text detection parameters file\n");
				System.exit(1);
			}
			
			if (arguments[5] != null) {
				out_path = arguments[5];
			} else {
				System.err.printf("error: missing the output frames path\n");
				System.exit(1);
			}

		} 
		else {
			System.err.printf("error: unknow option \"%s\"\n", arguments[0]);
			System.exit(1);
		}
	}
	
	/*Detection methods*/
	public String get_option() {
		return option;
	}
	
	public String get_in_image() {
		return in_image;
	}
	
	public String get_image_list() {
		return image_list;
	}
	
	public String get_out_image() {
		return out_image;
	}
	
	public String get_xml_name() {
		return xml_name;
	}
	
	public void set_xml_name (String xml_name) {
		this.xml_name = xml_name;
	}

	public String get_xml_header() {
		return xml_header;
	}

	public void set_xml_header (String xml_header) {
		this.xml_header = xml_header;
	}
	
	/*Tracking methods*/
	public String get_frames_path() {
		return frames_path;
	}
	
	public int get_bframe() {
		return bframe;
	}
	
	public int get_eframe() {
		return eframe;
	}
	
	public int get_tracking_step() {
		return tracking_step;
	}
	
	public String get_out_path() {
		return out_path;
	}
	
	public String get_detection_parameters_file() {
		return detection_parameters_file;
	}
	
	public String get_tracking_parameters_file() {
		return tracking_parameters_file;
	}
	
	void detection_error_message () {
		System.err.printf("error: missing arguments\n");
		System.err.printf("usage: input_image_name (png/jpg) \\ \n");
		System.err.printf("       output_image_name (png/jpg) \\ \n");
		System.err.printf("       xml_output_filename \\ \n");
		System.err.printf("       xml_string_header \\ \n");
		System.err.printf("       detection_parameters_configuration (txt) \n\n");
		System.exit(1);
	}
}
