package parameters;

import java.io.BufferedReader;
import java.util.ArrayList;
import preprocessing.Parser;

public class detection_arguments {

	/*SegmentationThresholds*/
	
	public final int pyramid_levels;

	private int minimum_surface;

	private int maximum_surface;

	private int minimum_grouping;

	public final int minimum_region_height;

	public final int maximum_region_height;

	public final int minimum_region_width;

	public final int maximum_region_width;

	public final int mask_size;

	public final int percentage;

	public final int contrast1;

	public final int contrast2;


	/*Grouping Thresholds*/
	
	private double S1;

	private double S2;

	private double S3;


	public final int homogeneus_maximum_size_region;

	/*Classification Thresholds*/
	
	public final int zernike_first_order;

	public final int zernike_last_order;

	public final int zernike_descriptor_size;

	public final int fourier_size;

	public final int fourier_descriptor_size;

	public final int polar_angle;

	public final int polar_radius;

	public final int polar_descriptor_size;

	
	/*Classification Files*/
	
	public final boolean svm_option;

	public final String fourier; 

	public final String fourier_normalization;

	public final String polar; 

	public final String polar_normalization;

	public final String zernike; 

	public final String zernike_normalization;

	public final String all; 

	public final String all_normalization;

	public final String hog_obj; 
	
	public final String hog_parameters;
	
	public final String dataset;
	
	public final boolean use_hog;
		
	/*HOG parameters*/
	
	/*public double rwt;
	
	public boolean gauss_norm_weight;
	
	public int number_of_cells_x; 
	
	public int number_of_cells_y; 
	
	public int bins_per_cell;
	
	public int new_height;
	
	public boolean normalize_image;
	
	public int option;
	
	public boolean normalize_histogram_L1; 
	
	public boolean use_interval;*/
	
	/*End HOG*/

	public final boolean write_image = false;
	 
	/*Used to set which descriptor must be applied: fourier, polar, zernike*/
	public boolean[] descriptors = {true, true, true, true};	
		
	/**/
	public detection_arguments (String file_name) 
	{
		Parser parser = new Parser();

		BufferedReader arguments = parser.Open_File_Stream (file_name);

		ArrayList<String> list = new ArrayList<String>();

		String[] s = null;
		do {
			s = parser.Get_Stream_Tokens (arguments, " ");
			if (s == null) { break; }
			System.err.println(s[0]);
			list.add(s[0]);
		} while (s != null); 

		parser.Close_File_Stream (arguments, file_name);

		pyramid_levels = Integer.parseInt(list.get(0));

		minimum_surface = Integer.parseInt(list.get(1));

		maximum_surface = Integer.parseInt(list.get(2));

		minimum_grouping = Integer.parseInt(list.get(3));

		minimum_region_height = Integer.parseInt(list.get(4));

		maximum_region_height = Integer.parseInt(list.get(5));

		minimum_region_width = Integer.parseInt(list.get(6));

		maximum_region_width = Integer.parseInt(list.get(7));

		mask_size = Integer.parseInt(list.get(8));

		percentage = Integer.parseInt(list.get(9));

		contrast1 = Integer.parseInt(list.get(10));

		contrast2 = Integer.parseInt(list.get(11));

		S1 = Double.parseDouble(list.get(12));

		S2 = Double.parseDouble(list.get(13)); 

		S3 = Double.parseDouble(list.get(14));

		homogeneus_maximum_size_region = Integer.parseInt(list.get(15));

		zernike_first_order = Integer.parseInt(list.get(16));

		zernike_last_order = Integer.parseInt(list.get(17));

		zernike_descriptor_size = Integer.parseInt(list.get(18));

		fourier_size = Integer.parseInt(list.get(19));

		fourier_descriptor_size = Integer.parseInt(list.get(20));

		polar_angle = Integer.parseInt(list.get(21));

		polar_radius = Integer.parseInt(list.get(22));

		polar_descriptor_size = Integer.parseInt(list.get(23));

		svm_option = Boolean.parseBoolean(list.get(24));

		fourier = list.get(25); 

		fourier_normalization = list.get(26);

		polar = list.get(27); 

		polar_normalization = list.get(28);

		zernike = list.get(29); 

		zernike_normalization = list.get(30);

		all = list.get(31); 

		all_normalization = list.get(32);

		hog_obj = list.get(33); 
		
		/*Reading HoG parameters filename*/
		
		hog_parameters = list.get(34);
		
		dataset = list.get(35); 
		
		use_hog = Boolean.parseBoolean(list.get(36));
		
		/*BufferedReader arguments2 = parser.Open_File_Stream (hog_parameters);
		
		ArrayList<String> list2 = new ArrayList<String>();

		String[] s2 = null;
		do {
			s2 = parser.Get_Stream_Tokens (arguments2, " ");
			if (s2 == null) { break; }
			System.err.println(s2[0]);
			list2.add(s2[0]);
		} while (s2 != null); 

		parser.Close_File_Stream (arguments2, hog_parameters);
		
		rwt = Double.parseDouble(list2.get(0));
		
		gauss_norm_weight = Boolean.parseBoolean(list2.get(1));
		
		number_of_cells_x = Integer.parseInt(list2.get(2)); 
		
		number_of_cells_y = Integer.parseInt(list2.get(3)); 
		
		bins_per_cell = Integer.parseInt(list2.get(4));
		
		new_height = Integer.parseInt(list2.get(5));
		
		normalize_image = Boolean.parseBoolean(list2.get(6));
		
		option = Integer.parseInt(list2.get(7));
		
		normalize_histogram_L1 = Boolean.parseBoolean(list2.get(8));
		
		use_interval = Boolean.parseBoolean(list2.get(9)); */
	}

	
	/*public double Get_Rwt () {
		return rwt;
	}
	
	public int Get_Number_of_Cells_X () {
		return number_of_cells_x;
	}
	
	public int Get_Number_of_Cells_Y () {
		return number_of_cells_y;
	}
	
	public int Get_Number_of_Bins_per_Cell () {
		return bins_per_cell;
	}
	
	public int Get_Weight_HoG_Option () {
		return option;
	}
	
	public int Get_New_Resized_Height () {
		return new_height;
	}
	
	public boolean Get_Normalization_Status () {
		return normalize_image;
	}
	
	public boolean Get_L1_Status () {
		return normalize_histogram_L1;
	}*/
	
	public void Set_S1 (double S1) {
		this.S1 = S1;
	}

	public double Get_S1 () {
		return this.S1;
	}

	public void Set_S2 (double S2) {
		this.S2 = S2;
	}

	public double Get_S2 () {
		return this.S2;
	}

	public void Set_S3 (double S3) {
		this.S3 = S3;
	}

	public double Get_S3 () {
		return this.S3;
	}

	public int Get_Minimum_Surface () {
		return minimum_surface;
	}

	public int Get_Maximum_Surface () {
		return maximum_surface; 
	}

	public int Set_Minimum_Surface (int minimum_surface) {
		return this.minimum_surface = minimum_surface;
	}

	public int Set_Maximum_Surface (int maximum_surface) {
		return this.maximum_surface = maximum_surface;
	}

	public int Get_Minimum_Grouping_Set () {
		return minimum_grouping;
	}

	public void Set_Minimum_Grouping_Set (int minimum_grouping) {
		this.minimum_grouping = minimum_grouping;
	}
}
