package main;

import fr.lip6.classifier.SMOSVM;
import hypothesis_validation.HoG_Functions;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Random;

import javax.imageio.ImageIO;

import descriptors.HoG;

import preprocessing.Parser;
import preprocessing.Util;

public class TestHoG3 {
	
	
	public static void main(String[] args) throws IOException {
			
		String image_list = args[0];
		
		Random rand = new Random();

    	Parser parser = new Parser();

		LineNumberReader list = parser.Open_File (image_list);
		
		int frame = 0;
		
		while(true) {
			
			/*Reading the image*/
			String image_name = Util.Get_Name (list);
			
			BufferedImage in_image = Util.Get_Image (image_name);

			if (in_image == null) { break; }
			
			int width = in_image.getWidth();
			
			int height = in_image.getHeight();
			
			int window = 0;
			
			while (window < 50) {

				int x = rand_func (0, width - 1, rand);

				int y = rand_func (0, height - 1, rand);

				int w = rand_func (10, 100, rand);

				int h = 32;

				if ((x >= 0) && (y >= 0) && (x + w < in_image.getWidth()-1) && (y + h < (in_image.getHeight()-1))) {
					
					BufferedImage sub_image = in_image.getSubimage(x, y, w, h);
							
					try {
					 	ImageIO.write(sub_image, "png", new File("./windows/win_icdar_"+String.format("%04d", frame)+"_"+String.format("%02d", window)+".png"));
					}
					catch (Exception e) {
						System.err.println("cannot store image");
					}									
					window++;
				}
			} 
		
			frame++;
		}

		
	}
	
	
	public static int rand_func (int lo, int hi, Random rand)
    {
            int n = hi - lo + 1;
            int i = rand.nextInt() % n;
            if (i < 0)
                    i = -i;
            return lo + i;
    }

	
	
}
