package main;

import fr.lip6.classifier.SMOSVM;
import hypothesis_validation.HoG_Functions;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.ArrayList;

import descriptors.HOG;
import descriptors.hog;
import parameters.detection_arguments;
import preprocessing.Parser;
import preprocessing.Util;

public class False_Positives {
		
	public static void main(String[] args) throws IOException {
		
		String image_list = args[0];
		
		String hog_parameters_file = args[1];
		
		String hog_norm = args[2];
		
		String hog_obj = args[3];

		Parser parser = new Parser();
		
		ArrayList<String> hog_parameters = parser.Get_Array_List (hog_parameters_file);

		double rwt = Double.parseDouble(hog_parameters.get(0));
		
		boolean gauss_norm_weight = Boolean.parseBoolean(hog_parameters.get(1));
		
		int number_of_cells_x = Integer.parseInt(hog_parameters.get(2)); 
		
		int number_of_cells_y = Integer.parseInt(hog_parameters.get(3)); 
		
		int bins_per_cell = Integer.parseInt(hog_parameters.get(4));
		
		int new_height = Integer.parseInt(hog_parameters.get(5));
		
		boolean normalize_image = Boolean.parseBoolean(hog_parameters.get(6));
		
		int option = Integer.parseInt(hog_parameters.get(7));
		
		boolean normalize_histogram_L1 = Boolean.parseBoolean(hog_parameters.get(8));
		
		boolean use_interval = Boolean.parseBoolean(hog_parameters.get(9));
		
		HOG hog = new HOG();
		
		ArrayList<Double> mean = new ArrayList<Double>();
		
		ArrayList<Double> deviation = new ArrayList<Double>();
		
		HoG_Functions.read_hog_vectors (mean, deviation, hog_norm);

		
		SMOSVM<double[]> cls = null;
		try {
    		ObjectInputStream obj = new ObjectInputStream(new FileInputStream(hog_obj));
    	    cls = (SMOSVM<double[]>) obj.readObject();
    	    obj.close();
    	}
    	catch (Exception e){
    		e.printStackTrace();
    	}

		LineNumberReader list = parser.Open_File (image_list);
		
		int errors = 0, images = 0;
			
		while(true) {
			
			/*Reading the image*/
			String image_name = Util.Get_Name (list);
			
			BufferedImage in_image = Util.Get_Image (image_name);

			if (in_image == null) { break; }			
			
			double[] descriptor = hog.hog ( in_image, rwt, gauss_norm_weight,
					                        number_of_cells_x, 
					                        number_of_cells_y, 
					                        bins_per_cell,
					                        new_height,
					                        normalize_image, 
					                        option,
					                        normalize_histogram_L1,
					                        use_interval); 
			
			double v = cls.valueOf(descriptor);
			
			if (v < 0) {
				System.out.printf("cp %s error/\n", image_name);
				errors++;
			}
			images++;				
		}
		System.err.printf("The error was %d, total of %f\n", errors, (double)errors/(double)images);
	}
}
