package fr.lip6.kernel.typed;

import fr.lip6.kernel.Kernel;

/**
 * Gaussian Kernel on double[] that uses a L2 distance.
 * @author dpicard
 *
 */
public class DoubleGaussL2 extends Kernel<double[]> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8139656729530005699L;
	
	
	private double gamma = 0.1;
	
	@Override
	public double valueOf(double[] t1, double[] t2) {
		double sum = 0.;
		for(int i = 0 ; i < Math.min(t1.length, t2.length); i++)
			sum += (t1[i]-t2[i])*(t1[i]-t2[i]);
		if(Double.isNaN(sum))
		{
			System.err.println(this+" : Warning sum NaN");
			return 0.0;
		}
		return Math.exp(-gamma * sum);
	}

	@Override
	public double valueOf(double[] t1) {
		return valueOf(t1, t1);
	}


	/**
	 * @return the sigma
	 */
	public double getGamma() {
		return gamma;
	}

	/**
	 * @param gamma inverse of std dev parameter
	 */
	public void setGamma(double gamma) {
		this.gamma = gamma;
	}

}
