// Last edited on 2024-07-26 08:53:08 by stolfi

#include "rap_cut_points.inc"

#debug "!! Loading rap_skeleton.inc ...\n"

#macro rap_skeleton(V, E, D, Zp, Neo, Nei, oshape, subfig)
  // The edge and vertex skeleton of the object.  Parameters:
  //
  // {V}      Array of vertex coordinates {V[1..Nv]}.
  // {E}      Array of edges {E[1..Ne]}.
  // {E}      Array of diagonals {E[1..Nd]}.
  // {Zp}     List of slicing plane positions, {Zp[1..Np]}
  // {Neo}    Number of edges in each outer chain.
  // {Nei}    Number of edges in each inner chain.
  // {oshape} Shape of outer chain.
  // {subfig} Which sub-figure we are generating.
  
  // Assumes each entry {E[ke]} is a triple of integers {<kv_org,kv_dst,ty>}
  // where {kv_org,kv_dst} are indices into {V}, and {ty} is a edge type code.
  
  // Assumes that {V[1..Neo+1]} are the vertices of the outer chain of plaza [0],
  // then {V[Neo+2..Neo+Nei+2} are the inner chain vertices of the same,
  // both in incresing order of elevation;
  // and these are followed by the {Neo+Nei+2} vertices of of plaza [1].

  #debug "!! Generating skeleton edges and vertices ...\n"
  
  #local Nv = dimension_size(V, 1) - 1;
  #local Ne = dimension_size(E, 1) - 1;
  #local Nd = dimension_size(D, 1) - 1;
  
  // Uses {Vmaxrad} to avoid generating multiple coincident spheres.
  // {Vmaxrad[kv]} is the max radius of spheres painted at vertex {kv}:
  #local Vmaxrad = array[Nv + 1];
  #for (kv, 0, Nv) #local Vmaxrad[kv] = 0;  #end

  // Edges and vertices of the object:
  #local vrad_orig = 0.35;
  #local erad_orig = vrad_orig;
  #local tx_orig = rap_tx_skel_orig

  // Edges and vertices of the triangulation or convex tiling:
  #local vrad_part = 0;
  #local erad_part = 0.30;
  #local tx_part = rap_tx_skel_part

  #local skel = 
    union{
    
      #debug "!! Plotting all original edges and vertices ...\n"
      rap_skeleton_plot_edges(V, E, vrad_orig, erad_orig, tx_orig, Vmaxrad)

      #debug "!! Plotting partition edges and vertices ...\n"
      rap_skeleton_plot_edges(V, D, vrad_part, erad_part, tx_part, Vmaxrad)
      
      #debug "!! Plotting edge-plane intersections...\n"
      #local cuts = rap_cut_points(V, E, D, Zp, subfig)
      object{ cuts }

      // To avoid stupid POV-Ray CSG warning:
      object{ nothing(1.77) }
      object{ nothing(1.87) }
    }
  skel
#end

#macro rap_skeleton_plot_edges(V, E, vrad, erad, tx, Vmaxrad)
  // Generates all edges and vertices of the skeleton, with given style. 
  // Assumes that there are {Ne} edges {E[1..Ne]}.
  
  #local Ne = dimension_size(E, 1) - 1;
  #debug concat("!!   Ne = ", str(Ne,0,0), "\n")

  #for (ke, 1, Ne)
    rap_skeleton_edge_verts(V, E, ke, erad, vrad, tx, Vmaxrad)
  #end
#end      

#macro rap_skeleton_edge_verts(V, E, ke, erad, vrad, tx, Vmaxrad)   

  // #debug concat("!!   ke = ", str(ke,0,0), "\n")

  #local kv_org = E[ke].x; // Origin vertex index.
  #local kv_dst = E[ke].y; // Destination vertex index.
  #local Ty = E[ke].z;  // Edge type.

  // #debug concat("!!   kv_org = ", str(kv_org,0,0), "\n")
  // #debug concat("!!   kv_dst = ", str(kv_dst,0,0), "\n")

  #local V_org = V[kv_org];   // Origin vertex.
  #local V_dst = V[kv_dst];   // Destination vertex.
  #if (kv_org != kv_dst)
    #if (erad > 0)
      cylinder{ V_org, V_dst, erad texture{ tx } }
    #end
  #end
  #if (vrad > 0)
    #if (vrad > Vmaxrad[kv_org])
      sphere{ V_org, vrad texture{ tx } }
      #local Vmaxrad[kv_org] = vrad;
    #end
    #if (vrad > Vmaxrad[kv_dst])
      sphere{ V_dst, vrad texture{ tx } }
      #local Vmaxrad[kv_dst] = vrad;
    #end
  #end
#end
