package regrouping;

import java.awt.image.BufferedImage;

import preprocessing.Util;

public class PointList {
    private int nb_point_haut;
    
    private int[] x_haut;
    private int[] y_haut;

    int nb_point_bas;
    private int[] x_bas;
    private int[] y_bas;
    
    public PointList (int size) {
     	x_haut = new int[size];
    	y_haut = new int[size];
    	x_bas = new int[size];
    	y_bas = new int[size];
    	nb_point_haut = nb_point_bas = 0;
    }
    
    public int getNbPointBas ()
    {
    	return this.nb_point_bas;
    }
    
    public int getNbPointHaut ()
    {
    	return this.nb_point_haut;
    }
    
    public int getXHaut (int pos) {
    	return x_haut[pos];
    }
    public int getYHaut (int pos) {
    	return y_haut[pos];
    }
    public int getXBas (int pos) {
    	return x_bas[pos];
    }
    public int getYBas (int pos) {
    	return y_bas[pos];
    }
    
    public void push_haut(int x, int y)
    {
    	if (nb_point_haut >= 2) {
    		int k = x_haut[nb_point_haut - 1] - x_haut[nb_point_haut - 2];
    		k = -Math.abs(k);
    		if ( (y_haut[nb_point_haut - 1] - y_haut[nb_point_haut - 2]) == k && -Math.abs(x - x_haut[nb_point_haut-2])==k-1 && (y - y_haut[nb_point_haut-2])==k-1 ) {
    			nb_point_haut--;
    		}
    	}
    	x_haut[nb_point_haut]=x;
    	y_haut[nb_point_haut++]=y;
    }

    public void push_bas(int x, int y)
    {
    	if (nb_point_bas >= 2) {
    		int k = x_bas[nb_point_bas-1] - x_bas[nb_point_bas-2];
    		k=Math.abs(k);
    		if ( (y_bas[nb_point_bas-1] - y_bas[nb_point_bas-2])==k && Math.abs(x-x_bas[nb_point_bas-2])==k+1 && (y-y_bas[nb_point_bas-2])==k+1 ) {
    			nb_point_bas--;
    		}
    	}
    	x_bas[nb_point_bas]=x;
    	y_bas[nb_point_bas++]=y;
    }
    
    public void parcours_left(BufferedImage img)
    {
    	int pos=0;
    	int i;
    	
    	//Draw d = new Draw();
    	
    	while(pos < nb_point_haut-1) {
    		double alpha_max=(y_haut[pos+1]-y_haut[pos])/(double)(x_haut[pos+1]-x_haut[pos]);
    		int next_pos=pos+1;
    		for(i=pos+2;i< nb_point_haut;i++) {
    			double alpha=( y_haut[i]- y_haut[pos])/(double)( x_haut[i]- x_haut[pos]);
    			if (alpha<=alpha_max) {
    				alpha_max=alpha;
    				next_pos=i;
    			}
    		}
    		
    		//d.draw_line(img, x_haut[pos], y_haut[pos], x_haut[next_pos], y_haut[next_pos], alpha_max);
    		Util.drawLine(img, x_haut[pos], y_haut[pos], x_haut[next_pos], y_haut[next_pos]);
    		pos=next_pos;
    	}

    	pos=0;
    	while(pos< nb_point_bas-1) {
    		double alpha_max=( y_bas[pos+1]- y_bas[pos])/(double)( x_bas[pos+1]- x_bas[pos]);
    		int next_pos=pos+1;
    		for(i=pos+2;i< nb_point_bas;i++) {
    			double alpha=( y_bas[i]- y_bas[pos])/(double)( x_bas[i]- x_bas[pos]);
    			if (alpha>=alpha_max) {
    				alpha_max=alpha;
    				next_pos=i;
    			}
    		}
    		if (alpha_max<=1) {
    			//d.draw_line(img, x_bas[pos], y_bas[pos], x_bas[next_pos], y_bas[next_pos], alpha_max);
    			Util.drawLine(img, x_bas[pos], y_bas[pos], x_bas[next_pos], y_bas[next_pos]);
    		} else {
    			//d.draw_line(img, x_bas[next_pos], y_bas[next_pos], x_bas[pos], y_bas[pos], alpha_max);
    			Util.drawLine(img, x_bas[next_pos], y_bas[next_pos], x_bas[pos], y_bas[pos]);
    		}
    		pos=next_pos;
    	}
    }
    
    public void parcours_right (BufferedImage img)
    {
    	int pos=0;
    	int i;
    	
    	//Draw d = new Draw();
    	
    	while(pos<nb_point_haut-1) {
    		double alpha_max=(y_haut[pos+1]-y_haut[pos])/(double)(x_haut[pos+1]-x_haut[pos]);
    		int next_pos=pos+1;
    		for(i=pos+2;i<nb_point_haut;i++) {
    			double alpha=(y_haut[i]-y_haut[pos])/(double)(x_haut[i]-x_haut[pos]);
    			if (alpha>=alpha_max) {
    				alpha_max=alpha;
    				next_pos=i;
    			}
    		}
    		if (alpha_max<=1) {
    			//d.draw_line(img, x_haut[next_pos], y_haut[next_pos], x_haut[pos], y_haut[pos], alpha_max);
    			Util.drawLine(img, x_haut[next_pos], y_haut[next_pos], x_haut[pos], y_haut[pos]);

    		} else {
       			//d.draw_line(img, x_haut[pos], y_haut[pos], x_haut[next_pos], y_haut[next_pos], alpha_max);
       			Util.drawLine(img, x_haut[pos], y_haut[pos], x_haut[next_pos], y_haut[next_pos]);
    		}
    		pos=next_pos;
    	}
    	pos=0;
    	while(pos<nb_point_bas-1) {
    		double alpha_max=(y_bas[pos+1]-y_bas[pos])/(double)(x_bas[pos+1]-x_bas[pos]);
    		int next_pos=pos+1;
    		for(i=pos+2;i<nb_point_bas;i++) {
    			double alpha=(y_bas[i]-y_bas[pos])/(double)(x_bas[i]-x_bas[pos]);
    			if (alpha<=alpha_max) {
    				alpha_max=alpha;
    				next_pos=i;
    			}
    		}
       		//d.draw_line(img, x_bas[next_pos], y_bas[next_pos], x_bas[pos], y_bas[pos], alpha_max);
       		Util.drawLine(img, x_bas[next_pos], y_bas[next_pos], x_bas[pos], y_bas[pos]);
    		pos=next_pos;
    	}
    }
    
}
