package fr.lip6.kernel.extra;

import java.util.ArrayList;

import fr.lip6.kernel.Kernel;

/**
 * performs a product of several minor kernels
 * @author dpicard
 *
 * @param <T>
 */
public class ProductKernel<T> extends Kernel<T> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6273022923321895693L;
	
	ArrayList<Kernel<T>> listOfKernels;
	
	public ProductKernel ()
	{
		super();
		
		listOfKernels = new ArrayList<Kernel<T>>();
	}
	
	@Override
	public double valueOf(T t1, T t2) {
		
		double prod = 1.0;
		
		for(Kernel<T> k : listOfKernels)
			prod *= k.valueOf(t1, t2);
		
		return prod;
	}

	@Override
	public double valueOf(T t1) {
		return valueOf(t1, t1);
	}
	
	/**
	 * adds a kernel to to product
	 * @param k
	 */
	public void addKernel(Kernel<T> k)
	{
		listOfKernels.add(k);
	}
	
	/**
	 * removes a kernel from the product
	 * @param k
	 */
	public void removeKernel(Kernel<T> k)
	{
		listOfKernels.remove(k);
	}

}
