package descriptors;

import java.awt.image.BufferedImage;

import preprocessing.Util;
import segmentation.Labels;
import segmentation.Regions;

public class Z2 {

	Z num1 = new Z();
	Z num2 = new Z();
    

	public Z getNum1 () {
		return num1;
	}
	
	public Z getNum2 () {
		return num2;
	}
	
    public void pseudo_zernike_moment (int p, int q, Labels img, Regions[] regions, double rho_max, int studied_region)
    {
    	/*Funcao mais custosa de todo descriptor*/
    	int width = img.getWidth();
  
    	Regions reg = regions[studied_region];

    	num1.setA(0.0);
    	num1.setB(0.0);
    	num2.setA(0.0);
    	num2.setB(0.0);

    	double v = (p+1)/Math.PI;

    	int x_min = reg.getXmin ();
    	int x_max = reg.getXmax ();

    	int y_min = reg.getYmin ();
    	int y_max = reg.getYmax ();

    	int xg = reg.getXg (); 
		int yg = reg.getYg ();
    	
    	for(int y = y_min; y <= y_max; y++)
    		for(int x = x_min; x <= x_max; x++)
    		{
    			//int xg = reg.getXg (); 
    			//int yg = reg.getYg ();
    			
    			double xc=((double)(x - xg))/rho_max;
    			double yc=((double)(y - yg))/rho_max;
    			
    			double rho = Math.sqrt(xc * xc + yc * yc);
    			double theta = Math.atan2(yc,xc);
    			
    		    if (img.getValue(x + y * width) == studied_region) { 
    			Z vpq = new Z();
    			vpq.V (p, q, rho, theta);
    			
    			double a; 
    			double b; 
    			a = num1.getA();
    			b = num1.getB();
    			num1.setA(a + vpq.getA());
    			num1.setB(b + vpq.getB());
    			a = num2.getA();
    			b = num2.getB();
    			num2.setA(a +  vpq.getA());
    			num2.setB(b + -vpq.getB());
    			}
    		}
    	double a; 
		double b; 
		a = num1.getA();
		b = num1.getB();
		num1.setA(a * v);
		num1.setB(b * v);
		a = num2.getA();
		b = num2.getB();
		num2.setA(a * v);
		num2.setB(b * v);
    }
   
    public void pseudo_zernike_moment (int p, int q, BufferedImage image, double rho_max, int xg, int yg)
    {
    	int width = image.getWidth();
		int height = image.getHeight();
		int[] array = Util.getImageArray (image);
		
    	num1.setA(0.0);
    	num1.setB(0.0);
    	num2.setA(0.0);
    	num2.setB(0.0);

    	double v = (p+1)/Math.PI;


    	for(int y = 0; y < height; y++)
    		for(int x = 0; x < width; x++)
    		{
    			double xc=((double)(x - xg))/rho_max;
    			double yc=((double)(y - yg))/rho_max;
    			
    			double rho = Math.sqrt(xc * xc + yc * yc);
    			double theta = Math.atan2(yc,xc);
    			
    		    if (array[x+y*width]==255) { 
    			Z vpq = new Z();
    			vpq.V (p, q, rho, theta);
    			
    			double a; 
    			double b; 
    			a = num1.getA();
    			b = num1.getB();
    			num1.setA(a + vpq.getA());
    			num1.setB(b + vpq.getB());
    			a = num2.getA();
    			b = num2.getB();
    			num2.setA(a +  vpq.getA());
    			num2.setB(b + -vpq.getB());
    			}
    		}
    	double a; 
		double b; 
		a = num1.getA();
		b = num1.getB();
		num1.setA(a * v);
		num1.setB(b * v);
		a = num2.getA();
		b = num2.getB();
		num2.setA(a * v);
		num2.setB(b * v);
    }
    
    
}
