package association;

import hypothesis_validation.HoG_Score;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import particlefiltering.observation;
import particlefiltering.pHistogram;
import tracking.Atributes;

public class Probabilities {
	
	
	public double prob_a (BufferedImage V1, BufferedImage V2, double sigma, ArrayList<String> hog_fingerprint_parameters)
	{
		pHistogram histo1 = new pHistogram();

		HoG_Score score = new HoG_Score();
		
		double[] e1 = score.get_descriptor (false, V1, hog_fingerprint_parameters);
		
		histo1.alloc_vector(e1.length);
		for (int i = 0; i < e1.length; i++) {
		  histo1.set_data(i, e1[i]);
		}
		
		observation obs = new observation();
		
		obs.normalize_histogram(histo1);
		
		pHistogram histo2 = new pHistogram();

		double[] e2 = score.get_descriptor (false, V2, hog_fingerprint_parameters);
		
		histo2.alloc_vector(e2.length);
		for (int i = 0; i < e2.length; i++) {
		  histo2.set_data(i, e2[i]);
		}
	
		obs.normalize_histogram(histo2);

		/* compute likelihood as e^{\lambda D^2(h, h^*)} */
		double d_sq = obs.histo_dist_sq (histo1, histo2);

		return Math.exp (-sigma * d_sq);
	}
	
	public double prob_p (Atributes A1, Atributes A2, double sigma)
	{
		double d = Math.sqrt ( 
				( A2.get_x() - A1.get_x() ) * ( A2.get_x() - A1.get_x() ) + 
				( A2.get_y() - A1.get_y() ) * ( A2.get_y() - A1.get_y() ) );
	    
	    double prob = Math.exp (-(d*d)/(2*sigma*sigma));

	    return prob;
	}
	
	public double prob_s (Atributes A1, Atributes A2, double sigma)
	{		
		int s1 = A1.get_width() * A1.get_height();
		
		int s2 = A2.get_width() * A2.get_height();
		
		double s = (s1-s2)/s1;
	    
	    double prob = Math.exp (-(s*s)/(2*sigma*sigma));

	    return prob;
	}	   
}
