package particlefiltering;

/*
A particle is an instantiation of the state variables of the system
being monitored.  A collection of particles is essentially a
discretization of the posterior probability of the system.
*/

public class particle {
	
	private double x;          /**< current x coordinate */
	private double y;          /**< current y coordinate */
	private double s;          /**< scale */
	private double xp;         /**< previous x coordinate */
	private double yp;         /**< previous y coordinate */
	private double sp;         /**< previous scale */
	private double x0;         /**< original x coordinate */
	private double y0;         /**< original y coordinate */
	private double w;          /**< weight */
	private int width;        /**< original width of region described by particle */
	private int height;       /**< original height of region described by particle */
	pHistogram histo; /**< reference histogram describing region being tracked */
    public boolean valid = true;
	
	public void set_x (double x) {
		this.x = x;
	}
	
	public double get_x () {
		return x;
	}
	
	public void set_y (double y) {
		this.y = y;
	}
	
	public double get_y () {
		return y;
	}
	
	public void set_s (double s) {
		this.s = s;
	}
	
	public double get_s () {
		return s;
	}
	
	public void set_xp (double xp) {
		this.xp = xp;
	}
	
	public double get_xp () {
		return xp;
	}
	
	public void set_yp (double yp) {
		this.yp = yp;
	}
	
	public double get_yp () {
		return yp;
	}
	
	public void set_sp (double sp) {
		this.sp = sp;
	}
	
	public double get_sp () {
		return sp;
	}	
	
	public void set_x0 (double x0) {
		this.x0 = x0;
	}
	
	public double get_x0 () {
		return x0;
	}

	public void set_y0 (double y0) {
		this.y0 = y0;
	}
	
	public double get_y0 () {
		return y0;
	}
	
	public void set_width (int width) {
		this.width = width;
	}
	
	public int get_width () {
		return width;
	}
	
	public void set_height (int height) {
		this.height = height;
	}
	
	public int get_height () {
		return height;
	}
	
	public void set_weight (double w) { 
		this.w = w;
	}
	
	public double get_weight () {
		return w;
	}
	
	public pHistogram get_histo () {
		return histo;
	}

}
