package classification;

import java.io.FileReader;
import java.io.LineNumberReader;
import preprocessing.Parser;

public class SVM {

	private int kernel_type;
    private double kernel_g_parameter;
	private double kernel_b_parameter;
	private int number_of_samples;
	private int sample_size;
	private double[] data;
	private double[] alpha;

	public int Get_Kernel_Type () {
		return kernel_type;
	}
	
	public int Get_Number_of_Samples() {
		return this.number_of_samples;
	}
    
	public int Get_Sample_Size() {
		return this.sample_size;
	}

    public double Get_SVM_G_Parameter () {
		return this.kernel_g_parameter;
	}

	public double Get_SVM_B_Parameter () {
		return this.kernel_b_parameter;
	}
    
	public double Get_Trained_Samples (int pos)	{
		return data[pos];
	}

	public double Get_Alpha (int pos) {
		return alpha[pos];
	}
	
    public void Reads_SVM_Model_From_Ascii_File (String file_name) {
    	
    	Parser parser = new Parser();

    	try {
    		
    		LineNumberReader file = new LineNumberReader(new FileReader(file_name));
    		
    		/*SVM training information*/
    		kernel_type = Integer.parseInt(parser.getLineParameter (file, "\n", 0));
    		kernel_g_parameter = Double.parseDouble(parser.getLineParameter(file, "\n", 0));
    		sample_size = Integer.parseInt(parser.getLineParameter (file, "\n", 0));
    		number_of_samples = Integer.parseInt(parser.getLineParameter (file, "\n", 0));
    		kernel_b_parameter = Double.parseDouble(parser.getLineParameter(file, "\n", 0));

    		data = parser.Get_Data (number_of_samples * sample_size, file); 

    		alpha = parser.Get_Data (number_of_samples, file);

    		file.close();
    	}
    	catch(Exception e){
    		System.err.println ("error: file \"" + file_name + "\" can not be loaded. ");
    		e.printStackTrace();
    	}
    }
}