package preprocessing;

import java.awt.image.BufferedImage;

public class HistogramCorrection {

	/*Stretching the image values to [0-255]*/
	public static void Image_Stretch (BufferedImage image)
	{
	    int w = image.getWidth(null);
	    
	    int h = image.getHeight(null);
	    
	    int size = w * h;
	    
	    int[] array = Util.getImageArray(image);

	    /*Searching the minimum and maximum value of the image*/
	    int min = 255, max = 0;
	    for(int i = 0; i < size; i++) {
	       if (array[i] < min) {
	          min = array[i];
	       }
	       if (array[i] > max) {
	          max = array[i];
	       }
	    }
	    
	    /*If the image has only one grey level returns*/
	    if (max == min) {
	       return;
	    }
	    
	    /*Changing the image interval*/
	    if ( (max < 255) || (min > 0) ) {
	       int mm = max - min;
	       for(int i = 0; i < size; i++) {
	          array[i] = 255 * (array[i] - min)/mm;
	       }
	    }

	    int startX = 0; int startY = 0;
	    Util.greyToColorImage (array, w, h);
	    image.setRGB(startX, startY, w, h, array, 0, w);
	}
	
	/*Image inversion (negating)*/
	public static BufferedImage Image_Inversion (BufferedImage image) {
			   
	    int w = image.getWidth(null);
		
	    int h = image.getHeight(null);
		
	    int size = w * h;
		
		int[] array = Util.getImageArray(image);
		
		int[] out = new int[size];
   
		/*Negating the image: [0 -> 255 and 255 -> 0]*/
   	    for(int i = 0; i < size; i++) {
           out[i] = 255 - array[i];
   	    }   
   	 
   	    int startX = 0; int startY = 0;
	    Util.greyToColorImage (out, w, h);
	    BufferedImage outimg = new BufferedImage (w, h, BufferedImage.TYPE_INT_ARGB);
		outimg.setRGB(startX, startY, w, h, out, 0, w);
	    return outimg;
    }
}
