# /usr/bin/python3
# Test program for module {raster_example_paper_B}
# Last edited on 2021-10-17 17:31:25 by stolfi

import raster_example_paper_B
import move
import move_parms
import path
import contact
import input_data
import txt_write
import job_parms
import hacks
import pyx
import rn
import sys
from math import sqrt, sin, cos, floor, ceil, inf, nan, pi

parms = job_parms.typical_js()

mp_jump = move_parms.make_for_jumps(parms)

# Some arbitrary dynamics parameters:
ac = parms['acceleration'] 
sp = parms['max_extrusion_speed'] 

# Move parameters matching the raster spacings in the file:
wd_cont = 0.75; mp_cont = move_parms.make(wd_cont, ac, sp, 0.0)
wd_fill = 1.00; mp_fill = move_parms.make(wd_fill, ac, sp, 0.0)
wd_link = 0.50; mp_link = move_parms.make(wd_link, ac, sp, 0.0)

wd_axes = 0.15*min(wd_fill,wd_cont)

parms['solid_raster_width'] = wd_fill
parms['contour_trace_width'] = wd_cont

def test_make_simple_path_or_moves(which):

  sys.stderr.write("--- testing {make_simple_path,make_simple_moves} ---\n")
  
  OCRS = []
  OLKS = []
  CTS = []
  if which == "path":
    tag = "make_simple_path"
    OPHS = raster_example_paper_B.make_simple_path(mp_fill, mp_jump)
  elif which == "moves":
    tag = "make_simple_moves"
    OPHS = raster_example_paper_B.make_simple_moves(mp_fill, mp_jump)
  else:
    assert False
    
  # Plot:
  o = None
  deco = True
  ydir = (0,1)
  for iph in range(len(OPHS)):
    oph = OPHS[iph]
    fname = "tests/out/raster_example_paper_B_TST_" + tag + ("_%d" % iph)
    input_data.show_check_and_plot(fname, OCRS, [oph,], OLKS, CTS, o, ydir, wd_axes, deco)
  return
  # ----------------------------------------------------------------------

def test_make_turkey():

  sys.stderr.write("--- testing {make_turkey} ---\n")
  
  tag = "make_turkey"
  
  OCRS, OPHS, OLKS, CTS, VGS, EGS = raster_example_paper_B.make_turkey(mp_cont, mp_fill, mp_link, mp_jump)
  o = None

  # Plot:
  deco = True
  ydir = (0,1)
  fname = "tests/out/raster_example_paper_B_TST_" + tag
  sys.stderr.write("wd_axes = %.3f\n" % wd_axes)
  input_data.show_check_and_plot(fname, OCRS, OPHS, OLKS, CTS, o, ydir, wd_axes, deco)
  return
  # ----------------------------------------------------------------------

def test_write_txt():
  sys.stderr.write("--- testing txt output ---\n")
  OCRS,OPHS,OLKS,CTS,VGS,EGS = raster_example_paper_B.make_turkey(mp_cont, mp_fill, mp_link, mp_jump) 

  fname = "tests/out/raster_example_paper_B_TST.txt"
  wr = open(fname, "w")

  Z = 10.0
  angle = 0
  shift = (0,0)
  for oph in OPHS: path.set_group(oph,0)
  txt_write.write(wr, OCRS, OPHS, Z, angle, shift)
  wr.close()
  return
  # ----------------------------------------------------------------------

# Figures:

test_make_simple_path_or_moves("path")
test_make_simple_path_or_moves("moves")
# test_make_turkey()
# test_write_txt()
