#! /usr/bin/python3
# Last edited on 2024-07-26 14:08:29 by stolfi

from math import sin, cos, tan, atan2, asin, hypot, sqrt, pi, inf, floor, sqrt
import rn, rmxn
import sys
import re
import random

import slicing_rackpin_IMP

def build_mesh(nt_rack,nt_pini,nf,ni):
  # Returns a mesh data structure {M}, as expected by e.g.
  # {slicing_OBJ.write}, describing a straight rack and a matching
  # pinion.  The rack has the longer direction towards the {Z} axis,
  # while the pinion has {Z} as the axis of rotation.
  #
  # The number of teeth is {nt_rack} for the rack and {nt_pini} for the pinion.
  # The parameters {nf} and {ni} determine the number of edges in the 
  # profile of each tooth.
  #
  # Each tooth has hundreds of rectangular or triangular facets.
  # The rack has non-convex Z-monotone faces with hundreds of angles.
  #
  # The structure {M} is a Python dict with keys 'V', 'E', 'F', 'P', 'T'.
  # Each element is a list of tuples, respectively the verices, edges, faces,
  # monotonization diagonals, and triangulation diagonals.
  #
  # Each element {v = M['V'][iv]} of the 'V' list is a 4-tuple where the
  # first three are the coordinates {x,y,z} of the vertex, and the
  # fourth {v[3]} is a string label that describes the vertex.
  #
  # The long direction of the rack is the {Z} axis, and the teeth are on
  # the {+X} face. The pinion is lying on the {Z=0} plane, with the axis
  # of rotation parallel to the {Z} axis.
  #
  # Each part is basically a prism obtained by extruding a polygon then
  # shaving off a 45 degree bevel with depth {bw} along the border of
  # each base.
  #
  # For {i} in {0..nt} label of a vertex that lies on tooth {i} is
  # "{c}.T.{i:04d}.{u}.{j:04d}.{s}" where {c} is "R" for the rack and
  # "P" for the pinion. The key {u} is 'b0', 't0', 't1', 'b1' where the
  # first letter is 'b' for the bottom of the tooth gap, 't' for the
  # tooth tip, and the second letter is '0' for the low-{Z} half of the
  # tooth, '1' for the high-{Z} half. The index {j} ranges in {0..nf},
  # in increasing {Z} for {u} = 'b0' or 't1' and decreasing {Z} for {u}
  # = 't0' or 'b1'. There are nonzero straight sides between the four
  # four parts of the tooth.
  #
  # The key {s} is 'pf', 'pe', 'me', or 'mf', where the first letter
  # specifies the sign of the {Y} coordinate (positive 'p', negative
  # 'm'), and the second is 'f' for the flat face at {Y = ±wd/2} and 'e'
  # for the bevel edge at {Y = ±(wd/2 - bw)}.
  #
  # The label for the other rack vertices (the corners of the flat face)
  # are "R.B.{e}.{k:02d}.{s}" where 'e' is 0 for low {Z} end, 1 for high
  # {Z} end, and {k} increases with {X}. The labels of vertices in the
  # pinion's central hole are "P.H.{k:05d}" where {k} increases in
  # circular order.
  return slicing_rackpin_IMP.build_mesh()
