#declare slicing_num_faces = 380;
#declare slicing_num_edges = 570;
#declare slicing_num_vertices = 192;

#declare slicing_num_planes = 0;
#declare slicing_planes_Z_min = -1.00000;
#declare slicing_planes_Z_max = 1.00000;
#declare slicing_edge_radius = 0.2979185;
#declare slicing_vertex_radius = 0.7447962;

#macro slicing_vertices()
  #local Nv = 192;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 26.60254, 0.00000, -50.00000 >; // vp.0.0
  #local V[   2] = < 21.52190, 15.63658, -50.00000 >; // vp.1.0
  #local V[   3] = < 8.22064, 25.30052, -50.00000 >; // vp.2.0
  #local V[   4] = < -8.22064, 25.30052, -50.00000 >; // vp.3.0
  #local V[   5] = < -21.52190, 15.63658, -50.00000 >; // vp.4.0
  #local V[   6] = < -26.60254, 0.00000, -50.00000 >; // vp.5.0
  #local V[   7] = < -21.52190, -15.63658, -50.00000 >; // vp.6.0
  #local V[   8] = < -8.22064, -25.30052, -50.00000 >; // vp.7.0
  #local V[   9] = < 8.22064, -25.30052, -50.00000 >; // vp.8.0
  #local V[  10] = < 21.52190, -15.63658, -50.00000 >; // vp.9.0
  #local V[  11] = < 33.96926, 0.00000, -34.20202 >; // vp.0.1
  #local V[  12] = < 29.05812, 0.00000, -44.73400 >; // ve.0.0.0
  #local V[  13] = < 31.51368, 0.00000, -39.46800 >; // ve.0.0.1
  #local V[  14] = < 27.48172, 19.96664, -34.20202 >; // vp.1.1
  #local V[  15] = < 23.50850, 17.07994, -44.73400 >; // ve.1.0.0
  #local V[  16] = < 25.49510, 18.52328, -39.46800 >; // ve.1.0.1
  #local V[  17] = < 10.49708, 32.30668, -34.20202 >; // vp.2.1
  #local V[  18] = < 8.97946, 27.63590, -44.73400 >; // ve.2.0.0
  #local V[  19] = < 9.73826, 29.97130, -39.46800 >; // ve.2.0.1
  #local V[  20] = < -10.49708, 32.30668, -34.20202 >; // vp.3.1
  #local V[  21] = < -8.97946, 27.63590, -44.73400 >; // ve.3.0.0
  #local V[  22] = < -9.73826, 29.97130, -39.46800 >; // ve.3.0.1
  #local V[  23] = < -27.48172, 19.96664, -34.20202 >; // vp.4.1
  #local V[  24] = < -23.50850, 17.07994, -44.73400 >; // ve.4.0.0
  #local V[  25] = < -25.49510, 18.52328, -39.46800 >; // ve.4.0.1
  #local V[  26] = < -33.96926, 0.00000, -34.20202 >; // vp.5.1
  #local V[  27] = < -29.05812, 0.00000, -44.73400 >; // ve.5.0.0
  #local V[  28] = < -31.51368, 0.00000, -39.46800 >; // ve.5.0.1
  #local V[  29] = < -27.48172, -19.96664, -34.20202 >; // vp.6.1
  #local V[  30] = < -23.50850, -17.07994, -44.73400 >; // ve.6.0.0
  #local V[  31] = < -25.49510, -18.52328, -39.46800 >; // ve.6.0.1
  #local V[  32] = < -10.49708, -32.30668, -34.20202 >; // vp.7.1
  #local V[  33] = < -8.97946, -27.63590, -44.73400 >; // ve.7.0.0
  #local V[  34] = < -9.73826, -29.97130, -39.46800 >; // ve.7.0.1
  #local V[  35] = < 10.49708, -32.30668, -34.20202 >; // vp.8.1
  #local V[  36] = < 8.97946, -27.63590, -44.73400 >; // ve.8.0.0
  #local V[  37] = < 9.73826, -29.97130, -39.46800 >; // ve.8.0.1
  #local V[  38] = < 27.48172, -19.96664, -34.20202 >; // vp.9.1
  #local V[  39] = < 23.50850, -17.07994, -44.73400 >; // ve.9.0.0
  #local V[  40] = < 25.49510, -18.52328, -39.46800 >; // ve.9.0.1
  #local V[  41] = < 38.48078, 0.00000, -17.36482 >; // vp.0.2
  #local V[  42] = < 35.47310, 0.00000, -28.58962 >; // ve.0.1.0
  #local V[  43] = < 36.97694, 0.00000, -22.97722 >; // ve.0.1.1
  #local V[  44] = < 31.13160, 22.61844, -17.36482 >; // vp.1.2
  #local V[  45] = < 28.69834, 20.85058, -28.58962 >; // ve.1.1.0
  #local V[  46] = < 29.91498, 21.73450, -22.97722 >; // ve.1.1.1
  #local V[  47] = < 11.89122, 36.59740, -17.36482 >; // vp.2.2
  #local V[  48] = < 10.96180, 33.73692, -28.58962 >; // ve.2.1.0
  #local V[  49] = < 11.42650, 35.16716, -22.97722 >; // ve.2.1.1
  #local V[  50] = < -11.89122, 36.59740, -17.36482 >; // vp.3.2
  #local V[  51] = < -10.96180, 33.73692, -28.58962 >; // ve.3.1.0
  #local V[  52] = < -11.42650, 35.16716, -22.97722 >; // ve.3.1.1
  #local V[  53] = < -31.13160, 22.61844, -17.36482 >; // vp.4.2
  #local V[  54] = < -28.69834, 20.85058, -28.58962 >; // ve.4.1.0
  #local V[  55] = < -29.91498, 21.73450, -22.97722 >; // ve.4.1.1
  #local V[  56] = < -38.48078, 0.00000, -17.36482 >; // vp.5.2
  #local V[  57] = < -35.47310, 0.00000, -28.58962 >; // ve.5.1.0
  #local V[  58] = < -36.97694, 0.00000, -22.97722 >; // ve.5.1.1
  #local V[  59] = < -31.13160, -22.61844, -17.36482 >; // vp.6.2
  #local V[  60] = < -28.69834, -20.85058, -28.58962 >; // ve.6.1.0
  #local V[  61] = < -29.91498, -21.73450, -22.97722 >; // ve.6.1.1
  #local V[  62] = < -11.89122, -36.59740, -17.36482 >; // vp.7.2
  #local V[  63] = < -10.96180, -33.73692, -28.58962 >; // ve.7.1.0
  #local V[  64] = < -11.42650, -35.16716, -22.97722 >; // ve.7.1.1
  #local V[  65] = < 11.89122, -36.59740, -17.36482 >; // vp.8.2
  #local V[  66] = < 10.96180, -33.73692, -28.58962 >; // ve.8.1.0
  #local V[  67] = < 11.42650, -35.16716, -22.97722 >; // ve.8.1.1
  #local V[  68] = < 31.13160, -22.61844, -17.36482 >; // vp.9.2
  #local V[  69] = < 28.69834, -20.85058, -28.58962 >; // ve.9.1.0
  #local V[  70] = < 29.91498, -21.73450, -22.97722 >; // ve.9.1.1
  #local V[  71] = < 40.00000, 0.00000, 0.00000 >; // vp.0.3
  #local V[  72] = < 38.98718, 0.00000, -11.57654 >; // ve.0.2.0
  #local V[  73] = < 39.49360, 0.00000, -5.78828 >; // ve.0.2.1
  #local V[  74] = < 32.36068, 23.51142, 0.00000 >; // vp.1.3
  #local V[  75] = < 31.54130, 22.91610, -11.57654 >; // ve.1.2.0
  #local V[  76] = < 31.95098, 23.21376, -5.78828 >; // ve.1.2.1
  #local V[  77] = < 12.36068, 38.04226, 0.00000 >; // vp.2.3
  #local V[  78] = < 12.04770, 37.07902, -11.57654 >; // ve.2.2.0
  #local V[  79] = < 12.20420, 37.56064, -5.78828 >; // ve.2.2.1
  #local V[  80] = < -12.36068, 38.04226, 0.00000 >; // vp.3.3
  #local V[  81] = < -12.04770, 37.07902, -11.57654 >; // ve.3.2.0
  #local V[  82] = < -12.20420, 37.56064, -5.78828 >; // ve.3.2.1
  #local V[  83] = < -32.36068, 23.51142, 0.00000 >; // vp.4.3
  #local V[  84] = < -31.54130, 22.91610, -11.57654 >; // ve.4.2.0
  #local V[  85] = < -31.95098, 23.21376, -5.78828 >; // ve.4.2.1
  #local V[  86] = < -40.00000, 0.00000, 0.00000 >; // vp.5.3
  #local V[  87] = < -38.98718, 0.00000, -11.57654 >; // ve.5.2.0
  #local V[  88] = < -39.49360, 0.00000, -5.78828 >; // ve.5.2.1
  #local V[  89] = < -32.36068, -23.51142, 0.00000 >; // vp.6.3
  #local V[  90] = < -31.54130, -22.91610, -11.57654 >; // ve.6.2.0
  #local V[  91] = < -31.95098, -23.21376, -5.78828 >; // ve.6.2.1
  #local V[  92] = < -12.36068, -38.04226, 0.00000 >; // vp.7.3
  #local V[  93] = < -12.04770, -37.07902, -11.57654 >; // ve.7.2.0
  #local V[  94] = < -12.20420, -37.56064, -5.78828 >; // ve.7.2.1
  #local V[  95] = < 12.36068, -38.04226, 0.00000 >; // vp.8.3
  #local V[  96] = < 12.04770, -37.07902, -11.57654 >; // ve.8.2.0
  #local V[  97] = < 12.20420, -37.56064, -5.78828 >; // ve.8.2.1
  #local V[  98] = < 32.36068, -23.51142, 0.00000 >; // vp.9.3
  #local V[  99] = < 31.54130, -22.91610, -11.57654 >; // ve.9.2.0
  #local V[ 100] = < 31.95098, -23.21376, -5.78828 >; // ve.9.2.1
  #local V[ 101] = < 38.48078, 0.00000, 17.36482 >; // vp.0.4
  #local V[ 102] = < 39.49360, 0.00000, 5.78828 >; // ve.0.3.0
  #local V[ 103] = < 38.98718, 0.00000, 11.57654 >; // ve.0.3.1
  #local V[ 104] = < 31.13160, 22.61844, 17.36482 >; // vp.1.4
  #local V[ 105] = < 31.95098, 23.21376, 5.78828 >; // ve.1.3.0
  #local V[ 106] = < 31.54130, 22.91610, 11.57654 >; // ve.1.3.1
  #local V[ 107] = < 11.89122, 36.59740, 17.36482 >; // vp.2.4
  #local V[ 108] = < 12.20420, 37.56064, 5.78828 >; // ve.2.3.0
  #local V[ 109] = < 12.04770, 37.07902, 11.57654 >; // ve.2.3.1
  #local V[ 110] = < -11.89122, 36.59740, 17.36482 >; // vp.3.4
  #local V[ 111] = < -12.20420, 37.56064, 5.78828 >; // ve.3.3.0
  #local V[ 112] = < -12.04770, 37.07902, 11.57654 >; // ve.3.3.1
  #local V[ 113] = < -31.13160, 22.61844, 17.36482 >; // vp.4.4
  #local V[ 114] = < -31.95098, 23.21376, 5.78828 >; // ve.4.3.0
  #local V[ 115] = < -31.54130, 22.91610, 11.57654 >; // ve.4.3.1
  #local V[ 116] = < -38.48078, 0.00000, 17.36482 >; // vp.5.4
  #local V[ 117] = < -39.49360, 0.00000, 5.78828 >; // ve.5.3.0
  #local V[ 118] = < -38.98718, 0.00000, 11.57654 >; // ve.5.3.1
  #local V[ 119] = < -31.13160, -22.61844, 17.36482 >; // vp.6.4
  #local V[ 120] = < -31.95098, -23.21376, 5.78828 >; // ve.6.3.0
  #local V[ 121] = < -31.54130, -22.91610, 11.57654 >; // ve.6.3.1
  #local V[ 122] = < -11.89122, -36.59740, 17.36482 >; // vp.7.4
  #local V[ 123] = < -12.20420, -37.56064, 5.78828 >; // ve.7.3.0
  #local V[ 124] = < -12.04770, -37.07902, 11.57654 >; // ve.7.3.1
  #local V[ 125] = < 11.89122, -36.59740, 17.36482 >; // vp.8.4
  #local V[ 126] = < 12.20420, -37.56064, 5.78828 >; // ve.8.3.0
  #local V[ 127] = < 12.04770, -37.07902, 11.57654 >; // ve.8.3.1
  #local V[ 128] = < 31.13160, -22.61844, 17.36482 >; // vp.9.4
  #local V[ 129] = < 31.95098, -23.21376, 5.78828 >; // ve.9.3.0
  #local V[ 130] = < 31.54130, -22.91610, 11.57654 >; // ve.9.3.1
  #local V[ 131] = < 33.96926, 0.00000, 34.20202 >; // vp.0.5
  #local V[ 132] = < 36.97694, 0.00000, 22.97722 >; // ve.0.4.0
  #local V[ 133] = < 35.47310, 0.00000, 28.58962 >; // ve.0.4.1
  #local V[ 134] = < 27.48172, 19.96664, 34.20202 >; // vp.1.5
  #local V[ 135] = < 29.91498, 21.73450, 22.97722 >; // ve.1.4.0
  #local V[ 136] = < 28.69834, 20.85056, 28.58962 >; // ve.1.4.1
  #local V[ 137] = < 10.49708, 32.30668, 34.20202 >; // vp.2.5
  #local V[ 138] = < 11.42650, 35.16716, 22.97722 >; // ve.2.4.0
  #local V[ 139] = < 10.96180, 33.73692, 28.58962 >; // ve.2.4.1
  #local V[ 140] = < -10.49708, 32.30668, 34.20202 >; // vp.3.5
  #local V[ 141] = < -11.42650, 35.16716, 22.97722 >; // ve.3.4.0
  #local V[ 142] = < -10.96180, 33.73692, 28.58962 >; // ve.3.4.1
  #local V[ 143] = < -27.48172, 19.96664, 34.20202 >; // vp.4.5
  #local V[ 144] = < -29.91498, 21.73450, 22.97722 >; // ve.4.4.0
  #local V[ 145] = < -28.69834, 20.85056, 28.58962 >; // ve.4.4.1
  #local V[ 146] = < -33.96926, 0.00000, 34.20202 >; // vp.5.5
  #local V[ 147] = < -36.97694, 0.00000, 22.97722 >; // ve.5.4.0
  #local V[ 148] = < -35.47310, 0.00000, 28.58962 >; // ve.5.4.1
  #local V[ 149] = < -27.48172, -19.96664, 34.20202 >; // vp.6.5
  #local V[ 150] = < -29.91498, -21.73450, 22.97722 >; // ve.6.4.0
  #local V[ 151] = < -28.69834, -20.85056, 28.58962 >; // ve.6.4.1
  #local V[ 152] = < -10.49708, -32.30668, 34.20202 >; // vp.7.5
  #local V[ 153] = < -11.42650, -35.16716, 22.97722 >; // ve.7.4.0
  #local V[ 154] = < -10.96180, -33.73692, 28.58962 >; // ve.7.4.1
  #local V[ 155] = < 10.49708, -32.30668, 34.20202 >; // vp.8.5
  #local V[ 156] = < 11.42650, -35.16716, 22.97722 >; // ve.8.4.0
  #local V[ 157] = < 10.96180, -33.73692, 28.58962 >; // ve.8.4.1
  #local V[ 158] = < 27.48172, -19.96664, 34.20202 >; // vp.9.5
  #local V[ 159] = < 29.91498, -21.73450, 22.97722 >; // ve.9.4.0
  #local V[ 160] = < 28.69834, -20.85056, 28.58962 >; // ve.9.4.1
  #local V[ 161] = < 26.60254, 0.00000, 50.00000 >; // vp.0.6
  #local V[ 162] = < 31.51368, 0.00000, 39.46802 >; // ve.0.5.0
  #local V[ 163] = < 29.05812, 0.00000, 44.73400 >; // ve.0.5.1
  #local V[ 164] = < 21.52190, 15.63658, 50.00000 >; // vp.1.6
  #local V[ 165] = < 25.49512, 18.52328, 39.46802 >; // ve.1.5.0
  #local V[ 166] = < 23.50852, 17.07994, 44.73400 >; // ve.1.5.1
  #local V[ 167] = < 8.22064, 25.30052, 50.00000 >; // vp.2.6
  #local V[ 168] = < 9.73826, 29.97130, 39.46802 >; // ve.2.5.0
  #local V[ 169] = < 8.97946, 27.63590, 44.73400 >; // ve.2.5.1
  #local V[ 170] = < -8.22064, 25.30052, 50.00000 >; // vp.3.6
  #local V[ 171] = < -9.73826, 29.97130, 39.46802 >; // ve.3.5.0
  #local V[ 172] = < -8.97946, 27.63590, 44.73400 >; // ve.3.5.1
  #local V[ 173] = < -21.52190, 15.63658, 50.00000 >; // vp.4.6
  #local V[ 174] = < -25.49512, 18.52328, 39.46802 >; // ve.4.5.0
  #local V[ 175] = < -23.50852, 17.07994, 44.73400 >; // ve.4.5.1
  #local V[ 176] = < -26.60254, 0.00000, 50.00000 >; // vp.5.6
  #local V[ 177] = < -31.51368, 0.00000, 39.46802 >; // ve.5.5.0
  #local V[ 178] = < -29.05812, 0.00000, 44.73400 >; // ve.5.5.1
  #local V[ 179] = < -21.52190, -15.63658, 50.00000 >; // vp.6.6
  #local V[ 180] = < -25.49512, -18.52328, 39.46802 >; // ve.6.5.0
  #local V[ 181] = < -23.50852, -17.07994, 44.73400 >; // ve.6.5.1
  #local V[ 182] = < -8.22064, -25.30052, 50.00000 >; // vp.7.6
  #local V[ 183] = < -9.73826, -29.97130, 39.46802 >; // ve.7.5.0
  #local V[ 184] = < -8.97946, -27.63590, 44.73400 >; // ve.7.5.1
  #local V[ 185] = < 8.22064, -25.30052, 50.00000 >; // vp.8.6
  #local V[ 186] = < 9.73826, -29.97130, 39.46802 >; // ve.8.5.0
  #local V[ 187] = < 8.97946, -27.63590, 44.73400 >; // ve.8.5.1
  #local V[ 188] = < 21.52190, -15.63658, 50.00000 >; // vp.9.6
  #local V[ 189] = < 25.49512, -18.52328, 39.46802 >; // ve.9.5.0
  #local V[ 190] = < 23.50852, -17.07994, 44.73400 >; // ve.9.5.1
  #local V[ 191] = < 0.00000, 0.00000, -50.00000 >; // vc.0
  #local V[ 192] = < 0.00000, 0.00000, 50.00000 >; // vc.1
  V
#end


#macro slicing_edges()
  #local Ne = 570;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   0 original object edge.
  //   1 refinement (triangulation, monotonization, etc) edge.
  //   2 ghost edge.
  // 
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 2, 0 >; // vp.0.0--vp.1.0:fv.0.0;
  #local E[   2] = < 2, 15, 0 >; // vp.1.0--ve.1.0.0:fv.0.0;
  #local E[   3] = < 15, 16, 0 >; // ve.1.0.0--ve.1.0.1:fv.0.0;
  #local E[   4] = < 11, 13, 0 >; // vp.0.1--ve.0.0.1:fv.0.0;
  #local E[   5] = < 11, 14, 0 >; // vp.0.1--vp.1.1:fv.0.1;
  #local E[   6] = < 14, 45, 0 >; // vp.1.1--ve.1.1.0:fv.0.1;
  #local E[   7] = < 45, 46, 0 >; // ve.1.1.0--ve.1.1.1:fv.0.1;
  #local E[   8] = < 41, 43, 0 >; // vp.0.2--ve.0.1.1:fv.0.1;
  #local E[   9] = < 41, 44, 0 >; // vp.0.2--vp.1.2:fv.0.2;
  #local E[  10] = < 44, 75, 0 >; // vp.1.2--ve.1.2.0:fv.0.2;
  #local E[  11] = < 75, 76, 0 >; // ve.1.2.0--ve.1.2.1:fv.0.2;
  #local E[  12] = < 71, 73, 0 >; // vp.0.3--ve.0.2.1:fv.0.2;
  #local E[  13] = < 71, 74, 0 >; // vp.0.3--vp.1.3:fv.0.3;
  #local E[  14] = < 74, 105, 0 >; // vp.1.3--ve.1.3.0:fv.0.3;
  #local E[  15] = < 105, 106, 0 >; // ve.1.3.0--ve.1.3.1:fv.0.3;
  #local E[  16] = < 101, 103, 0 >; // vp.0.4--ve.0.3.1:fv.0.3;
  #local E[  17] = < 101, 104, 0 >; // vp.0.4--vp.1.4:fv.0.4;
  #local E[  18] = < 104, 135, 0 >; // vp.1.4--ve.1.4.0:fv.0.4;
  #local E[  19] = < 135, 136, 0 >; // ve.1.4.0--ve.1.4.1:fv.0.4;
  #local E[  20] = < 131, 133, 0 >; // vp.0.5--ve.0.4.1:fv.0.4;
  #local E[  21] = < 131, 134, 0 >; // vp.0.5--vp.1.5:fv.0.5;
  #local E[  22] = < 134, 165, 0 >; // vp.1.5--ve.1.5.0:fv.0.5;
  #local E[  23] = < 165, 166, 0 >; // ve.1.5.0--ve.1.5.1:fv.0.5;
  #local E[  24] = < 161, 163, 0 >; // vp.0.6--ve.0.5.1:fv.0.5;
  #local E[  25] = < 1, 191, 0 >; // vp.0.0--vc.0:fh.0.0;
  #local E[  26] = < 161, 164, 0 >; // vp.0.6--vp.1.6:fh.0.1;
  #local E[  27] = < 164, 192, 0 >; // vp.1.6--vc.1:fh.0.1;
  #local E[  28] = < 2, 3, 0 >; // vp.1.0--vp.2.0:fv.1.0;
  #local E[  29] = < 3, 18, 0 >; // vp.2.0--ve.2.0.0:fv.1.0;
  #local E[  30] = < 18, 19, 0 >; // ve.2.0.0--ve.2.0.1:fv.1.0;
  #local E[  31] = < 14, 16, 0 >; // vp.1.1--ve.1.0.1:fv.1.0;
  #local E[  32] = < 14, 17, 0 >; // vp.1.1--vp.2.1:fv.1.1;
  #local E[  33] = < 17, 48, 0 >; // vp.2.1--ve.2.1.0:fv.1.1;
  #local E[  34] = < 48, 49, 0 >; // ve.2.1.0--ve.2.1.1:fv.1.1;
  #local E[  35] = < 44, 46, 0 >; // vp.1.2--ve.1.1.1:fv.1.1;
  #local E[  36] = < 44, 47, 0 >; // vp.1.2--vp.2.2:fv.1.2;
  #local E[  37] = < 47, 78, 0 >; // vp.2.2--ve.2.2.0:fv.1.2;
  #local E[  38] = < 78, 79, 0 >; // ve.2.2.0--ve.2.2.1:fv.1.2;
  #local E[  39] = < 74, 76, 0 >; // vp.1.3--ve.1.2.1:fv.1.2;
  #local E[  40] = < 74, 77, 0 >; // vp.1.3--vp.2.3:fv.1.3;
  #local E[  41] = < 77, 108, 0 >; // vp.2.3--ve.2.3.0:fv.1.3;
  #local E[  42] = < 108, 109, 0 >; // ve.2.3.0--ve.2.3.1:fv.1.3;
  #local E[  43] = < 104, 106, 0 >; // vp.1.4--ve.1.3.1:fv.1.3;
  #local E[  44] = < 104, 107, 0 >; // vp.1.4--vp.2.4:fv.1.4;
  #local E[  45] = < 107, 138, 0 >; // vp.2.4--ve.2.4.0:fv.1.4;
  #local E[  46] = < 138, 139, 0 >; // ve.2.4.0--ve.2.4.1:fv.1.4;
  #local E[  47] = < 134, 136, 0 >; // vp.1.5--ve.1.4.1:fv.1.4;
  #local E[  48] = < 134, 137, 0 >; // vp.1.5--vp.2.5:fv.1.5;
  #local E[  49] = < 137, 168, 0 >; // vp.2.5--ve.2.5.0:fv.1.5;
  #local E[  50] = < 168, 169, 0 >; // ve.2.5.0--ve.2.5.1:fv.1.5;
  #local E[  51] = < 164, 166, 0 >; // vp.1.6--ve.1.5.1:fv.1.5;
  #local E[  52] = < 2, 191, 0 >; // vp.1.0--vc.0:fh.1.0;
  #local E[  53] = < 164, 167, 0 >; // vp.1.6--vp.2.6:fh.1.1;
  #local E[  54] = < 167, 192, 0 >; // vp.2.6--vc.1:fh.1.1;
  #local E[  55] = < 3, 4, 0 >; // vp.2.0--vp.3.0:fv.2.0;
  #local E[  56] = < 4, 21, 0 >; // vp.3.0--ve.3.0.0:fv.2.0;
  #local E[  57] = < 21, 22, 0 >; // ve.3.0.0--ve.3.0.1:fv.2.0;
  #local E[  58] = < 17, 19, 0 >; // vp.2.1--ve.2.0.1:fv.2.0;
  #local E[  59] = < 17, 20, 0 >; // vp.2.1--vp.3.1:fv.2.1;
  #local E[  60] = < 20, 51, 0 >; // vp.3.1--ve.3.1.0:fv.2.1;
  #local E[  61] = < 51, 52, 0 >; // ve.3.1.0--ve.3.1.1:fv.2.1;
  #local E[  62] = < 47, 49, 0 >; // vp.2.2--ve.2.1.1:fv.2.1;
  #local E[  63] = < 47, 50, 0 >; // vp.2.2--vp.3.2:fv.2.2;
  #local E[  64] = < 50, 81, 0 >; // vp.3.2--ve.3.2.0:fv.2.2;
  #local E[  65] = < 81, 82, 0 >; // ve.3.2.0--ve.3.2.1:fv.2.2;
  #local E[  66] = < 77, 79, 0 >; // vp.2.3--ve.2.2.1:fv.2.2;
  #local E[  67] = < 77, 80, 0 >; // vp.2.3--vp.3.3:fv.2.3;
  #local E[  68] = < 80, 111, 0 >; // vp.3.3--ve.3.3.0:fv.2.3;
  #local E[  69] = < 111, 112, 0 >; // ve.3.3.0--ve.3.3.1:fv.2.3;
  #local E[  70] = < 107, 109, 0 >; // vp.2.4--ve.2.3.1:fv.2.3;
  #local E[  71] = < 107, 110, 0 >; // vp.2.4--vp.3.4:fv.2.4;
  #local E[  72] = < 110, 141, 0 >; // vp.3.4--ve.3.4.0:fv.2.4;
  #local E[  73] = < 141, 142, 0 >; // ve.3.4.0--ve.3.4.1:fv.2.4;
  #local E[  74] = < 137, 139, 0 >; // vp.2.5--ve.2.4.1:fv.2.4;
  #local E[  75] = < 137, 140, 0 >; // vp.2.5--vp.3.5:fv.2.5;
  #local E[  76] = < 140, 171, 0 >; // vp.3.5--ve.3.5.0:fv.2.5;
  #local E[  77] = < 171, 172, 0 >; // ve.3.5.0--ve.3.5.1:fv.2.5;
  #local E[  78] = < 167, 169, 0 >; // vp.2.6--ve.2.5.1:fv.2.5;
  #local E[  79] = < 3, 191, 0 >; // vp.2.0--vc.0:fh.2.0;
  #local E[  80] = < 167, 170, 0 >; // vp.2.6--vp.3.6:fh.2.1;
  #local E[  81] = < 170, 192, 0 >; // vp.3.6--vc.1:fh.2.1;
  #local E[  82] = < 4, 5, 0 >; // vp.3.0--vp.4.0:fv.3.0;
  #local E[  83] = < 5, 24, 0 >; // vp.4.0--ve.4.0.0:fv.3.0;
  #local E[  84] = < 24, 25, 0 >; // ve.4.0.0--ve.4.0.1:fv.3.0;
  #local E[  85] = < 20, 22, 0 >; // vp.3.1--ve.3.0.1:fv.3.0;
  #local E[  86] = < 20, 23, 0 >; // vp.3.1--vp.4.1:fv.3.1;
  #local E[  87] = < 23, 54, 0 >; // vp.4.1--ve.4.1.0:fv.3.1;
  #local E[  88] = < 54, 55, 0 >; // ve.4.1.0--ve.4.1.1:fv.3.1;
  #local E[  89] = < 50, 52, 0 >; // vp.3.2--ve.3.1.1:fv.3.1;
  #local E[  90] = < 50, 53, 0 >; // vp.3.2--vp.4.2:fv.3.2;
  #local E[  91] = < 53, 84, 0 >; // vp.4.2--ve.4.2.0:fv.3.2;
  #local E[  92] = < 84, 85, 0 >; // ve.4.2.0--ve.4.2.1:fv.3.2;
  #local E[  93] = < 80, 82, 0 >; // vp.3.3--ve.3.2.1:fv.3.2;
  #local E[  94] = < 80, 83, 0 >; // vp.3.3--vp.4.3:fv.3.3;
  #local E[  95] = < 83, 114, 0 >; // vp.4.3--ve.4.3.0:fv.3.3;
  #local E[  96] = < 114, 115, 0 >; // ve.4.3.0--ve.4.3.1:fv.3.3;
  #local E[  97] = < 110, 112, 0 >; // vp.3.4--ve.3.3.1:fv.3.3;
  #local E[  98] = < 110, 113, 0 >; // vp.3.4--vp.4.4:fv.3.4;
  #local E[  99] = < 113, 144, 0 >; // vp.4.4--ve.4.4.0:fv.3.4;
  #local E[ 100] = < 144, 145, 0 >; // ve.4.4.0--ve.4.4.1:fv.3.4;
  #local E[ 101] = < 140, 142, 0 >; // vp.3.5--ve.3.4.1:fv.3.4;
  #local E[ 102] = < 140, 143, 0 >; // vp.3.5--vp.4.5:fv.3.5;
  #local E[ 103] = < 143, 174, 0 >; // vp.4.5--ve.4.5.0:fv.3.5;
  #local E[ 104] = < 174, 175, 0 >; // ve.4.5.0--ve.4.5.1:fv.3.5;
  #local E[ 105] = < 170, 172, 0 >; // vp.3.6--ve.3.5.1:fv.3.5;
  #local E[ 106] = < 4, 191, 0 >; // vp.3.0--vc.0:fh.3.0;
  #local E[ 107] = < 170, 173, 0 >; // vp.3.6--vp.4.6:fh.3.1;
  #local E[ 108] = < 173, 192, 0 >; // vp.4.6--vc.1:fh.3.1;
  #local E[ 109] = < 5, 6, 0 >; // vp.4.0--vp.5.0:fv.4.0;
  #local E[ 110] = < 6, 27, 0 >; // vp.5.0--ve.5.0.0:fv.4.0;
  #local E[ 111] = < 27, 28, 0 >; // ve.5.0.0--ve.5.0.1:fv.4.0;
  #local E[ 112] = < 23, 25, 0 >; // vp.4.1--ve.4.0.1:fv.4.0;
  #local E[ 113] = < 23, 26, 0 >; // vp.4.1--vp.5.1:fv.4.1;
  #local E[ 114] = < 26, 57, 0 >; // vp.5.1--ve.5.1.0:fv.4.1;
  #local E[ 115] = < 57, 58, 0 >; // ve.5.1.0--ve.5.1.1:fv.4.1;
  #local E[ 116] = < 53, 55, 0 >; // vp.4.2--ve.4.1.1:fv.4.1;
  #local E[ 117] = < 53, 56, 0 >; // vp.4.2--vp.5.2:fv.4.2;
  #local E[ 118] = < 56, 87, 0 >; // vp.5.2--ve.5.2.0:fv.4.2;
  #local E[ 119] = < 87, 88, 0 >; // ve.5.2.0--ve.5.2.1:fv.4.2;
  #local E[ 120] = < 83, 85, 0 >; // vp.4.3--ve.4.2.1:fv.4.2;
  #local E[ 121] = < 83, 86, 0 >; // vp.4.3--vp.5.3:fv.4.3;
  #local E[ 122] = < 86, 117, 0 >; // vp.5.3--ve.5.3.0:fv.4.3;
  #local E[ 123] = < 117, 118, 0 >; // ve.5.3.0--ve.5.3.1:fv.4.3;
  #local E[ 124] = < 113, 115, 0 >; // vp.4.4--ve.4.3.1:fv.4.3;
  #local E[ 125] = < 113, 116, 0 >; // vp.4.4--vp.5.4:fv.4.4;
  #local E[ 126] = < 116, 147, 0 >; // vp.5.4--ve.5.4.0:fv.4.4;
  #local E[ 127] = < 147, 148, 0 >; // ve.5.4.0--ve.5.4.1:fv.4.4;
  #local E[ 128] = < 143, 145, 0 >; // vp.4.5--ve.4.4.1:fv.4.4;
  #local E[ 129] = < 143, 146, 0 >; // vp.4.5--vp.5.5:fv.4.5;
  #local E[ 130] = < 146, 177, 0 >; // vp.5.5--ve.5.5.0:fv.4.5;
  #local E[ 131] = < 177, 178, 0 >; // ve.5.5.0--ve.5.5.1:fv.4.5;
  #local E[ 132] = < 173, 175, 0 >; // vp.4.6--ve.4.5.1:fv.4.5;
  #local E[ 133] = < 5, 191, 0 >; // vp.4.0--vc.0:fh.4.0;
  #local E[ 134] = < 173, 176, 0 >; // vp.4.6--vp.5.6:fh.4.1;
  #local E[ 135] = < 176, 192, 0 >; // vp.5.6--vc.1:fh.4.1;
  #local E[ 136] = < 6, 7, 0 >; // vp.5.0--vp.6.0:fv.5.0;
  #local E[ 137] = < 7, 30, 0 >; // vp.6.0--ve.6.0.0:fv.5.0;
  #local E[ 138] = < 30, 31, 0 >; // ve.6.0.0--ve.6.0.1:fv.5.0;
  #local E[ 139] = < 26, 28, 0 >; // vp.5.1--ve.5.0.1:fv.5.0;
  #local E[ 140] = < 26, 29, 0 >; // vp.5.1--vp.6.1:fv.5.1;
  #local E[ 141] = < 29, 60, 0 >; // vp.6.1--ve.6.1.0:fv.5.1;
  #local E[ 142] = < 60, 61, 0 >; // ve.6.1.0--ve.6.1.1:fv.5.1;
  #local E[ 143] = < 56, 58, 0 >; // vp.5.2--ve.5.1.1:fv.5.1;
  #local E[ 144] = < 56, 59, 0 >; // vp.5.2--vp.6.2:fv.5.2;
  #local E[ 145] = < 59, 90, 0 >; // vp.6.2--ve.6.2.0:fv.5.2;
  #local E[ 146] = < 90, 91, 0 >; // ve.6.2.0--ve.6.2.1:fv.5.2;
  #local E[ 147] = < 86, 88, 0 >; // vp.5.3--ve.5.2.1:fv.5.2;
  #local E[ 148] = < 86, 89, 0 >; // vp.5.3--vp.6.3:fv.5.3;
  #local E[ 149] = < 89, 120, 0 >; // vp.6.3--ve.6.3.0:fv.5.3;
  #local E[ 150] = < 120, 121, 0 >; // ve.6.3.0--ve.6.3.1:fv.5.3;
  #local E[ 151] = < 116, 118, 0 >; // vp.5.4--ve.5.3.1:fv.5.3;
  #local E[ 152] = < 116, 119, 0 >; // vp.5.4--vp.6.4:fv.5.4;
  #local E[ 153] = < 119, 150, 0 >; // vp.6.4--ve.6.4.0:fv.5.4;
  #local E[ 154] = < 150, 151, 0 >; // ve.6.4.0--ve.6.4.1:fv.5.4;
  #local E[ 155] = < 146, 148, 0 >; // vp.5.5--ve.5.4.1:fv.5.4;
  #local E[ 156] = < 146, 149, 0 >; // vp.5.5--vp.6.5:fv.5.5;
  #local E[ 157] = < 149, 180, 0 >; // vp.6.5--ve.6.5.0:fv.5.5;
  #local E[ 158] = < 180, 181, 0 >; // ve.6.5.0--ve.6.5.1:fv.5.5;
  #local E[ 159] = < 176, 178, 0 >; // vp.5.6--ve.5.5.1:fv.5.5;
  #local E[ 160] = < 6, 191, 0 >; // vp.5.0--vc.0:fh.5.0;
  #local E[ 161] = < 176, 179, 0 >; // vp.5.6--vp.6.6:fh.5.1;
  #local E[ 162] = < 179, 192, 0 >; // vp.6.6--vc.1:fh.5.1;
  #local E[ 163] = < 7, 8, 0 >; // vp.6.0--vp.7.0:fv.6.0;
  #local E[ 164] = < 8, 33, 0 >; // vp.7.0--ve.7.0.0:fv.6.0;
  #local E[ 165] = < 33, 34, 0 >; // ve.7.0.0--ve.7.0.1:fv.6.0;
  #local E[ 166] = < 29, 31, 0 >; // vp.6.1--ve.6.0.1:fv.6.0;
  #local E[ 167] = < 29, 32, 0 >; // vp.6.1--vp.7.1:fv.6.1;
  #local E[ 168] = < 32, 63, 0 >; // vp.7.1--ve.7.1.0:fv.6.1;
  #local E[ 169] = < 63, 64, 0 >; // ve.7.1.0--ve.7.1.1:fv.6.1;
  #local E[ 170] = < 59, 61, 0 >; // vp.6.2--ve.6.1.1:fv.6.1;
  #local E[ 171] = < 59, 62, 0 >; // vp.6.2--vp.7.2:fv.6.2;
  #local E[ 172] = < 62, 93, 0 >; // vp.7.2--ve.7.2.0:fv.6.2;
  #local E[ 173] = < 93, 94, 0 >; // ve.7.2.0--ve.7.2.1:fv.6.2;
  #local E[ 174] = < 89, 91, 0 >; // vp.6.3--ve.6.2.1:fv.6.2;
  #local E[ 175] = < 89, 92, 0 >; // vp.6.3--vp.7.3:fv.6.3;
  #local E[ 176] = < 92, 123, 0 >; // vp.7.3--ve.7.3.0:fv.6.3;
  #local E[ 177] = < 123, 124, 0 >; // ve.7.3.0--ve.7.3.1:fv.6.3;
  #local E[ 178] = < 119, 121, 0 >; // vp.6.4--ve.6.3.1:fv.6.3;
  #local E[ 179] = < 119, 122, 0 >; // vp.6.4--vp.7.4:fv.6.4;
  #local E[ 180] = < 122, 153, 0 >; // vp.7.4--ve.7.4.0:fv.6.4;
  #local E[ 181] = < 153, 154, 0 >; // ve.7.4.0--ve.7.4.1:fv.6.4;
  #local E[ 182] = < 149, 151, 0 >; // vp.6.5--ve.6.4.1:fv.6.4;
  #local E[ 183] = < 149, 152, 0 >; // vp.6.5--vp.7.5:fv.6.5;
  #local E[ 184] = < 152, 183, 0 >; // vp.7.5--ve.7.5.0:fv.6.5;
  #local E[ 185] = < 183, 184, 0 >; // ve.7.5.0--ve.7.5.1:fv.6.5;
  #local E[ 186] = < 179, 181, 0 >; // vp.6.6--ve.6.5.1:fv.6.5;
  #local E[ 187] = < 7, 191, 0 >; // vp.6.0--vc.0:fh.6.0;
  #local E[ 188] = < 179, 182, 0 >; // vp.6.6--vp.7.6:fh.6.1;
  #local E[ 189] = < 182, 192, 0 >; // vp.7.6--vc.1:fh.6.1;
  #local E[ 190] = < 8, 9, 0 >; // vp.7.0--vp.8.0:fv.7.0;
  #local E[ 191] = < 9, 36, 0 >; // vp.8.0--ve.8.0.0:fv.7.0;
  #local E[ 192] = < 36, 37, 0 >; // ve.8.0.0--ve.8.0.1:fv.7.0;
  #local E[ 193] = < 32, 34, 0 >; // vp.7.1--ve.7.0.1:fv.7.0;
  #local E[ 194] = < 32, 35, 0 >; // vp.7.1--vp.8.1:fv.7.1;
  #local E[ 195] = < 35, 66, 0 >; // vp.8.1--ve.8.1.0:fv.7.1;
  #local E[ 196] = < 66, 67, 0 >; // ve.8.1.0--ve.8.1.1:fv.7.1;
  #local E[ 197] = < 62, 64, 0 >; // vp.7.2--ve.7.1.1:fv.7.1;
  #local E[ 198] = < 62, 65, 0 >; // vp.7.2--vp.8.2:fv.7.2;
  #local E[ 199] = < 65, 96, 0 >; // vp.8.2--ve.8.2.0:fv.7.2;
  #local E[ 200] = < 96, 97, 0 >; // ve.8.2.0--ve.8.2.1:fv.7.2;
  #local E[ 201] = < 92, 94, 0 >; // vp.7.3--ve.7.2.1:fv.7.2;
  #local E[ 202] = < 92, 95, 0 >; // vp.7.3--vp.8.3:fv.7.3;
  #local E[ 203] = < 95, 126, 0 >; // vp.8.3--ve.8.3.0:fv.7.3;
  #local E[ 204] = < 126, 127, 0 >; // ve.8.3.0--ve.8.3.1:fv.7.3;
  #local E[ 205] = < 122, 124, 0 >; // vp.7.4--ve.7.3.1:fv.7.3;
  #local E[ 206] = < 122, 125, 0 >; // vp.7.4--vp.8.4:fv.7.4;
  #local E[ 207] = < 125, 156, 0 >; // vp.8.4--ve.8.4.0:fv.7.4;
  #local E[ 208] = < 156, 157, 0 >; // ve.8.4.0--ve.8.4.1:fv.7.4;
  #local E[ 209] = < 152, 154, 0 >; // vp.7.5--ve.7.4.1:fv.7.4;
  #local E[ 210] = < 152, 155, 0 >; // vp.7.5--vp.8.5:fv.7.5;
  #local E[ 211] = < 155, 186, 0 >; // vp.8.5--ve.8.5.0:fv.7.5;
  #local E[ 212] = < 186, 187, 0 >; // ve.8.5.0--ve.8.5.1:fv.7.5;
  #local E[ 213] = < 182, 184, 0 >; // vp.7.6--ve.7.5.1:fv.7.5;
  #local E[ 214] = < 8, 191, 0 >; // vp.7.0--vc.0:fh.7.0;
  #local E[ 215] = < 182, 185, 0 >; // vp.7.6--vp.8.6:fh.7.1;
  #local E[ 216] = < 185, 192, 0 >; // vp.8.6--vc.1:fh.7.1;
  #local E[ 217] = < 9, 10, 0 >; // vp.8.0--vp.9.0:fv.8.0;
  #local E[ 218] = < 10, 39, 0 >; // vp.9.0--ve.9.0.0:fv.8.0;
  #local E[ 219] = < 39, 40, 0 >; // ve.9.0.0--ve.9.0.1:fv.8.0;
  #local E[ 220] = < 35, 37, 0 >; // vp.8.1--ve.8.0.1:fv.8.0;
  #local E[ 221] = < 35, 38, 0 >; // vp.8.1--vp.9.1:fv.8.1;
  #local E[ 222] = < 38, 69, 0 >; // vp.9.1--ve.9.1.0:fv.8.1;
  #local E[ 223] = < 69, 70, 0 >; // ve.9.1.0--ve.9.1.1:fv.8.1;
  #local E[ 224] = < 65, 67, 0 >; // vp.8.2--ve.8.1.1:fv.8.1;
  #local E[ 225] = < 65, 68, 0 >; // vp.8.2--vp.9.2:fv.8.2;
  #local E[ 226] = < 68, 99, 0 >; // vp.9.2--ve.9.2.0:fv.8.2;
  #local E[ 227] = < 99, 100, 0 >; // ve.9.2.0--ve.9.2.1:fv.8.2;
  #local E[ 228] = < 95, 97, 0 >; // vp.8.3--ve.8.2.1:fv.8.2;
  #local E[ 229] = < 95, 98, 0 >; // vp.8.3--vp.9.3:fv.8.3;
  #local E[ 230] = < 98, 129, 0 >; // vp.9.3--ve.9.3.0:fv.8.3;
  #local E[ 231] = < 129, 130, 0 >; // ve.9.3.0--ve.9.3.1:fv.8.3;
  #local E[ 232] = < 125, 127, 0 >; // vp.8.4--ve.8.3.1:fv.8.3;
  #local E[ 233] = < 125, 128, 0 >; // vp.8.4--vp.9.4:fv.8.4;
  #local E[ 234] = < 128, 159, 0 >; // vp.9.4--ve.9.4.0:fv.8.4;
  #local E[ 235] = < 159, 160, 0 >; // ve.9.4.0--ve.9.4.1:fv.8.4;
  #local E[ 236] = < 155, 157, 0 >; // vp.8.5--ve.8.4.1:fv.8.4;
  #local E[ 237] = < 155, 158, 0 >; // vp.8.5--vp.9.5:fv.8.5;
  #local E[ 238] = < 158, 189, 0 >; // vp.9.5--ve.9.5.0:fv.8.5;
  #local E[ 239] = < 189, 190, 0 >; // ve.9.5.0--ve.9.5.1:fv.8.5;
  #local E[ 240] = < 185, 187, 0 >; // vp.8.6--ve.8.5.1:fv.8.5;
  #local E[ 241] = < 9, 191, 0 >; // vp.8.0--vc.0:fh.8.0;
  #local E[ 242] = < 185, 188, 0 >; // vp.8.6--vp.9.6:fh.8.1;
  #local E[ 243] = < 188, 192, 0 >; // vp.9.6--vc.1:fh.8.1;
  #local E[ 244] = < 1, 12, 0 >; // vp.0.0--ve.0.0.0:fv.9.0;
  #local E[ 245] = < 12, 13, 0 >; // ve.0.0.0--ve.0.0.1:fv.9.0;
  #local E[ 246] = < 11, 38, 0 >; // vp.0.1--vp.9.1:fv.9.0;
  #local E[ 247] = < 38, 40, 0 >; // vp.9.1--ve.9.0.1:fv.9.0;
  #local E[ 248] = < 11, 42, 0 >; // vp.0.1--ve.0.1.0:fv.9.1;
  #local E[ 249] = < 42, 43, 0 >; // ve.0.1.0--ve.0.1.1:fv.9.1;
  #local E[ 250] = < 41, 68, 0 >; // vp.0.2--vp.9.2:fv.9.1;
  #local E[ 251] = < 68, 70, 0 >; // vp.9.2--ve.9.1.1:fv.9.1;
  #local E[ 252] = < 41, 72, 0 >; // vp.0.2--ve.0.2.0:fv.9.2;
  #local E[ 253] = < 72, 73, 0 >; // ve.0.2.0--ve.0.2.1:fv.9.2;
  #local E[ 254] = < 71, 98, 0 >; // vp.0.3--vp.9.3:fv.9.2;
  #local E[ 255] = < 98, 100, 0 >; // vp.9.3--ve.9.2.1:fv.9.2;
  #local E[ 256] = < 71, 102, 0 >; // vp.0.3--ve.0.3.0:fv.9.3;
  #local E[ 257] = < 102, 103, 0 >; // ve.0.3.0--ve.0.3.1:fv.9.3;
  #local E[ 258] = < 101, 128, 0 >; // vp.0.4--vp.9.4:fv.9.3;
  #local E[ 259] = < 128, 130, 0 >; // vp.9.4--ve.9.3.1:fv.9.3;
  #local E[ 260] = < 101, 132, 0 >; // vp.0.4--ve.0.4.0:fv.9.4;
  #local E[ 261] = < 132, 133, 0 >; // ve.0.4.0--ve.0.4.1:fv.9.4;
  #local E[ 262] = < 131, 158, 0 >; // vp.0.5--vp.9.5:fv.9.4;
  #local E[ 263] = < 158, 160, 0 >; // vp.9.5--ve.9.4.1:fv.9.4;
  #local E[ 264] = < 131, 162, 0 >; // vp.0.5--ve.0.5.0:fv.9.5;
  #local E[ 265] = < 162, 163, 0 >; // ve.0.5.0--ve.0.5.1:fv.9.5;
  #local E[ 266] = < 161, 188, 0 >; // vp.0.6--vp.9.6:fv.9.5;
  #local E[ 267] = < 188, 190, 0 >; // vp.9.6--ve.9.5.1:fv.9.5;
  #local E[ 268] = < 1, 10, 0 >; // vp.0.0--vp.9.0:fh.9.0;
  #local E[ 269] = < 10, 191, 0 >; // vp.9.0--vc.0:fh.9.0;
  #local E[ 270] = < 161, 192, 0 >; // vp.0.6--vc.1:fh.9.1;
  #local E[ 271] = < 1, 15, 1 >; // dv.0.0;
  #local E[ 272] = < 12, 16, 1 >; // dv.0.0;
  #local E[ 273] = < 12, 15, 1 >; // hv.0.0;
  #local E[ 274] = < 13, 14, 1 >; // dv.0.0;
  #local E[ 275] = < 13, 16, 1 >; // hv.0.0;
  #local E[ 276] = < 14, 42, 1 >; // dv.0.1;
  #local E[ 277] = < 43, 45, 1 >; // dv.0.1;
  #local E[ 278] = < 42, 45, 1 >; // hv.0.1;
  #local E[ 279] = < 41, 46, 1 >; // dv.0.1;
  #local E[ 280] = < 43, 46, 1 >; // hv.0.1;
  #local E[ 281] = < 41, 75, 1 >; // dv.0.2;
  #local E[ 282] = < 72, 76, 1 >; // dv.0.2;
  #local E[ 283] = < 72, 75, 1 >; // hv.0.2;
  #local E[ 284] = < 73, 74, 1 >; // dv.0.2;
  #local E[ 285] = < 73, 76, 1 >; // hv.0.2;
  #local E[ 286] = < 74, 102, 1 >; // dv.0.3;
  #local E[ 287] = < 103, 105, 1 >; // dv.0.3;
  #local E[ 288] = < 102, 105, 1 >; // hv.0.3;
  #local E[ 289] = < 101, 106, 1 >; // dv.0.3;
  #local E[ 290] = < 103, 106, 1 >; // hv.0.3;
  #local E[ 291] = < 101, 135, 1 >; // dv.0.4;
  #local E[ 292] = < 132, 136, 1 >; // dv.0.4;
  #local E[ 293] = < 132, 135, 1 >; // hv.0.4;
  #local E[ 294] = < 133, 134, 1 >; // dv.0.4;
  #local E[ 295] = < 133, 136, 1 >; // hv.0.4;
  #local E[ 296] = < 134, 162, 1 >; // dv.0.5;
  #local E[ 297] = < 163, 165, 1 >; // dv.0.5;
  #local E[ 298] = < 162, 165, 1 >; // hv.0.5;
  #local E[ 299] = < 161, 166, 1 >; // dv.0.5;
  #local E[ 300] = < 163, 166, 1 >; // hv.0.5;
  #local E[ 301] = < 3, 15, 1 >; // dv.1.0;
  #local E[ 302] = < 16, 18, 1 >; // dv.1.0;
  #local E[ 303] = < 15, 18, 1 >; // hv.1.0;
  #local E[ 304] = < 14, 19, 1 >; // dv.1.0;
  #local E[ 305] = < 16, 19, 1 >; // hv.1.0;
  #local E[ 306] = < 14, 48, 1 >; // dv.1.1;
  #local E[ 307] = < 45, 49, 1 >; // dv.1.1;
  #local E[ 308] = < 45, 48, 1 >; // hv.1.1;
  #local E[ 309] = < 46, 47, 1 >; // dv.1.1;
  #local E[ 310] = < 46, 49, 1 >; // hv.1.1;
  #local E[ 311] = < 47, 75, 1 >; // dv.1.2;
  #local E[ 312] = < 76, 78, 1 >; // dv.1.2;
  #local E[ 313] = < 75, 78, 1 >; // hv.1.2;
  #local E[ 314] = < 74, 79, 1 >; // dv.1.2;
  #local E[ 315] = < 76, 79, 1 >; // hv.1.2;
  #local E[ 316] = < 74, 108, 1 >; // dv.1.3;
  #local E[ 317] = < 105, 109, 1 >; // dv.1.3;
  #local E[ 318] = < 105, 108, 1 >; // hv.1.3;
  #local E[ 319] = < 106, 107, 1 >; // dv.1.3;
  #local E[ 320] = < 106, 109, 1 >; // hv.1.3;
  #local E[ 321] = < 107, 135, 1 >; // dv.1.4;
  #local E[ 322] = < 136, 138, 1 >; // dv.1.4;
  #local E[ 323] = < 135, 138, 1 >; // hv.1.4;
  #local E[ 324] = < 134, 139, 1 >; // dv.1.4;
  #local E[ 325] = < 136, 139, 1 >; // hv.1.4;
  #local E[ 326] = < 134, 168, 1 >; // dv.1.5;
  #local E[ 327] = < 165, 169, 1 >; // dv.1.5;
  #local E[ 328] = < 165, 168, 1 >; // hv.1.5;
  #local E[ 329] = < 166, 167, 1 >; // dv.1.5;
  #local E[ 330] = < 166, 169, 1 >; // hv.1.5;
  #local E[ 331] = < 3, 21, 1 >; // dv.2.0;
  #local E[ 332] = < 18, 22, 1 >; // dv.2.0;
  #local E[ 333] = < 18, 21, 1 >; // hv.2.0;
  #local E[ 334] = < 19, 20, 1 >; // dv.2.0;
  #local E[ 335] = < 19, 22, 1 >; // hv.2.0;
  #local E[ 336] = < 20, 48, 1 >; // dv.2.1;
  #local E[ 337] = < 49, 51, 1 >; // dv.2.1;
  #local E[ 338] = < 48, 51, 1 >; // hv.2.1;
  #local E[ 339] = < 47, 52, 1 >; // dv.2.1;
  #local E[ 340] = < 49, 52, 1 >; // hv.2.1;
  #local E[ 341] = < 47, 81, 1 >; // dv.2.2;
  #local E[ 342] = < 78, 82, 1 >; // dv.2.2;
  #local E[ 343] = < 78, 81, 1 >; // hv.2.2;
  #local E[ 344] = < 79, 80, 1 >; // dv.2.2;
  #local E[ 345] = < 79, 82, 1 >; // hv.2.2;
  #local E[ 346] = < 80, 108, 1 >; // dv.2.3;
  #local E[ 347] = < 109, 111, 1 >; // dv.2.3;
  #local E[ 348] = < 108, 111, 1 >; // hv.2.3;
  #local E[ 349] = < 107, 112, 1 >; // dv.2.3;
  #local E[ 350] = < 109, 112, 1 >; // hv.2.3;
  #local E[ 351] = < 107, 141, 1 >; // dv.2.4;
  #local E[ 352] = < 138, 142, 1 >; // dv.2.4;
  #local E[ 353] = < 138, 141, 1 >; // hv.2.4;
  #local E[ 354] = < 139, 140, 1 >; // dv.2.4;
  #local E[ 355] = < 139, 142, 1 >; // hv.2.4;
  #local E[ 356] = < 140, 168, 1 >; // dv.2.5;
  #local E[ 357] = < 169, 171, 1 >; // dv.2.5;
  #local E[ 358] = < 168, 171, 1 >; // hv.2.5;
  #local E[ 359] = < 167, 172, 1 >; // dv.2.5;
  #local E[ 360] = < 169, 172, 1 >; // hv.2.5;
  #local E[ 361] = < 5, 21, 1 >; // dv.3.0;
  #local E[ 362] = < 22, 24, 1 >; // dv.3.0;
  #local E[ 363] = < 21, 24, 1 >; // hv.3.0;
  #local E[ 364] = < 20, 25, 1 >; // dv.3.0;
  #local E[ 365] = < 22, 25, 1 >; // hv.3.0;
  #local E[ 366] = < 20, 54, 1 >; // dv.3.1;
  #local E[ 367] = < 51, 55, 1 >; // dv.3.1;
  #local E[ 368] = < 51, 54, 1 >; // hv.3.1;
  #local E[ 369] = < 52, 53, 1 >; // dv.3.1;
  #local E[ 370] = < 52, 55, 1 >; // hv.3.1;
  #local E[ 371] = < 53, 81, 1 >; // dv.3.2;
  #local E[ 372] = < 82, 84, 1 >; // dv.3.2;
  #local E[ 373] = < 81, 84, 1 >; // hv.3.2;
  #local E[ 374] = < 80, 85, 1 >; // dv.3.2;
  #local E[ 375] = < 82, 85, 1 >; // hv.3.2;
  #local E[ 376] = < 80, 114, 1 >; // dv.3.3;
  #local E[ 377] = < 111, 115, 1 >; // dv.3.3;
  #local E[ 378] = < 111, 114, 1 >; // hv.3.3;
  #local E[ 379] = < 112, 113, 1 >; // dv.3.3;
  #local E[ 380] = < 112, 115, 1 >; // hv.3.3;
  #local E[ 381] = < 113, 141, 1 >; // dv.3.4;
  #local E[ 382] = < 142, 144, 1 >; // dv.3.4;
  #local E[ 383] = < 141, 144, 1 >; // hv.3.4;
  #local E[ 384] = < 140, 145, 1 >; // dv.3.4;
  #local E[ 385] = < 142, 145, 1 >; // hv.3.4;
  #local E[ 386] = < 140, 174, 1 >; // dv.3.5;
  #local E[ 387] = < 171, 175, 1 >; // dv.3.5;
  #local E[ 388] = < 171, 174, 1 >; // hv.3.5;
  #local E[ 389] = < 172, 173, 1 >; // dv.3.5;
  #local E[ 390] = < 172, 175, 1 >; // hv.3.5;
  #local E[ 391] = < 5, 27, 1 >; // dv.4.0;
  #local E[ 392] = < 24, 28, 1 >; // dv.4.0;
  #local E[ 393] = < 24, 27, 1 >; // hv.4.0;
  #local E[ 394] = < 25, 26, 1 >; // dv.4.0;
  #local E[ 395] = < 25, 28, 1 >; // hv.4.0;
  #local E[ 396] = < 26, 54, 1 >; // dv.4.1;
  #local E[ 397] = < 55, 57, 1 >; // dv.4.1;
  #local E[ 398] = < 54, 57, 1 >; // hv.4.1;
  #local E[ 399] = < 53, 58, 1 >; // dv.4.1;
  #local E[ 400] = < 55, 58, 1 >; // hv.4.1;
  #local E[ 401] = < 53, 87, 1 >; // dv.4.2;
  #local E[ 402] = < 84, 88, 1 >; // dv.4.2;
  #local E[ 403] = < 84, 87, 1 >; // hv.4.2;
  #local E[ 404] = < 85, 86, 1 >; // dv.4.2;
  #local E[ 405] = < 85, 88, 1 >; // hv.4.2;
  #local E[ 406] = < 86, 114, 1 >; // dv.4.3;
  #local E[ 407] = < 115, 117, 1 >; // dv.4.3;
  #local E[ 408] = < 114, 117, 1 >; // hv.4.3;
  #local E[ 409] = < 113, 118, 1 >; // dv.4.3;
  #local E[ 410] = < 115, 118, 1 >; // hv.4.3;
  #local E[ 411] = < 113, 147, 1 >; // dv.4.4;
  #local E[ 412] = < 144, 148, 1 >; // dv.4.4;
  #local E[ 413] = < 144, 147, 1 >; // hv.4.4;
  #local E[ 414] = < 145, 146, 1 >; // dv.4.4;
  #local E[ 415] = < 145, 148, 1 >; // hv.4.4;
  #local E[ 416] = < 146, 174, 1 >; // dv.4.5;
  #local E[ 417] = < 175, 177, 1 >; // dv.4.5;
  #local E[ 418] = < 174, 177, 1 >; // hv.4.5;
  #local E[ 419] = < 173, 178, 1 >; // dv.4.5;
  #local E[ 420] = < 175, 178, 1 >; // hv.4.5;
  #local E[ 421] = < 7, 27, 1 >; // dv.5.0;
  #local E[ 422] = < 28, 30, 1 >; // dv.5.0;
  #local E[ 423] = < 27, 30, 1 >; // hv.5.0;
  #local E[ 424] = < 26, 31, 1 >; // dv.5.0;
  #local E[ 425] = < 28, 31, 1 >; // hv.5.0;
  #local E[ 426] = < 26, 60, 1 >; // dv.5.1;
  #local E[ 427] = < 57, 61, 1 >; // dv.5.1;
  #local E[ 428] = < 57, 60, 1 >; // hv.5.1;
  #local E[ 429] = < 58, 59, 1 >; // dv.5.1;
  #local E[ 430] = < 58, 61, 1 >; // hv.5.1;
  #local E[ 431] = < 59, 87, 1 >; // dv.5.2;
  #local E[ 432] = < 88, 90, 1 >; // dv.5.2;
  #local E[ 433] = < 87, 90, 1 >; // hv.5.2;
  #local E[ 434] = < 86, 91, 1 >; // dv.5.2;
  #local E[ 435] = < 88, 91, 1 >; // hv.5.2;
  #local E[ 436] = < 86, 120, 1 >; // dv.5.3;
  #local E[ 437] = < 117, 121, 1 >; // dv.5.3;
  #local E[ 438] = < 117, 120, 1 >; // hv.5.3;
  #local E[ 439] = < 118, 119, 1 >; // dv.5.3;
  #local E[ 440] = < 118, 121, 1 >; // hv.5.3;
  #local E[ 441] = < 119, 147, 1 >; // dv.5.4;
  #local E[ 442] = < 148, 150, 1 >; // dv.5.4;
  #local E[ 443] = < 147, 150, 1 >; // hv.5.4;
  #local E[ 444] = < 146, 151, 1 >; // dv.5.4;
  #local E[ 445] = < 148, 151, 1 >; // hv.5.4;
  #local E[ 446] = < 146, 180, 1 >; // dv.5.5;
  #local E[ 447] = < 177, 181, 1 >; // dv.5.5;
  #local E[ 448] = < 177, 180, 1 >; // hv.5.5;
  #local E[ 449] = < 178, 179, 1 >; // dv.5.5;
  #local E[ 450] = < 178, 181, 1 >; // hv.5.5;
  #local E[ 451] = < 7, 33, 1 >; // dv.6.0;
  #local E[ 452] = < 30, 34, 1 >; // dv.6.0;
  #local E[ 453] = < 30, 33, 1 >; // hv.6.0;
  #local E[ 454] = < 31, 32, 1 >; // dv.6.0;
  #local E[ 455] = < 31, 34, 1 >; // hv.6.0;
  #local E[ 456] = < 32, 60, 1 >; // dv.6.1;
  #local E[ 457] = < 61, 63, 1 >; // dv.6.1;
  #local E[ 458] = < 60, 63, 1 >; // hv.6.1;
  #local E[ 459] = < 59, 64, 1 >; // dv.6.1;
  #local E[ 460] = < 61, 64, 1 >; // hv.6.1;
  #local E[ 461] = < 59, 93, 1 >; // dv.6.2;
  #local E[ 462] = < 90, 94, 1 >; // dv.6.2;
  #local E[ 463] = < 90, 93, 1 >; // hv.6.2;
  #local E[ 464] = < 91, 92, 1 >; // dv.6.2;
  #local E[ 465] = < 91, 94, 1 >; // hv.6.2;
  #local E[ 466] = < 92, 120, 1 >; // dv.6.3;
  #local E[ 467] = < 121, 123, 1 >; // dv.6.3;
  #local E[ 468] = < 120, 123, 1 >; // hv.6.3;
  #local E[ 469] = < 119, 124, 1 >; // dv.6.3;
  #local E[ 470] = < 121, 124, 1 >; // hv.6.3;
  #local E[ 471] = < 119, 153, 1 >; // dv.6.4;
  #local E[ 472] = < 150, 154, 1 >; // dv.6.4;
  #local E[ 473] = < 150, 153, 1 >; // hv.6.4;
  #local E[ 474] = < 151, 152, 1 >; // dv.6.4;
  #local E[ 475] = < 151, 154, 1 >; // hv.6.4;
  #local E[ 476] = < 152, 180, 1 >; // dv.6.5;
  #local E[ 477] = < 181, 183, 1 >; // dv.6.5;
  #local E[ 478] = < 180, 183, 1 >; // hv.6.5;
  #local E[ 479] = < 179, 184, 1 >; // dv.6.5;
  #local E[ 480] = < 181, 184, 1 >; // hv.6.5;
  #local E[ 481] = < 9, 33, 1 >; // dv.7.0;
  #local E[ 482] = < 34, 36, 1 >; // dv.7.0;
  #local E[ 483] = < 33, 36, 1 >; // hv.7.0;
  #local E[ 484] = < 32, 37, 1 >; // dv.7.0;
  #local E[ 485] = < 34, 37, 1 >; // hv.7.0;
  #local E[ 486] = < 32, 66, 1 >; // dv.7.1;
  #local E[ 487] = < 63, 67, 1 >; // dv.7.1;
  #local E[ 488] = < 63, 66, 1 >; // hv.7.1;
  #local E[ 489] = < 64, 65, 1 >; // dv.7.1;
  #local E[ 490] = < 64, 67, 1 >; // hv.7.1;
  #local E[ 491] = < 65, 93, 1 >; // dv.7.2;
  #local E[ 492] = < 94, 96, 1 >; // dv.7.2;
  #local E[ 493] = < 93, 96, 1 >; // hv.7.2;
  #local E[ 494] = < 92, 97, 1 >; // dv.7.2;
  #local E[ 495] = < 94, 97, 1 >; // hv.7.2;
  #local E[ 496] = < 92, 126, 1 >; // dv.7.3;
  #local E[ 497] = < 123, 127, 1 >; // dv.7.3;
  #local E[ 498] = < 123, 126, 1 >; // hv.7.3;
  #local E[ 499] = < 124, 125, 1 >; // dv.7.3;
  #local E[ 500] = < 124, 127, 1 >; // hv.7.3;
  #local E[ 501] = < 125, 153, 1 >; // dv.7.4;
  #local E[ 502] = < 154, 156, 1 >; // dv.7.4;
  #local E[ 503] = < 153, 156, 1 >; // hv.7.4;
  #local E[ 504] = < 152, 157, 1 >; // dv.7.4;
  #local E[ 505] = < 154, 157, 1 >; // hv.7.4;
  #local E[ 506] = < 152, 186, 1 >; // dv.7.5;
  #local E[ 507] = < 183, 187, 1 >; // dv.7.5;
  #local E[ 508] = < 183, 186, 1 >; // hv.7.5;
  #local E[ 509] = < 184, 185, 1 >; // dv.7.5;
  #local E[ 510] = < 184, 187, 1 >; // hv.7.5;
  #local E[ 511] = < 9, 39, 1 >; // dv.8.0;
  #local E[ 512] = < 36, 40, 1 >; // dv.8.0;
  #local E[ 513] = < 36, 39, 1 >; // hv.8.0;
  #local E[ 514] = < 37, 38, 1 >; // dv.8.0;
  #local E[ 515] = < 37, 40, 1 >; // hv.8.0;
  #local E[ 516] = < 38, 66, 1 >; // dv.8.1;
  #local E[ 517] = < 67, 69, 1 >; // dv.8.1;
  #local E[ 518] = < 66, 69, 1 >; // hv.8.1;
  #local E[ 519] = < 65, 70, 1 >; // dv.8.1;
  #local E[ 520] = < 67, 70, 1 >; // hv.8.1;
  #local E[ 521] = < 65, 99, 1 >; // dv.8.2;
  #local E[ 522] = < 96, 100, 1 >; // dv.8.2;
  #local E[ 523] = < 96, 99, 1 >; // hv.8.2;
  #local E[ 524] = < 97, 98, 1 >; // dv.8.2;
  #local E[ 525] = < 97, 100, 1 >; // hv.8.2;
  #local E[ 526] = < 98, 126, 1 >; // dv.8.3;
  #local E[ 527] = < 127, 129, 1 >; // dv.8.3;
  #local E[ 528] = < 126, 129, 1 >; // hv.8.3;
  #local E[ 529] = < 125, 130, 1 >; // dv.8.3;
  #local E[ 530] = < 127, 130, 1 >; // hv.8.3;
  #local E[ 531] = < 125, 159, 1 >; // dv.8.4;
  #local E[ 532] = < 156, 160, 1 >; // dv.8.4;
  #local E[ 533] = < 156, 159, 1 >; // hv.8.4;
  #local E[ 534] = < 157, 158, 1 >; // dv.8.4;
  #local E[ 535] = < 157, 160, 1 >; // hv.8.4;
  #local E[ 536] = < 158, 186, 1 >; // dv.8.5;
  #local E[ 537] = < 187, 189, 1 >; // dv.8.5;
  #local E[ 538] = < 186, 189, 1 >; // hv.8.5;
  #local E[ 539] = < 185, 190, 1 >; // dv.8.5;
  #local E[ 540] = < 187, 190, 1 >; // hv.8.5;
  #local E[ 541] = < 1, 39, 1 >; // dv.9.0;
  #local E[ 542] = < 12, 40, 1 >; // dv.9.0;
  #local E[ 543] = < 12, 39, 1 >; // hv.9.0;
  #local E[ 544] = < 13, 38, 1 >; // dv.9.0;
  #local E[ 545] = < 13, 40, 1 >; // hv.9.0;
  #local E[ 546] = < 38, 42, 1 >; // dv.9.1;
  #local E[ 547] = < 43, 69, 1 >; // dv.9.1;
  #local E[ 548] = < 42, 69, 1 >; // hv.9.1;
  #local E[ 549] = < 41, 70, 1 >; // dv.9.1;
  #local E[ 550] = < 43, 70, 1 >; // hv.9.1;
  #local E[ 551] = < 41, 99, 1 >; // dv.9.2;
  #local E[ 552] = < 72, 100, 1 >; // dv.9.2;
  #local E[ 553] = < 72, 99, 1 >; // hv.9.2;
  #local E[ 554] = < 73, 98, 1 >; // dv.9.2;
  #local E[ 555] = < 73, 100, 1 >; // hv.9.2;
  #local E[ 556] = < 98, 102, 1 >; // dv.9.3;
  #local E[ 557] = < 103, 129, 1 >; // dv.9.3;
  #local E[ 558] = < 102, 129, 1 >; // hv.9.3;
  #local E[ 559] = < 101, 130, 1 >; // dv.9.3;
  #local E[ 560] = < 103, 130, 1 >; // hv.9.3;
  #local E[ 561] = < 101, 159, 1 >; // dv.9.4;
  #local E[ 562] = < 132, 160, 1 >; // dv.9.4;
  #local E[ 563] = < 132, 159, 1 >; // hv.9.4;
  #local E[ 564] = < 133, 158, 1 >; // dv.9.4;
  #local E[ 565] = < 133, 160, 1 >; // hv.9.4;
  #local E[ 566] = < 158, 162, 1 >; // dv.9.5;
  #local E[ 567] = < 163, 189, 1 >; // dv.9.5;
  #local E[ 568] = < 162, 189, 1 >; // hv.9.5;
  #local E[ 569] = < 161, 190, 1 >; // dv.9.5;
  #local E[ 570] = < 163, 190, 1 >; // hv.9.5;
  E
#end


#macro slicing_faces(explode)
  #local Nf = 380;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'prism' POV-ray primitive, for {kf} in {1..Nf}.
  // The {explode} parameter is a displacement to be
  // applied to each face in the normal direction of its normal.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = prism{ // fv.0.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +17.200098, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, +0.95105639, +0.00000000,
      +0.86939561, +0.28248416, -0.40540594,
      -0.38556390, -0.12527748, -0.91413677,
      +26.60254000, +0.00000000, -50.00000000
    >
  }
  #local F[   2] = prism{ // fv.0.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < +17.200098, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901755, -0.95105633, +0.00000000,
      +0.86939538, +0.28248425, -0.40540636,
      +0.38556429, +0.12527768, +0.91413658,
      +23.50850000, +17.07994000, -44.73400000
    >
  }
  #local F[   3] = prism{ // fv.0.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < +18.717719, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901755, +0.95105633, +0.00000000,
      +0.86939593, +0.28248443, -0.40540506,
      -0.38556305, -0.12527728, -0.91413716,
      +29.05812000, +0.00000000, -44.73400000
    >
  }
  #local F[   4] = prism{ // fv.0.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, -0.000000 >,
    < +18.717720, -5.760620 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901706, -0.95105649, +0.00000000,
      +0.86939667, +0.28248417, -0.40540366,
      +0.38556178, +0.12527665, +0.91413777,
      +25.49510000, +18.52328000, -39.46800000
    >
  }
  #local F[   5] = prism{ // fv.0.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, +0.000000 >,
    < +20.235347, -5.760615 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901706, +0.95105649, +0.00000000,
      +0.86939402, +0.28248331, -0.40540994,
      -0.38556776, -0.12527859, -0.91413499,
      +31.51368000, +0.00000000, -39.46800000
    >
  }
  #local F[   6] = prism{ // fv.0.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +20.235349, -5.760609 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      +0.86939513, +0.28248297, -0.40540779,
      +0.38556580, +0.12527764, +0.91413594,
      +27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[   7] = prism{ // fv.0.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < -0.464711, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, +0.95105672, +0.00000000,
      +0.92160251, +0.29944613, -0.24694297,
      -0.23485677, -0.07630942, -0.96903002,
      +33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[   8] = prism{ // fv.0.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, -0.000000 >,
    < +4.056909, -21.853361 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, +0.15213111, +0.96592604,
      +0.92160277, +0.29944671, -0.24694129,
      -0.32681083, +0.94190647, -0.07750414,
      +27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[   9] = prism{ // fv.0.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, +0.000000 >,
    < -0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901682, +0.95105657, +0.00000000,
      +0.92160237, +0.29944658, -0.24694293,
      -0.23485670, -0.07630952, -0.96903002,
      +35.47310000, +0.00000000, -28.58962000
    >
  }
  #local F[  10] = prism{ // fv.0.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +3.982674, -22.779799 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20939064, +0.15212764, +0.96592585,
      +0.92160230, +0.29944644, -0.24694336,
      -0.32680997, +0.94190711, -0.07749990,
      +28.69834000, +20.85058000, -28.58962000
    >
  }
  #local F[  11] = prism{ // fv.0.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < -0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, +0.95105661, +0.00000000,
      +0.92160241, +0.29944647, -0.24694294,
      -0.23485672, -0.07630950, -0.96903002,
      +36.97694000, +0.00000000, -22.97722000
    >
  }
  #local F[  12] = prism{ // fv.0.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, -0.000000 >,
    < +3.908239, -23.706246 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, +0.15213111, +0.96592604,
      +0.92160267, +0.29944700, -0.24694131,
      -0.32681111, +0.94190638, -0.07750406,
      +29.91498000, +21.73450000, -22.97722000
    >
  }
  #local F[  13] = prism{ // fv.0.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      +0.94778114, +0.30795290, -0.08292121,
      -0.07886276, -0.02562407, -0.99655611,
      +38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[  14] = prism{ // fv.0.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, -0.000000 >,
    < +23.938924, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, -0.95105667, +0.00000000,
      +0.94778153, +0.30795238, -0.08291868,
      +0.07886037, +0.02562324, +0.99655632,
      +31.54130000, +22.91610000, -11.57654000
    >
  }
  #local F[  15] = prism{ // fv.0.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +24.251903, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, +0.95105667, +0.00000000,
      +0.94778156, +0.30795239, -0.08291823,
      -0.07885993, -0.02562310, -0.99655635,
      +38.98718000, +0.00000000, -11.57654000
    >
  }
  #local F[  16] = prism{ // fv.0.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.251903, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, -0.95105637, +0.00000000,
      +0.94778095, +0.30795320, -0.08292220,
      +0.07886368, +0.02562441, +0.99655602,
      +31.95098000, +23.21376000, -5.78828000
    >
  }
  #local F[  17] = prism{ // fv.0.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.564882, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, +0.95105637, +0.00000000,
      +0.94778103, +0.30795322, -0.08292122,
      -0.07886276, -0.02562410, -0.99655611,
      +39.49360000, +0.00000000, -5.78828000
    >
  }
  #local F[  18] = prism{ // fv.0.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564883, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, -0.95105656, +0.00000000,
      +0.94778142, +0.30795271, -0.08291868,
      +0.07886035, +0.02562327, +0.99655632,
      +32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[  19] = prism{ // fv.0.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901687, +0.95105656, +0.00000000,
      +0.94778142, +0.30795271, +0.08291868,
      +0.07886035, +0.02562327, -0.99655632,
      +40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[  20] = prism{ // fv.0.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, +0.000000 >,
    < +6.467764, -24.399542 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, -0.05122891, +0.99619462,
      +0.94778103, +0.30795322, +0.08292122,
      -0.31102930, +0.95002127, +0.02683951,
      +32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[  21] = prism{ // fv.0.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +0.156493, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, +0.95105637, +0.00000000,
      +0.94778095, +0.30795320, +0.08292220,
      +0.07886368, +0.02562441, -0.99655602,
      +39.49360000, +0.00000000, +5.78828000
    >
  }
  #local F[  22] = prism{ // fv.0.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810369, +0.000000 >,
    < +6.459343, -24.086669 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07050843, -0.05122910, +0.99619483,
      +0.94778156, +0.30795239, +0.08291823,
      -0.31102841, +0.95002153, +0.02684076,
      +31.95098000, +23.21376000, +5.78828000
    >
  }
  #local F[  23] = prism{ // fv.0.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, -0.000000 >,
    < +0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, +0.95105667, +0.00000000,
      +0.94778153, +0.30795238, +0.08291868,
      +0.07886037, +0.02562324, -0.99655632,
      +38.98718000, +0.00000000, +11.57654000
    >
  }
  #local F[  24] = prism{ // fv.0.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, +0.000000 >,
    < +6.450906, -23.773809 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, -0.05122891, +0.99619462,
      +0.94778114, +0.30795290, +0.08292121,
      -0.31102898, +0.95002137, +0.02683954,
      +31.54130000, +22.91610000, +11.57654000
    >
  }
  #local F[  25] = prism{ // fv.0.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317716, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      +0.92160267, +0.29944700, +0.24694131,
      +0.23485513, +0.07630909, -0.96903044,
      +38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[  26] = prism{ // fv.0.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, -0.000000 >,
    < +23.317715, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, -0.95105661, +0.00000000,
      +0.92160241, +0.29944647, +0.24694294,
      -0.23485672, -0.07630950, +0.96903002,
      +29.91498000, +21.73450000, +22.97722000
    >
  }
  #local F[  27] = prism{ // fv.0.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +22.388289, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, +0.95105661, +0.00000000,
      +0.92160206, +0.29944636, +0.24694436,
      +0.23485807, +0.07630994, -0.96902966,
      +36.97694000, +0.00000000, +22.97722000
    >
  }
  #local F[  28] = prism{ // fv.0.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, +0.000000 >,
    < +22.388289, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, -0.95105648, +0.00000000,
      +0.92160229, +0.29944684, +0.24694291,
      -0.23485666, -0.07630958, +0.96903003,
      +28.69834000, +20.85056000, +28.58962000
    >
  }
  #local F[  29] = prism{ // fv.0.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, -0.000000 >,
    < +21.458875, -5.791767 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, +0.95105648, +0.00000000,
      +0.92160292, +0.29944705, +0.24694031,
      +0.23485418, +0.07630878, -0.96903069,
      +35.47310000, +0.00000000, +28.58962000
    >
  }
  #local F[  30] = prism{ // fv.0.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +21.458874, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      +0.92160251, +0.29944613, +0.24694297,
      -0.23485677, -0.07630942, +0.96903002,
      +27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[  31] = prism{ // fv.0.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +0.758814, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, +0.95105672, +0.00000000,
      +0.86939568, +0.28248314, +0.40540650,
      +0.38556458, +0.12527724, -0.91413652,
      +33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[  32] = prism{ // fv.0.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810389, -0.000000 >,
    < +8.353987, -19.309715 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190480, -0.24841021, +0.90630761,
      +0.86939605, +0.28248303, +0.40540579,
      -0.35672345, +0.92655043, +0.11938455,
      +27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[  33] = prism{ // fv.0.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, +0.000000 >,
    < +0.758808, -5.760602 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901613, +0.95105680, +0.00000000,
      +0.86939635, +0.28248313, +0.40540506,
      +0.38556323, +0.12527670, -0.91413716,
      +31.51368000, +0.00000000, +39.46802000
    >
  }
  #local F[  34] = prism{ // fv.0.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810366, +0.000000 >,
    < +8.155713, -17.805105 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190616, -0.24840775, +0.90630777,
      +0.86939574, +0.28248335, +0.40540623,
      -0.35672290, +0.92655100, +0.11938184,
      +25.49512000, +18.52328000, +39.46802000
    >
  }
  #local F[  35] = prism{ // fv.0.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, +0.000000 >,
    < +0.758815, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901655, +0.95105666, +0.00000000,
      +0.86939563, +0.28248331, +0.40540648,
      +0.38556453, +0.12527731, -0.91413652,
      +29.05812000, +0.00000000, +44.73400000
    >
  }
  #local F[  36] = prism{ // fv.0.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810396, -0.000000 >,
    < +7.957567, -16.300466 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190784, -0.24840991, +0.90630654,
      +0.86939445, +0.28248378, +0.40540869,
      -0.35672443, +0.92655028, +0.11938278,
      +23.50852000, +17.07994000, +44.73400000
    >
  }
  #local F[  37] = prism{ // fh.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521905, -15.636584 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901692, +0.58778536, -0.00000000,
      -0.00000000, -0.00000000, -1.00000000,
      -0.58778536, +0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  38] = prism{ // fh.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +8.220647, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, +0.95105639, +0.00000000,
      -0.00000000, -0.00000000, +1.00000000,
      +0.95105639, +0.30901739, +0.00000000,
      +26.60254000, +0.00000000, +50.00000000
    >
  }
  #local F[  39] = prism{ // fv.1.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, -0.000000 >,
    < -0.758806, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, +0.58778561, +0.00000000,
      +0.53731623, +0.73955167, -0.40540671,
      -0.23829223, -0.32798081, -0.91413642,
      +21.52190000, +15.63658000, -50.00000000
    >
  }
  #local F[  40] = prism{ // fv.1.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +3.465057, -17.805076 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, +0.40193212, +0.90630841,
      +0.53731617, +0.73955265, -0.40540500,
      -0.83320808, +0.53991893, -0.11938111,
      +8.22064000, +25.30052000, -50.00000000
    >
  }
  #local F[  41] = prism{ // fv.1.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, +0.000000 >,
    < -0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, +0.58778505, +0.00000000,
      +0.53731636, +0.73955290, -0.40540429,
      -0.23829058, -0.32797901, -0.91413750,
      +23.50850000, +17.07994000, -44.73400000
    >
  }
  #local F[  42] = prism{ // fv.1.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +3.266771, -19.309717 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059365, +0.40193519, +0.90630757,
      +0.53731637, +0.73955218, -0.40540559,
      -0.83320850, +0.53991729, -0.11938554,
      +8.97946000, +27.63590000, -44.73400000
    >
  }
  #local F[  43] = prism{ // fv.1.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, +0.000000 >,
    < -0.758823, -5.760615 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901686, +0.58778544, +0.00000000,
      +0.53731531, +0.73955071, -0.40540968,
      -0.23829391, -0.32798326, -0.91413511,
      +25.49510000, +18.52328000, -39.46800000
    >
  }
  #local F[  44] = prism{ // fv.1.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810366, +0.000000 >,
    < +3.068646, -20.814359 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059763, +0.40193337, +0.90630780,
      +0.53731534, +0.73955251, -0.40540636,
      -0.83320855, +0.53991819, -0.11938116,
      +9.73826000, +29.97130000, -39.46800000
    >
  }
  #local F[  45] = prism{ // fv.1.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458862, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      +0.56958067, +0.78396202, -0.24694415,
      -0.14514995, -0.19978215, -0.96902971,
      +27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[  46] = prism{ // fv.1.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, +0.000000 >,
    < +21.458863, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901722, -0.58778494, +0.00000000,
      +0.56958133, +0.78396209, -0.24694239,
      +0.14514902, +0.19978065, +0.96903016,
      +10.96180000, +33.73692000, -28.58962000
    >
  }
  #local F[  47] = prism{ // fv.1.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, +0.000000 >,
    < +22.388286, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901722, +0.58778494, +0.00000000,
      +0.56958136, +0.78396213, -0.24694221,
      -0.14514891, -0.19978050, -0.96903021,
      +28.69834000, +20.85058000, -28.58962000
    >
  }
  #local F[  48] = prism{ // fv.1.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +22.388286, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, -0.58778505, +0.00000000,
      +0.56958155, +0.78396216, -0.24694169,
      +0.14514863, +0.19978006, +0.96903034,
      +11.42650000, +35.16716000, -22.97722000
    >
  }
  #local F[  49] = prism{ // fv.1.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +23.317721, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, +0.58778505, +0.00000000,
      +0.56958119, +0.78396166, -0.24694410,
      -0.14515005, -0.19978201, -0.96902973,
      +29.91498000, +21.73450000, -22.97722000
    >
  }
  #local F[  50] = prism{ // fv.1.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317722, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      +0.56958178, +0.78396175, -0.24694244,
      +0.14514916, +0.19978060, +0.96903015,
      +11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[  51] = prism{ // fv.1.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < -0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, +0.58778541, +0.00000000,
      +0.58576116, +0.80623074, -0.08292083,
      -0.04873965, -0.06708435, -0.99655614,
      +31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[  52] = prism{ // fv.1.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, -0.000000 >,
    < +5.161417, -24.086668 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, +0.08288945, +0.99619479,
      +0.58576085, +0.80623118, -0.08291875,
      -0.81003639, +0.58576499, -0.02684073,
      +11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[  53] = prism{ // fv.1.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < -0.156478, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, +0.58778500, +0.00000000,
      +0.58576083, +0.80623115, -0.08291909,
      -0.04873860, -0.06708297, -0.99655628,
      +31.54130000, +22.91610000, -11.57654000
    >
  }
  #local F[  54] = prism{ // fv.1.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810370, +0.000000 >,
    < +5.153033, -24.399512 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693460, +0.08288972, +0.99619467,
      +0.58576111, +0.80623075, -0.08292103,
      -0.81003608, +0.58576554, -0.02683807,
      +12.04770000, +37.07902000, -11.57654000
    >
  }
  #local F[  55] = prism{ // fv.1.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, -0.000000 >,
    < -0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, +0.58778537, +0.00000000,
      +0.58576112, +0.80623076, -0.08292083,
      -0.04873965, -0.06708435, -0.99655614,
      +31.95098000, +23.21376000, -5.78828000
    >
  }
  #local F[  56] = prism{ // fv.1.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +5.144558, -24.712385 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, +0.08288945, +0.99619479,
      +0.58576082, +0.80623119, -0.08291875,
      -0.81003640, +0.58576497, -0.02684072,
      +12.20420000, +37.56064000, -5.78828000
    >
  }
  #local F[  57] = prism{ // fv.1.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, -0.000000 >,
    < +24.564859, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, +0.58778497, +0.00000000,
      +0.58576082, +0.80623119, +0.08291875,
      +0.04873839, +0.06708269, -0.99655631,
      +32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[  58] = prism{ // fv.1.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.564859, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, -0.58778537, +0.00000000,
      +0.58576112, +0.80623076, +0.08292083,
      -0.04873965, -0.06708435, +0.99655614,
      +12.20420000, +37.56064000, +5.78828000
    >
  }
  #local F[  59] = prism{ // fv.1.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.251887, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, +0.58778537, +0.00000000,
      +0.58576111, +0.80623075, +0.08292103,
      +0.04873977, +0.06708451, -0.99655612,
      +31.95098000, +23.21376000, +5.78828000
    >
  }
  #local F[  60] = prism{ // fv.1.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +24.251887, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, -0.58778500, +0.00000000,
      +0.58576083, +0.80623115, +0.08291909,
      -0.04873860, -0.06708297, +0.99655628,
      +12.04770000, +37.07902000, +11.57654000
    >
  }
  #local F[  61] = prism{ // fv.1.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +23.938915, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, +0.58778500, +0.00000000,
      +0.58576085, +0.80623118, +0.08291875,
      +0.04873839, +0.06708269, -0.99655631,
      +31.54130000, +22.91610000, +11.57654000
    >
  }
  #local F[  62] = prism{ // fv.1.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.938915, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      +0.58576116, +0.80623074, +0.08292083,
      -0.04873965, -0.06708435, +0.99655614,
      +11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[  63] = prism{ // fv.1.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +0.464699, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, +0.58778541, +0.00000000,
      +0.56958178, +0.78396175, +0.24694244,
      +0.14514916, +0.19978060, -0.96903015,
      +31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[  64] = prism{ // fv.1.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +7.638141, -22.779806 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, -0.24615232, +0.96592551,
      +0.56958119, +0.78396166, +0.24694410,
      -0.81803443, +0.56992381, +0.07750176,
      +11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[  65] = prism{ // fv.1.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +0.464716, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, +0.58778505, +0.00000000,
      +0.56958116, +0.78396161, +0.24694431,
      +0.14515017, +0.19978218, -0.96902967,
      +29.91498000, +21.73450000, +22.97722000
    >
  }
  #local F[  66] = prism{ // fv.1.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +7.563869, -21.853339 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07997750, -0.24615239, +0.96592577,
      +0.56958195, +0.78396172, +0.24694215,
      -0.81803423, +0.56992370, +0.07750466,
      +11.42650000, +35.16716000, +22.97722000
    >
  }
  #local F[  67] = prism{ // fv.1.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, +0.000000 >,
    < +0.464711, -5.791766 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901679, +0.58778553, +0.00000000,
      +0.56958229, +0.78396220, +0.24693983,
      +0.14514766, +0.19977847, -0.96903082,
      +28.69834000, +20.85056000, +28.58962000
    >
  }
  #local F[  68] = prism{ // fv.1.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, -0.000000 >,
    < +7.489468, -20.926903 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, -0.24615232, +0.96592551,
      +0.56958067, +0.78396202, +0.24694415,
      -0.81803479, +0.56992332, +0.07750160,
      +10.96180000, +33.73692000, +28.58962000
    >
  }
  #local F[  69] = prism{ // fv.1.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235354, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      +0.53731567, +0.73955297, +0.40540507,
      +0.23829083, +0.32797980, -0.91413715,
      +27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[  70] = prism{ // fv.1.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +20.235353, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901721, -0.58778495, +0.00000000,
      +0.53731566, +0.73955213, +0.40540662,
      -0.23829191, -0.32798093, +0.91413646,
      +9.73826000, +29.97130000, +39.46802000
    >
  }
  #local F[  71] = prism{ // fv.1.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +18.717714, -5.760607 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901721, +0.58778495, +0.00000000,
      +0.53731557, +0.73955202, +0.40540694,
      +0.23829210, +0.32798119, -0.91413632,
      +25.49512000, +18.52328000, +39.46802000
    >
  }
  #local F[  72] = prism{ // fv.1.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +18.717715, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778452, +0.00000000,
      +0.53731556, +0.73955282, +0.40540550,
      -0.23829108, -0.32798015, +0.91413696,
      +8.97946000, +27.63590000, +44.73400000
    >
  }
  #local F[  73] = prism{ // fv.1.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +17.200093, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778452, +0.00000000,
      +0.53731567, +0.73955297, +0.40540507,
      +0.23829083, +0.32797981, -0.91413715,
      +23.50852000, +17.07994000, +44.73400000
    >
  }
  #local F[  74] = prism{ // fv.1.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200089, -5.760633 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, -0.58778561, +0.00000000,
      +0.53731579, +0.73955105, +0.40540841,
      -0.23829323, -0.32798219, +0.91413567,
      +8.22064000, +25.30052000, +50.00000000
    >
  }
  #local F[  75] = prism{ // fh.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521906, -15.636572 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, +0.95105649, -0.00000000,
      -0.00000000, -0.00000000, -1.00000000,
      -0.95105649, +0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  76] = prism{ // fh.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220621, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, +0.58778561, +0.00000000,
      -0.00000000, -0.00000000, +1.00000000,
      +0.58778561, +0.80901674, +0.00000000,
      +21.52190000, +15.63658000, +50.00000000
    >
  }
  #local F[  77] = prism{ // fv.2.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +17.200100, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413754, -0.40540420,
      -0.00000000, -0.40540420, -0.91413754,
      +8.22064000, +25.30052000, -50.00000000
    >
  }
  #local F[  78] = prism{ // fv.2.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < +17.200100, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413754, -0.40540420,
      -0.00000000, +0.40540420, +0.91413754,
      -8.97946000, +27.63590000, -44.73400000
    >
  }
  #local F[  79] = prism{ // fv.2.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < +18.717720, -5.760629 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413625, -0.40540710,
      -0.00000000, -0.40540710, -0.91413625,
      +8.97946000, +27.63590000, -44.73400000
    >
  }
  #local F[  80] = prism{ // fv.2.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < +18.717720, -5.760629 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413625, -0.40540710,
      -0.00000000, +0.40540710, +0.91413625,
      -9.73826000, +29.97130000, -39.46800000
    >
  }
  #local F[  81] = prism{ // fv.2.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < +20.235340, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413697, -0.40540549,
      -0.00000000, -0.40540549, -0.91413697,
      +9.73826000, +29.97130000, -39.46800000
    >
  }
  #local F[  82] = prism{ // fv.2.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +20.235340, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413697, -0.40540549,
      -0.00000000, +0.40540549, +0.91413697,
      -10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[  83] = prism{ // fv.2.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < -0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, -0.24694343,
      -0.00000000, -0.24694343, -0.96902990,
      +10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[  84] = prism{ // fv.2.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, -0.000000 >,
    < +4.056916, -21.853365 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, +0.24615232, +0.96592551,
      +0.00000000, +0.96902990, -0.24694343,
      -0.99679639, -0.01975076, -0.07750390,
      -10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[  85] = prism{ // fv.2.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < -0.464700, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, -0.24694343,
      -0.00000000, -0.24694343, -0.96902990,
      +10.96180000, +33.73692000, -28.58962000
    >
  }
  #local F[  86] = prism{ // fv.2.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, -0.000000 >,
    < +3.982659, -22.779794 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07997750, +0.24615239, +0.96592577,
      +0.00000000, +0.96902990, -0.24694343,
      -0.99679667, -0.01974992, -0.07750059,
      -10.96180000, +33.73692000, -28.58962000
    >
  }
  #local F[  87] = prism{ // fv.2.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < -0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, -0.24694343,
      -0.00000000, -0.24694343, -0.96902990,
      +11.42650000, +35.16716000, -22.97722000
    >
  }
  #local F[  88] = prism{ // fv.2.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +3.908245, -23.706250 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, +0.24615232, +0.96592551,
      +0.00000000, +0.96902990, -0.24694343,
      -0.99679639, -0.01975076, -0.07750390,
      -11.42650000, +35.16716000, -22.97722000
    >
  }
  #local F[  89] = prism{ // fv.2.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.938920, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, -0.08291952,
      -0.00000000, -0.08291952, -0.99655625,
      +11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[  90] = prism{ // fv.2.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < +23.938920, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, -0.08291952,
      -0.00000000, +0.08291952, +0.99655625,
      -12.04770000, +37.07902000, -11.57654000
    >
  }
  #local F[  91] = prism{ // fv.2.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < +24.251900, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655622, -0.08291981,
      -0.00000000, -0.08291981, -0.99655622,
      +12.04770000, +37.07902000, -11.57654000
    >
  }
  #local F[  92] = prism{ // fv.2.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < +24.251900, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655622, -0.08291981,
      -0.00000000, +0.08291981, +0.99655622,
      -12.20420000, +37.56064000, -5.78828000
    >
  }
  #local F[  93] = prism{ // fv.2.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < +24.564880, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, -0.08291952,
      -0.00000000, -0.08291952, -0.99655625,
      +12.20420000, +37.56064000, -5.78828000
    >
  }
  #local F[  94] = prism{ // fv.2.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721360, +0.000000 >,
    < +24.564880, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, -0.08291952,
      -0.00000000, +0.08291952, +0.99655625,
      -12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[  95] = prism{ // fv.2.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721360, +0.000000 >,
    < +0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, +0.08291952,
      +0.00000000, +0.08291952, -0.99655625,
      +12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[  96] = prism{ // fv.2.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +6.467734, -24.399547 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, -0.08288945, +0.99619479,
      +0.00000000, +0.99655625, +0.08291952,
      -0.99963729, -0.00223311, +0.02683832,
      -12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[  97] = prism{ // fv.2.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < +0.156500, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655622, +0.08291981,
      +0.00000000, +0.08291981, -0.99655622,
      +12.20420000, +37.56064000, +5.78828000
    >
  }
  #local F[  98] = prism{ // fv.2.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810370, +0.000000 >,
    < +6.459370, -24.086658 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693460, -0.08288972, +0.99619467,
      +0.00000000, +0.99655622, +0.08291981,
      -0.99963720, -0.00223341, +0.02684184,
      -12.20420000, +37.56064000, +5.78828000
    >
  }
  #local F[  99] = prism{ // fv.2.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < +0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655625, +0.08291952,
      +0.00000000, +0.08291952, -0.99655625,
      +12.04770000, +37.07902000, +11.57654000
    >
  }
  #local F[ 100] = prism{ // fv.2.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +6.450876, -23.773814 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, -0.08288945, +0.99619479,
      +0.00000000, +0.99655625, +0.08291952,
      -0.99963729, -0.00223311, +0.02683832,
      -12.04770000, +37.07902000, +11.57654000
    >
  }
  #local F[ 101] = prism{ // fv.2.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.317720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      +11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[ 102] = prism{ // fv.2.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < +23.317720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      -11.42650000, +35.16716000, +22.97722000
    >
  }
  #local F[ 103] = prism{ // fv.2.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < +22.388300, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      +11.42650000, +35.16716000, +22.97722000
    >
  }
  #local F[ 104] = prism{ // fv.2.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < +22.388300, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      -10.96180000, +33.73692000, +28.58962000
    >
  }
  #local F[ 105] = prism{ // fv.2.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < +21.458880, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      +10.96180000, +33.73692000, +28.58962000
    >
  }
  #local F[ 106] = prism{ // fv.2.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +21.458880, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      -10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[ 107] = prism{ // fv.2.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413754, +0.40540420,
      +0.00000000, +0.40540420, -0.91413754,
      +10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[ 108] = prism{ // fv.2.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +8.353963, -19.309714 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, -0.40193212, +0.90630841,
      +0.00000000, +0.91413754, +0.40540420,
      -0.99143551, -0.05294466, +0.11938382,
      -10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[ 109] = prism{ // fv.2.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < +0.758800, -5.760611 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413568, +0.40540839,
      +0.00000000, +0.40540839, -0.91413568,
      +9.73826000, +29.97130000, +39.46802000
    >
  }
  #local F[ 110] = prism{ // fv.2.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810371, +0.000000 >,
    < +8.155700, -17.805118 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059406, -0.40193644, +0.90630695,
      +0.00000000, +0.91413568, +0.40540839,
      -0.99143592, -0.05294393, +0.11938069,
      -9.73826000, +29.97130000, +39.46802000
    >
  }
  #local F[ 111] = prism{ // fv.2.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < +0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413754, +0.40540420,
      +0.00000000, +0.40540420, -0.91413754,
      +8.97946000, +27.63590000, +44.73400000
    >
  }
  #local F[ 112] = prism{ // fv.2.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +7.957570, -16.300469 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, -0.40193212, +0.90630841,
      +0.00000000, +0.91413754, +0.40540420,
      -0.99143551, -0.05294466, +0.11938382,
      -8.97946000, +27.63590000, +44.73400000
    >
  }
  #local F[ 113] = prism{ // fh.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521905, -15.636586 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, +0.95105649, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.95105649, -0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 114] = prism{ // fh.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +8.220640, -25.300520 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      +0.00000000, +1.00000000, +0.00000000,
      +8.22064000, +25.30052000, +50.00000000
    >
  }
  #local F[ 115] = prism{ // fv.3.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < -0.758805, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, -0.58778561, +0.00000000,
      -0.53731670, +0.73955231, -0.40540492,
      +0.23829118, -0.32797937, -0.91413722,
      -8.22064000, +25.30052000, -50.00000000
    >
  }
  #local F[ 116] = prism{ // fv.3.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810389, +0.000000 >,
    < +3.465049, -17.805074 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190480, +0.24841021, +0.90630761,
      -0.53731575, +0.73955206, -0.40540663,
      -0.77096880, -0.62558382, -0.11938169,
      -21.52190000, +15.63658000, -50.00000000
    >
  }
  #local F[ 117] = prism{ // fv.3.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, +0.000000 >,
    < -0.758831, -5.760625 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, -0.58778505, +0.00000000,
      -0.53731601, +0.73955242, -0.40540564,
      +0.23829138, -0.32798011, -0.91413690,
      -8.97946000, +27.63590000, -44.73400000
    >
  }
  #local F[ 118] = prism{ // fv.3.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +3.266808, -19.309723 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190509, +0.24840698, +0.90630838,
      -0.53731670, +0.73955263, -0.40540434,
      -0.77096801, -0.62558444, -0.11938359,
      -23.50850000, +17.07994000, -44.73400000
    >
  }
  #local F[ 119] = prism{ // fv.3.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, +0.000000 >,
    < -0.758804, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901686, -0.58778544, +0.00000000,
      -0.53731621, +0.73955195, -0.40540623,
      +0.23829188, -0.32798048, -0.91413663,
      -9.73826000, +29.97130000, -39.46800000
    >
  }
  #local F[ 120] = prism{ // fv.3.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810378, -0.000000 >,
    < +3.068576, -20.814349 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190891, +0.24841069, +0.90630592,
      -0.53731450, +0.73955136, -0.40540955,
      -0.77096785, -0.62558446, -0.11938453,
      -25.49510000, +18.52328000, -39.46800000
    >
  }
  #local F[ 121] = prism{ // fv.3.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458857, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      -0.56958094, +0.78396239, -0.24694236,
      +0.14514890, -0.19978069, -0.96903017,
      -10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[ 122] = prism{ // fv.3.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, -0.000000 >,
    < +21.458856, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901722, +0.58778494, +0.00000000,
      -0.56958107, +0.78396174, -0.24694412,
      -0.14515003, +0.19978204, +0.96902972,
      -28.69834000, +20.85058000, -28.58962000
    >
  }
  #local F[ 123] = prism{ // fv.3.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, -0.000000 >,
    < +22.388291, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901722, -0.58778494, +0.00000000,
      -0.56958144, +0.78396224, -0.24694168,
      +0.14514860, -0.19978007, -0.96903034,
      -10.96180000, +33.73692000, -28.58962000
    >
  }
  #local F[ 124] = prism{ // fv.3.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +22.388291, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, +0.58778505, +0.00000000,
      -0.56958147, +0.78396205, -0.24694220,
      -0.14514893, +0.19978047, +0.96903021,
      -29.91498000, +21.73450000, -22.97722000
    >
  }
  #local F[ 125] = prism{ // fv.3.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +23.317714, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, -0.58778505, +0.00000000,
      -0.56958144, +0.78396201, -0.24694240,
      +0.14514905, -0.19978064, -0.96903016,
      -11.42650000, +35.16716000, -22.97722000
    >
  }
  #local F[ 126] = prism{ // fv.3.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317713, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      -0.56958154, +0.78396141, -0.24694407,
      -0.14515012, +0.19978192, +0.96902973,
      -31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[ 127] = prism{ // fv.3.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < -0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, -0.58778541, +0.00000000,
      -0.58576126, +0.80623088, -0.08291873,
      +0.04873842, -0.06708265, -0.99655631,
      -11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[ 128] = prism{ // fv.3.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, +0.000000 >,
    < +5.161417, -24.086668 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, +0.05122891, +0.99619462,
      -0.58576075, +0.80623104, -0.08292082,
      -0.80741096, -0.58937858, -0.02684076,
      -31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[ 129] = prism{ // fv.3.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < -0.156478, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, -0.58778500, +0.00000000,
      -0.58576074, +0.80623102, -0.08292104,
      +0.04873974, -0.06708455, -0.99655612,
      -12.04770000, +37.07902000, -11.57654000
    >
  }
  #local F[ 130] = prism{ // fv.3.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810369, +0.000000 >,
    < +5.153033, -24.399512 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07050843, +0.05122910, +0.99619483,
      -0.58576121, +0.80623088, -0.08291910,
      -0.80741091, -0.58937878, -0.02683805,
      -31.54130000, +22.91610000, -11.57654000
    >
  }
  #local F[ 131] = prism{ // fv.3.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < -0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, -0.58778537, +0.00000000,
      -0.58576122, +0.80623090, -0.08291873,
      +0.04873842, -0.06708266, -0.99655631,
      -12.20420000, +37.56064000, -5.78828000
    >
  }
  #local F[ 132] = prism{ // fv.3.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, -0.000000 >,
    < +5.144558, -24.712385 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, +0.05122891, +0.99619462,
      -0.58576072, +0.80623105, -0.08292082,
      -0.80741098, -0.58937856, -0.02684076,
      -31.95098000, +23.21376000, -5.78828000
    >
  }
  #local F[ 133] = prism{ // fv.3.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, +0.000000 >,
    < +24.564859, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, -0.58778497, +0.00000000,
      -0.58576072, +0.80623105, +0.08292082,
      -0.04873961, +0.06708437, -0.99655614,
      -12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[ 134] = prism{ // fv.3.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, -0.000000 >,
    < +24.564859, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, +0.58778537, +0.00000000,
      -0.58576122, +0.80623090, +0.08291873,
      +0.04873842, -0.06708266, +0.99655631,
      -31.95098000, +23.21376000, +5.78828000
    >
  }
  #local F[ 135] = prism{ // fv.3.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.251887, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, -0.58778537, +0.00000000,
      -0.58576121, +0.80623088, +0.08291910,
      -0.04873864, +0.06708296, -0.99655628,
      -12.20420000, +37.56064000, +5.78828000
    >
  }
  #local F[ 136] = prism{ // fv.3.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, -0.000000 >,
    < +24.251887, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, +0.58778500, +0.00000000,
      -0.58576074, +0.80623102, +0.08292104,
      +0.04873974, -0.06708455, +0.99655612,
      -31.54130000, +22.91610000, +11.57654000
    >
  }
  #local F[ 137] = prism{ // fv.3.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, -0.000000 >,
    < +23.938915, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, -0.58778500, +0.00000000,
      -0.58576075, +0.80623104, +0.08292082,
      -0.04873961, +0.06708437, -0.99655614,
      -12.04770000, +37.07902000, +11.57654000
    >
  }
  #local F[ 138] = prism{ // fv.3.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.938915, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      -0.58576126, +0.80623088, +0.08291873,
      +0.04873842, -0.06708265, +0.99655631,
      -31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[ 139] = prism{ // fv.3.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +0.464708, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, -0.58778541, +0.00000000,
      -0.56958154, +0.78396141, +0.24694407,
      -0.14515012, +0.19978192, -0.96902973,
      -11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[ 140] = prism{ // fv.3.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, +0.000000 >,
    < +7.638109, -22.779808 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, -0.15213111, +0.96592604,
      -0.56958144, +0.78396201, +0.24694240,
      -0.79481694, -0.60188013, +0.07750058,
      -31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[ 141] = prism{ // fv.3.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +0.464723, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, -0.58778505, +0.00000000,
      -0.56958147, +0.78396205, +0.24694220,
      -0.14514893, +0.19978047, -0.96903021,
      -11.42650000, +35.16716000, +22.97722000
    >
  }
  #local F[ 142] = prism{ // fv.3.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810387, -0.000000 >,
    < +7.563836, -21.853342 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20939053, -0.15213100, +0.96592534,
      -0.56958162, +0.78396127, +0.24694436,
      -0.79481595, -0.60188113, +0.07750304,
      -29.91498000, +21.73450000, +22.97722000
    >
  }
  #local F[ 143] = prism{ // fv.3.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, +0.000000 >,
    < +0.464708, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901679, -0.58778553, +0.00000000,
      -0.56958166, +0.78396133, +0.24694406,
      -0.14515015, +0.19978189, -0.96902974,
      -10.96180000, +33.73692000, +28.58962000
    >
  }
  #local F[ 144] = prism{ // fv.3.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810380, +0.000000 >,
    < +7.489486, -20.926901 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938735, -0.15212775, +0.96592654,
      -0.56958133, +0.78396293, +0.24693973,
      -0.79481699, -0.60187978, +0.07750279,
      -28.69834000, +20.85056000, +28.58962000
    >
  }
  #local F[ 145] = prism{ // fv.3.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, -0.000000 >,
    < +20.235346, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      -0.53731528, +0.73955244, +0.40540656,
      -0.23829170, +0.32798101, -0.91413649,
      -10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[ 146] = prism{ // fv.3.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +20.235348, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901721, +0.58778495, +0.00000000,
      -0.53731608, +0.73955271, +0.40540501,
      +0.23829097, -0.32797963, +0.91413718,
      -25.49512000, +18.52328000, +39.46802000
    >
  }
  #local F[ 147] = prism{ // fv.3.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +18.717725, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901721, -0.58778495, +0.00000000,
      -0.53731593, +0.73955251, +0.40540556,
      -0.23829129, +0.32798007, -0.91413693,
      -9.73826000, +29.97130000, +39.46802000
    >
  }
  #local F[ 148] = prism{ // fv.3.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +18.717724, -5.760607 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778452, +0.00000000,
      -0.53731517, +0.73955228, +0.40540700,
      +0.23829196, -0.32798137, +0.91413629,
      -23.50852000, +17.07994000, +44.73400000
    >
  }
  #local F[ 149] = prism{ // fv.3.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +17.200068, -5.760632 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778452, +0.00000000,
      -0.53731484, +0.73955183, +0.40540827,
      -0.23829270, +0.32798239, -0.91413573,
      -8.97946000, +27.63590000, +44.73400000
    >
  }
  #local F[ 150] = prism{ // fv.3.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200071, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, +0.58778561, +0.00000000,
      -0.53731670, +0.73955231, +0.40540492,
      +0.23829118, -0.32797937, +0.91413722,
      -21.52190000, +15.63658000, +50.00000000
    >
  }
  #local F[ 151] = prism{ // fh.3.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521912, -15.636577 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901692, +0.58778536, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.58778536, -0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 152] = prism{ // fh.3.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220646, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, -0.58778561, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      -0.58778561, +0.80901674, +0.00000000,
      -8.22064000, +25.30052000, +50.00000000
    >
  }
  #local F[ 153] = prism{ // fv.4.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +17.200092, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, -0.95105639, +0.00000000,
      -0.86939542, +0.28248410, -0.40540638,
      +0.38556433, -0.12527762, -0.91413657,
      -21.52190000, +15.63658000, -50.00000000
    >
  }
  #local F[ 154] = prism{ // fv.4.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < +17.200093, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901755, +0.95105633, +0.00000000,
      -0.86939555, +0.28248430, -0.40540595,
      -0.38556390, +0.12527756, +0.91413676,
      -29.05812000, +0.00000000, -44.73400000
    >
  }
  #local F[ 155] = prism{ // fv.4.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < +18.717726, -5.760619 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901755, -0.95105633, +0.00000000,
      -0.86939655, +0.28248463, -0.40540360,
      +0.38556167, -0.12527683, -0.91413780,
      -23.50850000, +17.07994000, -44.73400000
    >
  }
  #local F[ 156] = prism{ // fv.4.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, +0.000000 >,
    < +18.717725, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901706, +0.95105649, +0.00000000,
      -0.86939610, +0.28248399, -0.40540500,
      -0.38556306, +0.12527706, +0.91413718,
      -31.51368000, +0.00000000, -39.46800000
    >
  }
  #local F[ 157] = prism{ // fv.4.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, +0.000000 >,
    < +20.235346, -5.760609 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901706, -0.95105649, +0.00000000,
      -0.86939496, +0.28248362, -0.40540771,
      +0.38556563, -0.12527790, -0.91413598,
      -25.49510000, +18.52328000, -39.46800000
    >
  }
  #local F[ 158] = prism{ // fv.4.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +20.235344, -5.760615 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      -0.86939426, +0.28248268, -0.40540986,
      -0.38556777, +0.12527828, +0.91413502,
      -33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[ 159] = prism{ // fv.4.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < -0.464722, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, -0.95105672, +0.00000000,
      -0.92160292, +0.29944627, -0.24694125,
      +0.23485514, -0.07630889, -0.96903045,
      -27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[ 160] = prism{ // fv.4.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, +0.000000 >,
    < +4.056946, -21.853364 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      -0.92160237, +0.29944658, -0.24694293,
      -0.28924316, -0.95411307, -0.07750257,
      -33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[ 161] = prism{ // fv.4.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, -0.000000 >,
    < -0.464696, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901682, -0.95105657, +0.00000000,
      -0.92160227, +0.29944655, -0.24694337,
      +0.23485712, -0.07630966, -0.96902991,
      -28.69834000, +20.85058000, -28.58962000
    >
  }
  #local F[ 162] = prism{ // fv.4.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, +0.000000 >,
    < +3.982613, -22.779794 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      -0.92160241, +0.29944647, -0.24694294,
      -0.28924305, -0.95411310, -0.07750254,
      -35.47310000, +0.00000000, -28.58962000
    >
  }
  #local F[ 163] = prism{ // fv.4.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, -0.000000 >,
    < -0.464721, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, -0.95105661, +0.00000000,
      -0.92160281, +0.29944660, -0.24694128,
      +0.23485514, -0.07630898, -0.96903045,
      -29.91498000, +21.73450000, -22.97722000
    >
  }
  #local F[ 164] = prism{ // fv.4.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, -0.000000 >,
    < +3.908274, -23.706249 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      -0.92160228, +0.29944687, -0.24694291,
      -0.28924344, -0.95411298, -0.07750265,
      -36.97694000, +0.00000000, -22.97722000
    >
  }
  #local F[ 165] = prism{ // fv.4.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      -0.94778134, +0.30795296, -0.08291867,
      +0.07886034, -0.02562329, -0.99655632,
      -31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[ 166] = prism{ // fv.4.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +23.938922, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, +0.95105667, +0.00000000,
      -0.94778133, +0.30795231, -0.08292120,
      -0.07886276, +0.02562402, +0.99655611,
      -38.98718000, +0.00000000, -11.57654000
    >
  }
  #local F[ 167] = prism{ // fv.4.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +24.251902, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, -0.95105667, +0.00000000,
      -0.94778125, +0.30795229, -0.08292222,
      +0.07886373, -0.02562434, -0.99655602,
      -31.54130000, +22.91610000, -11.57654000
    >
  }
  #local F[ 168] = prism{ // fv.4.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.251902, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, +0.95105637, +0.00000000,
      -0.94778127, +0.30795330, -0.08291825,
      -0.07885993, +0.02562319, +0.99655635,
      -39.49360000, +0.00000000, -5.78828000
    >
  }
  #local F[ 169] = prism{ // fv.4.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.564882, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, -0.95105637, +0.00000000,
      -0.94778123, +0.30795329, -0.08291866,
      +0.07886032, -0.02562331, -0.99655632,
      -31.95098000, +23.21376000, -5.78828000
    >
  }
  #local F[ 170] = prism{ // fv.4.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, -0.000000 >,
    < +24.564882, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, +0.95105656, +0.00000000,
      -0.94778122, +0.30795265, -0.08292120,
      -0.07886276, +0.02562405, +0.99655611,
      -40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[ 171] = prism{ // fv.4.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901687, -0.95105656, +0.00000000,
      -0.94778122, +0.30795265, +0.08292120,
      -0.07886276, +0.02562405, -0.99655611,
      -32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[ 172] = prism{ // fv.4.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +6.467761, -24.399542 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715423, +0.00000000, +0.99619483,
      -0.94778123, +0.30795329, +0.08291866,
      -0.30678147, -0.95140148, +0.02683943,
      -40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[ 173] = prism{ // fv.4.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +0.156493, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, -0.95105637, +0.00000000,
      -0.94778127, +0.30795330, +0.08291825,
      -0.07885993, +0.02562319, -0.99655635,
      -31.95098000, +23.21376000, +5.78828000
    >
  }
  #local F[ 174] = prism{ // fv.4.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810371, +0.000000 >,
    < +6.459339, -24.086669 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715794, +0.00000000, +0.99619451,
      -0.94778125, +0.30795229, +0.08292222,
      -0.30678038, -0.95140180, +0.02684049,
      -39.49360000, +0.00000000, +5.78828000
    >
  }
  #local F[ 175] = prism{ // fv.4.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, -0.000000 >,
    < +0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, -0.95105667, +0.00000000,
      -0.94778133, +0.30795231, +0.08292120,
      -0.07886276, +0.02562402, -0.99655611,
      -31.54130000, +22.91610000, +11.57654000
    >
  }
  #local F[ 176] = prism{ // fv.4.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +6.450902, -23.773810 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715423, +0.00000000, +0.99619483,
      -0.94778134, +0.30795296, +0.08291867,
      -0.30678115, -0.95140158, +0.02683940,
      -38.98718000, +0.00000000, +11.57654000
    >
  }
  #local F[ 177] = prism{ // fv.4.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317724, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      -0.92160228, +0.29944687, +0.24694291,
      -0.23485665, +0.07630959, -0.96903003,
      -31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[ 178] = prism{ // fv.4.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +23.317725, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, +0.95105661, +0.00000000,
      -0.92160281, +0.29944660, +0.24694128,
      +0.23485514, -0.07630898, +0.96903045,
      -36.97694000, +0.00000000, +22.97722000
    >
  }
  #local F[ 179] = prism{ // fv.4.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +22.388292, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, -0.95105661, +0.00000000,
      -0.92160241, +0.29944647, +0.24694294,
      -0.23485672, +0.07630950, -0.96903002,
      -29.91498000, +21.73450000, +22.97722000
    >
  }
  #local F[ 180] = prism{ // fv.4.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, +0.000000 >,
    < +22.388291, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, +0.95105648, +0.00000000,
      -0.92160193, +0.29944673, +0.24694439,
      +0.23485807, -0.07631004, +0.96902965,
      -35.47310000, +0.00000000, +28.58962000
    >
  }
  #local F[ 181] = prism{ // fv.4.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, +0.000000 >,
    < +21.458865, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, -0.95105648, +0.00000000,
      -0.92160229, +0.29944684, +0.24694291,
      -0.23485666, +0.07630958, -0.96903003,
      -28.69834000, +20.85056000, +28.58962000
    >
  }
  #local F[ 182] = prism{ // fv.4.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +21.458866, -5.791767 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      -0.92160317, +0.29944635, +0.24694025,
      +0.23485418, -0.07630858, +0.96903071,
      -33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[ 183] = prism{ // fv.4.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +0.758825, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, -0.95105672, +0.00000000,
      -0.86939597, +0.28248324, +0.40540582,
      -0.38556393, +0.12527703, -0.91413682,
      -27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[ 184] = prism{ // fv.4.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, -0.000000 >,
    < +8.353946, -19.309720 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42261881, +0.00000000, +0.90630753,
      -0.86939573, +0.28248293, +0.40540653,
      -0.25601641, -0.95927233, +0.11938260,
      -33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[ 185] = prism{ // fv.4.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, -0.000000 >,
    < +0.758807, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901613, -0.95105680, +0.00000000,
      -0.86939588, +0.28248298, +0.40540618,
      -0.38556430, +0.12527705, -0.91413666,
      -25.49512000, +18.52328000, +39.46802000
    >
  }
  #local F[ 186] = prism{ // fv.4.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810363, +0.000000 >,
    < +8.155720, -17.805104 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42261730, +0.00000000, +0.90630824,
      -0.86939625, +0.28248351, +0.40540501,
      -0.25601713, -0.95927215, +0.11938242,
      -31.51368000, +0.00000000, +39.46802000
    >
  }
  #local F[ 187] = prism{ // fv.4.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, +0.000000 >,
    < +0.758819, -5.760633 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901655, -0.95105666, +0.00000000,
      -0.86939474, +0.28248302, +0.40540860,
      -0.38556655, +0.12527796, -0.91413559,
      -23.50852000, +17.07994000, +44.73400000
    >
  }
  #local F[ 188] = prism{ // fv.4.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, -0.000000 >,
    < +7.957564, -16.300466 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42261881, +0.00000000, +0.90630753,
      -0.86939542, +0.28248410, +0.40540638,
      -0.25601746, -0.95927198, +0.11938309,
      -29.05812000, +0.00000000, +44.73400000
    >
  }
  #local F[ 189] = prism{ // fh.4.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602540, +0.000000 >,
    < +21.521900, -15.636580 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.00000000, -1.00000000, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 190] = prism{ // fh.4.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +8.220628, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, -0.95105639, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      -0.95105639, +0.30901739, +0.00000000,
      -21.52190000, +15.63658000, +50.00000000
    >
  }
  #local F[ 191] = prism{ // fv.5.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < -0.758817, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, -0.95105639, +0.00000000,
      -0.86939542, -0.28248410, -0.40540638,
      +0.38556433, +0.12527762, -0.91413657,
      -26.60254000, +0.00000000, -50.00000000
    >
  }
  #local F[ 192] = prism{ // fv.5.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810389, +0.000000 >,
    < +3.465000, -17.805105 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190480, -0.24841021, +0.90630761,
      -0.86939555, -0.28248430, -0.40540595,
      +0.35672465, -0.92655005, -0.11938399,
      -21.52190000, -15.63658000, -50.00000000
    >
  }
  #local F[ 193] = prism{ // fv.5.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < -0.758811, -5.760619 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901755, -0.95105633, +0.00000000,
      -0.86939655, -0.28248463, -0.40540360,
      +0.38556167, +0.12527683, -0.91413780,
      -29.05812000, +0.00000000, -44.73400000
    >
  }
  #local F[ 194] = prism{ // fv.5.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, -0.000000 >,
    < +3.266856, -19.309730 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190509, -0.24840698, +0.90630838,
      -0.86939610, -0.28248399, -0.40540500,
      +0.35672304, -0.92655101, -0.11938134,
      -23.50850000, -17.07994000, -44.73400000
    >
  }
  #local F[ 195] = prism{ // fv.5.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, +0.000000 >,
    < -0.758816, -5.760609 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901706, -0.95105649, +0.00000000,
      -0.86939496, -0.28248362, -0.40540771,
      +0.38556563, +0.12527790, -0.91413598,
      -31.51368000, +0.00000000, -39.46800000
    >
  }
  #local F[ 196] = prism{ // fv.5.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810378, -0.000000 >,
    < +3.068599, -20.814359 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190891, -0.24841069, +0.90630592,
      -0.86939426, -0.28248268, -0.40540986,
      +0.35672387, -0.92655041, -0.11938348,
      -25.49510000, -18.52328000, -39.46800000
    >
  }
  #local F[ 197] = prism{ // fv.5.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +21.458885, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      -0.92160292, -0.29944627, -0.24694125,
      +0.23485514, +0.07630889, -0.96903045,
      -33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[ 198] = prism{ // fv.5.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, +0.000000 >,
    < +21.458884, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901682, +0.95105657, +0.00000000,
      -0.92160237, -0.29944658, -0.24694293,
      -0.23485670, -0.07630952, +0.96903002,
      -28.69834000, -20.85058000, -28.58962000
    >
  }
  #local F[ 199] = prism{ // fv.5.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, +0.000000 >,
    < +22.388292, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901682, -0.95105657, +0.00000000,
      -0.92160227, -0.29944655, -0.24694337,
      +0.23485712, +0.07630966, -0.96902991,
      -35.47310000, +0.00000000, -28.58962000
    >
  }
  #local F[ 200] = prism{ // fv.5.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +22.388292, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, +0.95105661, +0.00000000,
      -0.92160241, -0.29944647, -0.24694294,
      -0.23485672, -0.07630950, +0.96903002,
      -29.91498000, -21.73450000, -22.97722000
    >
  }
  #local F[ 201] = prism{ // fv.5.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +23.317725, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, -0.95105661, +0.00000000,
      -0.92160281, -0.29944660, -0.24694128,
      +0.23485514, +0.07630898, -0.96903045,
      -36.97694000, +0.00000000, -22.97722000
    >
  }
  #local F[ 202] = prism{ // fv.5.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317724, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      -0.92160228, -0.29944687, -0.24694291,
      -0.23485665, -0.07630959, +0.96903003,
      -31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[ 203] = prism{ // fv.5.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, -0.000000 >,
    < -0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, -0.95105647, +0.00000000,
      -0.94778134, -0.30795296, -0.08291867,
      +0.07886034, +0.02562329, -0.99655632,
      -38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[ 204] = prism{ // fv.5.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, +0.000000 >,
    < +5.161445, -24.086669 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, -0.05122891, +0.99619462,
      -0.94778133, -0.30795231, -0.08292120,
      +0.31102840, -0.95002156, -0.02683959,
      -31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[ 205] = prism{ // fv.5.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < -0.156492, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, -0.95105667, +0.00000000,
      -0.94778125, -0.30795229, -0.08292222,
      +0.07886373, +0.02562434, -0.99655602,
      -38.98718000, +0.00000000, -11.57654000
    >
  }
  #local F[ 206] = prism{ // fv.5.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810369, +0.000000 >,
    < +5.152968, -24.399541 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07050843, -0.05122910, +0.99619483,
      -0.94778127, -0.30795330, -0.08291825,
      +0.31102931, -0.95002123, -0.02684068,
      -31.54130000, -22.91610000, -11.57654000
    >
  }
  #local F[ 207] = prism{ // fv.5.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < -0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, -0.95105637, +0.00000000,
      -0.94778123, -0.30795329, -0.08291866,
      +0.07886032, +0.02562331, -0.99655632,
      -39.49360000, +0.00000000, -5.78828000
    >
  }
  #local F[ 208] = prism{ // fv.5.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, -0.000000 >,
    < +5.144587, -24.712401 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, -0.05122891, +0.99619462,
      -0.94778122, -0.30795265, -0.08292120,
      +0.31102873, -0.95002146, -0.02683956,
      -31.95098000, -23.21376000, -5.78828000
    >
  }
  #local F[ 209] = prism{ // fv.5.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, -0.000000 >,
    < +24.564882, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, -0.95105656, +0.00000000,
      -0.94778122, -0.30795265, +0.08292120,
      -0.07886276, -0.02562405, -0.99655611,
      -40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[ 210] = prism{ // fv.5.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.564882, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, +0.95105637, +0.00000000,
      -0.94778123, -0.30795329, +0.08291866,
      +0.07886032, +0.02562331, +0.99655632,
      -31.95098000, -23.21376000, +5.78828000
    >
  }
  #local F[ 211] = prism{ // fv.5.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.251902, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, -0.95105637, +0.00000000,
      -0.94778127, -0.30795330, +0.08291825,
      -0.07885993, -0.02562319, -0.99655635,
      -39.49360000, +0.00000000, +5.78828000
    >
  }
  #local F[ 212] = prism{ // fv.5.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +24.251902, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, +0.95105667, +0.00000000,
      -0.94778125, -0.30795229, +0.08292222,
      +0.07886373, +0.02562434, +0.99655602,
      -31.54130000, -22.91610000, +11.57654000
    >
  }
  #local F[ 213] = prism{ // fv.5.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +23.938922, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, -0.95105667, +0.00000000,
      -0.94778133, -0.30795231, +0.08292120,
      -0.07886276, -0.02562402, -0.99655611,
      -38.98718000, +0.00000000, +11.57654000
    >
  }
  #local F[ 214] = prism{ // fv.5.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      -0.94778134, -0.30795296, +0.08291867,
      +0.07886034, +0.02562329, +0.99655632,
      -31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[ 215] = prism{ // fv.5.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, -0.95105647, +0.00000000,
      -0.92160228, -0.29944687, +0.24694291,
      -0.23485665, -0.07630959, -0.96903003,
      -38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[ 216] = prism{ // fv.5.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, +0.000000 >,
    < +7.638192, -22.779791 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, +0.15213111, +0.96592604,
      -0.92160281, -0.29944660, +0.24694128,
      +0.32681072, -0.94190650, +0.07750416,
      -31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[ 217] = prism{ // fv.5.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, -0.95105661, +0.00000000,
      -0.92160241, -0.29944647, +0.24694294,
      -0.23485672, -0.07630950, -0.96903002,
      -36.97694000, +0.00000000, +22.97722000
    >
  }
  #local F[ 218] = prism{ // fv.5.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810387, +0.000000 >,
    < +7.563833, -21.853344 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20939053, +0.15213100, +0.96592534,
      -0.92160193, -0.29944673, +0.24694439,
      +0.32681108, -0.94190648, +0.07750292,
      -29.91498000, -21.73450000, +22.97722000
    >
  }
  #local F[ 219] = prism{ // fv.5.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, +0.000000 >,
    < +0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, -0.95105648, +0.00000000,
      -0.92160229, -0.29944684, +0.24694291,
      -0.23485666, -0.07630958, -0.96903003,
      -35.47310000, +0.00000000, +28.58962000
    >
  }
  #local F[ 220] = prism{ // fv.5.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810380, -0.000000 >,
    < +7.489451, -20.926911 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938735, +0.15212775, +0.96592654,
      -0.92160317, -0.29944635, +0.24694025,
      +0.32680964, -0.94190713, +0.07750114,
      -28.69834000, -20.85056000, +28.58962000
    >
  }
  #local F[ 221] = prism{ // fv.5.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +20.235338, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      -0.86939597, -0.28248324, +0.40540582,
      -0.38556393, -0.12527703, -0.91413682,
      -33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[ 222] = prism{ // fv.5.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, +0.000000 >,
    < +20.235337, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901613, +0.95105680, +0.00000000,
      -0.86939573, -0.28248293, +0.40540653,
      +0.38556463, +0.12527716, +0.91413650,
      -25.49512000, -18.52328000, +39.46802000
    >
  }
  #local F[ 223] = prism{ // fv.5.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, +0.000000 >,
    < +18.717717, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901613, -0.95105680, +0.00000000,
      -0.86939588, -0.28248298, +0.40540618,
      -0.38556430, -0.12527705, -0.91413666,
      -31.51368000, +0.00000000, +39.46802000
    >
  }
  #local F[ 224] = prism{ // fv.5.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, +0.000000 >,
    < +18.717718, -5.760602 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901655, +0.95105666, +0.00000000,
      -0.86939625, -0.28248351, +0.40540501,
      +0.38556313, +0.12527685, +0.91413718,
      -23.50852000, -17.07994000, +44.73400000
    >
  }
  #local F[ 225] = prism{ // fv.5.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, +0.000000 >,
    < +17.200090, -5.760633 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901655, -0.95105666, +0.00000000,
      -0.86939474, -0.28248302, +0.40540860,
      -0.38556655, -0.12527796, -0.91413559,
      -29.05812000, +0.00000000, +44.73400000
    >
  }
  #local F[ 226] = prism{ // fv.5.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +17.200092, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, +0.95105639, +0.00000000,
      -0.86939542, -0.28248410, +0.40540638,
      +0.38556433, +0.12527762, +0.91413657,
      -21.52190000, -15.63658000, +50.00000000
    >
  }
  #local F[ 227] = prism{ // fh.5.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521905, -15.636584 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901692, -0.58778536, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.58778536, -0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 228] = prism{ // fh.5.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +8.220647, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, -0.95105639, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      -0.95105639, -0.30901739, +0.00000000,
      -26.60254000, +0.00000000, +50.00000000
    >
  }
  #local F[ 229] = prism{ // fv.6.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200071, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, -0.58778561, +0.00000000,
      -0.53731670, -0.73955231, -0.40540492,
      +0.23829118, +0.32797937, -0.91413722,
      -21.52190000, -15.63658000, -50.00000000
    >
  }
  #local F[ 230] = prism{ // fv.6.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, -0.000000 >,
    < +17.200070, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, +0.58778505, +0.00000000,
      -0.53731575, -0.73955206, -0.40540663,
      -0.23829196, -0.32798091, +0.91413646,
      -8.97946000, -27.63590000, -44.73400000
    >
  }
  #local F[ 231] = prism{ // fv.6.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, +0.000000 >,
    < +18.717709, -5.760625 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, -0.58778505, +0.00000000,
      -0.53731601, -0.73955242, -0.40540564,
      +0.23829138, +0.32798011, -0.91413690,
      -23.50850000, -17.07994000, -44.73400000
    >
  }
  #local F[ 232] = prism{ // fv.6.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, -0.000000 >,
    < +18.717710, -5.760622 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901686, +0.58778544, +0.00000000,
      -0.53731670, -0.73955263, -0.40540434,
      -0.23829077, -0.32797894, +0.91413747,
      -9.73826000, -29.97130000, -39.46800000
    >
  }
  #local F[ 233] = prism{ // fv.6.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, +0.000000 >,
    < +20.235333, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901686, -0.58778544, +0.00000000,
      -0.53731621, -0.73955195, -0.40540623,
      +0.23829188, +0.32798048, -0.91413663,
      -25.49510000, -18.52328000, -39.46800000
    >
  }
  #local F[ 234] = prism{ // fv.6.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, -0.000000 >,
    < +20.235330, -5.760614 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      -0.53731450, -0.73955136, -0.40540955,
      -0.23829346, -0.32798343, +0.91413516,
      -10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[ 235] = prism{ // fv.6.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, -0.000000 >,
    < -0.464701, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778453, +0.00000000,
      -0.56958094, -0.78396239, -0.24694236,
      +0.14514890, +0.19978069, -0.96903017,
      -27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[ 236] = prism{ // fv.6.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +4.056968, -21.853332 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, -0.24615232, +0.96592551,
      -0.56958107, -0.78396174, -0.24694412,
      +0.81803451, -0.56992370, -0.07750173,
      -10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[ 237] = prism{ // fv.6.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, +0.000000 >,
    < -0.464728, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901722, -0.58778494, +0.00000000,
      -0.56958144, -0.78396224, -0.24694168,
      +0.14514860, +0.19978007, -0.96903034,
      -28.69834000, -20.85058000, -28.58962000
    >
  }
  #local F[ 238] = prism{ // fv.6.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, -0.000000 >,
    < +3.982565, -22.779801 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07997750, -0.24615239, +0.96592577,
      -0.56958147, -0.78396205, -0.24694220,
      +0.81803456, -0.56992324, -0.07750452,
      -10.96180000, -33.73692000, -28.58962000
    >
  }
  #local F[ 239] = prism{ // fv.6.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < -0.464700, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, -0.58778505, +0.00000000,
      -0.56958144, -0.78396201, -0.24694240,
      +0.14514905, +0.19978064, -0.96903016,
      -29.91498000, -21.73450000, -22.97722000
    >
  }
  #local F[ 240] = prism{ // fv.6.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +3.908296, -23.706235 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, -0.24615232, +0.96592551,
      -0.56958154, -0.78396141, -0.24694407,
      +0.81803418, -0.56992415, -0.07750187,
      -11.42650000, -35.16716000, -22.97722000
    >
  }
  #local F[ 241] = prism{ // fv.6.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.938915, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      -0.58576126, -0.80623088, -0.08291873,
      +0.04873842, +0.06708265, -0.99655631,
      -31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[ 242] = prism{ // fv.6.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, -0.000000 >,
    < +23.938915, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, +0.58778500, +0.00000000,
      -0.58576075, -0.80623104, -0.08292082,
      -0.04873961, -0.06708437, +0.99655614,
      -12.04770000, -37.07902000, -11.57654000
    >
  }
  #local F[ 243] = prism{ // fv.6.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, -0.000000 >,
    < +24.251887, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, -0.58778500, +0.00000000,
      -0.58576074, -0.80623102, -0.08292104,
      +0.04873974, +0.06708455, -0.99655612,
      -31.54130000, -22.91610000, -11.57654000
    >
  }
  #local F[ 244] = prism{ // fv.6.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.251887, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, +0.58778537, +0.00000000,
      -0.58576121, -0.80623088, -0.08291910,
      -0.04873864, -0.06708296, +0.99655628,
      -12.20420000, -37.56064000, -5.78828000
    >
  }
  #local F[ 245] = prism{ // fv.6.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, -0.000000 >,
    < +24.564859, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, -0.58778537, +0.00000000,
      -0.58576122, -0.80623090, -0.08291873,
      +0.04873842, +0.06708266, -0.99655631,
      -31.95098000, -23.21376000, -5.78828000
    >
  }
  #local F[ 246] = prism{ // fv.6.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, +0.000000 >,
    < +24.564859, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, +0.58778497, +0.00000000,
      -0.58576072, -0.80623105, -0.08292082,
      -0.04873961, -0.06708437, +0.99655614,
      -12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[ 247] = prism{ // fv.6.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, -0.000000 >,
    < +0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901720, -0.58778497, +0.00000000,
      -0.58576072, -0.80623105, +0.08292082,
      -0.04873961, -0.06708437, -0.99655614,
      -32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[ 248] = prism{ // fv.6.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +6.467793, -24.399510 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, +0.08288945, +0.99619479,
      -0.58576122, -0.80623090, +0.08291873,
      +0.81003611, -0.58576537, +0.02684077,
      -12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[ 249] = prism{ // fv.6.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +0.156478, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, -0.58778537, +0.00000000,
      -0.58576121, -0.80623088, +0.08291910,
      -0.04873864, -0.06708296, -0.99655628,
      -31.95098000, -23.21376000, +5.78828000
    >
  }
  #local F[ 250] = prism{ // fv.6.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810370, -0.000000 >,
    < +6.459279, -24.086670 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693460, +0.08288972, +0.99619467,
      -0.58576074, -0.80623102, +0.08292104,
      +0.81003635, -0.58576517, +0.02683804,
      -12.20420000, -37.56064000, +5.78828000
    >
  }
  #local F[ 251] = prism{ // fv.6.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, -0.58778500, +0.00000000,
      -0.58576075, -0.80623104, +0.08292082,
      -0.04873961, -0.06708437, -0.99655614,
      -31.54130000, -22.91610000, +11.57654000
    >
  }
  #local F[ 252] = prism{ // fv.6.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, -0.000000 >,
    < +6.450934, -23.773793 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, +0.08288945, +0.99619479,
      -0.58576126, -0.80623088, +0.08291873,
      +0.81003609, -0.58576540, +0.02684077,
      -12.04770000, -37.07902000, +11.57654000
    >
  }
  #local F[ 253] = prism{ // fv.6.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317713, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      -0.56958154, -0.78396141, +0.24694407,
      -0.14515012, -0.19978192, -0.96902973,
      -31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[ 254] = prism{ // fv.6.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +23.317714, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, +0.58778505, +0.00000000,
      -0.56958144, -0.78396201, +0.24694240,
      +0.14514905, +0.19978064, +0.96903016,
      -11.42650000, -35.16716000, +22.97722000
    >
  }
  #local F[ 255] = prism{ // fv.6.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +22.388291, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, -0.58778505, +0.00000000,
      -0.56958147, -0.78396205, +0.24694220,
      -0.14514893, -0.19978047, -0.96903021,
      -29.91498000, -21.73450000, +22.97722000
    >
  }
  #local F[ 256] = prism{ // fv.6.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, +0.000000 >,
    < +22.388290, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901679, +0.58778553, +0.00000000,
      -0.56958162, -0.78396127, +0.24694436,
      +0.14515032, +0.19978213, +0.96902966,
      -10.96180000, -33.73692000, +28.58962000
    >
  }
  #local F[ 257] = prism{ // fv.6.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, +0.000000 >,
    < +21.458867, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901679, -0.58778553, +0.00000000,
      -0.56958166, -0.78396133, +0.24694406,
      -0.14515015, -0.19978189, -0.96902974,
      -28.69834000, -20.85056000, +28.58962000
    >
  }
  #local F[ 258] = prism{ // fv.6.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458868, -5.791766 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      -0.56958133, -0.78396293, +0.24693973,
      +0.14514735, +0.19977857, +0.96903084,
      -10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[ 259] = prism{ // fv.6.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +0.758810, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778453, +0.00000000,
      -0.53731528, -0.73955244, +0.40540656,
      -0.23829170, -0.32798101, -0.91413649,
      -27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[ 260] = prism{ // fv.6.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, -0.000000 >,
    < +8.353909, -19.309746 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, +0.40193212, +0.90630841,
      -0.53731608, -0.73955271, +0.40540501,
      +0.83320814, -0.53991885, +0.11938106,
      -10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[ 261] = prism{ // fv.6.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +0.758820, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901721, -0.58778495, +0.00000000,
      -0.53731593, -0.73955251, +0.40540556,
      -0.23829129, -0.32798007, -0.91413693,
      -25.49512000, -18.52328000, +39.46802000
    >
  }
  #local F[ 262] = prism{ // fv.6.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810371, +0.000000 >,
    < +8.155787, -17.805081 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059406, +0.40193644, +0.90630695,
      -0.53731517, -0.73955228, +0.40540700,
      +0.83320922, -0.53991622, +0.11938541,
      -9.73826000, -29.97130000, +39.46802000
    >
  }
  #local F[ 263] = prism{ // fv.6.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +0.758826, -5.760632 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778452, +0.00000000,
      -0.53731484, -0.73955183, +0.40540827,
      -0.23829270, -0.32798239, -0.91413573,
      -23.50852000, -17.07994000, +44.73400000
    >
  }
  #local F[ 264] = prism{ // fv.6.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +7.957524, -16.300461 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, +0.40193212, +0.90630841,
      -0.53731670, -0.73955231, +0.40540492,
      +0.83320774, -0.53991940, +0.11938137,
      -8.97946000, -27.63590000, +44.73400000
    >
  }
  #local F[ 265] = prism{ // fh.6.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521906, -15.636572 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, -0.95105649, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.95105649, -0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 266] = prism{ // fh.6.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220621, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, -0.58778561, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      -0.58778561, -0.80901674, +0.00000000,
      -21.52190000, -15.63658000, +50.00000000
    >
  }
  #local F[ 267] = prism{ // fv.7.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < -0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413754, -0.40540420,
      +0.00000000, +0.40540420, -0.91413754,
      -8.22064000, -25.30052000, -50.00000000
    >
  }
  #local F[ 268] = prism{ // fv.7.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, -0.000000 >,
    < +3.464999, -17.805111 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059722, -0.40193212, +0.90630841,
      +0.00000000, -0.91413754, -0.40540420,
      +0.99143551, +0.05294466, -0.11938382,
      +8.22064000, -25.30052000, -50.00000000
    >
  }
  #local F[ 269] = prism{ // fv.7.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < -0.758800, -5.760629 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413625, -0.40540710,
      +0.00000000, +0.40540710, -0.91413625,
      -8.97946000, -27.63590000, -44.73400000
    >
  }
  #local F[ 270] = prism{ // fv.7.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +3.266880, -19.309723 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059365, -0.40193519, +0.90630757,
      +0.00000000, -0.91413625, -0.40540710,
      +0.99143598, +0.05294359, -0.11938039,
      +8.97946000, -27.63590000, -44.73400000
    >
  }
  #local F[ 271] = prism{ // fv.7.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < -0.758820, -5.760603 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413697, -0.40540549,
      +0.00000000, +0.40540549, -0.91413697,
      -9.73826000, -29.97130000, -39.46800000
    >
  }
  #local F[ 272] = prism{ // fv.7.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810366, +0.000000 >,
    < +3.068579, -20.814355 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.13059763, -0.40193337, +0.90630780,
      +0.00000000, -0.91413697, -0.40540549,
      +0.99143545, +0.05294499, -0.11938412,
      +9.73826000, -29.97130000, -39.46800000
    >
  }
  #local F[ 273] = prism{ // fv.7.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +21.458880, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      -10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[ 274] = prism{ // fv.7.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < +21.458880, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      +10.96180000, -33.73692000, -28.58962000
    >
  }
  #local F[ 275] = prism{ // fv.7.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < +22.388300, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      -10.96180000, -33.73692000, -28.58962000
    >
  }
  #local F[ 276] = prism{ // fv.7.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < +22.388300, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      +11.42650000, -35.16716000, -22.97722000
    >
  }
  #local F[ 277] = prism{ // fv.7.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < +23.317720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      -11.42650000, -35.16716000, -22.97722000
    >
  }
  #local F[ 278] = prism{ // fv.7.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.317720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, -0.24694343, +0.96902990,
      +11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[ 279] = prism{ // fv.7.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < -0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, -0.08291952,
      +0.00000000, +0.08291952, -0.99655625,
      -11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[ 280] = prism{ // fv.7.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, -0.000000 >,
    < +5.161475, -24.086660 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, -0.08288945, +0.99619479,
      +0.00000000, -0.99655625, -0.08291952,
      +0.99963729, +0.00223311, -0.02683832,
      +11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[ 281] = prism{ // fv.7.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < -0.156500, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655622, -0.08291981,
      +0.00000000, +0.08291981, -0.99655622,
      -12.04770000, -37.07902000, -11.57654000
    >
  }
  #local F[ 282] = prism{ // fv.7.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810370, +0.000000 >,
    < +5.152940, -24.399545 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693460, -0.08288972, +0.99619467,
      +0.00000000, -0.99655622, -0.08291981,
      +0.99963720, +0.00223341, -0.02684184,
      +12.04770000, -37.07902000, -11.57654000
    >
  }
  #local F[ 283] = prism{ // fv.7.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < -0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, -0.08291952,
      +0.00000000, +0.08291952, -0.99655625,
      -12.20420000, -37.56064000, -5.78828000
    >
  }
  #local F[ 284] = prism{ // fv.7.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +5.144617, -24.712393 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.02693107, -0.08288945, +0.99619479,
      +0.00000000, -0.99655625, -0.08291952,
      +0.99963729, +0.00223311, -0.02683832,
      +12.20420000, -37.56064000, -5.78828000
    >
  }
  #local F[ 285] = prism{ // fv.7.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721360, +0.000000 >,
    < +24.564880, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, +0.08291952,
      +0.00000000, -0.08291952, -0.99655625,
      -12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[ 286] = prism{ // fv.7.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < +24.564880, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, +0.08291952,
      +0.00000000, +0.08291952, +0.99655625,
      +12.20420000, -37.56064000, +5.78828000
    >
  }
  #local F[ 287] = prism{ // fv.7.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408400, +0.000000 >,
    < +24.251900, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655622, +0.08291981,
      +0.00000000, -0.08291981, -0.99655622,
      -12.20420000, -37.56064000, +5.78828000
    >
  }
  #local F[ 288] = prism{ // fv.7.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < +24.251900, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655622, +0.08291981,
      +0.00000000, +0.08291981, +0.99655622,
      +12.04770000, -37.07902000, +11.57654000
    >
  }
  #local F[ 289] = prism{ // fv.7.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095400, +0.000000 >,
    < +23.938920, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, +0.08291952,
      +0.00000000, -0.08291952, -0.99655625,
      -12.04770000, -37.07902000, +11.57654000
    >
  }
  #local F[ 290] = prism{ // fv.7.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.938920, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655625, +0.08291952,
      +0.00000000, +0.08291952, +0.99655625,
      +11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[ 291] = prism{ // fv.7.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, +0.24694343,
      +0.00000000, -0.24694343, -0.96902990,
      -11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[ 292] = prism{ // fv.7.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +7.638190, -22.779788 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, +0.24615232, +0.96592551,
      +0.00000000, -0.96902990, +0.24694343,
      +0.99679639, +0.01975076, +0.07750390,
      +11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[ 293] = prism{ // fv.7.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853000, +0.000000 >,
    < +0.464700, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, +0.24694343,
      +0.00000000, -0.24694343, -0.96902990,
      -11.42650000, -35.16716000, +22.97722000
    >
  }
  #local F[ 294] = prism{ // fv.7.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +7.563779, -21.853371 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07997750, +0.24615239, +0.96592577,
      +0.00000000, -0.96902990, +0.24694343,
      +0.99679667, +0.01974992, +0.07750059,
      +11.42650000, -35.16716000, +22.97722000
    >
  }
  #local F[ 295] = prism{ // fv.7.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923600, +0.000000 >,
    < +0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, +0.24694343,
      +0.00000000, -0.24694343, -0.96902990,
      -10.96180000, -33.73692000, +28.58962000
    >
  }
  #local F[ 296] = prism{ // fv.7.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810386, +0.000000 >,
    < +7.489518, -20.926903 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07998092, +0.24615232, +0.96592551,
      +0.00000000, -0.96902990, +0.24694343,
      +0.99679639, +0.01975076, +0.07750390,
      +10.96180000, -33.73692000, +28.58962000
    >
  }
  #local F[ 297] = prism{ // fv.7.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +20.235340, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413754, +0.40540420,
      +0.00000000, -0.40540420, -0.91413754,
      -10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[ 298] = prism{ // fv.7.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < +20.235340, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413754, +0.40540420,
      +0.00000000, +0.40540420, +0.91413754,
      +9.73826000, -29.97130000, +39.46802000
    >
  }
  #local F[ 299] = prism{ // fv.7.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476520, +0.000000 >,
    < +18.717720, -5.760611 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413568, +0.40540839,
      +0.00000000, -0.40540839, -0.91413568,
      -9.73826000, -29.97130000, +39.46802000
    >
  }
  #local F[ 300] = prism{ // fv.7.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < +18.717720, -5.760611 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413568, +0.40540839,
      +0.00000000, +0.40540839, +0.91413568,
      +8.97946000, -27.63590000, +44.73400000
    >
  }
  #local F[ 301] = prism{ // fv.7.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958920, +0.000000 >,
    < +17.200100, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413754, +0.40540420,
      +0.00000000, -0.40540420, -0.91413754,
      -8.97946000, -27.63590000, +44.73400000
    >
  }
  #local F[ 302] = prism{ // fv.7.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +17.200100, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413754, +0.40540420,
      +0.00000000, +0.40540420, +0.91413754,
      +8.22064000, -25.30052000, +50.00000000
    >
  }
  #local F[ 303] = prism{ // fh.7.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521905, -15.636586 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, -0.95105649, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.95105649, +0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 304] = prism{ // fh.7.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +8.220640, -25.300520 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      +0.00000000, -1.00000000, +0.00000000,
      -8.22064000, -25.30052000, +50.00000000
    >
  }
  #local F[ 305] = prism{ // fv.8.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200073, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, +0.58778561, +0.00000000,
      +0.53731623, -0.73955167, -0.40540671,
      -0.23829223, +0.32798081, -0.91413642,
      +8.22064000, -25.30052000, -50.00000000
    >
  }
  #local F[ 306] = prism{ // fv.8.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, +0.000000 >,
    < +17.200075, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, -0.58778505, +0.00000000,
      +0.53731617, -0.73955265, -0.40540500,
      +0.23829100, -0.32797959, +0.91413718,
      +23.50850000, -17.07994000, -44.73400000
    >
  }
  #local F[ 307] = prism{ // fv.8.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958878, -0.000000 >,
    < +18.717698, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, +0.58778505, +0.00000000,
      +0.53731636, -0.73955290, -0.40540429,
      -0.23829058, +0.32797901, -0.91413750,
      +8.97946000, -27.63590000, -44.73400000
    >
  }
  #local F[ 308] = prism{ // fv.8.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, +0.000000 >,
    < +18.717697, -5.760625 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901686, -0.58778544, +0.00000000,
      +0.53731637, -0.73955218, -0.40540559,
      +0.23829150, -0.32797995, +0.91413692,
      +25.49510000, -18.52328000, -39.46800000
    >
  }
  #local F[ 309] = prism{ // fv.8.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476529, +0.000000 >,
    < +20.235352, -5.760615 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901686, +0.58778544, +0.00000000,
      +0.53731531, -0.73955071, -0.40540968,
      -0.23829391, +0.32798326, -0.91413511,
      +9.73826000, -29.97130000, -39.46800000
    >
  }
  #local F[ 310] = prism{ // fv.8.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235354, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      +0.53731534, -0.73955251, -0.40540636,
      +0.23829158, -0.32798085, +0.91413658,
      +27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[ 311] = prism{ // fv.8.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < -0.464706, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778453, +0.00000000,
      +0.56958067, -0.78396202, -0.24694415,
      -0.14514995, +0.19978215, -0.96902971,
      +10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[ 312] = prism{ // fv.8.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, +0.000000 >,
    < +4.056991, -21.853334 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, -0.15213111, +0.96592604,
      +0.56958133, -0.78396209, -0.24694239,
      +0.79481702, +0.60188002, -0.07750062,
      +27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[ 313] = prism{ // fv.8.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923563, -0.000000 >,
    < -0.464723, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901722, +0.58778494, +0.00000000,
      +0.56958136, -0.78396213, -0.24694221,
      -0.14514891, +0.19978050, -0.96903021,
      +10.96180000, -33.73692000, -28.58962000
    >
  }
  #local F[ 314] = prism{ // fv.8.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810384, +0.000000 >,
    < +3.982548, -22.779799 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20939064, -0.15212764, +0.96592585,
      +0.56958155, -0.78396216, -0.24694169,
      +0.79481597, +0.60188082, -0.07750524,
      +28.69834000, -20.85058000, -28.58962000
    >
  }
  #local F[ 315] = prism{ // fv.8.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < -0.464707, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, +0.58778505, +0.00000000,
      +0.56958119, -0.78396166, -0.24694410,
      -0.14515005, +0.19978201, -0.96902973,
      +11.42650000, -35.16716000, -22.97722000
    >
  }
  #local F[ 316] = prism{ // fv.8.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810383, -0.000000 >,
    < +3.908327, -23.706238 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.20938724, -0.15213111, +0.96592604,
      +0.56958178, -0.78396175, -0.24694244,
      +0.79481669, +0.60188047, -0.07750047,
      +29.91498000, -21.73450000, -22.97722000
    >
  }
  #local F[ 317] = prism{ // fv.8.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.938915, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      +0.58576116, -0.80623074, -0.08292083,
      -0.04873965, +0.06708435, -0.99655614,
      +11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[ 318] = prism{ // fv.8.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +23.938915, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901718, -0.58778500, +0.00000000,
      +0.58576085, -0.80623118, -0.08291875,
      +0.04873839, -0.06708269, +0.99655631,
      +31.54130000, -22.91610000, -11.57654000
    >
  }
  #local F[ 319] = prism{ // fv.8.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +24.251887, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, +0.58778500, +0.00000000,
      +0.58576083, -0.80623115, -0.08291909,
      -0.04873860, +0.06708297, -0.99655628,
      +12.04770000, -37.07902000, -11.57654000
    >
  }
  #local F[ 320] = prism{ // fv.8.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.251887, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901691, -0.58778537, +0.00000000,
      +0.58576111, -0.80623075, -0.08292103,
      +0.04873977, -0.06708451, +0.99655612,
      +31.95098000, -23.21376000, -5.78828000
    >
  }
  #local F[ 321] = prism{ // fv.8.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, +0.000000 >,
    < +24.564859, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, +0.58778537, +0.00000000,
      +0.58576112, -0.80623076, -0.08292083,
      -0.04873965, +0.06708435, -0.99655614,
      +12.20420000, -37.56064000, -5.78828000
    >
  }
  #local F[ 322] = prism{ // fv.8.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, -0.000000 >,
    < +24.564859, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, -0.58778497, +0.00000000,
      +0.58576082, -0.80623119, -0.08291875,
      +0.04873839, -0.06708269, +0.99655631,
      +32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[ 323] = prism{ // fv.8.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721353, +0.000000 >,
    < +0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901720, +0.58778497, +0.00000000,
      +0.58576082, -0.80623119, +0.08291875,
      +0.04873839, -0.06708269, -0.99655631,
      +12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[ 324] = prism{ // fv.8.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, +0.000000 >,
    < +6.467793, -24.399510 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, +0.05122891, +0.99619462,
      +0.58576112, -0.80623076, +0.08292083,
      +0.80741069, +0.58937896, +0.02684072,
      +32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[ 325] = prism{ // fv.8.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408365, -0.000000 >,
    < +0.156478, -5.808263 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901691, +0.58778537, +0.00000000,
      +0.58576111, -0.80623075, +0.08292103,
      +0.04873977, -0.06708451, -0.99655612,
      +12.20420000, -37.56064000, +5.78828000
    >
  }
  #local F[ 326] = prism{ // fv.8.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810369, +0.000000 >,
    < +6.459279, -24.086670 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07050843, +0.05122910, +0.99619483,
      +0.58576083, -0.80623115, +0.08291909,
      +0.80741118, +0.58937841, +0.02683809,
      +31.95098000, -23.21376000, +5.78828000
    >
  }
  #local F[ 327] = prism{ // fv.8.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095409, +0.000000 >,
    < +0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901718, +0.58778500, +0.00000000,
      +0.58576085, -0.80623118, +0.08291875,
      +0.04873839, -0.06708269, -0.99655631,
      +12.04770000, -37.07902000, +11.57654000
    >
  }
  #local F[ 328] = prism{ // fv.8.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810391, -0.000000 >,
    < +6.450934, -23.773793 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.07051161, +0.05122891, +0.99619462,
      +0.58576116, -0.80623074, +0.08292083,
      +0.80741066, +0.58937899, +0.02684072,
      +31.54130000, -22.91610000, +11.57654000
    >
  }
  #local F[ 329] = prism{ // fv.8.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317722, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      +0.56958178, -0.78396175, +0.24694244,
      +0.14514916, -0.19978060, -0.96903015,
      +11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[ 330] = prism{ // fv.8.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, +0.000000 >,
    < +23.317721, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901714, -0.58778505, +0.00000000,
      +0.56958119, -0.78396166, +0.24694410,
      -0.14515005, +0.19978201, +0.96902973,
      +29.91498000, -21.73450000, +22.97722000
    >
  }
  #local F[ 331] = prism{ // fv.8.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853014, -0.000000 >,
    < +22.388298, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901714, +0.58778505, +0.00000000,
      +0.56958116, -0.78396161, +0.24694431,
      +0.14515017, -0.19978218, -0.96902967,
      +11.42650000, -35.16716000, +22.97722000
    >
  }
  #local F[ 332] = prism{ // fv.8.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, -0.000000 >,
    < +22.388299, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901679, -0.58778553, +0.00000000,
      +0.56958195, -0.78396172, +0.24694215,
      -0.14514903, +0.19978035, +0.96903022,
      +28.69834000, -20.85056000, +28.58962000
    >
  }
  #local F[ 333] = prism{ // fv.8.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923575, +0.000000 >,
    < +21.458864, -5.791766 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901679, +0.58778553, +0.00000000,
      +0.56958229, -0.78396220, +0.24693983,
      +0.14514766, -0.19977847, -0.96903082,
      +10.96180000, -33.73692000, +28.58962000
    >
  }
  #local F[ 334] = prism{ // fv.8.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458862, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      +0.56958067, -0.78396202, +0.24694415,
      -0.14514995, +0.19978215, +0.96902971,
      +27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[ 335] = prism{ // fv.8.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +0.758802, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778453, +0.00000000,
      +0.53731567, -0.73955297, +0.40540507,
      +0.23829083, -0.32797980, -0.91413715,
      +10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[ 336] = prism{ // fv.8.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810389, +0.000000 >,
    < +8.353930, -19.309744 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190480, +0.24841021, +0.90630761,
      +0.53731566, -0.73955213, +0.40540662,
      +0.77096886, +0.62558374, +0.11938173,
      +27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[ 337] = prism{ // fv.8.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476545, +0.000000 >,
    < +0.758831, -5.760607 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901721, +0.58778495, +0.00000000,
      +0.53731557, -0.73955202, +0.40540694,
      +0.23829210, -0.32798119, -0.91413632,
      +9.73826000, -29.97130000, +39.46802000
    >
  }
  #local F[ 338] = prism{ // fv.8.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810366, +0.000000 >,
    < +8.155759, -17.805084 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190616, +0.24840775, +0.90630777,
      +0.53731556, -0.73955282, +0.40540550,
      +0.77096833, +0.62558390, +0.11938432,
      +25.49512000, -18.52328000, +39.46802000
    >
  }
  #local F[ 339] = prism{ // fv.8.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958894, +0.000000 >,
    < +0.758802, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778452, +0.00000000,
      +0.53731567, -0.73955297, +0.40540507,
      +0.23829083, -0.32797981, -0.91413715,
      +8.97946000, -27.63590000, +44.73400000
    >
  }
  #local F[ 340] = prism{ // fv.8.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810396, +0.000000 >,
    < +7.957583, -16.300455 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.34190784, +0.24840991, +0.90630654,
      +0.53731579, -0.73955105, +0.40540841,
      +0.77096742, +0.62558513, +0.11938374,
      +23.50852000, -17.07994000, +44.73400000
    >
  }
  #local F[ 341] = prism{ // fh.8.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521912, -15.636577 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901692, -0.58778536, -0.00000000,
      -0.00000000, +0.00000000, -1.00000000,
      +0.58778536, +0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 342] = prism{ // fh.8.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220646, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, +0.58778561, +0.00000000,
      -0.00000000, +0.00000000, +1.00000000,
      +0.58778561, -0.80901674, +0.00000000,
      +8.22064000, -25.30052000, +50.00000000
    >
  }
  #local F[ 343] = prism{ // fv.9.0.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < -0.758823, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, +0.95105639, +0.00000000,
      +0.86939561, -0.28248416, -0.40540594,
      -0.38556390, +0.12527748, -0.91413677,
      +21.52190000, -15.63658000, -50.00000000
    >
  }
  #local F[ 344] = prism{ // fv.9.0.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +3.465016, -17.805108 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42261881, +0.00000000, +0.90630753,
      +0.86939538, -0.28248425, -0.40540636,
      +0.25601760, +0.95927194, -0.11938316,
      +26.60254000, +0.00000000, -50.00000000
    >
  }
  #local F[ 345] = prism{ // fv.9.0.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958915, +0.000000 >,
    < -0.758803, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901755, +0.95105633, +0.00000000,
      +0.86939593, -0.28248443, -0.40540506,
      -0.38556305, +0.12527728, -0.91413716,
      +23.50850000, -17.07994000, -44.73400000
    >
  }
  #local F[ 346] = prism{ // fv.9.0.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810381, -0.000000 >,
    < +3.266833, -19.309727 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42261598, +0.00000000, +0.90630885,
      +0.86939667, -0.28248417, -0.40540366,
      +0.25601790, +0.95927196, -0.11938233,
      +29.05812000, +0.00000000, -44.73400000
    >
  }
  #local F[ 347] = prism{ // fv.9.0.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476530, +0.000000 >,
    < -0.758817, -5.760615 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901706, +0.95105649, +0.00000000,
      +0.86939402, -0.28248331, -0.40540994,
      -0.38556776, +0.12527859, -0.91413499,
      +25.49510000, -18.52328000, -39.46800000
    >
  }
  #local F[ 348] = prism{ // fv.9.0.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810372, +0.000000 >,
    < +3.068607, -20.814361 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.42262013, +0.00000000, +0.90630692,
      +0.86939513, -0.28248297, -0.40540779,
      +0.25601627, +0.95927231, -0.11938299,
      +31.51368000, +0.00000000, -39.46800000
    >
  }
  #local F[ 349] = prism{ // fv.9.1.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +21.458874, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      +0.92160251, -0.29944613, -0.24694297,
      -0.23485677, +0.07630942, -0.96903002,
      +27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[ 350] = prism{ // fv.9.1.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, +0.000000 >,
    < +21.458875, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901682, -0.95105657, +0.00000000,
      +0.92160277, -0.29944671, -0.24694129,
      +0.23485514, -0.07630901, +0.96903044,
      +35.47310000, +0.00000000, -28.58962000
    >
  }
  #local F[ 351] = prism{ // fv.9.1.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923596, +0.000000 >,
    < +22.388308, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901682, +0.95105657, +0.00000000,
      +0.92160237, -0.29944658, -0.24694293,
      -0.23485670, +0.07630952, -0.96903002,
      +28.69834000, -20.85058000, -28.58962000
    >
  }
  #local F[ 352] = prism{ // fv.9.1.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +22.388308, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901671, -0.95105661, +0.00000000,
      +0.92160230, -0.29944644, -0.24694336,
      +0.23485712, -0.07630963, +0.96902991,
      +36.97694000, +0.00000000, -22.97722000
    >
  }
  #local F[ 353] = prism{ // fv.9.1.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, -0.000000 >,
    < +23.317715, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, +0.95105661, +0.00000000,
      +0.92160241, -0.29944647, -0.24694294,
      -0.23485672, +0.07630950, -0.96903002,
      +29.91498000, -21.73450000, -22.97722000
    >
  }
  #local F[ 354] = prism{ // fv.9.1.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317716, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      +0.92160267, -0.29944700, -0.24694131,
      +0.23485513, -0.07630909, +0.96903044,
      +38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[ 355] = prism{ // fv.9.2.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < -0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, +0.95105647, +0.00000000,
      +0.94778114, -0.30795290, -0.08292121,
      -0.07886276, +0.02562407, -0.99655611,
      +31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[ 356] = prism{ // fv.9.2.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +5.161450, -24.086669 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715423, +0.00000000, +0.99619483,
      +0.94778153, -0.30795238, -0.08291868,
      +0.30678057, +0.95140177, -0.02683935,
      +38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[ 357] = prism{ // fv.9.2.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < -0.156494, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, +0.95105667, +0.00000000,
      +0.94778156, -0.30795239, -0.08291823,
      -0.07885993, +0.02562310, -0.99655635,
      +31.54130000, -22.91610000, -11.57654000
    >
  }
  #local F[ 358] = prism{ // fv.9.2.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810371, +0.000000 >,
    < +5.152972, -24.399541 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715794, +0.00000000, +0.99619451,
      +0.94778095, -0.30795320, -0.08292220,
      +0.30678128, +0.95140151, -0.02684057,
      +38.98718000, +0.00000000, -11.57654000
    >
  }
  #local F[ 359] = prism{ // fv.9.2.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < -0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, +0.95105637, +0.00000000,
      +0.94778103, -0.30795322, -0.08292122,
      -0.07886276, +0.02562410, -0.99655611,
      +31.95098000, -23.21376000, -5.78828000
    >
  }
  #local F[ 360] = prism{ // fv.9.2.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810390, +0.000000 >,
    < +5.144590, -24.712402 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.08715423, +0.00000000, +0.99619483,
      +0.94778142, -0.30795271, -0.08291868,
      +0.30678090, +0.95140166, -0.02683938,
      +39.49360000, +0.00000000, -5.78828000
    >
  }
  #local F[ 361] = prism{ // fv.9.3.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564883, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, +0.95105656, +0.00000000,
      +0.94778142, -0.30795271, +0.08291868,
      +0.07886035, -0.02562327, -0.99655632,
      +32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[ 362] = prism{ // fv.9.3.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.564882, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901744, -0.95105637, +0.00000000,
      +0.94778103, -0.30795322, +0.08292122,
      -0.07886276, +0.02562410, +0.99655611,
      +39.49360000, +0.00000000, +5.78828000
    >
  }
  #local F[ 363] = prism{ // fv.9.3.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.408395, +0.000000 >,
    < +24.251903, -5.808264 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901744, +0.95105637, +0.00000000,
      +0.94778095, -0.30795320, +0.08292220,
      +0.07886368, -0.02562441, -0.99655602,
      +31.95098000, -23.21376000, +5.78828000
    >
  }
  #local F[ 364] = prism{ // fv.9.3.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, +0.000000 >,
    < +24.251903, -5.808262 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901653, -0.95105667, +0.00000000,
      +0.94778156, -0.30795239, +0.08291823,
      -0.07885993, +0.02562310, +0.99655635,
      +38.98718000, +0.00000000, +11.57654000
    >
  }
  #local F[ 365] = prism{ // fv.9.3.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +24.095410, -0.000000 >,
    < +23.938924, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901653, +0.95105667, +0.00000000,
      +0.94778153, -0.30795238, +0.08291868,
      +0.07886037, -0.02562324, -0.99655632,
      +31.54130000, -22.91610000, +11.57654000
    >
  }
  #local F[ 366] = prism{ // fv.9.3.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      +0.94778114, -0.30795290, +0.08292121,
      -0.07886276, +0.02562407, +0.99655611,
      +38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[ 367] = prism{ // fv.9.4.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +0.464720, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, +0.95105647, +0.00000000,
      +0.92160267, -0.29944700, +0.24694131,
      +0.23485513, -0.07630909, -0.96903044,
      +31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[ 368] = prism{ // fv.9.4.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, +0.000000 >,
    < +7.638156, -22.779794 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      +0.92160241, -0.29944647, +0.24694294,
      +0.28924305, +0.95411310, +0.07750254,
      +38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[ 369] = prism{ // fv.9.4.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +22.853004, +0.000000 >,
    < +0.464715, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901671, +0.95105661, +0.00000000,
      +0.92160206, -0.29944636, +0.24694436,
      +0.23485807, -0.07630994, -0.96902966,
      +29.91498000, -21.73450000, +22.97722000
    >
  }
  #local F[ 370] = prism{ // fv.9.4.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, +0.000000 >,
    < +7.563824, -21.853345 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      +0.92160229, -0.29944684, +0.24694291,
      +0.28924341, +0.95411299, +0.07750264,
      +36.97694000, +0.00000000, +22.97722000
    >
  }
  #local F[ 371] = prism{ // fv.9.4.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +21.923577, +0.000000 >,
    < +0.464701, -5.791767 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, +0.95105648, +0.00000000,
      +0.92160292, -0.29944705, +0.24694031,
      +0.23485418, -0.07630878, -0.96903069,
      +28.69834000, -20.85056000, +28.58962000
    >
  }
  #local F[ 372] = prism{ // fv.9.4.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +5.810385, +0.000000 >,
    < +7.489485, -20.926909 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.25881936, +0.00000000, +0.96592574,
      +0.92160251, -0.29944613, +0.24694297,
      +0.28924273, +0.95411321, +0.07750246,
      +35.47310000, +0.00000000, +28.58962000
    >
  }
  #local F[ 373] = prism{ // fv.9.5.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +20.235349, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      +0.86939568, -0.28248314, +0.40540650,
      +0.38556458, -0.12527724, -0.91413652,
      +27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[ 374] = prism{ // fv.9.5.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, -0.000000 >,
    < +20.235349, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901613, -0.95105680, +0.00000000,
      +0.86939605, -0.28248303, +0.40540579,
      -0.38556393, +0.12527693, +0.91413683,
      +31.51368000, +0.00000000, +39.46802000
    >
  }
  #local F[ 375] = prism{ // fv.9.5.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +19.476523, -0.000000 >,
    < +18.717716, -5.760602 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901613, +0.95105680, +0.00000000,
      +0.86939635, -0.28248313, +0.40540506,
      +0.38556323, -0.12527670, -0.91413716,
      +25.49512000, -18.52328000, +39.46802000
    >
  }
  #local F[ 376] = prism{ // fv.9.5.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, -0.000000 >,
    < +18.717715, -5.760605 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901655, -0.95105666, +0.00000000,
      +0.86939574, -0.28248335, +0.40540623,
      -0.38556429, +0.12527723, +0.91413664,
      +29.05812000, +0.00000000, +44.73400000
    >
  }
  #local F[ 377] = prism{ // fv.9.5.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +17.958909, +0.000000 >,
    < +17.200094, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901655, +0.95105666, +0.00000000,
      +0.86939563, -0.28248331, +0.40540648,
      +0.38556453, -0.12527731, -0.91413652,
      +23.50852000, -17.07994000, +44.73400000
    >
  }
  #local F[ 378] = prism{ // fv.9.5.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +17.200092, -5.760634 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, -0.95105639, +0.00000000,
      +0.86939445, -0.28248378, +0.40540869,
      -0.38556653, +0.12527834, +0.91413554,
      +26.60254000, +0.00000000, +50.00000000
    >
  }
  #local F[ 379] = prism{ // fh.9.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602540, +0.000000 >,
    < +21.521900, -15.636580 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, -0.00000000,
      -0.00000000, +0.00000000, -1.00000000,
      +0.00000000, +1.00000000, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[ 380] = prism{ // fh.9.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +8.220628, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, +0.95105639, +0.00000000,
      -0.00000000, +0.00000000, +1.00000000,
      +0.95105639, -0.30901739, +0.00000000,
      +21.52190000, -15.63658000, +50.00000000
    >
  }
  F
#end

