// Last edited on 2024-05-30 09:08:49 by stolfi
// Figure for topological slicing paper

#version 3.7;

global_settings{ max_trace_level 6 assumed_gamma 1.2 }
background{ color rgb < 1.000, 1.000, 1.000 > }

// ----------------------------------------------------------------------
// THING TO SHOW

#local view = 0;
#local show_axes = 0;
#local show_ground = 0;

// Read the parameters {N08d} (num sides as "%08d"), {subfig}:
#include "params.inc"

// The {subfig} specifies the sub-figure:
//
//   0 = nut with no highlighted edges and slicing plane.
//   1 = first outer quine as {e}, outer poly vertex.
//   2 = second outer quine as {e}, walked edges, outer poly vt+edge.
//   3 = third outer quine as {e}, walked edges, outer poly vts+edges.
//   4 = back to first outer quine as {e}, walked edges, full outer poly.
//   5 = first inner quine as {e}, walked edges, full outer poly, inner poly vt.
//   6 = second inner quine as {e}, walked edges, full outer poly, inner poly vts+ed.
//   7 = back to first inner quine as {e}, walked edges, full outer and inner polys.
//   8 = full outer and inner polys only, no nut.

#include "nut_textures.inc"

// To avoid stupid POV-Ray CSG warning:
#declare nothing = sphere{ <0,0,0>,0.001 texture{ nut_tx_invisible } }

// Read the elements of the nut:
#declare macname = concat( "out/nut_", N08d, ".inc" )
#include macname
#local Ro = nut_outer_radius;      #debug concat("!! Ro = ", str(Ro,0,4), "\n")
#local Ri = nut_hole_radius;       #debug concat("!! Ri = ", str(Ri,0,4), "\n")
#local Ha = nut_height;            #debug concat("!! Ha = ", str(Ha,0,4), "\n")
#local Nv = nut_num_vertices;      #debug concat("!! Nv = ", str(Nv,0,0), "\n")
#local Ne = nut_num_edges;         #debug concat("!! Ne = ", str(Ne,0,0), "\n")
#local Nf = nut_num_faces;         #debug concat("!! Nf = ", str(Nf,0,0), "\n")
#local Nr = nut_num_hole_sides;    #debug concat("!! Nr = ", str(Nr,0,0), "\n")

#local V = nut_vertices() 
#local E = nut_edges()    
#local F = nut_faces()    

#include "eixos.inc"
#include "misc_arrows.inc"

#include "nut_skeleton.inc"
#include "nut_solid.inc"
#include "nut_plane.inc"
#include "nut_slicepoly.inc"

#debug concat("!! Nr = ", str(Nr,0,0), "\n")

#local kr_start_o = 1;              // Rotation index of initial outer quine.
#local kr_start_i = int(3*Nr/4)+1;  // Rotation index of initial inner quine.

#local skel = nut_skeleton(V, E, Nr, kr_start_o, kr_start_i, subfig) 
#local surf = nut_solid(F, Nr, Ro, Ri, Ha, subfig)
#local spol = nut_slicepoly(V, E, Nr, kr_start_o, kr_start_i, subfig)
#local spla = nut_plane(Ro, subfig)

#local thing = 
  union{
    object{ nothing }
    object{ skel }
    object{ surf }
    object{ spol }
    rotate -50*z // To get face {kr=0) at left.
  }

// Leave the slicing plane out of the {thing} or it will mess its bounding box:
object{ spla rotate 90*z } // 133

// ----------------------------------------------------------------------

#include "nut_view.inc"
nut_view(thing, show_axes, show_ground, view)

#include "camlight.inc"
#declare intens_luz = 1.50;
camlight(centro_cena, raio_cena, dir_camera, dist_camera , z, intens_luz)
