#include <QString>
#include <er_TEST_test.h>

#include <iostream>
using namespace std;

#define DEBUG TRUE


int executeTest()
{
    int exemplo = 5;
    int m, n, p, r;
    fmpz_mat_t U, L, D;

    //===============================================================
    if(exemplo == 0){
        m = 3; n = 3; p = 2;

        // matriz A
        double A[m*n];
        A[0] = 16;    A[1] = 0;     A[2] = 16;
        A[3] = 0;     A[4] = 64;    A[5] = -64;
        A[6] = 6;     A[7] = 7;     A[8] = 64;

        // matriz B
        double B[m*p];
        B[0] = 10;   B[1] = 11;
        B[2] = 13;   B[3] = 30;
        B[4] = 3;    B[5] = 0;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//           testSolveDirect(m, n, A, p, B);
//           testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
             testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
//           testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //===============================================================
    else if(exemplo == 1){
        m = 3; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 4;    A[1] = 1;  A[2] = 3;
        A[3] = 3;    A[4] = 4;  A[5] = 7;
        A[6] = 8;    A[7] = 1;  A[8] = 9;

        // matriz B
        double B[m*p];
        B[0] = 3;
        B[1] = 6;
        B[2] = 9;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 2){
        m = 3; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 2;    A[1] = 4;    A[2] = 6;
        A[3] = 3;    A[4] = 14;   A[5] = 6;
        A[6] = 6;    A[7] = 6;    A[8] = 28;

        // matriz B
        double B[m*p];
        B[0] = 6;
        B[1] = 6;
        B[2] = 2;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 3){
        // matriz A
        m = 3; n = 4; p = 1;
        double A[m*n];
        A[0] = -5;    A[1] = 3;     A[2] = 0;     A[3] = -1;
        A[4] = 1;     A[5] = 3;     A[6] = 0;     A[7] = 1;
        A[8] = -2;    A[9] = 0;     A[10] = 3;    A[11] = 5;

        // matriz B
        double B[m*p];
        B[0] = 6;
        B[1] = 15;
        B[2] = 10;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }

    }

    //================================================================
     else if(exemplo == 4){
        m = 4; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 8;     A[1] = 7;     A[2] = 4;
        A[3] = 4;     A[4] = 6;     A[5] = 7;
        A[6] = 6;     A[7] = 3;     A[8] = 4;
        A[9] = 4;     A[10] = 5;     A[11] = 8;


        // matriz B
        double B[m*p];
        B[0] = 4;
        B[1] = 1;
        B[2] = 8;
        B[3] = 4;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 5){
        m = 5; n = 4; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 5;     A[1] = 10;    A[2] = 15;     A[3] = 20;
        A[4] = -1;    A[5] = -6;    A[6] = -19;    A[7] = -16;
        A[8] = 1;     A[9] = 5;     A[10] = 15;    A[11] = 19;
        A[12] = 5;    A[13] = 6;    A[14] = -1;    A[15] = -12;
        A[16] = 4;    A[17] = 9;    A[18] = 16;    A[19] = 29;


        // matriz B
        double B[m*p];
        B[0] = 50;
        B[1] = 42;
        B[2] = 40;
        B[3] = -128;
        B[4] = 142;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//              testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 6){
        m = 4; n = 4; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 1;     A[1] = 2;    A[2] = 3;     A[3] = 4;
        A[4] = 2;     A[5] = 2;    A[6] = 3;     A[7] = 4;
        A[8] = 3;     A[9] = 3;    A[10] = 3;     A[11] = 4;
        A[12] = 9;     A[13] = 8;    A[14] = 7;     A[15] = 6;


        // matriz B
        double B[m*p];
        B[0] = 10;
        B[1] = 11;
        B[2] = 13;
        B[3] = 30;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 7){
        m = 2; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 1;      A[1] = -3;      A[2] = 4;
        A[3] = 2;      A[4] = -6;     A[5] = 8;

        // matriz B
        double B[m*p];
        B[0] = 2;
        B[1] = 4;;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }

    }

    //================================================================
    else if(exemplo == 8){
        m = 5; n = 3; p = 2;

        // matriz A
        double A[m*n];
        A[0] = 68;      A[1] = 25;      A[2] = 11;
        A[3] = 66;      A[4] = -36;     A[5] = -32;
        A[6] = -5;      A[7] = 85;      A[8] = 58;
        A[9] = 134;     A[10] = -11;    A[11] = -21;
        A[12] = -73;    A[13] = 60;     A[14] = 47;

        // matriz B
        double B[m*p];
        B[0] = 26;      B[1] = 55;
        B[2] = -51;     B[3] = 17;
        B[4] = -22;     B[5] = -25;
        B[6] = -25;     B[7] = 72;
        B[8] = -48;     B[9] = -80;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 9){
        m = 2; n = 4; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 6;      A[1] = 8;      A[2] = 7;     A[3] = 3;
        A[4] = 3;      A[5] = 5;      A[6] = 4;     A[7] = 1;

        // matriz B
        double B[m*p];
        B[0] = 7;
        B[1] = 8;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 10){
        m = 2; n = 2; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 96;      A[1] = 172;
        A[2] = 228;     A[3] = 96;

        // matriz B
        double B[m*p];
        B[0] = 100;
        B[1] = 200;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 11){
        m = 2; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 96;      A[1] = 172;     A[2] = 76;
        A[3] = 228;      A[4] = 96;     A[5] = -132;

        // matriz B
        double B[m*p];
        B[0] = 100;
        B[1] = 200;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 12){
        m = 3; n = 2; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 96;      A[1] = 172;
        A[2] = 228;     A[3] = 96;
        A[4] = 132;     A[5] = -76;

        // matriz B
        double B[m*p];
        B[0] = 100;
        B[1] = 200;
        B[2] = 100;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }


    //================================================================
    else if(exemplo == 13){
        m = 3; n = 3; p = 1;

        // matriz A
        double A[m*n];
        A[0] = 96;      A[1] = 172;     A[2] = 76;
        A[3] = 228;     A[4] = 96;      A[5] = -132;
        A[6] = 132;     A[7] = -76;     A[8] = -208;

        // matriz B
        double B[m*p];
        B[0] = 100;
        B[1] = 200;
        B[2] = 100;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }


    //================================================================
    else if(exemplo == 14){
        m = 12; n = 12; p = 2;

        // matriz A
        double A[m*n];
        A[0]=1;    A[1]=0;      A[2]=0;     A[3]=0;     A[4]=0;       A[5]=0;       A[6]=-1;   A[7]=-1;  A[8]=0;     A[9]=0;      A[10]=0;     A[11]=0;
        A[12]=1;   A[13]=-1;  A[14]=-1; A[15]=0;    A[16]=0;      A[17]=0;      A[18]=0;     A[19]=0;    A[20]=0;    A[21]=0;     A[22]=0;     A[23]=0;
        A[24]=-1;  A[25]=0;     A[26]=1;  A[27]=-1; A[28]=0;      A[29]=0;      A[30]=0;     A[31]=0;    A[32]=0;    A[33]=0;     A[34]=0;     A[35]=0;
        A[36]=0;     A[37]=0;     A[38]=1;  A[39]=0;   A[40]=0;      A[41]=0;      A[42]=0;     A[43]=-1; A[44]=-1; A[45]=0;     A[46]=0;     A[47]=0;
        A[48]=0;     A[49]=0;     A[50]=0;    A[51]=1;  A[52]=0;      A[53]=0;      A[54]=0;     A[55]=0;    A[56]=-1; A[57]=-1;  A[58]=0;     A[59]=0;
        A[60]=0;     A[61]=0;     A[62]=-1; A[63]=1;  A[64]=-1;   A[65]=0;      A[66]=0;     A[67]=0;    A[68]=0;    A[69]=0;     A[70]=0;     A[71]=0;
        A[72]=0;     A[73]=0;     A[74]=0;    A[75]=-1; A[76]=1;    A[77]=-1;   A[78]=0;     A[79]=0;    A[80]=0;    A[81]=0;     A[82]=0;     A[83]=0;
        A[84]=0;     A[85]=0;     A[86]=0;    A[87]=0;    A[88]=1;    A[89]=0;      A[90]=0;     A[91]=0;    A[92]=0;    A[93]=-1;  A[94]=-1;  A[95]=0;
        A[96]=0;     A[97]=0;     A[98]=0;    A[99]=-0;   A[100]=0;     A[101]=1;   A[102]=0;    A[103]=0;   A[104]=0;   A[105]=0;    A[106]=-1; A[107]=-1;
        A[108]=0;    A[109]=-1; A[110]=0;   A[111]=0;   A[112]=-1;  A[113]=1;   A[114]=0;    A[115]=0;   A[116]=0;   A[117]=0;    A[118]=0;    A[119]=0;
        A[120]=-1; A[121]=1;  A[122]=0;   A[123]=0;   A[124]=0;     A[125]=-1;  A[126]=0;    A[127]=0;   A[128]=0;   A[129]=0;    A[130]=0;    A[131]=0;
        A[132]=0;    A[133]=1;    A[134]=0;   A[135]=0;   A[136]=0;     A[137]=0;     A[138]=-1; A[139]=0;   A[140]=0;   A[141]=0;    A[142]=0;    A[143]=-1;

        // matriz B
        double B[m*p];
        B[0]=32;    B[1]=56;
        B[2]=-3;    B[3]=-1;
        B[4]=-3;     B[5]=-1;
        B[6]=-32;     B[7]=56;
        B[8]=-64;     B[9]=0;
        B[10]=-3;   B[11]=-1;
        B[12]=-3;   B[13]=-1;
        B[14]=-32;     B[15]=-56;
        B[16]=32;    B[17]=-56;
        B[18]=-3;    B[19]=-1;
        B[20]=-3;     B[21]=-1;
        B[22]=64;   B[23]=0;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
            //testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }


    //================================================================
    else if(exemplo == 15){
        m = 2; n = 5; p = 2;

        // matriz A
        double A[m*n];
        A[0]=-1;    A[1]=1;      A[2]=-1;     A[3]=0;     A[4]=0;
        A[5]=0;      A[6]=1;   A[7]=0;  A[8]=-1;     A[9]=-1;

       // matriz B
        double B[m*p];
        B[0]=-165;    B[1]=4;
        B[2]=-96;    B[3]=0;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }//================================================================
    else if(exemplo == 16){
        m = 6; n = 8; p = 2;

        // matriz A
        double A[m*n];
        A[0]=2;   A[1]=0;   A[2]=0;   A[3]=-2;  A[4]=0;    A[5]=0;    A[6]=0;   A[7]=0;
        A[8]=2;   A[9]=0;   A[10]=0;  A[11]=0;  A[12]=-2;  A[13]=0;   A[14]=0;  A[15]=0;
        A[16]=0;  A[17]=0;  A[18]=0;  A[19]=0;  A[20]=-2;  A[21]=0;   A[22]=-2; A[23]=0;
        A[24]=0;  A[25]=0;  A[26]=-2; A[27]=0;  A[28]=0;   A[29]=0;   A[30]=0;  A[31]=-2;
        A[32]=0;  A[33]=2;  A[34]=0;  A[35]=0;  A[36]=0;   A[37]=-2;  A[38]=0;  A[39]=0;
        A[40]=0;  A[41]=2;  A[42]=0;  A[43]=0;  A[44]=0;   A[45]=0;   A[46]=-2; A[47]=0;

        // matriz B
        double B[m*p];
        B[0]=-16;     B[1]=28;
        B[2]=-32;     B[3]=0;
        B[4]=-48;     B[5]=80;
        B[6]=-80;     B[7]=136;
        B[8]=-16;     B[9]=28;
        B[10]=16;    B[11]=28;


        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testInverse(r, m, n, U, L, D, Pr, Pc, A);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 17){
        m = 18; n = 29; p = 2;

        // matriz A
        double A[m*n];
        A[0]=1; A[1]=0; A[2]=0; A[3]=0; A[4]=0; A[5]=0; A[6]=0; A[7]=0; A[8]=0; A[9]=0; A[10]=0; A[11]=0; A[12]=0; A[13]=-1; A[14]=0; A[15]=0; A[16]=-1; A[17]=0; A[18]=0; A[19]=0; A[20]=0; A[21]=0; A[22]=0; A[23]=0; A[24]=0; A[25]=0; A[26]=0; A[27]=0; A[28]=0;
        A[29]=1; A[30]=1; A[31]=0; A[32]=0; A[33]=0; A[34]=0; A[35]=0; A[36]=0; A[37]=0; A[38]=0; A[39]=0; A[40]=0; A[41]=0; A[42]=0; A[43]=-1; A[44]=0; A[45]=0; A[46]=-1; A[47]=0; A[48]=0; A[49]=0; A[50]=0; A[51]=0; A[52]=0; A[53]=0; A[54]=0; A[55]=0; A[56]=0; A[57]=0;
        A[58]=0; A[59]=1; A[60]=-1; A[61]=0; A[62]=-1; A[63]=0; A[64]=0; A[65]=0; A[66]=0; A[67]=0; A[68]=0; A[69]=0; A[70]=0; A[71]=0; A[72]=0; A[73]=0; A[74]=0; A[75]=0; A[76]=0; A[77]=0; A[78]=0; A[79]=0; A[80]=0; A[81]=0; A[82]=0; A[83]=0; A[84]=0; A[85]=0; A[86]=0;
        A[87]=0; A[88]=-1; A[89]=0; A[90]=0; A[91]=1; A[92]=0; A[93]=0; A[94]=-1; A[95]=0; A[96]=0; A[97]=0; A[98]=0; A[99]=0; A[100]=0; A[101]=0; A[102]=0; A[103]=0; A[104]=0; A[105]=0; A[106]=0; A[107]=0; A[108]=0; A[109]=0; A[110]=0; A[111]=0; A[112]=0; A[113]=0; A[114]=0; A[115]=0;
        A[116]=0; A[117]=0; A[118]=0; A[119]=0; A[120]=1; A[121]=1; A[122]=0; A[123]=0; A[124]=0; A[125]=0; A[126]=0; A[127]=0; A[128]=0; A[129]=0; A[130]=0; A[131]=0; A[132]=0; A[133]=-1; A[134]=0; A[135]=-1; A[136]=0; A[137]=0; A[138]=0; A[139]=0; A[140]=0; A[141]=0; A[142]=0; A[143]=0; A[144]=0;
        A[145]=0; A[146]=0; A[147]=0; A[148]=0; A[149]=0; A[150]=1; A[151]=0; A[152]=0; A[153]=0; A[154]=0; A[155]=0; A[156]=0; A[157]=0; A[158]=0; A[159]=0; A[160]=-1; A[161]=0; A[162]=0; A[163]=0; A[164]=0; A[165]=-1; A[166]=0; A[167]=0; A[168]=0; A[169]=0; A[170]=0; A[171]=0; A[172]=0; A[173]=0;
        A[174]=0; A[175]=0; A[176]=0; A[177]=0; A[178]=0; A[179]=0; A[180]=1; A[181]=0; A[182]=0; A[183]=0; A[184]=0; A[185]=0; A[186]=0; A[187]=0; A[188]=0; A[189]=0; A[190]=0; A[191]=0; A[192]=-1; A[193]=0; A[194]=0; A[195]=0; A[196]=-1; A[197]=0; A[198]=0; A[199]=0; A[200]=0; A[201]=0; A[202]=0;
        A[203]=0; A[204]=0; A[205]=0; A[206]=0; A[207]=0; A[208]=0; A[209]=1; A[210]=1; A[211]=0; A[212]=0; A[213]=0; A[214]=0; A[215]=0; A[216]=0; A[217]=0; A[218]=0; A[219]=0; A[220]=0; A[221]=0; A[222]=-1; A[223]=0; A[224]=0; A[225]=0; A[226]=-1; A[227]=0; A[228]=0; A[229]=0; A[230]=0; A[231]=0;
        A[232]=0; A[233]=0; A[234]=0; A[235]=0; A[236]=-1; A[237]=0; A[238]=0; A[239]=1; A[240]=-1; A[241]=0; A[242]=0; A[243]=0; A[244]=0; A[245]=0; A[246]=0; A[247]=0; A[248]=0; A[249]=0; A[250]=0; A[251]=0; A[252]=0; A[253]=0; A[254]=0; A[255]=0; A[256]=0; A[257]=0; A[258]=0; A[259]=0; A[260]=0;
        A[261]=0; A[262]=0; A[263]=0; A[264]=0; A[265]=0; A[266]=0; A[267]=0; A[268]=-1; A[269]=1; A[270]=0; A[271]=0; A[272]=-1; A[273]=0; A[274]=0; A[275]=0; A[276]=0; A[277]=0; A[278]=0; A[279]=0; A[280]=0; A[281]=0; A[282]=0; A[283]=0; A[284]=0; A[285]=0; A[286]=0; A[287]=0; A[288]=0; A[289]=0;
        A[290]=0; A[291]=0; A[292]=0; A[293]=0; A[294]=0; A[295]=0; A[296]=0; A[297]=0; A[298]=1; A[299]=1; A[300]=0; A[301]=0; A[302]=0; A[303]=0; A[304]=0; A[305]=0; A[306]=0; A[307]=0; A[308]=0; A[309]=0; A[310]=0; A[311]=0; A[312]=0; A[313]=-1; A[314]=0; A[315]=-1; A[316]=0; A[317]=0; A[318]=0;
        A[319]=0; A[320]=0; A[321]=0; A[322]=0; A[323]=0; A[324]=0; A[325]=0; A[326]=0; A[327]=0; A[328]=1; A[329]=0; A[330]=0; A[331]=0; A[332]=0; A[333]=0; A[334]=0; A[335]=0; A[336]=0; A[337]=0; A[338]=0; A[339]=0; A[340]=-1; A[341]=0; A[342]=0; A[343]=0; A[344]=0; A[345]=0; A[346]=0; A[347]=0;
        A[348]=0; A[349]=0; A[350]=0; A[351]=0; A[352]=0; A[353]=0; A[354]=0; A[355]=0; A[356]=0; A[357]=0; A[358]=1; A[359]=0; A[360]=0; A[361]=0; A[362]=0; A[363]=0; A[364]=0; A[365]=0; A[366]=0; A[367]=0; A[368]=0; A[369]=0; A[370]=0; A[371]=0; A[372]=-1; A[373]=0; A[374]=0; A[375]=-1; A[376]=0;
        A[377]=0; A[378]=0; A[379]=0; A[380]=0; A[381]=0; A[382]=0; A[383]=0; A[384]=0; A[385]=0; A[386]=0; A[387]=1; A[388]=1; A[389]=0; A[390]=0; A[391]=0; A[392]=0; A[393]=0; A[394]=0; A[395]=0; A[396]=0; A[397]=0; A[398]=0; A[399]=0; A[400]=0; A[401]=0; A[402]=-1; A[403]=0; A[404]=0; A[405]=-1;
        A[406]=0; A[407]=0; A[408]=-1; A[409]=0; A[410]=0; A[411]=0; A[412]=0; A[413]=0; A[414]=-1; A[415]=0; A[416]=0; A[417]=1; A[418]=0; A[419]=0; A[420]=0; A[421]=0; A[422]=0; A[423]=0; A[424]=0; A[425]=0; A[426]=0; A[427]=0; A[428]=0; A[429]=0; A[430]=0; A[431]=0; A[432]=0; A[433]=0; A[434]=0;
        A[435]=0; A[436]=-1; A[437]=1; A[438]=0; A[439]=0; A[440]=0; A[441]=0; A[442]=0; A[443]=0; A[444]=0; A[445]=0; A[446]=-1; A[447]=0; A[448]=0; A[449]=0; A[450]=0; A[451]=0; A[452]=0; A[453]=0; A[454]=0; A[455]=0; A[456]=0; A[457]=0; A[458]=0; A[459]=0; A[460]=0; A[461]=0; A[462]=0; A[463]=0;
        A[464]=0; A[465]=0; A[466]=1; A[467]=1; A[468]=0; A[469]=0; A[470]=0; A[471]=0; A[472]=0; A[473]=0; A[474]=0; A[475]=0; A[476]=0; A[477]=0; A[478]=-1; A[479]=0; A[480]=0; A[481]=0; A[482]=0; A[483]=0; A[484]=0; A[485]=0; A[486]=0; A[487]=0; A[488]=0; A[489]=0; A[490]=0; A[491]=0; A[492]=-1;
        A[493]=0; A[494]=0; A[495]=0; A[496]=1; A[497]=0; A[498]=0; A[499]=0; A[500]=0; A[501]=0; A[502]=0; A[503]=0; A[504]=0; A[505]=-1; A[506]=0; A[507]=0; A[508]=0; A[509]=0; A[510]=0; A[511]=0; A[512]=0; A[513]=0; A[514]=0; A[515]=0; A[516]=0; A[517]=0; A[518]=0; A[519]=-1; A[520]=0; A[521]=0;

        // matriz B
        double B[m*p];
        B[0]=48;     B[1]=84;
        B[2]=0;      B[3]=0;
        B[4]=-2;     B[5]=-2;
        B[6]=-2;     B[7]=-2;
        B[8]=0;      B[9]=0;
        B[10]=-48;   B[11]=84;
        B[12]=-96;   B[13]=0;
        B[14]=0;     B[15]=0;
        B[16]=-2;    B[17]=-2;
        B[18]=-2;    B[19]=-2;
        B[20]=0;     B[21]=0;
        B[22]=-32;   B[23]=0;
        B[24]=0;     B[25]=0;
        B[26]=0;     B[27]=0;
        B[28]=-2;    B[29]=-2;
        B[30]=-2;    B[31]=-2;
        B[32]=-30;     B[33]=2;
        B[34]=-32;    B[35]=0;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
            //testSolveDirect(m, n, A, p, B);
//            testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
//            testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }

    //================================================================
    else if(exemplo == 18){
        m = 10; n = 10; p = 2;

        // matriz A
        double A[m*n];
        A[0]=4608; A[1]=0; A[2]=0; A[3]=0; A[4]=0; A[5]=-3328; A[6]=-3552; A[7]=0; A[8]=0; A[9]=0;
        A[10]=2272; A[11]=-3328; A[12]=-3552; A[13]=0; A[14]=0; A[15]=0; A[16]=0; A[17]=0; A[18]=0; A[19]=0;
        A[20]=-3552; A[21]=0; A[22]=2272; A[23]=-3328; A[24]=0; A[25]=0; A[26]=0; A[27]=0; A[28]=0; A[29]=0;
        A[30]=0; A[31]=0; A[32]=4608; A[33]=0; A[34]=0; A[35]=0; A[36]=-3552; A[37]=-3328; A[38]=0; A[39]=0;
        A[40]=0; A[41]=0; A[42]=0; A[43]=4800; A[44]=0; A[45]=0; A[46]=0; A[47]=-2912; A[48]=-3552; A[49]=0;
        A[50]=0; A[51]=0; A[52]=-2912; A[53]=1664; A[54]=-3552; A[55]=0; A[56]=0; A[57]=0; A[58]=0; A[59]=0;
        A[60]=0; A[61]=-2912; A[62]=0; A[63]=-2912; A[64]=2240; A[65]=0; A[66]=0; A[67]=0; A[68]=0; A[69]=0;
        A[70]=0; A[71]=0; A[72]=0; A[73]=0; A[74]=3584; A[75]=0; A[76]=0; A[77]=0; A[78]=-2912; A[79]=-2912;
        A[80]=-2912; A[81]=1664; A[82]=0; A[83]=0; A[84]=-3552; A[85]=0; A[86]=0; A[87]=0; A[88]=0; A[89]=0;
        A[90]=0; A[91]=4800; A[92]=0; A[93]=0; A[94]=0; A[95]=-2912; A[96]=0; A[97]=0; A[98]=0; A[99]=-3552;

        // matriz B
        double B[m*p];
        B[0]=145408;     B[1]=236288;
        B[2]=0;         B[3]=0;
        B[4]=0;         B[5]=0;
        B[6]=-145408;    B[7]=236288;
        B[8]=-186368;    B[9]=-66560;
        B[10]=0;      B[11]=0;
        B[12]=0;        B[13]=0;
        B[14]=0;        B[15]=-232960;
        B[16]=0;        B[17]=0;
        B[18]=186368;        B[19]=-66560;

        int Pr[m], Pc[n];
        initPermutationVector(m, Pr);
        initPermutationVector(n, Pc);

        r = factoring(m, n, A, U, L, D, Pr, Pc);

        if(r > 0){
//            testSolveDirect(m, n, A, p, B);
//           testSolve(r, m, n, U, L, D, Pr, Pc, A, p, B);
 //           testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, A, p, B);
            testSolveLS(r, m, n, U, L, D, Pr, Pc, A, p, B);
  //          testLU(m, n, r, Pr, Pc, U, L, D, A);
        }else{
            cout << "\n\n >>>>> Rank menor ou igual a zero!" << endl;
        }
    }


    return 1;

}


void testSolveDirect(int m, int n, double A[], int p, double B[])
{
    fmpz_mat_t Ai, Bi;

    fmpz_mat_init(Ai, m, n);
    fmpz_mat_init(Bi, m, p);

    for(int i=0; i<m; i++){
        for(int j=0; j<n; j++){ fmpz_set_d(fmpz_mat_entry(Ai, i, j), A[j+i*n]); }
        for(int j=0; j<p; j++){ fmpz_set_d(fmpz_mat_entry(Bi, i, j), B[j+i*p]); }
    }

    if(DEBUG){
        cout << "\n\n============================================================================= " << endl;
        cout << "=== Teste: Resolução do Sistema Original AX=b usando função da bib. FLINT === " << endl;
        cout << "=============================================================================" << endl;
    }

    testSolveDirect(m, n, Ai, p, Bi);
}

/** ************************************************************************************************************/
void testSolveDirect(int m, int n, fmpz_mat_t A, int p, fmpz_mat_t B)
{
    double Xd[n*p];

    // o sistema A Xd = B poderá ser resolvido diretamente se A for quadrada, inversível e full-rank.
    if(m == n){
        int singular = solveSystem(n, A, p, B, Xd);
        if(singular == 0){
            cout << "\n\n >>> Sistema sem solução! :: Matrix singular!" << endl;
        }
    }
    else{
        cout << "\n\n >>> Sistema sem solução! :: Matriz retangular!" << endl;
    }
}


void
testSolve(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[])
{
    fmpz_mat_t Ai, Bi;

    fmpz_mat_init(Ai, m, n);
    fmpz_mat_init(Bi, m, p);

    for(int i=0; i<m; i++){
        for(int j=0; j<n; j++){ fmpz_set_d(fmpz_mat_entry(Ai, i, j), A[j+i*n]); }
        for(int j=0; j<p; j++){ fmpz_set_d(fmpz_mat_entry(Bi, i, j), B[j+i*p]); }
    }

    if(DEBUG){
        cout << "\n\n============================================================================== " << endl;
        cout << "=== Teste: Resolução do Sistema Decomposto usando FFLU da bib. er_exact_ls === " << endl;
        cout << "==============================================================================" << endl;
    }

    testSolve(r, m, n, U, L, D, Pr, Pc, Ai, p, Bi);
}

void testSolve(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B)
{
    // verifica solvabilidade
    if(verifySolvability(r, m, L, p, B)){

        fmpz_mat_t Y;
        double Xd[n*p];

        // calcula Y
        solveY(m, r, D, L, p, B, Y);

        // calcula X
        solveX(r, n, U, p, Y, Xd);


    }else{
        cout << "\n\n >>> Sistema sem solução! :: Condição de Solvabilidade Não Verificada!" << endl;
    }
}

void testSolveLSDirect(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[])
{
    fmpz_mat_t Ai, Bi;

    fmpz_mat_init(Ai, m, n);
    fmpz_mat_init(Bi, m, p);

    for(int i=0; i<m; i++){
        for(int j=0; j<n; j++){ fmpz_set_d(fmpz_mat_entry(Ai, i, j), A[j+i*n]); }
        for(int j=0; j<p; j++){ fmpz_set_d(fmpz_mat_entry(Bi, i, j), B[j+i*p]); }
    }

    if(DEBUG){
        cout << "\n\n==================================================================================== " << endl;
        cout << "=== Teste: Resolução do Sistema de Mínimos Quadrados usando FFLU da bib. FLINT ===== "<< endl;
        cout << "====================================================================================" << endl;
    }

    testSolveLSDirect(r, m, n, U, L, D, Pr, Pc, Ai, p, Bi);
}

void testSolveLSDirect(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B)
{
    // verifica solvabilidade
    if(verifySolvability(r, m, L, p, B)){

        int rn = r+n;
        fmpz_mat_t M, Y, BX, B_pr;
        double Xd[rn*p];
        int fac[m], Pr_inv[r];

        // inicializa matrizes e vetores
        fmpz_mat_init(BX, rn, p);
        for(int i=0; i<m; i++){
            fac[i] = 1;
        }

        // determina matriz M de mínimos quadrados
        determineLSSystem(n, r, M, U, Pc, fac);

        // aplica a permutação inversa no vetor
        computeInverseVector(m, Pr, Pr_inv);
        permuteRows(m, p, Pr, B, B_pr);
        fmpz_mat_set(B, B_pr);

        // calcula Y
        solveY(m, r, D, L, p, B, Y);

        // une vetores auxA e auxB, fmpz_mat_t A2
        for(int i=0; i<p; i++){
            for(int j=0; j<n; j++){

                fmpz_set_d(fmpz_mat_entry(BX, 0, 0), -31);
                fmpz_set_d(fmpz_mat_entry(BX, 0, 1), -55);

                fmpz_set_d(fmpz_mat_entry(BX, 1, 0), 65);
                fmpz_set_d(fmpz_mat_entry(BX, 1, 1), 1);

                fmpz_set_d(fmpz_mat_entry(BX, 2, 0), 17);
                fmpz_set_d(fmpz_mat_entry(BX, 2, 1), -82);

                fmpz_set_d(fmpz_mat_entry(BX, 3, 0), -15);
                fmpz_set_d(fmpz_mat_entry(BX, 3, 1), -83);

                fmpz_set_d(fmpz_mat_entry(BX, 4, 0), 1);
                fmpz_set_d(fmpz_mat_entry(BX, 4, 1), -54);

                fmpz_set_d(fmpz_mat_entry(BX, 5, 0), 81);
                fmpz_set_d(fmpz_mat_entry(BX, 5, 1), -27);

                fmpz_set_d(fmpz_mat_entry(BX, 6, 0), 49);
                fmpz_set_d(fmpz_mat_entry(BX, 6, 1), -26);

                fmpz_set_d(fmpz_mat_entry(BX, 7, 0), 65);
                fmpz_set_d(fmpz_mat_entry(BX, 7, 1), -54);

                //fmpz_set_d(fmpz_mat_entry(BX, j, i), 0);
            }
            for(int j=n; j<rn; j++){
                fmpz_set(fmpz_mat_entry(BX, j, i), fmpz_mat_entry(Y, j-n, i));
            }
        }

        if(DEBUG){ flint_printf("\n\nBX = \n"); fmpz_mat_print_pretty(BX); }

        solveSystem(rn, M, p, BX, Xd);

    }else{
        cout << "\n\n >>> Sistema sem solução!" << endl;
    }

}


void testSolveLS(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[])
{
    fmpz_mat_t Ai, Bi;

    fmpz_mat_init(Ai, m, n);
    fmpz_mat_init(Bi, m, p);

    for(int i=0; i<m; i++){
        for(int j=0; j<n; j++){ fmpz_set_d(fmpz_mat_entry(Ai, i, j), A[j+i*n]); }
        for(int j=0; j<p; j++){ fmpz_set_d(fmpz_mat_entry(Bi, i, j), B[j+i*p]); }
    }


    if(DEBUG){
        cout << "\n\n============================================================================================== " << endl;
        cout << "=== Teste: Resolução do Sistema de Mínimos Quadrados por partes da bib. er_least_squares.h === "<< endl;
        cout << "==============================================================================================" << endl;
    }

    testSolveLS(r, m, n, U, L, D, Pr, Pc, Ai, p, Bi);
}

void testSolveLS(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B1)
{
    int Pr_inv[m];
    fmpz_mat_t B, B_pr, Bpr_aux;
    fmpq_mat_t P2;

    // define B = Pr_1 * B
    fmpz_mat_init(Bpr_aux, m, p);
   computeInverseVector(m, Pr, Pr_inv);
    permuteRows(m, p, Pr, B1, Bpr_aux);

    fmpz_mat_init(B, m, p);
    fmpz_mat_set(B, Bpr_aux);

    // B_pr são as primeiras r linhas da matrix Bpr_aux
    fmpz_mat_init(B_pr, r, p);
    for(int i=0; i<r; i++){
        for(int j=0; j<p; j++){
            fmpz_set(fmpz_mat_entry(B_pr, i, j), fmpz_mat_entry(Bpr_aux, i, j));
        }
    }

    // verifica solvabilidade
    if(verifySolvability(r, m, L, p, B)){

        fmpq_mat_t M1, M2, M3, M4;
        fmpz_mat_t W, aux;
        fmpq_mat_t P1;
        double Xd[n*p];

        // determina matriz de pesos W
        determineWeightMatrix(n, W);

        // determina matrizes de mínimos quadrados
        determineLSMatrix(m, r, n, W, L, D, U, Pc, M1, M2, M3, M4);

        // configura posições iniciais para zero
        fmpz_mat_init(aux, n, p);
        for(int i=0; i<n; i++){
            for(int j=0; j<p; j++){
                fmpz_set_d(fmpz_mat_entry(aux, i, j), 1.0);
            }
        }
        fmpq_mat_init(P1, n, p);
        fmpq_mat_set_fmpz_mat(P1, aux);

        // resolve o sistema
        solveLSSystem(r, n, M1, M2, M3, M4, B_pr, p, P1, P2);

        // permuta as linhas da matrix B
        verifySolution(m, n, p, A, B1, P2, Xd);

    }else{
        cout << "\n\n >>> Sistema sem solução!" << endl;
    }

}


void testInverse(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[])
{
    cout << "////////////////////////////////////////////////////" << endl;

    fmpz_mat_t U_aux, Pc_aux, U_inv;
    fmpz_t det, det_1, det_aux;
    fmpz_mat_t Linv, L1;
    int Pc_inv[n], Pr_inv[m];

    // inicializa fmpz_t
    fmpz_init(det);
    fmpz_init(det_1);
    fmpz_init(det_aux);

    fmpz_mat_init(L1, r, r);
    fmpz_mat_init(U_aux, r, r);
    fmpz_mat_init(U_inv, r, r);

    for(int i=0; i<r; i++){
        for(int j=0; j<r; j++){
            fmpz_set(fmpz_mat_entry(U_aux, i, j), fmpz_mat_entry(U, i, j));
        }
    }
    if(DEBUG){
        flint_printf("\n\nU_aux = \n"); fmpz_mat_print_pretty(U_aux);
    }

    // calcula U inversa
    if(fmpz_mat_inv(U_inv, det, U_aux) != 0){

        if(DEBUG){
            flint_printf("\n\nUinv = \n"); fmpz_mat_print_pretty(U_inv);
            flint_printf("\n\ndet = \n");fmpz_print(det);
        }

        // calcula Pc inversa
        computeInverseVector(n, Pc, Pc_inv);
//        double Pcd[r*r];
//        double PcdInv[r*r];

//        convertMatrixToDouble(r, r, Pc_aux, Pcd, 1);
//        rmxn_inv (r, Pcd, PcdInv);
//        for(int i=0; i<r; i++){
//            for(int j=0; j<r; j++){
//                fmpz_set_d(fmpz_mat_entry(Pc_inv, i, j), PcdInv[j+i*r]);
//            }
//        }
//        fmpz_set_d(det_1, 1);
//        if(DEBUG){
//            flint_printf("\n\nPcinv = \n"); fmpz_mat_print_pretty(Pc_inv);
//            flint_printf("\n\ndet = \n");fmpz_print(det_1);
//        }

        // devolve U_aux = Pc_inv * U_inv
        permuteColumns(m, n, Pc_inv, U_aux, U_inv);
//        fmpz_mat_mul(U_aux, Pc_inv, U_inv);

//        fmpz_mul(det_aux, det, det_1);
//        for(int i=0; i<r; i++){
//            for(int j=i; j<r; j++){
//                fmpz_divexact(fmpz_mat_entry(U_aux, i, j), fmpz_mat_entry(U_aux, i, j), det_aux);
//            }
//        }

        // D = U_aux * D
        fmpz_mat_mul(D, U_aux, D);

        // calcula L inversa
        fmpz_mat_init(Linv, r, r);
        if(fmpz_mat_inv(Linv, det, L) != 0){
            if(DEBUG){
                flint_printf("\n\nLinv = \n"); fmpz_mat_print_pretty(Linv);
                flint_printf("\n\ndet = \n");fmpz_print(det);
            }

            // calcula Pr inversa
            computeInverseVector(m, Pr, Pr_inv);
//            fmpz_mat_init(Prinv, r, r);

//            double Prd[r*r];
//            double PrdInv[r*r];
//            convertMatrixToDouble(r, r, Pr, Prd, 1);
//            rmxn_inv (r, Prd, PrdInv);
//            for(int i=0; i<r; i++){
//                for(int j=0; j<r; j++){
//                    fmpz_set_d(fmpz_mat_entry(Prinv, i, j), PrdInv[j+i*r]);
//                }
//            }
//            fmpz_set_d(det_1, 1);

//            if(DEBUG){
//                flint_printf("\n\nPrinv = \n"); fmpz_mat_print_pretty(Prinv);
//                flint_printf("\n\ndet1 = \n");fmpz_print(det_1);
//            }

            fmpz_mat_mul(L, D, Linv);
            permuteRows(m, n, Pr_inv, L, L1);
            //fmpz_mat_mul(L1, L, Prinv);
//        //    for(int i=0; i<r; i++){
//        //        for(int j=i; j<r; j++){
//        //            fmpz_divexact(fmpz_mat_entry(L, i, j), fmpz_mat_entry(L, i, j), det);
//        //        }
//        //    }

//        //    if(DEBUG){
//        //        flint_printf("\n\nU = \n"); fmpz_mat_print_pretty(U_aux);
//        //        flint_printf("\n\nL = \n"); fmpz_mat_print_pretty(L);
//        //    }

//        //    fmpz_mul(detAux, det, det1);
//        //    fmpz_mat_mul(A, U_aux, L);
//        //    //        for(int i=1; i<r; i++){
//        //    //            for(int j=i; j<np; j++){
//        //    //                fmpz_divexact(fmpz_mat_entry(AB, i, j), fmpz_mat_entry(AB, i, j), detAux);
//        //    //            }
//        //    //        }

            if(DEBUG){
                flint_printf("\n\An = \n"); fmpz_mat_print_pretty(L1);
            }
        }
    }

}



/** ******************************************************************************************************************
    Função para testar se as matrizes fmpz encontradas na fatoração estão corretas com relação a entrada
*********************************************************************************************************************   */

void testLU(int m, int n, int r, int Pr[], int Pc[], fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, double A[])
{
    fmpz_mat_t Ai;

    fmpz_mat_init(Ai, m, n);

    for(int i=0; i<m; i++){
        for(int j=0; j<n; j++){ fmpz_set_d(fmpz_mat_entry(Ai, i, j), A[j+i*n]); }
    }

    testLU(m, n, r, Pr, Pc, U, L, D, Ai);
}

void testLU(int m, int n, int r, int Pr[], int Pc[], fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, fmpz_mat_t A)
{
    fmpz_t det;
    fmpz_init(det);

    fmpq_mat_t Dinv, Daux, A1, Laux, A2, Uaux;
    fmpz_mat_t L_pr, A_pc, A2aux;


    if(DEBUG){
        cout << "\n\nTestando matrizes L e U .................";
        flint_printf("\n\nTeste A1 = \n"); fmpz_mat_print_pretty(A);         
        flint_printf("\n\nPr = "); printPermutationVector(m, Pr);
        flint_printf("\n\nPc = "); printPermutationVector(n, Pc);
        flint_printf("\n\nD = "); fmpz_mat_print_pretty(D);
        cout << "r:" << r << endl;
    }


    fmpq_mat_init(Daux, r, r);
    fmpq_mat_set_fmpz_mat(Daux, D);

    fmpq_mat_init(Dinv, r, r);
    int inv = fmpq_mat_inv(Dinv, Daux);
    cout << "inv:" << inv << endl;

    if(DEBUG){ flint_printf("\n\nInversa de D = \n"); fmpq_mat_print(Dinv);}

    if(inv != 0){

        permuteRows(m, r, Pr, L, L_pr);
        fmpz_mat_set(L, L_pr);
        if(DEBUG){ flint_printf("\n\nPr * L= \n"); fmpz_mat_print_pretty(L);}

        fmpq_mat_init(Laux, m, r);
        fmpq_mat_set_fmpz_mat(Laux, L);

        fmpq_mat_init(A1, m, r);
        fmpq_mat_mul(A1, Laux, Dinv);
        if(DEBUG){ flint_printf("\n\n(Pr * L) * Dinv = \n"); fmpq_mat_print(A1);}

        fmpq_mat_init(Uaux, r, n);
        fmpq_mat_set_fmpz_mat(Uaux, U);

        fmpq_mat_init(A2, m, n);
        fmpq_mat_mul(A2, A1, Uaux);
        if(DEBUG){ flint_printf("\n\n(Pr * L * Dinv) * U = \n"); fmpq_mat_print(A2);}

        fmpz_mat_init(A2aux, m, n);
        fmpq_mat_get_fmpz_mat(A2aux, A2);

        permuteColumns(m, n, Pc, A2aux, A_pc);
        fmpz_mat_set(A, A_pc);
        if(DEBUG){ flint_printf("\n\n(Pr * L * Dinv * U) * Pc \n"); fmpz_mat_print_pretty(A);}

        if(DEBUG){ flint_printf("\n\nTeste A2 = \n"); fmpz_mat_print_pretty(A); }
    }

}
