#! /usr/bin/python3
# Last edited on 2024-06-16 16:50:23 by stolfi

def write_vertices(wrp, Nv, vtot):
  # Writes to {wrp} a POV-Ray macro that defines 
  # an array {V} containing the vertex coordinates.
  # The label of each vertex is written as a comment.

  # Write the POV-Ray preamble:
  wrp.write("#macro hel_vertices()\n")
  wrp.write("  #local Nv = hel_num_vertices;\n")
  wrp.write("  // Returns an array {V} of {Nv+1} elements.\n")
  wrp.write("  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.\n")
  wrp.write("  // Element {V[0]} is not used.\n")
  wrp.write("  #local V = array[Nv+1]\n")
  wrp.write("  #local V[   0] = < -1, -1, -1>; // Not used.\n")

  for kv in range(1,Nv+1):
    p = vobj[kv]
    lab = Vlab[kv]
    wrp.write("  #local V[%4d] =" % kv)
    wrp.write(" < %.*f, %.*f, %.*f >;" % (prec, reven(p[0]), prec, reven(p[1]), prec, reven(p[2])))
    wrp.write(" // %s\n" % lab)

  # Write the POV-Ray postamble:
  wrp.write("  V\n")
  wrp.write("#end\n\n")
  
def write_edges(wrp, Eorg, Edst, vobj, Vlab):
  # Writes to {wrp} the indices of the endpoints of the edges of the hel.
  
  Nv = len(vobj) - 1
  Ne = len(Eorg) - 1

  # Write the POV-Ray preambles:
  wrp.write("#macro hel_edges()\n")
  wrp.write("  #local Ne = hel_num_edges;\n")
  wrp.write("  // Returns an array {E} of {Ne+1} elements.\n")
  wrp.write("  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.\n")
  wrp.write("  // Here {ko[ke],kd[ke]} are the indices of the vertices\n")
  wrp.write("  // which are the endpoints of edge {E[ke]},\n")
  wrp.write("  // and {ty[ke]} is an edge type code:\n")
  wrp.write("  // \n")
  wrp.write("  //   100-199 outer chain edge of plaza [0].\n")
  wrp.write("  //   200-299 inner chain edge of plaza [0].\n")
  wrp.write("  //   300-399 outer chain edge of plaza [1].\n")
  wrp.write("  //   400-499 inner chain edge of plaza [1].\n")
  wrp.write("  //   0       other.\n")
  wrp.write("  // \n")
  wrp.write("  // The index of the edge in the chain is {ty[ke] % 100}.\n")
  wrp.write("  #local E = array[Ne+1]\n")
  wrp.write("  #local E[   0] = < -1, -1, -1 >; // Not used.\n")
  
  for ke in range(1, Ne+1):
    kv_org = Eorg[ke];
    kv_dst = Edst[ke]; 
    
    # Determine type and index of origin and destination:
    lab_org = Vlab[kv_org]; # Label of vertex {kv_org}.
    kc_org = int(re.sub(r"^v[io][.][01][.]", "", lab_org))
    
    lab_dst = Vlab[kv_dst]; # Label of vertex {kv_dst}.
    kc_dst = int(re.sub(r"^v[io][.][01][.]", "", lab_dst))
    
    vo0_pat = "^vo[.]0[.][0-9]$"      # Outer vertex of plaza [0].
    vo0_org = re.match(vo0_pat, lab_org); vo0_dst = re.match(vo0_pat, lab_dst)
    
    vo1_pat = "vo[.]1[.][0-9]+$"      # Outer vertex of plaza [1].
    vo1_org = re.match(vo1_pat, lab_org); vo1_dst = re.match(vo1_pat, lab_dst)
    
    vi0_pat = "^vi[.]0[.][0-9]$"      # Inner vertex of plaza [0].
    vi0_org = re.match(vi0_pat, lab_org); vi0_dst = re.match(vi0_pat, lab_dst)
    
    vi1_pat = "vi[.]1[.][0-9]+$"      # Inner vertex of plaza [1].
    vi1_org = re.match(vi1_pat, lab_org); vi1_dst = re.match(vi1_pat, lab_dst)

    if vo0_org and vo0_dst:
      # Edge is outer chain of plaza [0]:
      ty = 100 + kc_org
    elif vi0_org and vi0_dst:
      # Edge is inner chain of plaza [0]:
      ty = 100 + kc_org
    elif vo1_org and vo1_dst:
      # Edge is outer chain of plaza [1]:
      ty = 300 + kc_org
    elif vi1_org and vi1_dst:
      # Edge is inner chain of plaza [1]:
      ty = 400 + kc_org
    else:
      ty = 0

    wrp.write("  #local E[%4d] = < %d, %d, %d >;\n" % (ke, Eorg[ke], Edst[ke], ty))
    elen = rn.norm(rn.sub(vobj[Edst[ke]], vobj[Eorg[ke]]))
    assert elen >= 5*eps, f"edge {lab_org}--{lab_dst} too short"
    
  # Write the POV-Ray postamble:
  wrp.write("  E\n")
  wrp.write("#end\n\n")
 
def write_faces(wrp, Fnrm, Fpos):
  # Writes the face planes to {wrp} as POV-ray.
  
  Nf = len(Fnrm) - 1

  # Write the POV-Ray preambles:
  wrp.write("#macro hel_faces()\n")
  wrp.write("  #local Nf = hel_num_faces;\n")
  wrp.write("  // Returns an array {F} of {Nf+1} elements.\n")
  wrp.write("  // Element {F[kf]} is an instance of the\n")
  wrp.write("  // 'plane' (halfspace) POV-ray primitive\n")
  wrp.write("  // for {kf} in {1..Nf}.\n")
  wrp.write("  // The order is outer chain faces, inner chain faces.\n")
  wrp.write("  // inner-outer connecting faces,\n")
  wrp.write("  // and finally the plazas.\n")
  wrp.write("  #local F = array[Nf+1]\n")
  wrp.write("  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.\n")
  
  for kf in range(1, Nf+1):
    Fn = Fnrm[kf]
    Fp = Fpos[kf]
    wrp.write("  #local F[%4d] = plane{ " % kf)
    wrp.write(" < %.7f, %.7f, %.7f >, 0" % (Fn[0], Fn[1], Fn[2]))
    wrp.write(" translate < %.*f, %.*f, %.*f >" % (prec, Fp[0], prec, Fp[1], prec, Fp[2]))
    wrp.write(" }\n")
    
  # Write the POV-Ray postamble:
  wrp.write("  F\n")
  wrp.write("#end\n\n")
  
def write_parms(wrp, S, Nv,Nf,Ne,Ng,Nt, prec,eps):
  wrp.write("#declare hel_outer_chain_even_radius = %.*f;\n\n" % (prec, Ro_even))
  wrp.write("#declare hel_outer_chain_odd_radius = %.*f;\n\n" % (prec, Ro_odd))
  wrp.write("#declare hel_inner_chain_even_radius = %.*f;\n\n" % (prec, Ri_even))
  wrp.write("#declare hel_inner_chain_odd_radius = %.*f;\n\n" % (prec, Ri_odd))
  wrp.write("#declare hel_thickness = %.*f;\n\n" % (prec, Ha))
  wrp.write("#declare hel_min_elevation = %.5f; // Degrees.\n\n" % Amin)
  wrp.write("#declare hel_max_elevation = %.5f; // Degrees.\n\n" % Amax)
  
  wrp.write("#declare hel_num_faces = %d;\n\n" % Nf)
  wrp.write("#declare hel_num_edges = %d;\n\n" % Ne)
  wrp.write("#declare hel_num_vertices = %d;\n\n" % Nv)
  wrp.write("#declare hel_num_outer_chain_edges = %d;\n\n" % Neo)
  wrp.write("#declare hel_num_inner_chain_edges = %d;\n\n" % Nei)
  wrp.write("#declare hel_outer_chain_shape = %d;\n\n" % oshape)
