// Last edited on 2024-09-19 13:40:08 by stolfi
// Figure for topological slicing paper

#version 3.7;

global_settings{ max_trace_level 6 assumed_gamma 1.2 }
background{ color rgb < 1.000, 1.000, 1.000 > }
#debug "!! === slicing_box_main.pov =============================\n"

// ----------------------------------------------------------------------
// THING TO SHOW

#local view = 0;
#local show_axes = 0;
#local show_ground = 0;

// Read the parameter file that defines {incfile}:
#include "out/params.inc"

#declare eps = 0.0005; // Fudge distance for contacting surfaces etc.

#include "slicing_textures.inc"
#declare slicing_tx_face = slicing_tx_face_opaque

// Read the elements of the object:
#include inc_file

#local Nv  =    slicing_num_vertices; #debug concat("!! Nv      = ", str(Nv,      0,0), "\n")
#local Ne  =    slicing_num_edges;    #debug concat("!! Ne      = ", str(Ne,      0,0), "\n")
#local Nf  =    slicing_num_faces;    #debug concat("!! Nf      = ", str(Nf,      0,0), "\n")
#local Np  =    slicing_num_planes;   #debug concat("!! Np      = ", str(Np,      0,0), "\n")
#local Zp_min = slicing_planes_Z_min;
#local Zp_max = slicing_planes_Z_max;
#local erad =   slicing_edge_radius;
#local vrad =   slicing_vertex_radius;

// To avoid stupid POV-Ray CSG warning:
#macro nothing(rad)
  sphere{ <0,0,0>, rad*eps texture{ slicing_tx_invisible } }
#end

#local V = slicing_vertices()
#local E = slicing_edges()
#local explode = 0.0;
#local F = slicing_faces(explode)

#include "eixos.inc"
#include "misc_arrows.inc"

#macro slicing_debug_vertex(name, kv, vk)
  #if (kv >= 1)
    #local kvx = concat(" (v", str(kv,0,0), ")")
  #else
    #local kvx = ""
  #end
  #local vtx = concat("( ", str(vk.x,9,4), " ", str(vk.y,9,4), " ", str(vk.z,9,4), ")")
  #debug concat("!!   ", name, kvx, " = ", vtx, "\n")
#end

// Choose the positions of the slicing planes:
#include "slicing_choose_planes.inc"
#local Zp = slicing_choose_planes(V, Np, Zp_min, Zp_max)

#include "slicing_skeleton.inc"
#include "slicing_solid.inc"
#include "slicing_planes.inc"

#local skel = slicing_skeleton(V, E, Zp, erad, vrad) 
#local surf = slicing_solid(V, F)
#local spla = slicing_planes(Zp, V)

#local Zrot = 0; // -50; // Degrees.

#local thing = 
  union{
    object{ nothing(1.17) }
    object{ skel }
    object{ surf }
    rotate Zrot*z 
  }

// Leave the slicing planes out of the {thing} or it will mess its bounding box:
object{ spla rotate Zrot*z }

// ----------------------------------------------------------------------

#include "slicing_view.inc"
slicing_view(thing, show_axes, show_ground, view)

#include "slicing_camlight.inc"
#declare light_intens = 1.20;
#declare light_ard = 30;
slicing_camlight(scene_center, scene_radius, dir_camera, dist_camera , z, light_intens, 0,0, light_ard)
