// Last edited on 2024-07-26 08:53:29 by stolfi

#debug "!! Loading rap_solid.inc ...\n"

#macro rap_solid(V, F, Neo, Nei, oshape, subfig)
  // The 3D volume of the object.  Parameters:
  
  // {V}      Array of vertex coordinates {V[1..Nv]}.
  // {F}      Array of planes that define the faces, {F[1..Nf]}.
  // {Neo}    Number of edges in the outer chain of each plaza.
  // {Nei}    Number of edges in the inner chain of each plaza.
  // {oshape} Shape of outer chain.
  // {subfig} Which sub-figure we are generating.
  
  // Assumes that {F} has the strip of {Neo} outer chain faces, followed
  // by the strip of {Nei} inner chain faces (both in CCW order as seen
  // from {(+oo,0,0)}, followed by the two wedge sides that connect the
  // two chains, followed by the two plaza faces.

  #debug "!! Generating the object's surface ...\n"

  #local Nv = dimension_size(V, 1) - 1;
  #local Nf = dimension_size(F, 1) - 1;

  #debug concat("!!   Nv     = ", str(Nv    ,0,0), "\n")
  #debug concat("!!   Neo    = ", str(Neo   ,0,0), "\n")
  #debug concat("!!   Nei    = ", str(Nei   ,0,0), "\n")
  #debug concat("!!   oshape = ", str(oshape,0,0), "\n")
  #debug concat("!!   subfig = ", str(subfig,0,0), "\n")

  #if (Nv != 2*(Neo+Nei+2)) kaboom("Inconsistent {Nv,Neo,Nei}") #end
  #if (Nf != Neo+Nei+4) kaboom("Inconsistent {Nf,Neo,Nei}") #end

  #local tx_face = rap_tx_face
  
  // A clipping box for the whole object:
  #local vmin = < +9999, +9999, +9999 >;
  #local vmax = < -9999, -9999, -9999 >;
  #for (kv,1,Nv)
    #local vk = V[kv];
    #local vmin = < min(vmin.x, vk.x), min(vmin.y, vk.y), min(vmin.z, vk.z) >;
    #local vmax = < max(vmax.x, vk.x), max(vmax.y, vk.y), max(vmax.z, vk.z) >;
  #end
  rap_debug_vertex("vmin", -1, vmin)
  rap_debug_vertex("vmax", -1, vmax)
  #local bbox1 = box { vmin - 2.0*<1,1,1>, vmax + 2.0*<1,1,1> }
  #local bbox2 = box { vmin - 3.0*<1,1,1>, vmax + 3.0*<1,1,1> }
  
  #local kfo_ini = 1;              // Index of first face on outer strip.
  #local kfi_ini = kfo_ini + Neo;  // Index of first face on inner strip.
  #local kfs_ini = kfi_ini + Nei;  // Index of first spoke face.
  #local kfp_ini = kfs_ini + 2;    // Index of plaza [0]
  #if (kfp_ini + 1 != Nf) kaboom("inconsistent {Nf,Neo,Nei}") #end

  // Object with the inner chain dent filled in:
  #local surf = 
    intersection{
      #debug "!!   bounding box...\n"
      object{ bbox1 }
      object{ bbox2 }

      #debug "!!   halfspaces of spoke faces...\n"
      #for (kf, kfs_ini, kfs_ini+1)
        object{ F[kf] }
      #end

      #debug "!!   halfspaces of plazas...\n"
      #for (kf, kfp_ini, kfp_ini+1)
        object{ F[kf] }
      #end

      // Outer chain faces:
      #if (oshape = 0)
        #debug "!!   outer strip halfspaces...\n"
        #for (kf, kfo_ini, kfo_ini+Neo-1)
          object{ F[kf] }
        #end
      #elseif ((oshape = 1) | (oshape = 3))
        #debug "!!   outer strip dent wedges...\n"
        #local Nw = int(Neo/2); // Number of complemented wedges.
        #if (Neo != 2*Nw) kaboom("outer edge count {Neo} is not even") #end
        #for (kw,0,Nw-1)
          #local kf0 = kfo_ini + 2*kw;
          #local kf1 = kf0 + 1;
          #local wedge = 
            union{ 
              object{ F[kf0] }
              object{ F[kf1] }
            }
          object{ wedge }
        #end
      #elseif (oshape = 2)
        #debug "!!   union of outer strip dent halfspaces...\n"
        #local dent = 
          union{
            #for (kf, kfo_ini, kfo_ini+Neo-1)
              object{ F[kf] }
            #end
          }
        object{ dent }
      #else
        kaboom("invalid {oshape}")
      #end
      
      #if (Nei > 0)
        #if ((oshape = 0) | (oshape = 1) | (oshape = 2))
          // Unite the inner chain faces:
          #local dent = 
            union{
              #for (kf, kfi_ini, kfi_ini+Nei-1)
                object{ F[kf] }
              #end
            }
          object{ dent }
        #elseif (oshape = 3)
          #debug "!!   inner strip dent wedges...\n"
          #local Nw = int(Nei/2); // Number of complemented wedges.
          #if (Nei != 2*Nw) kaboom("inner edge count {Nei} is not even") #end
          #for (kw,0,Nw-1)
            #local kf0 = kfi_ini + 2*kw;
            #local kf1 = kf0 + 1;
            #local wedge = 
              union{ 
                object{ F[kf0] }
                object{ F[kf1] }
              }
            object{ wedge }
          #end
          
        #else
          kaboom("invalid {oshape}")
        #end
      #end

      texture{ tx_face }
    }

  surf
#end