package parameters;

import java.io.BufferedReader;
import java.util.ArrayList;

import preprocessing.Parser;

public class tracking_arguments {
	 
	/*Probabilities deviations*/

	public final double sigma_app;

	public final double sigma_pos;

	public final double sigma_size;
	
	/*Assignments thresholds*/

	public final double assignment_threshold;

	public final double weight_threshold;

	/*Particle Filter Parameters*/

	public final int number_of_particles;

	public final double rho;

	/*Similarity option*/
	public final String similarity_option;

	/*HSV thresholds - HSV similarity function*/
	  /*max HSV values. Number of bins of HSV in histogram */
	  public final int NH;
	  public final int NS;
	  public final int NV;
	  /* max HSV values */
	  public final double H_MAX;
	  public final double S_MAX;
	  public final double V_MAX;
	  /* low thresholds on saturation and value for histogramming */
	  public final double S_THRESH;
	  public final double V_THRESH;
	/*End-HSV*/

	/*HoG thresholds - HoG similarity function*/
	  public final int numCellsX;
	  public final int numCellsY;
	  public final int blockSize;

	/* distribution parameter */
	public final int LAMBDA;
	public final double TRANS_X_STD;
	public final double TRANS_Y_STD;
	public final double TRANS_S_STD;

	/* autoregressive dynamics parameters for transition model */
	public final double A1;
	public final double A2;
	public final double B0;
	
	/*HoG parameters*/
	public String hog_obj;
	public String hog_parameters_similarity;
	public String hog_parameters_trained;
	
	/*End*/	
	
	public tracking_arguments (String file_name) 
	{
		Parser parser = new Parser();

		BufferedReader arguments = parser.Open_File_Stream (file_name);

		ArrayList<String> list = new ArrayList<String>();

		String[] s = null;
		do {
			s = parser.Get_Stream_Tokens (arguments, " ");
			if (s == null) { break; }
			System.err.println(s[0]);
			list.add(s[0]);
		} while (s != null); 
		
		assignment_threshold = Double.parseDouble(list.get(0));
		
		weight_threshold = Double.parseDouble(list.get(1));
		
		number_of_particles = Integer.parseInt(list.get(2));
		
		rho = Double.parseDouble(list.get(3));
		
		sigma_app = Double.parseDouble(list.get(4));
		
		sigma_pos = Double.parseDouble(list.get(5));
		
		sigma_size = Double.parseDouble(list.get(6));
		
		similarity_option = list.get(7);
		
		NH = Integer.parseInt(list.get(8));
		
		NS = Integer.parseInt(list.get(9));
		
		NV = Integer.parseInt(list.get(10));

		H_MAX = Double.parseDouble(list.get(11));
		
		S_MAX = Double.parseDouble(list.get(12));
		
		V_MAX = Double.parseDouble(list.get(13));
		
		S_THRESH = Double.parseDouble(list.get(14));
		
		V_THRESH = Double.parseDouble(list.get(15));
			
		numCellsX = Integer.parseInt(list.get(16));
		
		numCellsY = Integer.parseInt(list.get(17));
		
		blockSize = Integer.parseInt(list.get(18));

		LAMBDA = Integer.parseInt(list.get(19));
		
		TRANS_X_STD = Double.parseDouble(list.get(20));
		
		TRANS_Y_STD = Double.parseDouble(list.get(21));
		
		TRANS_S_STD = Double.parseDouble(list.get(22));

		A1 = Double.parseDouble(list.get(23));
		
		A2 = Double.parseDouble(list.get(24));
		
		B0 = Double.parseDouble(list.get(25));
		
		hog_obj = list.get(26);
		
		hog_parameters_similarity = list.get(27);
		
		hog_parameters_trained = list.get(28);
	}	
}
