function [le,re] = rec_delaunay(sites,sl,sh)

if( sh == sl + 1)
   a = make_edge;
   set_Org(a,sites{sl});
   set_Dest(a,sites{sl+1});
   %plot_edge(a,'r');
   %pause(0.01);
   
   le = a;
   re = Symet(a);
else
   if (sh == sl+2)
      a = make_edge;
      b = make_edge;
      splice(Symet(a),b);
      set_Org(a,sites{sl});
      set_Dest(a,sites{sl+1});
	   set_Org(b,sites{sl+1});
      set_Dest(b,sites{sl+2});
      
      %plot_edge(a,'r');
      %pause(0.01);
      %plot_edge(b,'r');
      %pause(0.01);
      
      ct = ccw(sites{sl},sites{sl+1},sites{sl+2});
      
      if(ct==0)
         le = a;
         re = Symet(b);
      else
         c = conn(b,a);
         %plot_edge(c,'r');
         %pause(0.01);
         
         if(ct>0)
            le=a;
            re = Symet(b);
         else
            le=Symet(c);
            re = c;
         end;
      end;
      
   else
      sm = floor((sl + sh)/2);
      [ldo,ldi ] = rec_delaunay(sites, sl, sm);
      %quad_enum(ldo,'visit_proc');
      %quad_enum(ldi,'visit_proc');
      %pause(0.01);
      
      [rdi,rdo ] = rec_delaunay(sites, sm+1, sh);
      %quad_enum(rdi,'visit_proc');
      %quad_enum(rdo,'visit_proc');
      %pause(0.01);

      while(1)
         if(leftof(Org(rdi),ldi))
            ldi = Lnext(ldi);
         else
            if (rightof(Org(ldi),rdi))
               rdi = Onext(Symet(rdi));
            else
               break;
            end;
         end;
      end;
      
      basel = conn(Symet(rdi),ldi);
      %plot_edge(basel,'r');
      %disp('basel');
      %pause(0.01);
      if(equal(Org(ldi),Org(ldo)))
         ldo = Symet(basel);
      end;
      if(equal(Org(rdi),Org(rdo)))
         rdo = basel;
      end;
      
      
      while(1) % Merge Loop
         lcand = Onext(Symet(basel));
         if(rightof(Dest(lcand),basel))
            while(incircle(Dest(basel),Org(basel),Dest(lcand),Dest(Onext(lcand))))
               t = Onext(lcand);
               destroy_edge(lcand);
               %plot_edge(lcand,'y');
         
               lcand = t;
            end;
         end;
         
         rcand = Oprev(basel);
         if(rightof(Dest(rcand),basel))
            while(incircle(Dest(basel),Org(basel),Dest(rcand),Dest(Oprev(rcand))))
               t = Oprev(rcand);
               destroy_edge(rcand);
               %plot_edge(rcand,'y');
               rcand = t;
            end;
         end;
         
         
         if((rightof(Dest(lcand), basel)==0)&(rightof(Dest(rcand), basel)==0))
            %le = ldo;
            %re = rdo;
            %%plot_edge(basel,'r');
            break;
         end;
         
         if ( (rightof(Dest(lcand), basel)==0) |( rightof(Dest(rcand), basel) & ...
               incircle(Dest(lcand), Org(lcand), Org(rcand), Dest(rcand)))...
               )
            basel = conn(rcand, Symet(basel));
            %plot_edge(basel,'r');
            %disp('basel');
            %pause(0.01);
         else
            basel = conn(Symet(basel), Symet(lcand));
            %plot_edge(basel,'r');
            %disp('basel');
            %pause(0.01);
         end;
         
         le = ldo;
         re = rdo;
         %%plot_edge(re,'r');
         %%plot_edge(le,'r');
         %quad_enum(le,'visit_proc');
         %quad_enum(re,'visit_proc');
         pause(0.01);
      end;
   end;
end;
