package xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import parameters.detection_arguments;
import regrouping.Box;
import tracking.Atributes;

public class Icdar {

	
	private int nboxes;
	
	private String imageName;
	
	private int width;
	
	private int height;
	
	LinkedList<BoxParameters> bParameters;

	public Icdar (){

	}

	public Icdar (String imageName, int width, int height, LinkedList<BoxParameters> bParameters, int nboxes){
		this.imageName = imageName;
		this.width = width;
		this.height = height;
		this.bParameters = bParameters;
		this.nboxes = nboxes;
	}
	
	public int getNboxes() {
		return nboxes;
	}

	public void setNBoxes(int nboxes) {
		this.nboxes = nboxes;
	}
	
	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width =  width;
	}
	
	public int getHeight() {
		return height;
	}

	public void setHeight (int height) {
		this.height =  height;
	}
	
	public String getImageName() {
		return imageName;
	}

	public void setImageName(String imageName) {
		this.imageName = imageName;
	}
	
	public BoxParameters getBox (int pos) {
		return bParameters.get(pos);
	}
	
	public void print () {
		
		System.out.println("******************************");
		System.out.println("Image name : " + getImageName());
		System.out.println("width      : " + getWidth());
		System.out.println("height     : " + getHeight());
		
		for (int i = 0; i < bParameters.size(); i++) {
			BoxParameters b = bParameters.get(i);
			System.out.println("---------------------------");
			b.print();
		}
	}
	
	public static void toXML (String xml_header_name, String xml_file_name, int width, int height, LinkedList<regrouping.Box> lbox, detection_arguments detection_parameters)
	{
		int size = 0;
		for (int b = 0; b < lbox.size(); b++) {
			size++;
		}
		
		try {

			FileOutputStream file = new FileOutputStream(xml_file_name); 

			PrintStream out = new PrintStream(file);

			//out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

			//out.println("<tagset>");

			out.println("<image>");

			out.println("<imageName>" + xml_header_name + "</imageName>");

			out.println("<resolution x=\"" + width + "\" y=\"" + height + "\" />");

			
			if (size <= 0) {
				out.println("<taggedRectangles/>\n");
			}
			else {
				out.println("<taggedRectangles>");
				for (int b = 0; b < size; b++) {

					Box box = lbox.get(b);

					if ( (box.getDec() > 0) || box.getCount() < detection_parameters.Get_Minimum_Grouping_Set() || box.getValid() > 0) {
						//continue;
					}
					out.println("<taggedRectangle x=\"" + box.getXMin()/2 + "\" y=\"" + box.getYMin()/2 + "\" width=\"" + (box.getXMax()-box.getXMin())/2 + "\" height=\"" + (box.getYMax()-box.getYMin())/2 + "\" offset=\"0.0\" />");
				}
				out.println("</taggedRectangles>");
			}
			out.println("</image>");
			System.err.println("writing XML file : " + xml_file_name);
			out.close();
		}
		catch (IOException e) {
			System.err.println ("Error to write XML file\n");
			e.printStackTrace();
		} 

	}
	
	
	
	
	/*public static void toXML (String xml_header_name, String xml_file_name, int width, int height, ArrayList<textzones> tzones, Parameters param)
	{
		try {


			File file= new File(xml_file_name);

			PrintStream out = new PrintStream (file);

			//out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

			//out.println("<tagset>");

			out.println("<image>");

			out.println("<imageName>" + xml_header_name + "</imageName>");

			out.println("<resolution x=\"" + width + "\" y=\"" + height + "\" />");

			out.println("<taggedRectangles>");
			
			if (tzones.size() <= 0) {
				out.println("<taggedRectangle x=\"" + 0 + "\" y=\"" + 0 + "\" width=\"" + 2.0 + "\" height=\"" + 2.0 + "\" offset=\"0.0\" />");
			}
			else {
				for (int b = 0; b < tzones.size(); b++) {

					textzones box = tzones.get(b);

					out.println("<taggedRectangle x=\"" + box.get_x() + "\" y=\"" + box.get_y() + "\" width=\"" + box.get_width() + "\" height=\"" + box.get_height() + "\" offset=\"0.0\" />");
				}
			}
			out.println("</taggedRectangles>");
			out.println("</image>");
			System.err.println("writing XML file : " + xml_file_name);
			out.close();
					//out.println("</tagset>");
		}
		catch (IOException e) {
			System.err.println ("Error to write XML file\n");
			e.printStackTrace();
		}

	}*/
	
	
	public static void toXML (String xml_header_name, String xml_file_name, int width, int height, ArrayList<Atributes> tzones, detection_arguments param)
	{
		int margin = 2;
		try {
			
			FileOutputStream file = new FileOutputStream(xml_file_name); 

			PrintStream out = new PrintStream(file);

			//out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

			//out.println("<tagset>");

			out.println("<image>");

			out.println("<imageName>" + xml_header_name + "</imageName>");

			out.println("<resolution x=\"" + width + "\" y=\"" + height + "\" />");
			
			if (tzones.size() <= 0) {
				out.println("<taggedRectangles/>\n");
			}
			else {
				out.println("<taggedRectangles>");
				for (int b = 0; b < tzones.size(); b++) {
					Atributes box = tzones.get(b);
					out.println("<taggedRectangle x=\"" + (box.get_x() - margin) + "\" y=\"" + (box.get_y()-margin) + "\" width=\"" + (box.get_width()+margin+3) + "\" height=\"" + (box.get_height()+margin+3) + "\" text=\"\" rotation=\"0.0\" offset=\"0.0\" />");
				}
				out.println("</taggedRectangles>");
			}
			out.println("</image>");
			System.err.println("writing XML file : " + xml_file_name);
			out.close();
			//out.println("</tagset>");
		}
		catch (IOException e) {
			System.err.println ("Error to write XML file\n");
			e.printStackTrace();
		} 

	}
	
	
	public static void toXML (String xml_header_name, String xml_file_name, int width, int height, ArrayList<Atributes> tzones)
	{
		int margin = 2;
		try {
			
			FileOutputStream file = new FileOutputStream(xml_file_name); 

			PrintStream out = new PrintStream(file);

			//out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

			//out.println("<tagset>");

			out.println("<image>");

			out.println("<imageName>" + xml_header_name + "</imageName>");

			out.println("<resolution x=\"" + width + "\" y=\"" + height + "\"/>");
			
			if (tzones.size() <= 0) {
				out.println("<taggedRectangles/>\n");
			}
			else {
				out.println("<taggedRectangles>");
				for (int b = 0; b < tzones.size(); b++) {
					Atributes box = tzones.get(b);
					out.println("<taggedRectangle x=\"" + (box.get_x() - margin) + "\" y=\"" + (box.get_y()-margin) + "\" width=\"" + (box.get_width()+margin+3) + "\" height=\"" + (box.get_height()+margin+3) + "\" label=\"" + box.get_label() + "\" rotation=\"0.0\" offset=\"0.0\"/>");
				}
				out.println("</taggedRectangles>");
			}
			out.println("</image>");
			//System.err.println("writing XML file : " + xml_file_name);
			out.close();
			//out.println("</tagset>");
		}
		catch (IOException e) {
			System.err.println ("Error to write XML file\n");
			e.printStackTrace();
		} 

	}
	
}
