package preprocessing;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;

public class Parser { 

	/*This function ...*/
	public String getLineParameter (LineNumberReader f, String separator, int parameter) {
		String[] s = getTokens (f, separator);
		return s[parameter];
	}

	/*This function ...*/
	public String[] getTokens (LineNumberReader f, String separator) {
		String line = "";
		try {
			if ( (line = f.readLine()) != null) {
				String[] s = breakToken(line, separator); 
				if(!line.trim().isEmpty()) {
					return s;
				}
				else {
					//System.err.println("The line is empty");
					System.exit(1);
				}
			}
			else {
				//System.err.println("The line is null");
				return null;
			}
		}

		catch(Exception e){
			//System.err.println ("The line is null");
			e.printStackTrace();
		}
		return null;
	}
	
	/*This function ...*/
	public String[] Get_Stream_Tokens (BufferedReader f, String separator) {
		String line = "";
		try {
			if ( (line = f.readLine()) != null) {
				String[] s = breakToken(line, separator); 
				if(!line.trim().isEmpty()) {
					return s;
				}
				else {
					//System.err.println("The line is empty");
					return null;
				}
			}
			else {
				//System.err.println("The line is null");
				return null;
			}
		}

		catch(Exception e){
			//System.err.println ("The line is null");
			e.printStackTrace();
		}
		return null;
	}
	
	
	/*This function ...*/
	public String[] breakToken (String s, String separator) {
		String[] S = s.trim().split(separator);
		return S;
	}
	
	
	
	public double[] Get_Data (int size, LineNumberReader file) {
		
		double[] data = new double[size];
		
		for(int i = 0; i < size; i++) {
			String[] s = getTokens (file, "\n");
			data[i] = Double.parseDouble(s[0]);
		}
		return data;
	}
	
	public ArrayList<String> Get_Array_List (String file_parameters) {  
		
		BufferedReader arguments = Open_File_Stream (file_parameters);

		ArrayList<String> list = new ArrayList<String>();

		String[] s = null;
		do {
			s = Get_Stream_Tokens (arguments, " ");
			if (s == null) { break; }
			list.add(s[0]);
		} while (s != null); 

		Close_File_Stream (arguments, file_parameters);
		
		return list;
	}	
	
	public void Write_Print_Stream (PrintStream stream, double[] data) {
		for(int i = 0; i < data.length; i++) {
			stream.printf("%f\n", data[i]);
		}
	}
	
	public void Write_Double_to_int_Print_Stream (PrintStream stream, double[] data) {
		for(int i = 0; i < data.length; i++) {
			stream.printf("%d\n", (int)data[i]);
		}
	}
	
	public LineNumberReader Open_File (String file_name)
    {
    	LineNumberReader file = null;
    	
    	try{ 
    		//System.err.printf("Opening : %s\n", file_name);
    		file = new LineNumberReader(new FileReader(file_name));
    		return file;
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be loaded. ");
    		e.printStackTrace();
    	}
    	return file;
    }
	
	public void Close_File (LineNumberReader file, String file_name)
    {
       	try{ 
    		file.close();
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be closed. ");
    		e.printStackTrace();
    	}
    }
	
	public BufferedReader Open_File_Stream (String file_name)
    {
		BufferedReader file = null;
    	
    	try{ 
    		InputStream stream = new FileInputStream (file_name);
    		//System.err.printf("Opening : %s\n", file_name);
    		file = new BufferedReader(new InputStreamReader(stream));
    		return file;
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be loaded. ");
    		e.printStackTrace();
    	}
    	return file;
    }
	
	public PrintStream Open_Print_Stream (String file_name)
    {
		PrintStream stream = null;
		
    	try{ 
    		FileOutputStream file = new FileOutputStream(file_name);
    		stream = new PrintStream (file);
    		//System.err.printf("Opening : %s\n", file_name);
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be loaded. ");
    		e.printStackTrace();
    	}
    	return stream;
    }
	
	public void Close_Print_Stream (PrintStream file, String file_name)
    {
       	try{ 
    		file.close();
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be closed. ");
    		e.printStackTrace();
    	}
    }
	
	public void Close_File_Stream (BufferedReader file, String file_name)
    {
       	try{ 
    		file.close();
    	}
    	catch(Exception e){
    		System.err.println ("Error: file \"" + file_name + "\" can not be closed. ");
    		e.printStackTrace();
    	}
    } 
	
	
}
