# Last edited on 2010-03-12 22:02:42 by stolfi

JOBNAME := logos-indice
PAPERSIZE := letter

MACROS :=

FIGDIRS := eps
FIGURES := ${wildcard ${addsuffix /*.eps, ${FIGDIRS}}}

.PHONY: all

all: ${JOBNAME}.pdf ${JOBNAME}-icon.jpg

# ----------------------------------------------------------------------
# Viewing programs:
 
DVIVIEW := xdvi

# PSVIEW := ghostview
PSVIEW := gv

# PDFVIEW := acroread
PDFVIEW := gv

# ----------------------------------------------------------------------
# Rules:
 
${JOBNAME}.dvi: ${JOBNAME}.make ${JOBNAME}.tex ${MACROS} ${FIGURES}
	latex ${JOBNAME}
	latex ${JOBNAME}

${JOBNAME}.ps: ${JOBNAME}.dvi ${FIGURES}
	dvips -t ${PAPERSIZE} -o ${JOBNAME}.ps -D600 ${JOBNAME} &&\
        ${PSVIEW} ${JOBNAME}.ps
  
${JOBNAME}.pdf: ${JOBNAME}.ps 
	ps2pdf ${JOBNAME}.ps ${JOBNAME}.pdf &&\
        ${PDFVIEW} ${JOBNAME}.pdf
          
${JOBNAME}-icon.jpg: ${JOBNAME}.pdf
	convert "${JOBNAME}.pdf[0]" -resize '80x' -quality 98 ${JOBNAME}-icon.jpg
	-display ${JOBNAME}-icon.jpg
