# Last edited on 2010-03-13 19:24:10 by stolfi

DERIVED_VERSIONS := \
  logo-unicamp-name-line-blk-red:0480:FFFFFF \
  logo-unicamp-name-line-blk-red:0240:FFFFFF \
  logo-unicamp-name-line-blk-red:0160:FFFFFF \
  logo-unicamp-name-line-blk-red:0120:FFFFFF \
   \
  logo-unicamp-name-line-blk-blk:0480:FFFFFF \
  logo-unicamp-name-line-blk-blk:0240:FFFFFF \
  logo-unicamp-name-line-blk-blk:0160:FFFFFF \
  logo-unicamp-name-line-blk-blk:0120:FFFFFF \
   \
  logo-unicamp-name-line-wht-wht:0480:000000 \
  logo-unicamp-name-line-wht-wht:0240:000000 \
  logo-unicamp-name-line-wht-wht:0160:000000 \
  logo-unicamp-name-line-wht-wht:0120:000000 \
   \
  logo-unicamp-anon-line-blk-red:0480:FFFFFF \
  logo-unicamp-anon-line-blk-red:0240:FFFFFF \
  logo-unicamp-anon-line-blk-red:0160:FFFFFF \
  logo-unicamp-anon-line-blk-red:0120:FFFFFF \
   \
  logo-unicamp-anon-line-blk-blk:0480:FFFFFF \
  logo-unicamp-anon-line-blk-blk:0240:FFFFFF \
  logo-unicamp-anon-line-blk-blk:0160:FFFFFF \
  logo-unicamp-anon-line-blk-blk:0120:FFFFFF \
   \
  logo-unicamp-anon-line-wht-wht:0480:000000 \
  logo-unicamp-anon-line-wht-wht:0240:000000 \
  logo-unicamp-anon-line-wht-wht:0160:000000 \
  logo-unicamp-anon-line-wht-wht:0120:000000 \
   \
  logo-ic-unicamp-slant-tint-blk-sky-ora:0480:FFFFFF \
  logo-ic-unicamp-slant-tint-blk-sky-ora:0240:FFFFFF \
  logo-ic-unicamp-slant-tint-blk-sky-ora:0160:FFFFFF \
  logo-ic-unicamp-slant-tint-blk-sky-ora:0120:FFFFFF \
    \
  logo-ic-unicamp-slant-tint-beg-sky-ora:0480:FFFFFF \
  logo-ic-unicamp-slant-tint-beg-sky-ora:0240:FFFFFF \
  logo-ic-unicamp-slant-tint-beg-sky-ora:0160:FFFFFF \
  logo-ic-unicamp-slant-tint-beg-sky-ora:0120:FFFFFF \
    \
  logo-ic-unicamp-slant-tint-wht-wht-wht:0480:000000 \
  logo-ic-unicamp-slant-tint-wht-wht-wht:0240:000000 \
  logo-ic-unicamp-slant-tint-wht-wht-wht:0160:000000 \
  logo-ic-unicamp-slant-tint-wht-wht-wht:0120:000000 \
   \
  logo-ic-unicamp-slant-line-wht-ash-gry:0480:FFFFFF \
  logo-ic-unicamp-slant-line-wht-ash-gry:0240:FFFFFF \
  logo-ic-unicamp-slant-line-wht-ash-gry:0160:FFFFFF \
  logo-ic-unicamp-slant-line-wht-ash-gry:0120:FFFFFF \
   \
  logo-ic-unicamp-slant-line-wht-wht-wht:0480:FFFFFF \
  logo-ic-unicamp-slant-line-wht-wht-wht:0240:FFFFFF \
  logo-ic-unicamp-slant-line-wht-wht-wht:0160:FFFFFF \
  logo-ic-unicamp-slant-line-wht-wht-wht:0120:FFFFFF \
   \
  logo-ic-unicamp-slant-line-wht-sky-ora:0480:FFFFFF \
  logo-ic-unicamp-slant-line-wht-sky-ora:0240:FFFFFF \
  logo-ic-unicamp-slant-line-wht-sky-ora:0160:FFFFFF \
  logo-ic-unicamp-slant-line-wht-sky-ora:0120:FFFFFF \
   \
  logo-ic-unicamp-slant-line-wht-red-red:0480:FFFFFF \
  logo-ic-unicamp-slant-line-wht-red-red:0240:FFFFFF \
  logo-ic-unicamp-slant-line-wht-red-red:0160:FFFFFF \
  logo-ic-unicamp-slant-line-wht-red-red:0120:FFFFFF \
 
# ACTIONS := clean
# ACTIONS := build-eps show-eps
# ACTIONS := build-eps
# ACTIONS := build-tif
# ACTIONS := debug
# ACTIONS := build-png build-tif build-jpg show-jpg build-eps show-eps
ACTIONS := build-png build-tif build-jpg build-eps

ifeq "/${VERSION_ARGS}" "/" 
######################################################################
# Top-level make

# Actions to perform for each variant:
ACTIONS_SINGLE := ${addsuffix -single,${ACTIONS}}

.PHONY: \
  all debug

all:
	for vs in ${DERIVED_VERSIONS} ; do \
          ${MAKE} -k -f derived-images.make VERSION_ARGS=$$vs ${ACTIONS_SINGLE} dummy ; \
        done

debug:
	@-echo "ACTIONS_SINGLE = ${ACTIONS_SINGLE}"

# End top-level make
######################################################################
else
######################################################################
# For sub-make - caller must define ${VERSION_ARGS}

ARG_FIELDS := ${subst :, ,${VERSION_ARGS}}
VAR :=     ${word 1,${ARG_FIELDS}}
SIZE :=    ${word 2,${ARG_FIELDS}}
BGCOLOR := ${word 3,${ARG_FIELDS}}

PREFIX := 

.PHONY: all dummy debug-single clean-single \
  build-png-single show-png-single \
  build-tif-single show-tif-single \
  build-jpg-single show-jpg-single \
  build-eps-single show-eps-single

IN_PNG_FILE := full/${PREFIX}${VAR}.png

TEMP_PNG_FILE := /tmp/${PREFIX}${VAR}.png

all:
	@echo "make what?"

# ----------------------------------------------------------------------
# EPS version

OUT_EPS_FILE := eps/${PREFIX}${VAR}-${SIZE}.eps

DVIVIEW := xdvi

# PSVIEW := ghostview
PSVIEW := gv

debug-single: 
	@-echo "PREFIX := ${PREFIX}"
	@-echo "VAR    := ${VAR}"
	@-echo "SIZE   := ${SIZE}"

build-eps-single: ${OUT_EPS_FILE}

${OUT_EPS_FILE}: ${IN_PNG_FILE}
	convert \
            \( ${IN_PNG_FILE} -resize '${SIZE}x' \) \
            -size ${SIZE}x${SIZE} xc:'#${BGCOLOR}FF' \
            -compose DstOver \
            -composite ${TEMP_PNG_FILE}
	convert \
            ${TEMP_PNG_FILE} \
            PPM:- \
          | pamdepth 255 \
          | pnmtopsx \
            -rle \
            -noturn \
            -scale '1.00' \
          > ${OUT_EPS_FILE}
	rm ${TEMP_PNG_FILE}
	ls -l ${OUT_EPS_FILE}
        
show-eps-single: ${OUT_EPS_FILE}       
	-${PSVIEW} ${OUT_EPS_FILE}
        
# ----------------------------------------------------------------------
# JPG version

OUT_JPG_FILE := jpg/${PREFIX}${VAR}-${SIZE}.jpg

build-jpg-single: ${OUT_JPG_FILE}

${OUT_JPG_FILE}: ${IN_PNG_FILE}
	convert \
            \( ${IN_PNG_FILE} -resize '${SIZE}x' \) \
            -size ${SIZE}x${SIZE} xc:'#${BGCOLOR}FF' \
            -compose DstOver \
            -quality 98 \
            -composite ${OUT_JPG_FILE}
	ls -l ${OUT_JPG_FILE}
        
show-jpg-single: ${OUT_JPG_FILE}       
	-display ${OUT_JPG_FILE}
        
# ----------------------------------------------------------------------
# PNG version

OUT_PNG_FILE := png/${PREFIX}${VAR}-${SIZE}.png

build-png-single: ${OUT_PNG_FILE}

${OUT_PNG_FILE}: ${IN_PNG_FILE}
	convert \
            ${IN_PNG_FILE} -resize '${SIZE}x' ${OUT_PNG_FILE}
	ls -l ${OUT_PNG_FILE}
        
show-png-single: ${OUT_PNG_FILE}       
	-display ${OUT_PNG_FILE}
        
# ----------------------------------------------------------------------
# TIF version

OUT_TIF_FILE := tif/${PREFIX}${VAR}-${SIZE}.tif

build-tif-single: ${OUT_TIF_FILE}

${OUT_TIF_FILE}: ${IN_PNG_FILE}
	convert \
            \( ${IN_PNG_FILE} -resize '${SIZE}x' \) \
            -size ${SIZE}x${SIZE} xc:'#${BGCOLOR}FF' \
            -compose DstOver \
            -quality 98 \
            -composite ${OUT_TIF_FILE}
	ls -l ${OUT_TIF_FILE}
        
show-tif-single: ${OUT_TIF_FILE}       
	-display ${OUT_TIF_FILE}
        
# ----------------------------------------------------------------------
# Cleanup

clean-single:
	/bin/rm -f '${OUT_EPS_FILE}' '${TEMP_PNG_FILE}' '${OUT_JPG_FILE}' '${OUT_PNG_FILE}' '${OUT_TIF_FILE}'

# ----------------------------------------------------------------------
# Separator:

dummy:
	@-echo "++++++++++++++++++++++++++++++++++++++++++++++++++"

endif
# End ${VERSION_ARGS} section
######################################################################
