# Last edited on 2010-03-13 00:41:21 by stolfi

JOBNAME := letter-example-port
PAPERSIZE := a4

MACROS := \
  letter-data-fpessoa.tex \
  letter-ic.sty \
  logo-ic-unicamp.sty \
  logo-unicamp.sty

FIGURES := \
  logo-ic-unicamp.eps \
  logo-unicamp.eps

.PHONY: all

all: ${JOBNAME}.pdf ${JOBNAME}-icon.jpg

# ----------------------------------------------------------------------
# Viewing programs:
 
DVIVIEW := xdvi

# PSVIEW := ghostview
PSVIEW := gv
 
# PDFVIEW := acroread
PDFVIEW := gv
  
# ----------------------------------------------------------------------
# Rules:
 
${JOBNAME}.dvi: ${JOBNAME}.make ${JOBNAME}.tex ${MACROS} ${FIGURES}
	latex ${JOBNAME}

${JOBNAME}.ps: ${JOBNAME}.dvi ${FIGURES}
	dvips -t ${PAPERSIZE} -D600 -o ${JOBNAME}.ps ${JOBNAME}
	${PSVIEW} ${JOBNAME}.ps
  
${JOBNAME}.pdf: ${JOBNAME}.ps 
	ps2pdf ${JOBNAME}.ps > ${JOBNAME}.pdf
	${PDFVIEW} ${JOBNAME}.pdf
        
${JOBNAME}-icon.jpg: ${JOBNAME}.pdf
	convert "${JOBNAME}.pdf[0]" -resize '80x' -quality 98 ${JOBNAME}-icon.jpg
	-display ${JOBNAME}-icon.jpg
