#! /bin/bash
# Last edited on 2010-03-13 00:09:37 by stolfi

prefix="$1"; shift

# Creates HTML index listings for logos that start with given prefix.
# Looks for files that end with "{PREFIX}-{NAME}-{NNNN}.png"

# Get bare names of all style variants:

variants=( `( cd full && ls ${prefix}*.png ) | sed -e 's:[.]png::g' | sort | uniq | sort -r` )

for v in ${variants[@]} ; do
  printf '  <tr valign=middle>\n'
  printf '    <td valign=middle>\n'
  printf '      <a href="#%s"><img border=0 src="png/%s-0120.png" width="40px"></a>\n' "${v}" "${v}"
  printf '    </td>\n'
  printf '    <td valign=middle>\n'
  printf '      <a href="#%s">%s-*.png</a>\n' "${v}" "${v}"
  printf '    </td>\n'
  printf '  </tr>\n'
done
