#! /bin/bash
# Last edited on 2010-03-13 00:19:08 by stolfi

prefix="$1"; shift

# Creates HTML test entries for logos that start with given prefix.
# Looks for files that end with "{PREFIX}-{NAME}-{NNNN}.png"
# Puts files with same {PREFIX} and {NAME} on same line.

# Get bare names of all style variants:

variants=( `( cd full && ls ${prefix}*.png ) | sed -e 's:[.]png::g' | sort | uniq | sort -r` )

for v in ${variants[@]} ; do
  printf '<a name="%s"/>\n' "${v}"
  printf '<h3>%s-*.png</h3>\n' "${v}"
  printf '\n'
  printf '<table boder=0 cellboder=0>\n'
  printf '  <tr valign=bottom>\n'
  # Get all size versions of the variant ${v}:
  files=(  `( cd png && ls ${v}-*.png ) | sort -r` )
  for f in ${files[@]} ; do 
    printf '    <td><a href="png/%s"><img border=0 align=middle src="png/%s"></a></td>\n' "$f" "$f"
  done
  printf '    <td><a href="full/%s.png"><font size="+5"><b>*</b></font></a></td>\n' "${v}"
  printf '  </tr>\n'
  printf '  <tr valign=bottom>\n'
  for f in ${files[@]} ; do 
    printf '    <td align=center>'
    ff="${f##*-}"
    fff="${ff%.*}"
    printf '%s<br/>' "${fff}"
    printf '[<a href="png/%s">PNG</a>]' "${f}"
    printf '[<a href="tif/%s">TIF</a>]<br/>' "${f%.*}.tif"
    printf '[<a href="eps/%s">EPS</a>]' "${f%.*}.eps"
    printf '[<a href="jpg/%s">JPG</a>]' "${f%.*}.jpg"
    printf '</td>\n'
  done
  printf '    <td>[<a href="%s">FULL</a>]</td>\n' "full/${v}.png"
  printf '  </tr>\n'
  printf '</table>\n'
done
