# Tools to parse G-code files into tool-paths.
# Last edited on 2021-05-17 15:55:40 by jstolfi

import gcode_read_IMP
from gcode_read_IMP import Printer_State_IMP
import path
import move
import move_parms
import sys

class Printer_State(Printer_State_IMP):
  # An object of this class holds the simulated state of the 
  # printer while reading a G-code file.
  #
  # Parameters of the job/printer not usually specified in the G-code:
  # 
  #   {fdiam}  Filament diameter (mm).
  #   {ac}     Acceleration/deceleration at ends of moves (mm/s^2).
  #   {ud}     Trace/jump transition penalty (s).
  #   {zstep}  Layer thickness (mm).
  #   {fname}  File name, for warnings and error messages.
  #
  # Variable parameters usually obtained from the G-code:
  # 
  #   {unit}    Unit of G-code in mm (1 for metric, 25.4 for imperial).
  #   {pabs}    Coordinates in G-code are absolute (true) or relative (false).
  #   {eabs}    Filament position in G-code is absolute (true) or relative (false).
  #   {xyzpos}  Absolute {(X,Y,X)} coordinates, mm.
  #   {epos}    Absolute filament position, mm.
  #   {eret}    Filament retraction distance, mm.
  #   {sp}      Feedrate (cruise speed), mm/s.
  #   {fan}     Cooling fan speed (0-255)
  #   {ntemp}   Nozzle temperature (C).
  #   {btemp}   Bed temperature (C).
  #   {lnum}    Number of lines read so far from file, for messages.
  #
  # The attribute {fname} is a file name used for error messages. The procedure assumes 
  # that lines {1..lnum} of that file have been read and processed already.
  #
  pass
  
def make_state(fdiam, zstep, ac, ud, fname):
  # Creates a {Printer_State} record with the given printer and job parameters,
  # which are usually not specified in the G-code.  The {fname} should include 
  # the extension, and preferably the folder name.
  #
  return gcode_read_IMP.make_state(fdiam, zstep, ac, ud, fname)
  
def set_state(state, unit, pabs, eabs, xyzpos, epos, eret, sp, fan,ntemp,btemp, lnum):
  # Sets the position and other state variables of the printer, usually 
  # from the preamble or other initial section of the G-code file.
  #
  return gcode_read_IMP.set_state(state, unit, pabs, eabs, xyzpos, epos, eret, sp, fan,ntemp,btemp, lnum)

def slice(rd, state):
  # Reads from file {rd} a fragment of G-code file for a single slice.
  # Assumes that {state} is the state as defined by the previous
  # lines of the G-code file, and updates it according to the 
  # fragment read.
  #
  # ??? Change to receive a list of strings (lines) instead of {rd}. ???
  # 
  # Returns that slice in the form of {Path} object {ph}. The moves in
  # the path will use the {Move_Parms} objects storedin the {state}. All
  # coordinates and dimensions in {ph} will have been converted to
  # millimeters, irrespective of the unit specified in the file.
  return gcode_read_IMP.slice(rd, state)

def show_state(wr, state):
  # Prints the {Printer_State} record {state} to file {wr}.
  gcode_read_IMP.show_state(wr, state)

