// Last edited on 2024-06-09 07:54:14 by stolfi

#debug "!! Loading fan_cut_points.inc ...\n"

#macro fan_cut_points(V, E, D, Zp, subfig)
  // Generates all intersections between slicing planes and edges. Parameters:
  //
  // {V}      Array of vertex coordinates {V[1..Nv]}.
  // {E}      Array of edges {E[1..Ne]}.
  // {D}      Array of partition diagonals {D[1..Nd]}.
  // {Zp}     {Z}-coordinates of the slicing planes {Zp[1..Np]}.
  // {subfig} Which sub-figure we are generating.

  #debug "!! Generating edge-plane cut points ...\n"
  
  #local Nv = dimension_size(V, 1) - 1;
  #local Ne = dimension_size(E, 1) - 1;
  #local Nd = dimension_size(D, 1) - 1;
  
  #local vrad = 0.80;
  #local tx = fan_tx_cuts;

  #local cuts = 
    union{
  
      #if (subfig != 3)

        #for (ke,1,Ne)
          fan_cut_points_single(Zp, V, E[ke], vrad, tx)
        #end

        #for (kd,1,Nd)
          fan_cut_points_single(Zp, V, D[kd], vrad, tx)
        #end

      #end
      
      object{ nothing(0.87) }
      object{ nothing(0.85) }
    }

  cuts
#end

#macro fan_cut_points_single(Zp, V, Ek, vrad, tx)
  
  #local Np = dimension_size(Zp, 1) - 1;
  
  #local V_org = V[Ek.x];
  #local V_dst = V[Ek.y];
  
  #if (V_org.z != V_dst.z)
    #for (kp,1,Np)
      #local Zk = Zp[kp];
      #if ((V_org.z-Zk)*(V_dst.z-Zk) <= 0)
        #local s = (Zk - V_org.z)/(V_dst.z - V_org.z);
        #local U = (1-s)*V_org + s*V_dst;
        sphere{ U, vrad texture{ tx } }
      #end
    #end
  #end
#end
  
  
  