import java.awt.*;

// importa a classe de Layout personalizado
import InterfaceLayout;

// Classe: CanvasBotaoArquivoVeiculo
// Autor: Fbio Dalla Vecchia - RA:981091
// Canvas que controla o Botao de abertura de arquivos de veiculos
class CanvasBotaoArquivoVeiculo extends Canvas {
    private int largura;
    private int altura;
    private Image img[] = new Image[2];
    private FileDialog CaixaDialogoVeiculo;
    private int Estado = 0;

    // acessveis ao Applet
    protected boolean BotaoPressionado = false;
    protected String msg = "Abrir arquivo de Veiculos (Arquivo atual: Nenhum)"; 
    protected String ArquivoVeiculo;
    protected boolean msgStatus=false;

    // Construtor
    public CanvasBotaoArquivoVeiculo( int larg,int alt, Image imagem[]) {
        largura = larg;
        altura = alt;
        img[0] = imagem[0];
        img[1] = imagem[1];

        reshape( 0,0,larg,alt );
        }

    // Mouse foi pressionado
    // Retorna o arquivo de veculos aberto
    public boolean mouseDown( Event evt,int x,int y ) {
        BotaoPressionado = true;
        repaint();

        // Abrir Novo arquivo de veiculos
        CaixaDialogoVeiculo = new FileDialog(new Frame(), "Escolha o novo arquivo de Veiculos", FileDialog.LOAD);
        CaixaDialogoVeiculo.setDirectory("."); // seta diretorio corrente
        CaixaDialogoVeiculo.show();
//      ArquivoVeiculo = CaixaDialogoVeiculo.getFile();
        
        if (CaixaDialogoVeiculo.getFile() != null) {
          ArquivoVeiculo = CaixaDialogoVeiculo.getFile(); 
          msg = "Abrir arquivo de Veiculos (Arquivo atual: "+ArquivoVeiculo+")" ;
          System.out.println( msg );
        }
         
        repaint();
        return( true );

        }

    // Boto do mouse foi solto
    public boolean mouseUp( Event evt,int x,int y ) {
        BotaoPressionado = false; // by fdv
        repaint();
        return( true );
        }
                         
    // Quando mouse passa sobre controle, exibimos uma mensagem
    // na linha de estado inferior da tela
    public boolean mouseEnter( Event evt,int x,int y ) {
        //showStatus( "Abrir arquivo de Veiculos" );
        msgStatus=true;
        repaint();
        return( true );
        }

    // Limpa linha de status quando mouse sai do controle
    public boolean mouseExit( Event evt,int x,int y ) {
        BotaoPressionado = false; // by FDV
        //showStatus( "" );
        msgStatus=false;
        repaint();
        return( true );
        }

    public void update( Graphics g ) {
        // Muda estado do controle (pressionado ou no)
        if( !BotaoPressionado )
            Estado = 0;
        else 
            Estado = 1;
        paint( g );
        }

    public void paint( Graphics g ) {
        g.drawImage( img[Estado],0,0,this );
        }
    } 