#declare fan_outer_chain_even_radius = 100.0000;

#declare fan_outer_chain_odd_radius = 100.0000;

#declare fan_inner_chain_even_radius = 0.0000;

#declare fan_inner_chain_odd_radius = 0.0000;

#declare fan_thickness = 9.9996;

#declare fan_min_elevation = 60.00000; // Degrees.

#declare fan_max_elevation = 120.00000; // Degrees.

#declare fan_num_faces = 14;

#declare fan_num_edges = 36;

#declare fan_num_vertices = 24;

#declare fan_num_outer_chain_edges = 10;

#declare fan_num_inner_chain_edges = 0;

#declare fan_outer_chain_shape = 2;

#macro fan_vertices()
  #local Nv = fan_num_vertices;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 4.9998, 50.0000, 86.6026 >; // vo.0.0
  #local V[   2] = < 4.9998, 40.6736, 81.8506 >; // vo.0.1
  #local V[   3] = < 4.9998, 30.9016, 78.0994 >; // vo.0.2
  #local V[   4] = < 4.9998, 20.7912, 75.3904 >; // vo.0.3
  #local V[   5] = < 4.9998, 10.4528, 73.7528 >; // vo.0.4
  #local V[   6] = < 4.9998, 0.0000, 73.2050 >; // vo.0.5
  #local V[   7] = < 4.9998, -10.4528, 73.7528 >; // vo.0.6
  #local V[   8] = < 4.9998, -20.7912, 75.3904 >; // vo.0.7
  #local V[   9] = < 4.9998, -30.9016, 78.0994 >; // vo.0.8
  #local V[  10] = < 4.9998, -40.6736, 81.8506 >; // vo.0.9
  #local V[  11] = < 4.9998, -50.0000, 86.6026 >; // vo.0.10
  #local V[  12] = < 4.9998, 0.0000, 0.0000 >; // vi.0.0
  #local V[  13] = < -4.9998, 50.0000, 86.6026 >; // vo.1.0
  #local V[  14] = < -4.9998, 40.6736, 81.8506 >; // vo.1.1
  #local V[  15] = < -4.9998, 30.9016, 78.0994 >; // vo.1.2
  #local V[  16] = < -4.9998, 20.7912, 75.3904 >; // vo.1.3
  #local V[  17] = < -4.9998, 10.4528, 73.7528 >; // vo.1.4
  #local V[  18] = < -4.9998, 0.0000, 73.2050 >; // vo.1.5
  #local V[  19] = < -4.9998, -10.4528, 73.7528 >; // vo.1.6
  #local V[  20] = < -4.9998, -20.7912, 75.3904 >; // vo.1.7
  #local V[  21] = < -4.9998, -30.9016, 78.0994 >; // vo.1.8
  #local V[  22] = < -4.9998, -40.6736, 81.8506 >; // vo.1.9
  #local V[  23] = < -4.9998, -50.0000, 86.6026 >; // vo.1.10
  #local V[  24] = < -4.9998, 0.0000, 0.0000 >; // vi.1.0
  V
#end

#macro fan_edges()
  #local Ne = fan_num_edges;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   100-199 outer chain edge of plaza [0].
  //   200-299 inner chain edge of plaza [0].
  //   300-399 outer chain edge of plaza [1].
  //   400-499 inner chain edge of plaza [1].
  //   0       other.
  // 
  // The index of the edge in the chain is {ty[ke] % 100}.
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 13, 0 >;
  #local E[   2] = < 13, 14, 300 >;
  #local E[   3] = < 2, 14, 0 >;
  #local E[   4] = < 14, 15, 301 >;
  #local E[   5] = < 3, 15, 0 >;
  #local E[   6] = < 15, 16, 302 >;
  #local E[   7] = < 4, 16, 0 >;
  #local E[   8] = < 16, 17, 303 >;
  #local E[   9] = < 5, 17, 0 >;
  #local E[  10] = < 17, 18, 304 >;
  #local E[  11] = < 6, 18, 0 >;
  #local E[  12] = < 18, 19, 305 >;
  #local E[  13] = < 7, 19, 0 >;
  #local E[  14] = < 19, 20, 306 >;
  #local E[  15] = < 8, 20, 0 >;
  #local E[  16] = < 20, 21, 307 >;
  #local E[  17] = < 9, 21, 0 >;
  #local E[  18] = < 21, 22, 308 >;
  #local E[  19] = < 10, 22, 0 >;
  #local E[  20] = < 22, 23, 309 >;
  #local E[  21] = < 12, 24, 0 >;
  #local E[  22] = < 1, 12, 0 >;
  #local E[  23] = < 11, 23, 0 >;
  #local E[  24] = < 23, 24, 0 >;
  #local E[  25] = < 1, 2, 100 >;
  #local E[  26] = < 2, 3, 101 >;
  #local E[  27] = < 3, 4, 102 >;
  #local E[  28] = < 4, 5, 103 >;
  #local E[  29] = < 5, 6, 104 >;
  #local E[  30] = < 6, 7, 105 >;
  #local E[  31] = < 7, 8, 106 >;
  #local E[  32] = < 8, 9, 107 >;
  #local E[  33] = < 9, 10, 108 >;
  #local E[  34] = < 10, 11, 0 >;
  #local E[  35] = < 11, 12, 0 >;
  #local E[  36] = < 13, 24, 0 >;
  E
#end

#macro fan_faces()
  #local Nf = fan_num_faces;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'plane' (halfspace) POV-ray primitive
  // for {kf} in {1..Nf}.
  // The order is outer chain faces, inner chain faces.
  // inner-outer connecting faces,
  // and finally the plazas.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = plane{  < 0.0000000, -0.4539905, 0.8910065 >, 0 translate < 4.9998, 50.0000, 86.6025 > }
  #local F[   2] = plane{  < 0.0000000, -0.3583679, 0.9335804 >, 0 translate < 4.9998, 40.6737, 81.8505 > }
  #local F[   3] = plane{  < 0.0000000, -0.2588190, 0.9659258 >, 0 translate < 4.9998, 30.9017, 78.0994 > }
  #local F[   4] = plane{  < 0.0000000, -0.1564345, 0.9876883 >, 0 translate < 4.9998, 20.7912, 75.3903 > }
  #local F[   5] = plane{  < 0.0000000, -0.0523360, 0.9986295 >, 0 translate < 4.9998, 10.4528, 73.7529 > }
  #local F[   6] = plane{  < 0.0000000, 0.0523360, 0.9986295 >, 0 translate < 4.9998, 0.0000, 73.2051 > }
  #local F[   7] = plane{  < 0.0000000, 0.1564345, 0.9876883 >, 0 translate < 4.9998, -10.4528, 73.7529 > }
  #local F[   8] = plane{  < 0.0000000, 0.2588190, 0.9659258 >, 0 translate < 4.9998, -20.7912, 75.3903 > }
  #local F[   9] = plane{  < 0.0000000, 0.3583679, 0.9335804 >, 0 translate < 4.9998, -30.9017, 78.0994 > }
  #local F[  10] = plane{  < 0.0000000, 0.4539905, 0.8910065 >, 0 translate < 4.9998, -40.6737, 81.8505 > }
  #local F[  11] = plane{  < 0.0000000, 0.8660254, -0.5000000 >, 0 translate < 4.9998, 0.0000, 0.0000 > }
  #local F[  12] = plane{  < -0.0000000, -0.8660254, -0.5000000 >, 0 translate < 4.9998, -50.0000, 86.6025 > }
  #local F[  13] = plane{  < 1.0000000, 0.0000000, 0.0000000 >, 0 translate < 4.9998, 0.0000, 0.0000 > }
  #local F[  14] = plane{  < -1.0000000, 0.0000000, 0.0000000 >, 0 translate < -4.9998, 0.0000, 0.0000 > }
  F
#end

