function [Mx,yy,zz] = coleta(models,h_ax,amostras)
% Realiza a coleta de pontos para interpolacao de "n" refletores
% por splines cubicas
% Retorna-se em "modelo":
%      => Os pontos dos refletores (modelo.refletores) *
%      => Os pontos interpolados (modelo.entrada)
%      => Informacoes sobre as splines(modelo.splines)
%      => Numero de refletores (modelo.n_refs)
%
% *Os refletores sao discretizados em unidades de abcissa
%  iguais a "dx"

n = models{1}.samp_num;
% Inicializacao de variaveis
%linhas = cell(1,n); % conterah refletores
%linha1=cell(1,n);   % conterah pontos de entrada
spl = cell(1,n);    % conterah informacoes sobre as splines

axes(h_ax);
cla;

%Organizando informacoes em matrizes
[aux models_num] = size(models);
models_num=2;
Mx=[];
Mz=[];
My=[];
for i=1:models_num
	% cada linha corresponde a um "model"
	aux =models{i}.reflector(:,1);
	Mx = [Mx; aux'];
	aux =models{i}.reflector(:,2);
	My = [My; aux'];
	aux =models{i}.reflector(:,3);
	Mz = [Mz; aux'];
end;

[aux l] = size(Mx);
k = floor(l/amostras);

Mx_breaks = zeros(aux,amostras);
My_breaks = zeros(aux,amostras);
Mz_breaks = zeros(aux,amostras);

Mx_breaks(:,1) = Mx(:,1);
Mx_breaks(:,amostras) = Mx(:,l);

My_breaks(:,1) = My(:,1);
My_breaks(:,amostras) = My(:,l);

Mz_breaks(:,1) = Mz(:,1);
Mz_breaks(:,amostras) = Mz(:,l);

for i=2:amostras-1
	Mx_breaks(:,i)=Mx(:,(i-1)*k);
	My_breaks(:,i)=My(:,(i-1)*k);
	Mz_breaks(:,i)=Mz(:,(i-1)*k);
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

zz=[];
yylim = [min(My(:,i)), max(My(:,i))];
dy = ceil((yylim(2) - yylim(1))/ models{1}.samp_num);
for i=1:n
	% Obtencao dos valores das splines
	yy= yylim(1): dy :yylim(2) ;
	zz=[zz;spline(My(:,i),Mz(:,i),yy)];

	%spl{i} = % Obtencao das informacoes das splines


    % Plotando refletor "i" com cor relacionada a "i"
    %h=plot(xx,yy);
    %set(h,'Color',[1/i 0 0]);
    %surf(Mx,My,zz);


end;

% Atribuicao dos valores de retorno
%model.reflector = linhas;
%model.breaks = linha1;
%model.splines = spl;
%model.ref_num = n;



