/*
 * Decompiled with CFR 0.152.
 */
package Hack.VMEmulator;

import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.InteractiveComputerPart;
import Hack.Controller.ProgramException;
import Hack.Events.ErrorEventListener;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import Hack.Utilities.HackFileFilter;
import Hack.VMEmulator.VMEmulatorInstruction;
import Hack.VMEmulator.VMProgramGUI;
import Hack.VirtualMachine.HVMInstructionSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class VMProgram
extends InteractiveComputerPart
implements ProgramEventListener {
    public static final short BUILTIN_FUNCTION_ADDRESS = -1;
    private static final int BUILTIN_ACCESS_UNDECIDED = 0;
    private static final int BUILTIN_ACCESS_AUTHORIZED = 1;
    private static final int BUILTIN_ACCESS_DENIED = 2;
    private Vector listeners;
    private VMEmulatorInstruction[] instructions;
    private int instructionsLength;
    private int visibleInstructionsLength;
    private short nextPC;
    private short currentPC;
    private short prevPC;
    private VMProgramGUI gui;
    private short startAddress;
    private Hashtable staticRange;
    private Hashtable functions;
    private short infiniteLoopForBuiltInsAddress;
    private int currentStaticIndex;
    private int largestStaticIndex;
    private int builtInAccessStatus;
    private boolean isSlashStar;

    public VMProgram(VMProgramGUI vMProgramGUI) {
        super(vMProgramGUI != null);
        this.gui = vMProgramGUI;
        this.listeners = new Vector();
        this.staticRange = new Hashtable();
        this.functions = new Hashtable();
        if (this.hasGUI) {
            vMProgramGUI.addProgramListener(this);
            vMProgramGUI.addErrorListener((ErrorEventListener)this);
        }
        this.reset();
    }

    public void loadProgram(String string) throws ProgramException {
        short s;
        String string2;
        int n;
        File[] fileArray;
        File file = new File(string);
        if (!file.exists()) {
            throw new ProgramException("cannot find " + string);
        }
        if (file.isDirectory()) {
            fileArray = file.listFiles((FilenameFilter)new HackFileFilter(".vm"));
            if (fileArray == null || fileArray.length == 0) {
                throw new ProgramException("No vm files found in " + string);
            }
        } else {
            fileArray = new File[]{file};
        }
        if (this.displayChanges) {
            this.gui.showMessage("Loading...");
        }
        this.staticRange.clear();
        this.functions.clear();
        this.builtInAccessStatus = 0;
        Hashtable hashtable = new Hashtable();
        this.nextPC = 0;
        for (n = 0; n < fileArray.length; ++n) {
            String string3 = fileArray[n].getName();
            string2 = string3.substring(0, string3.indexOf("."));
            this.staticRange.put(string2, new Boolean(true));
            try {
                this.updateSymbolTable(fileArray[n], hashtable, this.functions);
                continue;
            }
            catch (ProgramException programException) {
                if (this.displayChanges) {
                    this.gui.hideMessage();
                }
                throw new ProgramException(string3 + ": " + programException.getMessage());
            }
        }
        n = 0;
        if ((file.isDirectory() || hashtable.get("Main.main") != null) && hashtable.get("Sys.init") == null) {
            n = 1;
            this.getAddress("Sys.init");
            this.nextPC = (short)(this.nextPC + 1);
        }
        this.instructions = new VMEmulatorInstruction[this.nextPC + 4];
        this.nextPC = 0;
        this.currentStaticIndex = 16;
        for (s = 0; s < fileArray.length; ++s) {
            string2 = fileArray[s].getName();
            String string4 = string2.substring(0, string2.indexOf("."));
            this.largestStaticIndex = -1;
            int[] nArray = new int[2];
            nArray[0] = this.currentStaticIndex;
            try {
                this.buildProgram(fileArray[s], hashtable);
            }
            catch (ProgramException programException) {
                if (this.displayChanges) {
                    this.gui.hideMessage();
                }
                throw new ProgramException(string2 + ": " + programException.getMessage());
            }
            this.currentStaticIndex += this.largestStaticIndex + 1;
            nArray[1] = this.currentStaticIndex - 1;
            this.staticRange.put(string4, nArray);
        }
        short s2 = this.nextPC;
        this.visibleInstructionsLength = s2;
        this.instructionsLength = s2;
        if (this.builtInAccessStatus == 1) {
            this.instructionsLength += 4;
            if (n != 0) {
                ++this.instructionsLength;
            }
            s = 0;
            this.instructions[this.nextPC] = new VMEmulatorInstruction(13, (short)this.instructionsLength, s);
            this.instructions[this.nextPC].setStringArg("afterInvisibleCode");
            this.nextPC = (short)(this.nextPC + 1);
            this.instructions[this.nextPC] = new VMEmulatorInstruction(12, -1);
            this.instructions[this.nextPC].setStringArg("infiniteLoopForBuiltIns");
            this.infiniteLoopForBuiltInsAddress = this.nextPC = (short)(this.nextPC + 1);
            s = (short)(s + 1);
            this.instructions[this.nextPC] = new VMEmulatorInstruction(13, this.nextPC, s);
            this.instructions[this.nextPC].setStringArg("infiniteLoopForBuiltIns");
            this.nextPC = (short)(this.nextPC + 1);
            if (n != 0) {
                s = (short)(s + 1);
                this.instructions[this.nextPC] = new VMEmulatorInstruction(17, this.getAddress("Sys.init"), 0, s);
                this.instructions[this.nextPC].setStringArg("Sys.init");
                this.startAddress = this.nextPC;
                this.nextPC = (short)(this.nextPC + 1);
            }
            this.instructions[this.nextPC] = new VMEmulatorInstruction(12, -1);
            this.instructions[this.nextPC].setStringArg("afterInvisibleCode");
            this.nextPC = (short)(this.nextPC + 1);
        }
        if (n == 0) {
            Short s3 = (Short)hashtable.get("Sys.init");
            this.startAddress = s3 == null ? (short)0 : s3;
        }
        if (this.displayChanges) {
            this.gui.hideMessage();
        }
        this.nextPC = this.startAddress;
        this.setGUIContents();
        this.notifyProgramListeners((byte)1, string);
    }

    private void updateSymbolTable(File file, Hashtable hashtable, Hashtable hashtable2) throws ProgramException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProgramException("file " + file.getName() + " does not exist");
        }
        String string = null;
        int n = 0;
        this.isSlashStar = false;
        try {
            String string2;
            while ((string2 = this.unCommentLine(bufferedReader.readLine())) != null) {
                StringTokenizer stringTokenizer;
                ++n;
                if (string2.trim().equals("")) continue;
                if (string2.startsWith("function ")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    if (hashtable.containsKey(string)) {
                        throw new ProgramException("subroutine " + string + " already exists");
                    }
                    hashtable2.put(string, new Short(this.nextPC));
                    hashtable.put(string, new Short(this.nextPC));
                } else if (string2.startsWith("label ")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    String string3 = string + "$" + stringTokenizer.nextToken();
                    hashtable.put(string3, new Short((short)(this.nextPC + 1)));
                }
                this.nextPC = (short)(this.nextPC + 1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ProgramException("Error while reading from file");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ProgramException("In line " + n + ": unexpected end of command");
        }
        if (this.isSlashStar) {
            throw new ProgramException("Unterminated /* comment at end of file");
        }
    }

    private void buildProgram(File file, Hashtable hashtable) throws ProgramException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProgramException("file does not exist");
        }
        int n = 0;
        String string = null;
        short s = 0;
        short s2 = this.nextPC;
        HVMInstructionSet hVMInstructionSet = HVMInstructionSet.getInstance();
        this.isSlashStar = false;
        try {
            String string2;
            while ((string2 = this.unCommentLine(bufferedReader.readLine())) != null) {
                ++n;
                if (!string2.trim().equals("")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    String string3 = stringTokenizer.nextToken();
                    byte by = hVMInstructionSet.instructionStringToCode(string3);
                    if (by == -99) {
                        throw new ProgramException("in line " + n + ": unknown instruction - " + string3);
                    }
                    switch (by) {
                        case 10: {
                            short s3;
                            String string4 = stringTokenizer.nextToken();
                            try {
                                s3 = this.translateSegment(string4, hVMInstructionSet, file.getName());
                            }
                            catch (ProgramException programException) {
                                throw new ProgramException("in line " + n + programException.getMessage());
                            }
                            short s4 = Short.parseShort(stringTokenizer.nextToken());
                            if (s4 < 0) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            if (s3 == 100 && s4 > this.largestStaticIndex) {
                                this.largestStaticIndex = s4;
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s4, s);
                            break;
                        }
                        case 11: {
                            short s3;
                            int n2 = stringTokenizer.countTokens();
                            String string4 = stringTokenizer.nextToken();
                            try {
                                s3 = this.translateSegment(string4, hVMInstructionSet, file.getName());
                            }
                            catch (ProgramException programException) {
                                throw new ProgramException("in line " + n + programException.getMessage());
                            }
                            short s4 = Short.parseShort(stringTokenizer.nextToken());
                            if (s4 < 0) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            if (s3 == 100 && s4 > this.largestStaticIndex) {
                                this.largestStaticIndex = s4;
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s4, s);
                            break;
                        }
                        case 15: {
                            string = stringTokenizer.nextToken();
                            s = 0;
                            short s3 = Short.parseShort(stringTokenizer.nextToken());
                            if (s3 < 0) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s);
                            this.instructions[s2].setStringArg(string);
                            break;
                        }
                        case 17: {
                            short s3;
                            String string5 = stringTokenizer.nextToken();
                            try {
                                s3 = this.getAddress(string5);
                            }
                            catch (ProgramException programException) {
                                throw new ProgramException("in line " + n + ": " + programException.getMessage());
                            }
                            short s4 = Short.parseShort(stringTokenizer.nextToken());
                            if (s4 < 0 || (s3 < 0 || s3 > 32768) && s3 != -1) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s4, s);
                            this.instructions[s2].setStringArg(string5);
                            break;
                        }
                        case 12: {
                            String string6 = string + "$" + stringTokenizer.nextToken();
                            this.instructions[s2] = new VMEmulatorInstruction(by, -1);
                            this.instructions[s2].setStringArg(string6);
                            s = (short)(s - 1);
                            break;
                        }
                        case 13: {
                            String string6 = string + "$" + stringTokenizer.nextToken();
                            Short s5 = (Short)hashtable.get(string6);
                            if (s5 == null) {
                                throw new ProgramException("in line " + n + ": Unknown label - " + string6);
                            }
                            short s3 = s5;
                            if (s3 < 0 || s3 > 32768) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s);
                            this.instructions[s2].setStringArg(string6);
                            break;
                        }
                        case 14: {
                            String string6 = string + "$" + stringTokenizer.nextToken();
                            Short s5 = (Short)hashtable.get(string6);
                            if (s5 == null) {
                                throw new ProgramException("in line " + n + ": Unknown label - " + string6);
                            }
                            short s3 = s5;
                            if (s3 < 0 || s3 > 32768) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s);
                            this.instructions[s2].setStringArg(string6);
                            break;
                        }
                        default: {
                            if (stringTokenizer.countTokens() == 0) {
                                this.instructions[s2] = new VMEmulatorInstruction(by, s);
                                break;
                            }
                            short s3 = Short.parseShort(stringTokenizer.nextToken());
                            if (s3 < 0) {
                                throw new ProgramException("in line " + n + ": Illegal argument - " + string2);
                            }
                            this.instructions[s2] = new VMEmulatorInstruction(by, s3, s);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        throw new ProgramException("in line " + n + ": Too many arguments - " + string2);
                    }
                    s2 = (short)(s2 + 1);
                    s = (short)(s + 1);
                }
                this.nextPC = s2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ProgramException("Error while reading from file");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProgramException("Illegal 16-bit value");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ProgramException("In line " + n + ": unexpected end of command");
        }
        if (this.isSlashStar) {
            throw new ProgramException("Unterminated /* comment at end of file");
        }
    }

    private String unCommentLine(String string) {
        String string2 = string;
        if (string != null) {
            if (this.isSlashStar) {
                int n = string.indexOf("*/");
                if (n >= 0) {
                    this.isSlashStar = false;
                    string2 = this.unCommentLine(string.substring(n + 2));
                } else {
                    string2 = "";
                }
            } else {
                int n = string.indexOf("//");
                int n2 = string.indexOf("/*");
                if (n >= 0 && (n2 < 0 || n2 > n)) {
                    string2 = string.substring(0, n);
                } else if (n2 >= 0) {
                    this.isSlashStar = true;
                    string2 = string.substring(0, n2) + this.unCommentLine(string.substring(n2 + 2));
                }
            }
        }
        return string2;
    }

    public int[] getStaticRange(String string) {
        return (int[])this.staticRange.get(string);
    }

    public int getSize() {
        return this.instructionsLength;
    }

    public short getAddress(String string) throws ProgramException {
        Short s = (Short)this.functions.get(string);
        if (s != null) {
            return s;
        }
        String string2 = string.substring(0, string.indexOf("."));
        if (this.staticRange.get(string2) == null) {
            if (this.builtInAccessStatus == 0) {
                this.builtInAccessStatus = this.hasGUI && this.gui.confirmBuiltInAccess() ? 1 : 2;
            }
            if (this.builtInAccessStatus == 1) {
                return -1;
            }
        }
        throw new ProgramException(string2 + ".vm not found " + "or function " + string + " not found in " + string2 + ".vm");
    }

    public short getPC() {
        return this.nextPC;
    }

    public short getCurrentPC() {
        return this.currentPC;
    }

    public short getPreviousPC() {
        return this.prevPC;
    }

    public void setPC(short s) {
        this.prevPC = this.currentPC;
        this.currentPC = this.nextPC;
        this.nextPC = s;
        this.setGUIPC();
    }

    public void setPCToInfiniteLoopForBuiltIns(String string) {
        if (this.hasGUI) {
            this.gui.notify(string);
        }
        this.setPC(this.infiniteLoopForBuiltInsAddress);
    }

    public VMEmulatorInstruction getNextInstruction() {
        VMEmulatorInstruction vMEmulatorInstruction = null;
        if (this.nextPC < this.instructionsLength) {
            vMEmulatorInstruction = this.instructions[this.nextPC];
            this.prevPC = this.currentPC;
            this.currentPC = this.nextPC;
            do {
                this.nextPC = (short)(this.nextPC + 1);
            } while (this.nextPC < this.instructionsLength && this.instructions[this.nextPC].getOpCode() == 12);
            this.setGUIPC();
        }
        return vMEmulatorInstruction;
    }

    public void restartProgram() {
        this.currentPC = (short)-999;
        this.prevPC = (short)-999;
        this.nextPC = this.startAddress;
        this.setGUIPC();
    }

    public void reset() {
        this.instructions = new VMEmulatorInstruction[0];
        this.instructionsLength = 0;
        this.visibleInstructionsLength = 0;
        this.currentPC = (short)-999;
        this.prevPC = (short)-999;
        this.nextPC = (short)-1;
        this.setGUIContents();
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public void programChanged(ProgramEvent programEvent) {
        switch (programEvent.getType()) {
            case 1: {
                LoadProgramTask loadProgramTask = new LoadProgramTask(programEvent.getProgramFileName());
                Thread thread = new Thread(loadProgramTask);
                thread.start();
                break;
            }
            case 3: {
                this.reset();
                this.notifyProgramListeners((byte)3, null);
            }
        }
    }

    private byte translateSegment(String string, HVMInstructionSet hVMInstructionSet, String string2) throws ProgramException {
        byte by = hVMInstructionSet.segmentVMStringToCode(string);
        if (by == -1) {
            throw new ProgramException(": Illegal memory segment - " + string);
        }
        return by;
    }

    private void setGUIContents() {
        if (this.displayChanges) {
            this.gui.setContents(this.instructions, this.visibleInstructionsLength);
            this.gui.setCurrentInstruction(this.nextPC);
        }
    }

    private void setGUIPC() {
        if (this.displayChanges) {
            this.gui.setCurrentInstruction(this.nextPC);
        }
    }

    public void refreshGUI() {
        if (this.displayChanges) {
            this.gui.setContents(this.instructions, this.visibleInstructionsLength);
            this.gui.setCurrentInstruction(this.nextPC);
        }
    }

    public void addProgramListener(ProgramEventListener programEventListener) {
        this.listeners.add(programEventListener);
    }

    public void removeProgramListener(ProgramEventListener programEventListener) {
        this.listeners.remove(programEventListener);
    }

    protected void notifyProgramListeners(byte by, String string) {
        ProgramEvent programEvent = new ProgramEvent((Object)this, by, string);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ProgramEventListener)this.listeners.elementAt(i)).programChanged(programEvent);
        }
    }

    class LoadProgramTask
    implements Runnable {
        private String fileName;

        public LoadProgramTask(String string) {
            this.fileName = string;
        }

        public void run() {
            VMProgram.this.clearErrorListeners();
            try {
                VMProgram.this.loadProgram(this.fileName);
            }
            catch (ProgramException programException) {
                VMProgram.this.notifyErrorListeners(programException.getMessage());
            }
        }
    }
}

