/*
 * Decompiled with CFR 0.152.
 */
package Hack.HardwareSimulator;

import Hack.Controller.ControllerException;
import Hack.Controller.ControllerGUI;
import Hack.Controller.HackController;
import Hack.Controller.HackSimulator;
import Hack.Controller.ScriptException;
import Hack.Gates.GateException;
import Hack.Gates.GatesManager;
import Hack.HardwareSimulator.HardwareSimulator;
import Hack.HardwareSimulator.HardwareSimulatorControllerGUI;
import java.io.File;

public class HardwareSimulatorController
extends HackController {
    public HardwareSimulatorController(HardwareSimulatorControllerGUI hardwareSimulatorControllerGUI, HardwareSimulator hardwareSimulator, String string) throws ScriptException, ControllerException {
        super((ControllerGUI)hardwareSimulatorControllerGUI, (HackSimulator)hardwareSimulator, string);
        hardwareSimulatorControllerGUI.disableEval();
        hardwareSimulatorControllerGUI.disableTickTock();
    }

    protected void updateProgramFile(String string) {
        super.updateProgramFile(string);
        File file = new File(string).getParentFile();
        GatesManager.getInstance().setWorkingDir(file);
    }

    protected void doUnknownAction(byte by, Object object) {
        switch (by) {
            case 102: {
                File file = (File)object;
                this.updateProgramFile(file.getPath());
                if (!this.singleStepLocked) {
                    this.reloadDefaultScript();
                }
                LoadChipTask loadChipTask = new LoadChipTask(file.getPath());
                Thread thread = new Thread(loadChipTask);
                thread.start();
                break;
            }
            case 101: {
                ((HardwareSimulator)this.simulator).runEvalTask();
                break;
            }
            case 100: {
                ((HardwareSimulator)this.simulator).runTickTockTask();
                break;
            }
            case 107: {
                ((HardwareSimulatorControllerGUI)this.gui).disableEval();
                break;
            }
            case 108: {
                ((HardwareSimulatorControllerGUI)this.gui).enableEval();
                break;
            }
            case 105: {
                ((HardwareSimulatorControllerGUI)this.gui).disableTickTock();
                ((HardwareSimulatorControllerGUI)this.gui).disableTickTock();
                break;
            }
            case 106: {
                ((HardwareSimulatorControllerGUI)this.gui).enableTickTock();
            }
        }
    }

    class LoadChipTask
    implements Runnable {
        private String chipName;

        public LoadChipTask(String string) {
            this.chipName = string;
        }

        public void run() {
            try {
                ((HardwareSimulator)HardwareSimulatorController.this.simulator).loadGate(this.chipName, true);
            }
            catch (GateException gateException) {
                HardwareSimulatorController.this.gui.displayMessage(gateException.getMessage(), true);
            }
        }
    }
}

