/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.BuiltInGateClass;
import Hack.Gates.CompositeGateClass;
import Hack.Gates.Gate;
import Hack.Gates.GatesManager;
import Hack.Gates.HDLException;
import Hack.Gates.HDLTokenizer;
import Hack.Gates.PinInfo;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public abstract class GateClass {
    public static final byte UNKNOWN_PIN_TYPE = 0;
    public static final byte INPUT_PIN_TYPE = 1;
    public static final byte OUTPUT_PIN_TYPE = 2;
    protected PinInfo[] inputPinsInfo;
    protected PinInfo[] outputPinsInfo;
    protected String name;
    protected boolean isClocked;
    protected boolean[] isInputClocked;
    protected boolean[] isOutputClocked;
    protected Hashtable namesToTypes = new Hashtable();
    protected Hashtable namesToNumbers = new Hashtable();
    protected static Hashtable GateClasses = new Hashtable();

    protected GateClass(String string, PinInfo[] pinInfoArray, PinInfo[] pinInfoArray2) {
        this.name = string;
        this.inputPinsInfo = pinInfoArray;
        this.registerPins(pinInfoArray, (byte)1);
        this.outputPinsInfo = pinInfoArray2;
        this.registerPins(pinInfoArray2, (byte)2);
    }

    public static GateClass getGateClass(String string, boolean bl) throws HDLException {
        Object object;
        String string2 = null;
        if (!bl) {
            string2 = GatesManager.getInstance().getHDLFileName(string);
            if (string2 == null) {
                throw new HDLException("Chip " + string + " is not found in the working and built in folders");
            }
        } else {
            string2 = string;
            object = new File(string2);
            if (!((File)object).exists()) {
                throw new HDLException("Chip " + string2 + " doesn't exist");
            }
            string = ((File)object).getName().substring(0, ((File)object).getName().lastIndexOf("."));
        }
        if ((object = (GateClass)GateClasses.get(string2)) == null) {
            HDLTokenizer hDLTokenizer = new HDLTokenizer(string2);
            object = GateClass.readHDL(hDLTokenizer, string);
            GateClasses.put(string2, object);
        }
        return object;
    }

    public static void clearGateCache() {
        GateClasses.clear();
    }

    public static boolean gateClassExists(String string) {
        String string2 = GatesManager.getInstance().getHDLFileName(string);
        return GateClasses.get(string2) != null;
    }

    private static GateClass readHDL(HDLTokenizer hDLTokenizer, String string) throws HDLException {
        PinInfo[] pinInfoArray;
        PinInfo[] pinInfoArray2;
        String string2;
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() != 1 || hDLTokenizer.getKeywordType() != 1) {
            hDLTokenizer.HDLError("Missing 'CHIP' keyword");
        }
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() != 3) {
            hDLTokenizer.HDLError("Missing chip name");
        }
        if (!string.equals(string2 = hDLTokenizer.getIdentifier())) {
            hDLTokenizer.HDLError("Chip name doesn't match the HDL name");
        }
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != '{') {
            hDLTokenizer.HDLError("Missing '{'");
        }
        hDLTokenizer.advance();
        if (hDLTokenizer.getTokenType() == 1 && hDLTokenizer.getKeywordType() == 2) {
            pinInfoArray2 = GateClass.getPinsInfo(hDLTokenizer, GateClass.readPinNames(hDLTokenizer));
            hDLTokenizer.advance();
        } else {
            pinInfoArray2 = new PinInfo[]{};
        }
        if (hDLTokenizer.getTokenType() == 1 && hDLTokenizer.getKeywordType() == 3) {
            pinInfoArray = GateClass.getPinsInfo(hDLTokenizer, GateClass.readPinNames(hDLTokenizer));
            hDLTokenizer.advance();
        } else {
            pinInfoArray = new PinInfo[]{};
        }
        GateClass gateClass = null;
        if (hDLTokenizer.getTokenType() == 1 && hDLTokenizer.getKeywordType() == 4) {
            gateClass = new BuiltInGateClass(string, hDLTokenizer, pinInfoArray2, pinInfoArray);
        } else if (hDLTokenizer.getTokenType() == 1 && hDLTokenizer.getKeywordType() == 6) {
            gateClass = new CompositeGateClass(string, hDLTokenizer, pinInfoArray2, pinInfoArray);
        } else {
            hDLTokenizer.HDLError("Keyword expected");
        }
        return gateClass;
    }

    protected static String[] readPinNames(HDLTokenizer hDLTokenizer) throws HDLException {
        Object object;
        Vector<String[]> vector = new Vector<String[]>();
        boolean bl = false;
        hDLTokenizer.advance();
        while (!bl) {
            if (hDLTokenizer.getTokenType() == 2 && hDLTokenizer.getSymbol() == ';') {
                bl = true;
                continue;
            }
            if (hDLTokenizer.getTokenType() != 3) {
                hDLTokenizer.HDLError("Pin name expected");
            }
            object = hDLTokenizer.getIdentifier();
            vector.addElement((String[])object);
            hDLTokenizer.advance();
            if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != ',' && hDLTokenizer.getSymbol() != ';') {
                hDLTokenizer.HDLError("',' or ';' expected");
            }
            if (hDLTokenizer.getTokenType() != 2 || hDLTokenizer.getSymbol() != ',') continue;
            hDLTokenizer.advance();
        }
        object = new String[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    private static PinInfo[] getPinsInfo(HDLTokenizer hDLTokenizer, String[] stringArray) throws HDLException {
        PinInfo[] pinInfoArray = new PinInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pinInfoArray[i] = new PinInfo();
            int n = stringArray[i].indexOf("[");
            if (n >= 0) {
                try {
                    String string = stringArray[i].substring(n + 1, stringArray[i].indexOf("]"));
                    pinInfoArray[i].width = (byte)Integer.parseInt(string);
                    pinInfoArray[i].name = stringArray[i].substring(0, n);
                }
                catch (Exception exception) {
                    hDLTokenizer.HDLError(stringArray[i] + " has an invalid bus width");
                }
                continue;
            }
            pinInfoArray[i].width = 1;
            pinInfoArray[i].name = stringArray[i];
        }
        return pinInfoArray;
    }

    public PinInfo getPinInfo(byte by, int n) {
        PinInfo pinInfo = null;
        switch (by) {
            case 1: {
                if (n >= this.inputPinsInfo.length) break;
                pinInfo = this.inputPinsInfo[n];
                break;
            }
            case 2: {
                if (n >= this.outputPinsInfo.length) break;
                pinInfo = this.outputPinsInfo[n];
            }
        }
        return pinInfo;
    }

    public PinInfo getPinInfo(String string) {
        byte by = this.getPinType(string);
        int n = this.getPinNumber(string);
        return this.getPinInfo(by, n);
    }

    protected void registerPins(PinInfo[] pinInfoArray, byte by) {
        for (int i = 0; i < pinInfoArray.length; ++i) {
            this.namesToTypes.put(pinInfoArray[i].name, new Byte(by));
            this.namesToNumbers.put(pinInfoArray[i].name, new Integer(i));
        }
    }

    protected void registerPin(PinInfo pinInfo, byte by, int n) {
        this.namesToTypes.put(pinInfo.name, new Byte(by));
        this.namesToNumbers.put(pinInfo.name, new Integer(n));
    }

    public byte getPinType(String string) {
        Byte by = (Byte)this.namesToTypes.get(string);
        return by != null ? by : (byte)0;
    }

    public int getPinNumber(String string) {
        Integer n = (Integer)this.namesToNumbers.get(string);
        return n != null ? n : -1;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClocked() {
        return this.isClocked;
    }

    public abstract Gate newInstance() throws InstantiationException;
}

