/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.DirtyGateListener;
import Hack.Gates.GateClass;
import Hack.Gates.Node;
import java.util.Vector;

public abstract class Gate {
    public static final Node TRUE_NODE = new Node(-1);
    public static final Node FALSE_NODE = new Node(0);
    public static final Node CLOCK_NODE = new Node();
    protected Node[] inputPins;
    protected Node[] outputPins;
    protected GateClass gateClass;
    protected boolean isDirty;
    private Vector dirtyGateListeners;

    public void addDirtyGateListener(DirtyGateListener dirtyGateListener) {
        if (this.dirtyGateListeners == null) {
            this.dirtyGateListeners = new Vector(1, 1);
        }
        this.dirtyGateListeners.add(dirtyGateListener);
    }

    public void removeDirtyGateListener(DirtyGateListener dirtyGateListener) {
        if (this.dirtyGateListeners != null) {
            this.dirtyGateListeners.remove(dirtyGateListener);
        }
    }

    protected abstract void reCompute();

    protected abstract void clockUp();

    protected abstract void clockDown();

    public void setDirty() {
        this.isDirty = true;
        if (this.dirtyGateListeners != null) {
            for (int i = 0; i < this.dirtyGateListeners.size(); ++i) {
                ((DirtyGateListener)this.dirtyGateListeners.elementAt(i)).gotDirty();
            }
        }
    }

    public GateClass getGateClass() {
        return this.gateClass;
    }

    public Node getNode(String string) {
        Node node = null;
        byte by = this.gateClass.getPinType(string);
        int n = this.gateClass.getPinNumber(string);
        switch (by) {
            case 1: {
                node = this.inputPins[n];
                break;
            }
            case 2: {
                node = this.outputPins[n];
            }
        }
        return node;
    }

    public Node[] getInputNodes() {
        return this.inputPins;
    }

    public Node[] getOutputNodes() {
        return this.outputPins;
    }

    public void eval() {
        if (this.isDirty) {
            this.doEval();
        }
    }

    private void doEval() {
        if (this.isDirty) {
            this.isDirty = false;
            if (this.dirtyGateListeners != null) {
                for (int i = 0; i < this.dirtyGateListeners.size(); ++i) {
                    ((DirtyGateListener)this.dirtyGateListeners.elementAt(i)).gotClean();
                }
            }
        }
        this.reCompute();
    }

    public void tick() {
        this.doEval();
        this.clockUp();
    }

    public void tock() {
        this.clockDown();
        this.doEval();
    }
}

