/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.Assembler.AssemblerException;
import Hack.Assembler.HackAssemblerTranslator;
import Hack.CPUEmulator.ROMGUI;
import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.PointedMemory;
import Hack.ComputerParts.PointedMemoryGUI;
import Hack.Controller.ProgramException;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import java.util.Vector;

public class ROM
extends PointedMemory
implements ProgramEventListener {
    public static final int DECIMAL_FORMAT = 0;
    public static final int HEXA_FORMAT = 1;
    public static final int BINARY_FORMAT = 2;
    public static final int ASM_FORMAT = 4;
    private Vector listeners;

    public ROM(ROMGUI rOMGUI) {
        super(32768, (PointedMemoryGUI)rOMGUI);
        this.setNullValue((short)Short.MIN_VALUE, true);
        this.listeners = new Vector();
        if (this.hasGUI) {
            rOMGUI.addProgramListener(this);
            rOMGUI.setNumericFormat(4);
        }
    }

    public synchronized void loadProgram(String string) throws ProgramException {
        short[] sArray = null;
        if (this.displayChanges) {
            ((ROMGUI)this.gui).showMessage("Loading...");
        }
        try {
            sArray = HackAssemblerTranslator.loadProgram((String)string, (int)32768, (short)Short.MIN_VALUE);
            this.mem = sArray;
            if (this.displayChanges) {
                this.gui.setContents(this.mem);
                ((ROMGUI)this.gui).setProgram(string);
                ((ROMGUI)this.gui).hideMessage();
                this.gui.hideHighlight();
            }
            this.notifyProgramListeners((byte)1, string);
        }
        catch (AssemblerException assemblerException) {
            if (this.displayChanges) {
                ((ROMGUI)this.gui).hideMessage();
            }
            throw new ProgramException(assemblerException.getMessage());
        }
    }

    public void programChanged(ProgramEvent programEvent) {
        switch (programEvent.getType()) {
            case 1: {
                ROMLoadProgramTask rOMLoadProgramTask = new ROMLoadProgramTask(programEvent.getProgramFileName());
                Thread thread = new Thread(rOMLoadProgramTask);
                thread.start();
                break;
            }
            case 3: {
                this.notifyProgramListeners((byte)3, null);
            }
        }
    }

    public void valueChanged(ComputerPartEvent computerPartEvent) {
        short s = computerPartEvent.getValue();
        int n = computerPartEvent.getIndex();
        this.clearErrorListeners();
        try {
            HackAssemblerTranslator.getInstance().codeToText(s);
            this.setValueAt(n, s, true);
        }
        catch (AssemblerException assemblerException) {
            this.notifyErrorListeners("Illegal instruction");
            this.quietUpdateGUI(n, this.mem[n]);
        }
    }

    public void addProgramListener(ProgramEventListener programEventListener) {
        this.listeners.add(programEventListener);
    }

    public void removeProgramListener(ProgramEventListener programEventListener) {
        this.listeners.remove(programEventListener);
    }

    protected void notifyProgramListeners(byte by, String string) {
        ProgramEvent programEvent = new ProgramEvent((Object)this, by, string);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ProgramEventListener)this.listeners.elementAt(i)).programChanged(programEvent);
        }
    }

    class ROMLoadProgramTask
    implements Runnable {
        private String programName;

        public ROMLoadProgramTask(String string) {
            this.programName = string;
        }

        public void run() {
            ROM.this.clearErrorListeners();
            try {
                ROM.this.loadProgram(this.programName);
            }
            catch (ProgramException programException) {
                ROM.this.notifyErrorListeners(programException.getMessage());
            }
        }
    }
}

