/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.CPUEmulator.KeyboardGUI;
import Hack.CPUEmulator.RAM;
import Hack.ComputerParts.ComputerPart;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.Utilities.Definitions;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class Keyboard
extends ComputerPart
implements KeyListener {
    private RAM ram;
    private KeyboardGUI gui;

    public Keyboard(RAM rAM, KeyboardGUI keyboardGUI) {
        super(keyboardGUI != null);
        this.ram = rAM;
        this.gui = keyboardGUI;
        if (this.hasGUI) {
            keyboardGUI.getKeyEventHandler().addKeyListener(this);
        }
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public void keyPressed(KeyEvent keyEvent) {
        short s = Definitions.getInstance().getKeyCode(keyEvent);
        if (s > 0) {
            this.ram.setValueAt(24576, s, true);
            if (this.hasGUI) {
                this.gui.setKey(Definitions.getInstance().getKeyName(keyEvent));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.ram.setValueAt(24576, (short)0, true);
        this.gui.clearKey();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void refreshGUI() {
    }

    public void requestFocus() {
        if (this.hasGUI) {
            this.gui.getKeyEventHandler().requestFocus();
        }
    }
}

