/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.Assembler.AssemblerException;
import Hack.Assembler.HackAssemblerTranslator;
import Hack.CPUEmulator.ALU;
import Hack.CPUEmulator.PointerAddressRegisterAdapter;
import Hack.CPUEmulator.RAM;
import Hack.CPUEmulator.ROM;
import Hack.ComputerParts.Bus;
import Hack.ComputerParts.Register;
import Hack.ComputerParts.ValueComputerPart;
import Hack.Controller.ProgramException;

public class CPU {
    protected PointerAddressRegisterAdapter A;
    protected PointerAddressRegisterAdapter PC;
    protected Register D;
    protected RAM M;
    protected ROM rom;
    protected ALU alu;
    protected Bus bus;
    protected long time;
    protected HackAssemblerTranslator assemblerTranslator;

    public CPU(RAM rAM, ROM rOM, PointerAddressRegisterAdapter pointerAddressRegisterAdapter, Register register, PointerAddressRegisterAdapter pointerAddressRegisterAdapter2, ALU aLU, Bus bus) {
        this.M = rAM;
        this.rom = rOM;
        this.A = pointerAddressRegisterAdapter;
        this.D = register;
        this.PC = pointerAddressRegisterAdapter2;
        this.alu = aLU;
        this.bus = bus;
        pointerAddressRegisterAdapter.setUpdatePointer(false);
        this.assemblerTranslator = HackAssemblerTranslator.getInstance();
    }

    public Bus getBus() {
        return this.bus;
    }

    public Register getA() {
        return this.A;
    }

    public Register getD() {
        return this.D;
    }

    public Register getPC() {
        return this.PC;
    }

    public RAM getRAM() {
        return this.M;
    }

    public ROM getROM() {
        return this.rom;
    }

    public ALU getALU() {
        return this.alu;
    }

    public long getTime() {
        return this.time;
    }

    public void initProgram() {
        this.A.reset();
        this.A.setUpdatePointer(true);
        this.A.setUpdatePointer(false);
        this.D.reset();
        this.PC.reset();
        this.alu.reset();
        this.M.clearScreen();
        this.M.hideSelect();
        this.M.hideHighlight();
        this.rom.hideSelect();
        this.rom.hideHighlight();
        this.time = 0L;
    }

    public void executeInstruction() throws ProgramException {
        short s = this.rom.getValueAt(this.PC.get());
        boolean bl = false;
        if ((s & 0x8000) == 0) {
            this.bus.send((ValueComputerPart)this.rom, (int)this.PC.get(), (ValueComputerPart)this.A, 0);
        } else if ((s & 0xE000) == 57344) {
            this.computeExp(s);
            this.setDestination(s);
            bl = this.checkJump(s);
        } else if (s != Short.MIN_VALUE) {
            throw new ProgramException("At line " + this.PC.get() + ": Illegal instruction");
        }
        if (!bl) {
            short s2 = (short)(this.PC.get() + 1);
            if (s2 < 0 || s2 >= 32768) {
                throw new ProgramException("At line " + this.PC.get() + ": Can't continue past last line");
            }
            this.PC.setValueAt(0, s2, true);
        }
        ++this.time;
    }

    protected void computeExp(short s) throws ProgramException {
        boolean bl = (s & 0x1000) > 0;
        boolean bl2 = (s & 0x800) > 0;
        boolean bl3 = (s & 0x400) > 0;
        boolean bl4 = (s & 0x200) > 0;
        boolean bl5 = (s & 0x100) > 0;
        boolean bl6 = (s & 0x80) > 0;
        boolean bl7 = (s & 0x40) > 0;
        try {
            this.alu.setCommand(this.assemblerTranslator.getExpByCode((short)(s & 0xFFC0)), bl2, bl3, bl4, bl5, bl6, bl7);
        }
        catch (AssemblerException assemblerException) {
            // empty catch block
        }
        this.bus.send((ValueComputerPart)this.D, 0, (ValueComputerPart)this.alu, 0);
        if (bl) {
            short s2 = this.A.get();
            if (s2 < 0 || s2 >= this.M.getSize()) {
                throw new ProgramException("At line " + this.PC.get() + ": Expression involves M but A=" + s2 + " is an illegal memory address.");
            }
            this.A.setUpdatePointer(true);
            this.bus.send((ValueComputerPart)this.M, (int)s2, (ValueComputerPart)this.alu, 1);
            this.A.setUpdatePointer(false);
        } else {
            this.bus.send((ValueComputerPart)this.A, 0, (ValueComputerPart)this.alu, 1);
        }
        this.alu.compute();
    }

    protected void setDestination(short s) throws ProgramException {
        boolean bl;
        boolean bl2 = (s & 0x20) > 0;
        boolean bl3 = (s & 0x10) > 0;
        boolean bl4 = bl = (s & 8) > 0;
        if (bl) {
            short s2 = this.A.get();
            if (s2 < 0 || s2 >= this.M.getSize()) {
                throw new ProgramException("At line " + this.PC.get() + ": Destination is M but A=" + s2 + " is an illegal memory address.");
            }
            this.A.setUpdatePointer(true);
            this.bus.send((ValueComputerPart)this.alu, 2, (ValueComputerPart)this.M, (int)s2);
            this.A.setUpdatePointer(false);
        }
        if (bl2) {
            this.bus.send((ValueComputerPart)this.alu, 2, (ValueComputerPart)this.A, 0);
        }
        if (bl3) {
            this.bus.send((ValueComputerPart)this.alu, 2, (ValueComputerPart)this.D, 0);
        }
    }

    protected boolean checkJump(short s) throws ProgramException {
        boolean bl = (s & 4) > 0;
        boolean bl2 = (s & 2) > 0;
        boolean bl3 = (s & 1) > 0;
        boolean bl4 = false;
        short s2 = this.alu.getValueAt(2);
        if (s2 < 0 && bl || s2 == 0 && bl2 || s2 > 0 && bl3) {
            short s3 = this.A.get();
            if (s3 < 0 || s3 >= 32768) {
                throw new ProgramException("At line " + this.PC.get() + ": Jump requested but A=" + s3 + " is an illegal program address.");
            }
            this.bus.send((ValueComputerPart)this.A, 0, (ValueComputerPart)this.PC, 0);
            bl4 = true;
        }
        return bl4;
    }
}

