/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.Assembler.AssemblerException;
import Hack.Assembler.HackAssemblerTranslator;
import Hack.CPUEmulator.ROMGUI;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import HackGUI.Format;
import HackGUI.MouseOverJButton;
import HackGUI.PointedMemoryComponent;
import HackGUI.TranslationException;
import HackGUI.Utilities;
import SimulatorsGUI.ROMFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;

public class ROMComponent
extends PointedMemoryComponent
implements ROMGUI {
    private Vector programEventListeners;
    private static final int ASM_FORMAT = 4;
    protected MouseOverJButton loadButton = new MouseOverJButton();
    private ImageIcon loadIcon = new ImageIcon("bin/images/open2.gif");
    private FileFilter filter;
    private JFileChooser fileChooser;
    private HackAssemblerTranslator translator = HackAssemblerTranslator.getInstance();
    private JTextField messageTxt = new JTextField();
    private String[] format = new String[]{"Asm", "Dec", "Hex", "Bin"};
    protected JComboBox romFormat = new JComboBox<String>(this.format);
    private String programFileName;

    public ROMComponent() {
        this.dataFormat = 4;
        this.programEventListeners = new Vector();
        this.filter = new ROMFileFilter();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(this.filter);
        this.jbInit();
    }

    public void setNumericFormat(int n) {
        super.setNumericFormat(n);
        switch (n) {
            case 4: {
                this.romFormat.setSelectedIndex(0);
                break;
            }
            case 0: {
                this.romFormat.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.romFormat.setSelectedIndex(2);
                break;
            }
            case 2: {
                this.romFormat.setSelectedIndex(3);
            }
        }
    }

    public void addProgramListener(ProgramEventListener programEventListener) {
        this.programEventListeners.addElement(programEventListener);
    }

    public void removeProgramListener(ProgramEventListener programEventListener) {
        this.programEventListeners.removeElement(programEventListener);
    }

    public void notifyProgramListeners(byte by, String string) {
        ProgramEvent programEvent = new ProgramEvent((Object)this, by, string);
        for (int i = 0; i < this.programEventListeners.size(); ++i) {
            ((ProgramEventListener)this.programEventListeners.elementAt(i)).programChanged(programEvent);
        }
    }

    public void notifyClearListeners() {
        super.notifyClearListeners();
        this.notifyProgramListeners((byte)3, null);
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new ROMTableCellRenderer();
    }

    public void setProgram(String string) {
        this.programFileName = string;
    }

    public String getValueAsString(int n) {
        if (this.dataFormat != 4) {
            return super.getValueAsString(n);
        }
        return Format.translateValueToString((short)this.values[n], (int)0);
    }

    public void hideMessage() {
        this.messageTxt.setText("");
        this.messageTxt.setVisible(false);
        this.loadButton.setVisible(true);
        this.searchButton.setVisible(true);
        this.romFormat.setVisible(true);
    }

    public void showMessage(String string) {
        this.messageTxt.setText(string);
        this.loadButton.setVisible(false);
        this.searchButton.setVisible(false);
        this.romFormat.setVisible(false);
        this.messageTxt.setVisible(true);
    }

    protected short translateValueToShort(String string) throws TranslationException {
        short s = 0;
        if (this.dataFormat != 4) {
            s = super.translateValueToShort(string);
        } else {
            try {
                s = this.translator.textToCode(string);
            }
            catch (AssemblerException assemblerException) {
                throw new TranslationException(assemblerException.getMessage());
            }
        }
        return s;
    }

    protected String translateValueToString(short s) {
        String string = null;
        if (this.dataFormat != 4) {
            string = super.translateValueToString(s);
        } else {
            try {
                string = this.translator.codeToText(s);
            }
            catch (AssemblerException assemblerException) {
                // empty catch block
            }
        }
        return string;
    }

    private void jbInit() {
        this.loadButton.setIcon((Icon)this.loadIcon);
        this.loadButton.setBounds(new Rectangle(97, 2, 31, 25));
        this.loadButton.setToolTipText("Load Program");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROMComponent.this.loadButton_actionPerformed(actionEvent);
            }
        });
        this.messageTxt.setBackground(SystemColor.info);
        this.messageTxt.setEnabled(false);
        this.messageTxt.setFont(Utilities.labelsFont);
        this.messageTxt.setPreferredSize(new Dimension(70, 20));
        this.messageTxt.setDisabledTextColor(Color.red);
        this.messageTxt.setEditable(false);
        this.messageTxt.setHorizontalAlignment(0);
        this.messageTxt.setBounds(new Rectangle(37, 3, 154, 22));
        this.messageTxt.setVisible(false);
        this.romFormat.setPreferredSize(new Dimension(125, 23));
        this.romFormat.setBounds(new Rectangle(39, 3, 56, 23));
        this.romFormat.setFont(Utilities.thinLabelsFont);
        this.romFormat.setToolTipText("Display Format");
        this.romFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROMComponent.this.romFormat_actionPerformed(actionEvent);
            }
        });
        this.add(this.messageTxt, null);
        this.add((Component)this.loadButton);
        this.add(this.romFormat, null);
    }

    public void setWorkingDir(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public void loadProgram() {
        int n = this.fileChooser.showDialog((Component)((Object)this), "Load ROM");
        if (n == 0) {
            this.notifyProgramListeners((byte)1, this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void loadButton_actionPerformed(ActionEvent actionEvent) {
        this.loadProgram();
    }

    public void romFormat_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.romFormat.getSelectedItem();
        if (string.equals(this.format[0])) {
            this.setNumericFormat(4);
        } else if (string.equals(this.format[1])) {
            this.setNumericFormat(0);
        } else if (string.equals(this.format[2])) {
            this.setNumericFormat(1);
        } else if (string.equals(this.format[3])) {
            this.setNumericFormat(2);
        }
    }

    public class ROMTableCellRenderer
    extends PointedMemoryComponent.PointedMemoryTableCellRenderer {
        public ROMTableCellRenderer() {
            super((PointedMemoryComponent)ROMComponent.this);
        }

        public void setRenderer(int n, int n2) {
            super.setRenderer(n, n2);
            if (ROMComponent.this.dataFormat == 4 && n2 == 1) {
                this.setHorizontalAlignment(2);
            }
        }
    }
}

