/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import Hack.VMEmulator.VMEmulatorInstruction;
import Hack.VMEmulator.VMProgramGUI;
import Hack.VirtualMachine.HVMInstruction;
import HackGUI.MouseOverJButton;
import HackGUI.Utilities;
import SimulatorsGUI.SearchProgramWindow;
import SimulatorsGUI.VMFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ProgramComponent
extends JPanel
implements VMProgramGUI {
    private Vector listeners;
    private Vector errorEventListeners;
    protected JTable programTable;
    private ProgramTableModel model;
    protected VMEmulatorInstruction[] instructions;
    protected MouseOverJButton browseButton = new MouseOverJButton();
    private ImageIcon browseIcon = new ImageIcon("bin/images/open2.gif");
    private JFileChooser fileChooser = new JFileChooser();
    private int instructionIndex;
    private JTextField messageTxt = new JTextField();
    private ColoredTableCellRenderer coloredRenderer = new ColoredTableCellRenderer();
    private MouseOverJButton searchButton = new MouseOverJButton();
    private ImageIcon searchIcon = new ImageIcon("bin/images/find.gif");
    private SearchProgramWindow searchWindow;
    private JScrollPane scrollPane;
    private JLabel nameLbl = new JLabel();
    protected MouseOverJButton clearButton = new MouseOverJButton();
    private ImageIcon clearIcon = new ImageIcon("bin/images/smallnew.gif");

    public ProgramComponent() {
        this.listeners = new Vector();
        this.errorEventListeners = new Vector();
        this.instructions = new VMEmulatorInstruction[0];
        this.model = new ProgramTableModel();
        this.programTable = new JTable(this.model);
        this.programTable.setDefaultRenderer(this.programTable.getColumnClass(0), this.coloredRenderer);
        this.searchWindow = new SearchProgramWindow(this.programTable, (HVMInstruction[])this.instructions);
        this.jbInit();
    }

    public void addProgramListener(ProgramEventListener programEventListener) {
        this.listeners.addElement(programEventListener);
    }

    public void removeProgramListener(ProgramEventListener programEventListener) {
        this.listeners.removeElement(programEventListener);
    }

    public void notifyProgramListeners(byte by, String string) {
        ProgramEvent programEvent = new ProgramEvent((Object)this, by, string);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ProgramEventListener)this.listeners.elementAt(i)).programChanged(programEvent);
        }
    }

    public void addErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.addElement(errorEventListener);
    }

    public void removeErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.removeElement(errorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ErrorEvent errorEvent = new ErrorEvent((Object)this, string);
        for (int i = 0; i < this.errorEventListeners.size(); ++i) {
            ((ErrorEventListener)this.errorEventListeners.elementAt(i)).errorOccured(errorEvent);
        }
    }

    public void setWorkingDir(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public synchronized void setContents(VMEmulatorInstruction[] vMEmulatorInstructionArray, int n) {
        this.instructions = new VMEmulatorInstruction[n];
        System.arraycopy(vMEmulatorInstructionArray, 0, this.instructions, 0, n);
        this.programTable.revalidate();
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.searchWindow.setInstructions((HVMInstruction[])this.instructions);
    }

    public void setCurrentInstruction(int n) {
        this.instructionIndex = n;
        Utilities.tableCenterScroll((JPanel)this, (JTable)this.programTable, (int)n);
    }

    public void reset() {
        this.instructions = new VMEmulatorInstruction[0];
        this.programTable.clearSelection();
        this.repaint();
    }

    public void loadProgram() {
        int n = this.fileChooser.showDialog(this, "Load Program");
        if (n == 0) {
            this.notifyProgramListeners((byte)1, this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void browseButton_actionPerformed(ActionEvent actionEvent) {
        this.loadProgram();
    }

    public void hideMessage() {
        this.messageTxt.setText("");
        this.messageTxt.setVisible(false);
        this.searchButton.setVisible(true);
        this.clearButton.setVisible(true);
        this.browseButton.setVisible(true);
    }

    public void showMessage(String string) {
        this.messageTxt.setText(string);
        this.messageTxt.setVisible(true);
        this.searchButton.setVisible(false);
        this.clearButton.setVisible(false);
        this.browseButton.setVisible(false);
    }

    private void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 3; ++i) {
            tableColumn = this.programTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(30);
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(40);
                continue;
            }
            if (i != 2) continue;
            tableColumn.setPreferredWidth(100);
        }
    }

    public void searchButton_actionPerformed(ActionEvent actionEvent) {
        this.searchWindow.showWindow();
    }

    public void clearButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{"Yes", "No", "Cancel"};
        int n = JOptionPane.showOptionDialog(this.getParent(), "Are you sure you want to clear the program?", "Warning Message", 1, 2, null, objectArray, objectArray[2]);
        if (n == 0) {
            this.notifyProgramListeners((byte)3, null);
        }
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.programTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    public void setNameLabel(String string) {
        this.nameLbl.setText(string);
    }

    public int getTableWidth() {
        return 225;
    }

    private void jbInit() {
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setFileFilter(new VMFileFilter());
        this.programTable.getTableHeader().setReorderingAllowed(false);
        this.programTable.getTableHeader().setResizingAllowed(false);
        this.scrollPane = new JScrollPane(this.programTable);
        this.scrollPane.setLocation(0, 27);
        this.browseButton.setToolTipText("Load Program");
        this.browseButton.setIcon((Icon)this.browseIcon);
        this.browseButton.setBounds(new Rectangle(119, 2, 31, 24));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgramComponent.this.browseButton_actionPerformed(actionEvent);
            }
        });
        this.messageTxt.setBackground(SystemColor.info);
        this.messageTxt.setEnabled(false);
        this.messageTxt.setFont(Utilities.labelsFont);
        this.messageTxt.setPreferredSize(new Dimension(70, 20));
        this.messageTxt.setDisabledTextColor(Color.red);
        this.messageTxt.setEditable(false);
        this.messageTxt.setBounds(new Rectangle(91, 2, 132, 23));
        this.messageTxt.setVisible(false);
        this.searchButton.setToolTipText("Search");
        this.searchButton.setIcon((Icon)this.searchIcon);
        this.searchButton.setBounds(new Rectangle(188, 2, 31, 24));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgramComponent.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.setForeground(Color.lightGray);
        this.setLayout(null);
        this.nameLbl.setText("Program");
        this.nameLbl.setBounds(new Rectangle(5, 5, 73, 20));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgramComponent.this.clearButton_actionPerformed(actionEvent);
            }
        });
        this.clearButton.setBounds(new Rectangle(154, 2, 31, 24));
        this.clearButton.setIcon((Icon)this.clearIcon);
        this.clearButton.setToolTipText("Clear");
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.nameLbl, null);
        this.add((Component)this.searchButton, null);
        this.add((Component)this.clearButton, null);
        this.add((Component)this.messageTxt, null);
        this.add((Component)this.browseButton, null);
        this.determineColumnWidth();
        this.programTable.setTableHeader(null);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public boolean confirmBuiltInAccess() {
        String string = "No implementation was found for some functions which are called in the VM code.\nThe VM Emulator provides built-in implementations for the OS functions.\nIf available, should this built-in implementation be used for functions which were not implemented in the VM code?";
        return JOptionPane.showConfirmDialog(this.getParent(), string, "Confirmation Message", 0, 3) == 0;
    }

    public void notify(String string) {
        JOptionPane.showMessageDialog(this.getParent(), string, "Information Message", 1);
    }

    class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        ColoredTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable == null || jTable.isEnabled());
            this.setBackground(null);
            this.setForeground(null);
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (n == ProgramComponent.this.instructionIndex) {
                this.setBackground(Color.yellow);
            } else {
                VMEmulatorInstruction vMEmulatorInstruction = ProgramComponent.this.instructions[n];
                String string = vMEmulatorInstruction.getFormattedStrings()[0];
                if (string.equals("function") && (n2 == 1 || n2 == 2)) {
                    this.setBackground(new Color(190, 171, 210));
                }
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class ProgramTableModel
    extends AbstractTableModel {
        ProgramTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return ProgramComponent.this.instructions.length;
        }

        public String getColumnName(int n) {
            return null;
        }

        public Object getValueAt(int n, int n2) {
            String[] stringArray = ProgramComponent.this.instructions[n].getFormattedStrings();
            switch (n2) {
                case 0: {
                    short s = ProgramComponent.this.instructions[n].getIndexInFunction();
                    if (s >= 0) {
                        return new Short(s);
                    }
                    return "";
                }
                case 1: {
                    return stringArray[0];
                }
                case 2: {
                    return stringArray[1] + " " + stringArray[2];
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

