/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.Gates.BuiltInGate;
import Hack.Gates.CompositeGate;
import Hack.Gates.Gate;
import Hack.HardwareSimulator.PartsGUI;
import HackGUI.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PartsComponent
extends JPanel
implements PartsGUI {
    private static final String BUILTIN_GATE = "BuiltIn";
    private static final String COMPOSITE_GATE = "Composite";
    private JTable partsTable;
    private Gate[] parts;
    private JScrollPane scrollPane;
    private PartsTableModel model;
    private JLabel nameLbl = new JLabel();

    public PartsComponent() {
        this.parts = new Gate[0];
        this.model = new PartsTableModel();
        this.partsTable = new JTable(this.model);
        this.jbInit();
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.partsTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    public int getTableWidth() {
        return 241;
    }

    public void setName(String string) {
        this.nameLbl.setText(string);
    }

    public void setContents(Gate[] gateArray) {
        this.parts = new Gate[gateArray.length];
        System.arraycopy(gateArray, 0, this.parts, 0, gateArray.length);
        this.partsTable.clearSelection();
        this.partsTable.revalidate();
    }

    public void reset() {
        this.partsTable.clearSelection();
        this.repaint();
    }

    private void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 3; ++i) {
            tableColumn = this.partsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(110);
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(72);
                continue;
            }
            if (i != 2) continue;
            tableColumn.setPreferredWidth(55);
        }
    }

    private void jbInit() {
        this.setLayout(null);
        this.partsTable.setFont(Utilities.valueFont);
        this.partsTable.getTableHeader().setReorderingAllowed(false);
        this.partsTable.getTableHeader().setResizingAllowed(false);
        this.partsTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                PartsComponent.this.partsTable_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                PartsComponent.this.partsTable_focusLost(focusEvent);
            }
        });
        this.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane = new JScrollPane(this.partsTable);
        this.scrollPane.setLocation(0, 27);
        this.nameLbl.setText("Name :");
        this.nameLbl.setBounds(new Rectangle(3, 3, 102, 21));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.nameLbl, null);
        this.determineColumnWidth();
    }

    public void partsTable_focusGained(FocusEvent focusEvent) {
    }

    public void partsTable_focusLost(FocusEvent focusEvent) {
        this.partsTable.clearSelection();
    }

    class PartsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Chip Name", "Type", "Clocked"};

        PartsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return PartsComponent.this.parts.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = PartsComponent.this.parts[n].getGateClass().getName();
            } else if (n2 == 1) {
                if (PartsComponent.this.parts[n] instanceof CompositeGate) {
                    object = PartsComponent.COMPOSITE_GATE;
                } else if (PartsComponent.this.parts[n] instanceof BuiltInGate) {
                    object = PartsComponent.BUILTIN_GATE;
                }
            } else if (n2 == 2) {
                object = new Boolean(PartsComponent.this.parts[n].getGateClass().isClocked());
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

