/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.ComputerParts.TextFileGUI;
import Hack.Gates.GatesPanelGUI;
import Hack.HardwareSimulator.GateInfoGUI;
import Hack.HardwareSimulator.HardwareSimulatorGUI;
import Hack.HardwareSimulator.PartPinsGUI;
import Hack.HardwareSimulator.PartsGUI;
import Hack.HardwareSimulator.PinsGUI;
import HackGUI.TextFileComponent;
import SimulatorsGUI.GateInfoComponent;
import SimulatorsGUI.HackSimulatorComponent;
import SimulatorsGUI.PartPinsComponent;
import SimulatorsGUI.PartsComponent;
import SimulatorsGUI.PinsComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class HardwareSimulatorComponent
extends HackSimulatorComponent
implements HardwareSimulatorGUI,
GatesPanelGUI {
    private static final int WIDTH = 1018;
    private static final int HEIGHT = 611;
    private PinsComponent inputPins;
    private PinsComponent outputPins;
    private PinsComponent internalPins;
    private TextFileComponent hdlView;
    private PartPinsComponent partPins;
    private PartsComponent parts;
    private JLabel messageLbl = new JLabel();
    private JPanel nullLayoutGatesPanel = new JPanel();
    private JPanel flowLayoutGatesPanel = new JPanel();
    private boolean flowLayout = false;
    private GateInfoComponent gateInfo;

    public HardwareSimulatorComponent() {
        this.nullLayoutGatesPanel.setLayout(null);
        this.flowLayoutGatesPanel.setLayout(new FlowLayout(1, 1, 1));
        this.inputPins = new PinsComponent();
        this.inputPins.setPinsName("Input pins");
        this.outputPins = new PinsComponent();
        this.outputPins.setPinsName("Output pins");
        this.internalPins = new PinsComponent();
        this.internalPins.setPinsName("Internal pins");
        this.partPins = new PartPinsComponent();
        this.partPins.setPinsName("Part pins");
        this.parts = new PartsComponent();
        this.parts.setName("Internal Parts");
        this.hdlView = new TextFileComponent();
        this.gateInfo = new GateInfoComponent();
        this.jbInit();
        this.inputPins.setTopLevelLocation(this);
        this.outputPins.setTopLevelLocation(this);
        this.internalPins.setTopLevelLocation(this);
        this.partPins.setTopLevelLocation(this);
        this.hdlView.setName("HDL");
    }

    public void loadProgram() {
    }

    public GatesPanelGUI getGatesPanel() {
        return this;
    }

    public TextFileGUI getHDLView() {
        return this.hdlView;
    }

    public PinsGUI getInputPins() {
        return this.inputPins;
    }

    public PinsGUI getOutputPins() {
        return this.outputPins;
    }

    public PinsGUI getInternalPins() {
        return this.internalPins;
    }

    public GateInfoGUI getGateInfo() {
        return this.gateInfo;
    }

    public PartPinsGUI getPartPins() {
        return this.partPins;
    }

    public PartsGUI getParts() {
        return this.parts;
    }

    public void showInternalPins() {
        this.internalPins.setVisible(true);
    }

    public void hideInternalPins() {
        this.internalPins.setVisible(false);
    }

    public void showPartPins() {
        this.partPins.setVisible(true);
    }

    public void hidePartPins() {
        this.partPins.setVisible(false);
    }

    public void showParts() {
        this.parts.setVisible(true);
    }

    public void hideParts() {
        this.parts.setVisible(false);
    }

    public void displayMessage(String string, boolean bl) {
        if (bl) {
            this.messageLbl.setForeground(Color.red);
        } else {
            this.messageLbl.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.messageLbl.setText(string);
    }

    public Point getAdditionalDisplayLocation() {
        return new Point(496, 13);
    }

    public void setWorkingDir(File file) {
    }

    public void addGateComponent(Component component) {
        if (this.flowLayout) {
            this.flowLayoutGatesPanel.add(component);
            this.flowLayoutGatesPanel.revalidate();
            this.flowLayoutGatesPanel.repaint();
        } else {
            Component[] componentArray = this.nullLayoutGatesPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Rectangle rectangle = componentArray[i].getBounds();
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)(rectangle.getX() + rectangle.getWidth() - 1.0);
                int n4 = (int)(rectangle.getY() + rectangle.getHeight() - 1.0);
                if (component.getY() > n4 || component.getX() > n3 || component.getY() + component.getHeight() - 1 < n2 || component.getX() + component.getWidth() - 1 < n) continue;
                this.flowLayout = true;
                if (this.currentAdditionalDisplay == null) {
                    this.nullLayoutGatesPanel.setVisible(false);
                    this.flowLayoutGatesPanel.setVisible(true);
                }
                for (i = 0; i < componentArray.length; ++i) {
                    this.flowLayoutGatesPanel.add(componentArray[i]);
                }
                this.flowLayoutGatesPanel.add(component);
                break;
            }
            if (!this.flowLayout) {
                this.nullLayoutGatesPanel.add(component);
                this.nullLayoutGatesPanel.revalidate();
                this.nullLayoutGatesPanel.repaint();
            }
        }
    }

    public void removeGateComponent(Component component) {
        this.nullLayoutGatesPanel.remove(component);
        this.flowLayoutGatesPanel.remove(component);
        this.nullLayoutGatesPanel.revalidate();
        this.flowLayoutGatesPanel.revalidate();
        this.nullLayoutGatesPanel.repaint();
        this.flowLayoutGatesPanel.repaint();
    }

    public void removeAllGateComponents() {
        this.nullLayoutGatesPanel.removeAll();
        this.flowLayoutGatesPanel.removeAll();
        this.nullLayoutGatesPanel.revalidate();
        this.flowLayoutGatesPanel.revalidate();
        this.nullLayoutGatesPanel.repaint();
        this.flowLayoutGatesPanel.repaint();
        this.flowLayout = false;
        if (this.currentAdditionalDisplay == null) {
            this.nullLayoutGatesPanel.setVisible(true);
            this.flowLayoutGatesPanel.setVisible(false);
        }
    }

    private void jbInit() {
        this.setLayout(null);
        this.gateInfo.setBounds(5, 10, this.gateInfo.getWidth(), this.gateInfo.getHeight());
        this.inputPins.setVisibleRows(15);
        this.inputPins.setBounds(5, 53, this.inputPins.getWidth(), this.inputPins.getHeight());
        this.outputPins.setVisibleRows(15);
        this.outputPins.setBounds(247, 53, this.outputPins.getWidth(), this.outputPins.getHeight());
        this.internalPins.setVisibleRows(15);
        this.internalPins.setBounds(247, 332, this.internalPins.getWidth(), this.internalPins.getHeight());
        this.internalPins.setVisible(false);
        this.hdlView.setVisibleRows(15);
        this.hdlView.setBounds(5, 332, this.hdlView.getWidth(), this.hdlView.getHeight());
        this.partPins.setVisibleRows(15);
        this.partPins.setBounds(247, 332, this.partPins.getWidth(), this.partPins.getHeight());
        this.partPins.setVisible(false);
        this.parts.setVisibleRows(15);
        this.parts.setBounds(247, 332, this.parts.getWidth(), this.parts.getHeight());
        this.parts.setVisible(false);
        this.nullLayoutGatesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.nullLayoutGatesPanel.setBounds(new Rectangle(492, 10, 524, 592));
        this.flowLayoutGatesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.flowLayoutGatesPanel.setBounds(new Rectangle(492, 10, 524, 592));
        this.flowLayoutGatesPanel.setVisible(false);
        this.messageLbl.setBorder(BorderFactory.createLoweredBevelBorder());
        this.messageLbl.setBounds(new Rectangle(0, 694, 1010, 20));
        this.add((Component)this.partPins, null);
        this.add((Component)this.hdlView, null);
        this.add((Component)this.inputPins, null);
        this.add((Component)this.outputPins, null);
        this.add((Component)this.internalPins, null);
        this.add((Component)this.parts, null);
        this.add((Component)this.messageLbl, null);
        this.add((Component)this.gateInfo, null);
        this.add((Component)this.nullLayoutGatesPanel, null);
        this.add((Component)this.flowLayoutGatesPanel, null);
        this.setSize(1018, 611);
    }

    public void setAdditionalDisplay(JComponent jComponent) {
        if (this.currentAdditionalDisplay == null && jComponent != null) {
            if (this.flowLayout) {
                this.flowLayoutGatesPanel.setVisible(false);
            } else {
                this.nullLayoutGatesPanel.setVisible(false);
            }
        } else if (this.currentAdditionalDisplay != null && jComponent == null) {
            if (this.flowLayout) {
                this.flowLayoutGatesPanel.setVisible(true);
            } else {
                this.nullLayoutGatesPanel.setVisible(true);
            }
        }
        super.setAdditionalDisplay(jComponent);
    }
}

