/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.VMEmulator.CallStackGUI;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class CallStackComponent
extends JPanel
implements CallStackGUI {
    protected static final int DEFAULT_VISIBLE_ROWS = 10;
    private Vector methodNames;
    private JTable callStackTable;
    private CallStackTableModel model;
    private JScrollPane scrollPane;
    private JLabel nameLbl = new JLabel();

    public CallStackComponent() {
        this.methodNames = new Vector();
        this.model = new CallStackTableModel();
        this.callStackTable = new JTable(this.model);
        this.jbInit();
    }

    public void setContents(Vector vector) {
        this.methodNames = (Vector)vector.clone();
        this.callStackTable.revalidate();
        Rectangle rectangle = this.callStackTable.getCellRect(vector.size() - 1, 0, true);
        this.callStackTable.scrollRectToVisible(rectangle);
        this.repaint();
    }

    public void reset() {
        this.methodNames.removeAllElements();
        this.callStackTable.revalidate();
        this.callStackTable.clearSelection();
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.callStackTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    public int getTableWidth() {
        return 190;
    }

    private void jbInit() {
        this.callStackTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                CallStackComponent.this.callStackTable_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                CallStackComponent.this.callStackTable_focusLost(focusEvent);
            }
        });
        this.callStackTable.setTableHeader(null);
        this.callStackTable.setDefaultRenderer(this.callStackTable.getColumnClass(0), this.getCellRenderer());
        this.scrollPane = new JScrollPane(this.callStackTable);
        this.setVisibleRows(10);
        this.scrollPane.setLocation(0, 27);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(null);
        this.nameLbl.setText("Call Stack");
        this.nameLbl.setBounds(new Rectangle(3, 4, 70, 23));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.nameLbl, null);
    }

    public void callStackTable_focusGained(FocusEvent focusEvent) {
    }

    public void callStackTable_focusLost(FocusEvent focusEvent) {
        this.callStackTable.clearSelection();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new callStackTableCellRenderer();
    }

    public class callStackTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(null);
            this.setBackground(null);
            this.setRenderer(n, n2);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setRenderer(int n, int n2) {
            if (n == CallStackComponent.this.methodNames.size() - 1) {
                this.setForeground(Color.blue);
            }
        }
    }

    class CallStackTableModel
    extends AbstractTableModel {
        CallStackTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return CallStackComponent.this.methodNames.size();
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return CallStackComponent.this.methodNames.elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

