/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.CPUEmulator.ALUGUI;
import HackGUI.Format;
import HackGUI.Utilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ALUComponent
extends JPanel
implements ALUGUI {
    private static final int START_LOCATION_ZERO_X = 7;
    private static final int START_LOCATION_ZERO_Y = 39;
    private static final int START_LOCATION_ONE_Y = 85;
    private static final int START_LOCATION_TWO_X = 237;
    private static final int START_LOCATION_TWO_Y = 61;
    private static final int START_ALU_X = 159;
    private static final int FINISH_ALU_X = 216;
    private static final int LOCATION_WIDTH = 124;
    private static final int LOCATION_HEIGHT = 19;
    private static final BasicStroke wideStroke = new BasicStroke(3.0f);
    private static final BasicStroke regularStroke = new BasicStroke(1.0f);
    protected int dataFormat = 0;
    protected short location0Value;
    protected short location1Value;
    protected short location2Value;
    protected JTextField location0 = new JTextField();
    protected JTextField location1 = new JTextField();
    protected JTextField location2 = new JTextField();
    private JTextField commandLbl = new JTextField();
    private Color aluColor = new Color(107, 194, 46);
    private JLabel nameLbl = new JLabel();
    private Border commandBorder;
    private JLabel location0Lbl = new JLabel();
    private JLabel location1Lbl = new JLabel();
    private JLabel location2Lbl = new JLabel();
    protected short nullValue;
    protected boolean hideNullValue;

    public ALUComponent() {
        this.jbInit();
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
    }

    protected String translateValueToString(short s) {
        if (this.hideNullValue) {
            if (s == this.nullValue) {
                return "";
            }
            return Format.translateValueToString((short)s, (int)this.dataFormat);
        }
        return Format.translateValueToString((short)s, (int)this.dataFormat);
    }

    public void disableUserInput() {
    }

    public void enableUserInput() {
    }

    public void commandFlash() {
        this.commandLbl.setBackground(Color.red);
        this.repaint();
    }

    public void hideCommandFlash() {
        this.commandLbl.setBackground(new Color(107, 194, 46));
        this.repaint();
    }

    public void bodyFlash() {
        this.aluColor = Color.red;
        this.commandLbl.setBackground(Color.red);
        this.repaint();
    }

    public void hideBodyFlash() {
        this.aluColor = new Color(107, 194, 46);
        this.commandLbl.setBackground(new Color(107, 194, 46));
        this.repaint();
    }

    public void flash(int n) {
        switch (n) {
            case 0: {
                this.location0.setBackground(Color.orange);
                break;
            }
            case 1: {
                this.location1.setBackground(Color.orange);
                break;
            }
            case 2: {
                this.location2.setBackground(Color.orange);
            }
        }
    }

    public void hideFlash() {
        this.location0.setBackground(null);
        this.location1.setBackground(null);
        this.location2.setBackground(null);
    }

    public void hideHighlight() {
        this.location0.setDisabledTextColor(Color.black);
        this.location1.setDisabledTextColor(Color.black);
        this.location2.setDisabledTextColor(Color.black);
        this.repaint();
    }

    public void highlight(int n) {
        switch (n) {
            case 0: {
                this.location0.setDisabledTextColor(Color.blue);
                break;
            }
            case 1: {
                this.location1.setDisabledTextColor(Color.blue);
                break;
            }
            case 2: {
                this.location2.setDisabledTextColor(Color.blue);
            }
        }
        this.repaint();
    }

    public Point getCoordinates(int n) {
        Point point = this.getLocation();
        switch (n) {
            case 0: {
                return new Point((int)(point.getX() + this.location0.getLocation().getX()), (int)(point.getY() + this.location0.getLocation().getY()));
            }
            case 1: {
                return new Point((int)(point.getX() + this.location1.getLocation().getX()), (int)(point.getY() + this.location1.getLocation().getY()));
            }
            case 2: {
                return new Point((int)(point.getX() + this.location2.getLocation().getX()), (int)(point.getY() + this.location2.getLocation().getY()));
            }
        }
        return null;
    }

    public String getValueAsString(int n) {
        switch (n) {
            case 0: {
                return this.location0.getText();
            }
            case 1: {
                return this.location1.getText();
            }
            case 2: {
                return this.location2.getText();
            }
        }
        return null;
    }

    public void reset() {
        this.location0.setText(Format.translateValueToString((short)this.nullValue, (int)this.dataFormat));
        this.location1.setText(Format.translateValueToString((short)this.nullValue, (int)this.dataFormat));
        this.location2.setText(Format.translateValueToString((short)this.nullValue, (int)this.dataFormat));
        this.setCommand("");
        this.hideFlash();
        this.hideHighlight();
    }

    public void setValueAt(int n, short s) {
        String string = Format.translateValueToString((short)s, (int)this.dataFormat);
        switch (n) {
            case 0: {
                this.location0Value = s;
                this.location0.setText(string);
                break;
            }
            case 1: {
                this.location1Value = s;
                this.location1.setText(string);
                break;
            }
            case 2: {
                this.location2Value = s;
                this.location2.setText(string);
            }
        }
    }

    public void setCommand(String string) {
        this.commandLbl.setText(string);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        int[] nArray = new int[]{159, 216, 216, 159};
        int[] nArray2 = new int[]{23, 56, 83, 116};
        GeneralPath generalPath = new GeneralPath(0, nArray.length);
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        generalPath.closePath();
        graphics2D.setPaint(this.aluColor);
        graphics2D.fill(generalPath);
        graphics2D.setStroke(wideStroke);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(generalPath);
        graphics2D.setStroke(regularStroke);
        graphics2D.draw(new Line2D.Double(131.0, 48.0, 159.0, 48.0));
        graphics2D.draw(new Line2D.Double(131.0, 94.0, 159.0, 94.0));
        graphics2D.draw(new Line2D.Double(216.0, 70.0, 236.0, 70.0));
    }

    public void setNumericFormat(int n) {
        this.dataFormat = n;
        this.location0.setText(Format.translateValueToString((short)this.location0Value, (int)n));
        this.location1.setText(Format.translateValueToString((short)this.location1Value, (int)n));
        this.location2.setText(Format.translateValueToString((short)this.location2Value, (int)n));
    }

    private void jbInit() {
        this.setOpaque(false);
        this.commandBorder = BorderFactory.createLineBorder(Color.black, 1);
        this.setLayout(null);
        this.location0.setForeground(Color.black);
        this.location0.setDisabledTextColor(Color.black);
        this.location0.setEditable(false);
        this.location0.setHorizontalAlignment(4);
        this.location0.setBounds(new Rectangle(7, 39, 124, 19));
        this.location0.setBackground(UIManager.getColor("Button.background"));
        this.location0.setEnabled(false);
        this.location0.setFont(Utilities.valueFont);
        this.location1.setHorizontalAlignment(4);
        this.location1.setBounds(new Rectangle(7, 85, 124, 19));
        this.location1.setForeground(Color.black);
        this.location1.setDisabledTextColor(Color.black);
        this.location1.setEditable(false);
        this.location1.setBackground(UIManager.getColor("Button.background"));
        this.location1.setEnabled(false);
        this.location1.setFont(Utilities.valueFont);
        this.location2.setHorizontalAlignment(4);
        this.location2.setBounds(new Rectangle(237, 61, 124, 19));
        this.location2.setForeground(Color.black);
        this.location2.setDisabledTextColor(Color.black);
        this.location2.setEditable(false);
        this.location2.setBackground(UIManager.getColor("Button.background"));
        this.location2.setEnabled(false);
        this.location2.setFont(Utilities.valueFont);
        this.commandLbl.setBackground(new Color(107, 194, 46));
        this.commandLbl.setEnabled(false);
        this.commandLbl.setFont(Utilities.labelsFont);
        this.commandLbl.setForeground(Color.black);
        this.commandLbl.setBorder(this.commandBorder);
        this.commandLbl.setDisabledTextColor(Color.black);
        this.commandLbl.setEditable(false);
        this.commandLbl.setHorizontalAlignment(0);
        this.commandLbl.setBounds(new Rectangle(163, 62, 50, 16));
        this.location0Lbl.setText("D Input :");
        this.location0Lbl.setBounds(new Rectangle(7, 23, 56, 16));
        this.location0Lbl.setFont(Utilities.smallLabelsFont);
        this.location0Lbl.setForeground(Color.black);
        this.location1Lbl.setText("M/A Input :");
        this.location1Lbl.setBounds(new Rectangle(7, 69, 70, 16));
        this.location1Lbl.setFont(Utilities.smallLabelsFont);
        this.location1Lbl.setForeground(Color.black);
        this.location2Lbl.setText("ALU output :");
        this.location2Lbl.setBounds(new Rectangle(237, 45, 72, 16));
        this.location2Lbl.setFont(Utilities.smallLabelsFont);
        this.location2Lbl.setForeground(Color.black);
        this.nameLbl.setText("ALU");
        this.nameLbl.setFont(Utilities.labelsFont);
        this.nameLbl.setBounds(new Rectangle(6, 0, 50, 22));
        this.add((Component)this.commandLbl, null);
        this.add((Component)this.location1, null);
        this.add((Component)this.location0, null);
        this.add((Component)this.location2, null);
        this.add((Component)this.location0Lbl, null);
        this.add((Component)this.location1Lbl, null);
        this.add((Component)this.location2Lbl, null);
        this.add((Component)this.nameLbl, null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(368, 122));
        this.setSize(368, 122);
    }
}

