/*
 * Decompiled with CFR 0.152.
 */
package Hack.Controller;

import Hack.Controller.ControllerException;
import Hack.Controller.HackSimulator;
import Hack.Controller.ScriptException;
import Hack.Controller.ScriptTokenizer;
import Hack.Controller.VariableException;
import Hack.Utilities.Conversions;

public class ScriptCondition {
    public static final byte EQUAL = 1;
    public static final byte GREATER = 2;
    public static final byte LESS = 3;
    public static final byte GREATER_EQUAL = 4;
    public static final byte LESS_EQUAL = 5;
    public static final byte NOT_EQUAL = 6;
    private String arg0;
    private String arg1;
    private byte comparisonOperator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScriptCondition(ScriptTokenizer scriptTokenizer) throws ScriptException, ControllerException {
        if (scriptTokenizer.getTokenType() != 3 && scriptTokenizer.getTokenType() != 4) {
            throw new ScriptException("A condition expected");
        }
        this.arg0 = scriptTokenizer.getToken();
        scriptTokenizer.advance();
        if (scriptTokenizer.getTokenType() != 2) throw new ScriptException("Comparison operator expected");
        String string = scriptTokenizer.getToken();
        scriptTokenizer.advance();
        if (scriptTokenizer.getTokenType() == 2) {
            string = string + scriptTokenizer.getToken();
            scriptTokenizer.advance();
        }
        if (string.equals("=")) {
            this.comparisonOperator = 1;
        } else if (string.equals(">")) {
            this.comparisonOperator = (byte)2;
        } else if (string.equals(">=")) {
            this.comparisonOperator = (byte)4;
        } else if (string.equals("<")) {
            this.comparisonOperator = (byte)3;
        } else if (string.equals("<=")) {
            this.comparisonOperator = (byte)5;
        } else {
            if (!string.equals("<>")) throw new ScriptException("Illegal comparison operator: " + string);
            this.comparisonOperator = (byte)6;
        }
        if (scriptTokenizer.getTokenType() != 3 && scriptTokenizer.getTokenType() != 4) {
            throw new ScriptException("A variable name or constant expected");
        }
        this.arg1 = scriptTokenizer.getToken();
        scriptTokenizer.advance();
    }

    public boolean compare(HackSimulator hackSimulator) throws ControllerException {
        boolean bl;
        block21: {
            block22: {
                boolean bl2;
                boolean bl3;
                String string;
                String string2;
                block20: {
                    bl = false;
                    int n = 0;
                    int n2 = 0;
                    try {
                        string2 = hackSimulator.getValue(this.arg0);
                    }
                    catch (VariableException variableException) {
                        string2 = this.arg0;
                    }
                    try {
                        string = hackSimulator.getValue(this.arg1);
                    }
                    catch (VariableException variableException) {
                        string = this.arg1;
                    }
                    try {
                        n = Integer.parseInt(Conversions.toDecimalForm(string2));
                        bl3 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl3 = false;
                    }
                    try {
                        n2 = Integer.parseInt(Conversions.toDecimalForm(string));
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl2 = false;
                    }
                    if (!bl3 || !bl2) break block20;
                    switch (this.comparisonOperator) {
                        case 1: {
                            bl = n == n2;
                            break;
                        }
                        case 2: {
                            bl = n > n2;
                            break;
                        }
                        case 3: {
                            bl = n < n2;
                            break;
                        }
                        case 4: {
                            bl = n >= n2;
                            break;
                        }
                        case 5: {
                            bl = n <= n2;
                            break;
                        }
                        case 6: {
                            bl = n != n2;
                        }
                    }
                    break block21;
                }
                if (bl3 || bl2) break block22;
                switch (this.comparisonOperator) {
                    case 1: {
                        bl = string2.equals(string);
                        break block21;
                    }
                    case 6: {
                        bl = !string2.equals(string);
                        break block21;
                    }
                    default: {
                        throw new ControllerException("Only = and <> can be used to compare strings");
                    }
                }
            }
            throw new ControllerException("Cannot compare an integer with a string");
        }
        return bl;
    }
}

